/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import org.bukkit.ChatColor;

public class StringHelper {
    public static String capitalize(Object string) {
        String capitalize = string.toString();
        return capitalize.replaceFirst(String.valueOf(capitalize.charAt(0)), String.valueOf(Character.toUpperCase(capitalize.charAt(0))));
    }

    public static int getLevenshteinDistance(String s, String t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static String parseColors(Object string) {
        String parsed = string.toString();
        for (ChatColor color : ChatColor.values()) {
            parsed = parsed.replace("<" + color.getChar() + ">", color.toString());
        }
        parsed = ChatColor.translateAlternateColorCodes((char)'&', (String)parsed);
        return parsed;
    }

    public static String wrap(Object string) {
        return ChatColor.YELLOW + string.toString() + ChatColor.GREEN;
    }

    public static String wrapHeader(Object string) {
        return "<a>=====[ " + string.toString() + "<a> ]=====";
    }
}

