/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.google.common.base.Preconditions;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.event.PlayerCreateNPCEvent;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class NPCPayListener
implements Listener {
    private final Economy provider;

    public NPCPayListener(Economy provider) {
        Preconditions.checkNotNull((Object)provider, (Object)"provider cannot be null");
        this.provider = provider;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCreateNPC(PlayerCreateNPCEvent event) {
        String name = event.getCreator().getName();
        boolean hasAccount = this.provider.hasAccount(name);
        if (!hasAccount) {
            return;
        }
        double cost = Settings.Setting.NPC_COST.asDouble();
        boolean hasEnough = this.provider.has(name, cost);
        if (!hasEnough) {
            event.setCancelled(true);
            event.setCancelReason(String.format("Need at least %s.", this.provider.format(cost)));
            return;
        }
        this.provider.bankWithdraw(name, cost);
    }
}

