/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import is.currency.Currency;
import is.currency.syst.AccountContext;
import java.util.List;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_CurrencyCore
implements Economy {
    private Currency currency;
    private static final Logger log = Logger.getLogger("Minecraft");
    private final Plugin plugin;
    private final String name = "CurrencyCore";

    public Economy_CurrencyCore(Plugin plugin) {
        Plugin currencyPlugin;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.currency == null && (currencyPlugin = plugin.getServer().getPluginManager().getPlugin("CurrencyCore")) != null && currencyPlugin.getClass().getName().equals("is.currency.Currency")) {
            this.currency = (Currency)currencyPlugin;
            log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "CurrencyCore"));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.currency != null;
    }

    @Override
    public String getName() {
        return "CurrencyCore";
    }

    @Override
    public String format(double amount) {
        return this.currency.getFormatHelper().format(amount);
    }

    @Override
    public String currencyNamePlural() {
        return (String)this.currency.getCurrencyConfig().getCurrencyMajor().get(1);
    }

    @Override
    public String currencyNameSingular() {
        return (String)this.currency.getCurrencyConfig().getCurrencyMajor().get(0);
    }

    @Override
    public double getBalance(String playerName) {
        AccountContext account = this.currency.getAccountManager().getAccount(playerName);
        if (account == null) {
            return 0.0;
        }
        return account.getBalance();
    }

    @Override
    public boolean has(String playerName, double amount) {
        AccountContext account = this.currency.getAccountManager().getAccount(playerName);
        if (account == null) {
            return false;
        }
        return account.hasBalance(amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        AccountContext account = this.currency.getAccountManager().getAccount(playerName);
        if (account == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That account does not exist");
        }
        if (!account.hasBalance(amount)) {
            return new EconomyResponse(0.0, account.getBalance(), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
        }
        account.subtractBalance(amount);
        return new EconomyResponse(amount, account.getBalance(), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot desposit negative funds");
        }
        AccountContext account = this.currency.getAccountManager().getAccount(playerName);
        if (account == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That account does not exist");
        }
        account.addBalance(amount);
        return new EconomyResponse(amount, account.getBalance(), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        if (this.currency.getAccountManager().hasAccount(name)) {
            return new EconomyResponse(0.0, this.currency.getAccountManager().getAccount(name).getBalance(), EconomyResponse.ResponseType.FAILURE, "That account already exists.");
        }
        this.currency.getAccountManager().createAccount(name);
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        if (this.currency.getAccountManager().hasAccount(name)) {
            this.currency.getAccountManager().deleteAccount(name);
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That account does not exist!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        AccountContext account = this.currency.getAccountManager().getAccount(name);
        if (account == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That account does not exists.");
        }
        return new EconomyResponse(0.0, account.getBalance(), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        AccountContext account = this.currency.getAccountManager().getAccount(name);
        if (account == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That account does not exist!");
        }
        if (!account.hasBalance(amount)) {
            return new EconomyResponse(0.0, account.getBalance(), EconomyResponse.ResponseType.FAILURE, "That account does not have enough!");
        }
        return new EconomyResponse(0.0, account.getBalance(), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        AccountContext account = this.currency.getAccountManager().getAccount(name);
        if (account == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That account does not exist!");
        }
        if (!account.hasBalance(amount)) {
            return new EconomyResponse(0.0, account.getBalance(), EconomyResponse.ResponseType.FAILURE, "That account does not have enough!");
        }
        account.subtractBalance(amount);
        return new EconomyResponse(amount, account.getBalance(), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot desposit negative funds");
        }
        AccountContext account = this.currency.getAccountManager().getAccount(name);
        if (account == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That account does not exist!");
        }
        account.addBalance(amount);
        return new EconomyResponse(amount, account.getBalance(), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Currency does not support Bank members.");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Currency does not support Bank members.");
    }

    @Override
    public List<String> getBanks() {
        return this.currency.getAccountManager().getAccountList();
    }

    @Override
    public boolean hasBankSupport() {
        return true;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return this.currency.getAccountManager().getAccount(playerName) != null;
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        if (this.currency.getAccountManager().getAccount(playerName) != null) {
            return false;
        }
        this.currency.getAccountManager().createAccount(playerName);
        return true;
    }

    @Override
    public int fractionalDigits() {
        return -1;
    }

    public class EconomyServerListener
    implements Listener {
        private Economy_CurrencyCore economy = null;

        public EconomyServerListener(Economy_CurrencyCore economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin currencyPlugin;
            if (this.economy.currency == null && (currencyPlugin = Economy_CurrencyCore.this.plugin.getServer().getPluginManager().getPlugin("CurrencyCore")) != null && currencyPlugin.getClass().getName().equals("is.currency.Currency")) {
                this.economy.currency = (Currency)currencyPlugin;
                log.info(String.format("[%s][Economy] %s hooked.", Economy_CurrencyCore.this.plugin.getDescription().getName(), this.economy.getName()));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.currency != null && event.getPlugin().getDescription().getName().equals("CurrencyCore")) {
                this.economy.currency = null;
                log.info(String.format("[%s][Economy] %s unhooked.", Economy_CurrencyCore.this.plugin.getDescription().getName(), this.economy.getName()));
            }
        }
    }
}

