/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai;

import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class TeleportStuckAction
implements StuckAction {
    public static TeleportStuckAction INSTANCE = new TeleportStuckAction();
    private static int MAX_ITERATIONS = 10;
    private static final double RANGE = 10.0;

    private TeleportStuckAction() {
    }

    @Override
    public boolean run(NPC npc, Navigator navigator) {
        if (!npc.isSpawned()) {
            return false;
        }
        Location base = navigator.getTargetAsLocation();
        if (npc.getBukkitEntity().getLocation().distanceSquared(base) <= 10.0) {
            return true;
        }
        Block block = base.getBlock();
        int iterations = 0;
        while (!block.isEmpty()) {
            block = block.getRelative(BlockFace.UP);
            if (++iterations < MAX_ITERATIONS || block.isEmpty()) continue;
            block = base.getBlock();
        }
        npc.getBukkitEntity().teleport(block.getLocation());
        return false;
    }
}

