/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ListResourceBundle;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public enum Messages {
    CITIZENS_IMPLEMENTATION_DISABLED("citizens.changed-implementation", "Citizens implementation changed, disabling plugin."),
    FAILED_LOAD_SAVES("citizens.saves.load-failed", "Unable to load saves, disabling...");

    private String defaultTranslation;
    private String key;
    private static ResourceBundle defaultBundle;

    private Messages(String key, String defaultTranslation) {
        this.key = key;
        this.defaultTranslation = defaultTranslation;
    }

    public String getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle getDefaultResourceBundle(File resourceDirectory, String fileName) {
        if (defaultBundle == null) {
            resourceDirectory.mkdirs();
            File bundleFile = new File(resourceDirectory, fileName);
            if (!bundleFile.exists()) {
                try {
                    bundleFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Messages.populateDefaults(bundleFile);
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(bundleFile);
                defaultBundle = new PropertyResourceBundle(stream);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    defaultBundle = Messages.getFallbackResourceBundle();
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(stream);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)stream);
            }
            Closeables.closeQuietly((Closeable)stream);
        }
        return defaultBundle;
    }

    private static ResourceBundle getFallbackResourceBundle() {
        return new ListResourceBundle(){

            @Override
            protected Object[][] getContents() {
                Messages[] values = Messages.values();
                Object[][] contents = new Object[values.length][2];
                for (int i = 0; i < values.length; ++i) {
                    Messages message = values[i];
                    contents[i] = new Object[]{message.key, message.defaultTranslation};
                }
                return contents;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void populateDefaults(File bundleFile) {
        Properties properties = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(bundleFile);
            properties.load(in);
        }
        catch (IOException e) {
            Closeables.closeQuietly((Closeable)in);
            catch (Throwable throwable) {
                Closeables.closeQuietly(in);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)in);
        for (Messages message : Messages.values()) {
            if (properties.containsKey(message.key)) continue;
            properties.put(message.key, message.defaultTranslation);
        }
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(bundleFile);
            properties.store(stream, "");
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(stream);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)stream);
        }
        Closeables.closeQuietly((Closeable)stream);
    }
}

