/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import org.bukkit.Rotation;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;

@TraitName(value="itemframe")
public class ItemFrameTrait
extends Trait {
    @Persist
    private Boolean fixed;
    @Persist
    private ItemStack item;
    @Persist
    private Rotation rotation = Rotation.NONE;
    @Persist
    private boolean visible = true;
    @Persist
    private BlockFace facing = BlockFace.NORTH;

    public ItemFrameTrait() {
        super("itemframe");
    }

    public Boolean getFixed() {
        return this.fixed;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public BlockFace getFacing() {
        return this.facing;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void onSpawn() {
        if (this.npc.getEntity() instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)this.npc.getEntity();
            if (this.rotation != null) {
                frame.setRotation(this.rotation);
            }
            if (this.item != null) {
                frame.setItem(this.item);
            }
            if (this.facing != null) {
                frame.setFacingDirection(this.facing);
            }
            if (this.fixed != null) {
                frame.setFixed(this.fixed.booleanValue());
            } else {
                frame.setFixed(this.npc.isProtected());
            }
            frame.setVisible(this.visible);
        }
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
        this.onSpawn();
    }

    public void setItem(ItemStack item) {
        this.item = item;
        this.onSpawn();
    }

    public void setRotation(Rotation rot) {
        this.rotation = rot;
        this.onSpawn();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.onSpawn();
    }

    public void setFacing(BlockFace face) {
        this.facing = face;
        this.onSpawn();
    }
}

