/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_19_R3.util.EntityJumpControl;
import net.citizensnpcs.nms.v1_19_R3.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_19_R3.util.EntityNavigation;
import net.citizensnpcs.nms.v1_19_R3.util.NMSImpl;
import org.bukkit.entity.Entity;

public interface MobAI {
    public Entity getBukkitEntity();

    public blu getJumpControl();

    public Map<dwv, Float> getMalus();

    public blw getMoveControl();

    public bph getNavigation();

    default public float getPathfindingMalus(dwv var1) {
        Map<dwv, Float> malus = this.getMalus();
        return malus.containsKey(var1) ? malus.get(var1).floatValue() : var1.a();
    }

    default public void setPathfindingMalus(dwv water, float oldWaterCost) {
        this.getMalus().put(water, Float.valueOf(oldWaterCost));
    }

    default public void tickAI() {
        this.getJumpControl().b();
        this.getMoveControl().a();
        bph nav = this.getNavigation();
        if (!nav.l()) {
            nav.c();
        }
    }

    default public void updatePathfindingRange(float range) {
        ((bfx)NMSImpl.getHandle(this.getBukkitEntity())).a(bhe.b).a((double)range);
    }

    public static MobAI from(bfh handle) {
        if (handle instanceof bfz) {
            final bfz mob = (bfz)handle;
            return new MobAI(){

                @Override
                public Entity getBukkitEntity() {
                    return mob.getBukkitEntity();
                }

                @Override
                public blu getJumpControl() {
                    return mob.E();
                }

                @Override
                public Map<dwv, Float> getMalus() {
                    return null;
                }

                @Override
                public blw getMoveControl() {
                    return mob.D();
                }

                @Override
                public bph getNavigation() {
                    return mob.G();
                }

                @Override
                public float getPathfindingMalus(dwv var1) {
                    return mob.a(var1);
                }

                @Override
                public void setPathfindingMalus(dwv water, float oldWaterCost) {
                    mob.a(water, oldWaterCost);
                }

                @Override
                public void tickAI() {
                    mob.I().a();
                    mob.G().c();
                    mob.D().a();
                    mob.C().a();
                    mob.E().b();
                }
            };
        }
        if (handle instanceof MobAI) {
            return (MobAI)handle;
        }
        return null;
    }

    public static interface ForwardingMobAI
    extends MobAI {
        public MobAI getAI();

        @Override
        default public Entity getBukkitEntity() {
            return this.getAI().getBukkitEntity();
        }

        @Override
        default public blu getJumpControl() {
            return this.getAI().getJumpControl();
        }

        @Override
        default public Map<dwv, Float> getMalus() {
            return this.getAI().getMalus();
        }

        @Override
        default public blw getMoveControl() {
            return this.getAI().getMoveControl();
        }

        @Override
        default public bph getNavigation() {
            return this.getAI().getNavigation();
        }
    }

    public static class BasicMobAI
    implements MobAI {
        private final EntityJumpControl controllerJump;
        private final EntityMoveControl controllerMove;
        private final bfx entity;
        private final Map<dwv, Float> malus;
        private final EntityNavigation navigation;

        public BasicMobAI(bfx entity) {
            this.entity = entity;
            NMSImpl.setAttribute(entity, bhe.b, Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
            entity.a(bhe.d).a(0.3);
            this.controllerJump = new EntityJumpControl(entity);
            this.controllerMove = new EntityMoveControl(entity);
            this.navigation = new EntityNavigation(entity, entity.H);
            this.malus = Maps.newEnumMap(dwv.class);
        }

        @Override
        public Entity getBukkitEntity() {
            return this.entity.getBukkitEntity();
        }

        @Override
        public blu getJumpControl() {
            return this.controllerJump;
        }

        @Override
        public Map<dwv, Float> getMalus() {
            return this.malus;
        }

        @Override
        public blw getMoveControl() {
            return this.controllerMove;
        }

        @Override
        public bph getNavigation() {
            return this.navigation;
        }
    }
}

