/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R4.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R4.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R4.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R4.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.HorseModifiers;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftMule;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mule;

public class HorseMuleController
extends MobEntityController {
    public HorseMuleController() {
        super(EntityHorseMuleNPC.class, bxn.aG);
    }

    public void create(Location at, NPC npc) {
        npc.getOrAddTrait(HorseModifiers.class);
        super.create(at, npc);
    }

    public Mule getBukkitEntity() {
        return (Mule)super.getBukkitEntity();
    }

    public static class EntityHorseMuleNPC
    extends cmj
    implements NPCHolder {
        private double baseMovementSpeed;
        private final CitizensNPC npc;
        private boolean riding;

        public EntityHorseMuleNPC(bxn<? extends cmj> types, dkj level) {
            this(types, level, null);
        }

        public EntityHorseMuleNPC(bxn<? extends cmj> types, dkj level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                ((Mule)this.getBukkitEntity()).setDomestication(((Mule)this.getBukkitEntity()).getMaxDomestication());
                this.baseMovementSpeed = this.g(bzl.v).g();
            }
        }

        public boolean a(asc player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        protected boolean o(bxe entity) {
            if (this.npc != null && (entity instanceof cux || entity instanceof cuv)) {
                return !this.npc.isProtected();
            }
            return super.o(entity);
        }

        public boolean a(double f, float f1, bvt damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public void dH() {
            if (this.npc == null) {
                super.dH();
            }
        }

        protected void a(double d0, boolean flag, ebq iblockdata, iw blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public void a(asb level) {
            super.a(level);
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState((NPC)this.npc, (byh)this);
                if (this.npc.hasTrait(Controllable.class) && ((Controllable)this.npc.getOrAddTrait(Controllable.class)).isEnabled()) {
                    this.riding = this.getBukkitEntity().getPassengers().size() > 0;
                    this.g(bzl.v).a(this.baseMovementSpeed * (double)this.npc.getNavigator().getDefaultParameters().speedModifier());
                } else {
                    this.riding = false;
                }
                if (this.riding) {
                    if (this.npc.getNavigator().isNavigating()) {
                        CraftEntity basePassenger = ((bxe)this.u.get(0)).getBukkitEntity();
                        NMS.look((Entity)basePassenger, (float)this.dL(), (float)this.dN());
                    }
                    this.d(4, true);
                }
                NMS.setStepHeight((Entity)this.getBukkitEntity(), (float)1.0f);
                this.npc.update();
            }
        }

        protected awx s() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.s(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((bxe)this, (CraftEntity)new HorseMuleNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected awx j_() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.j_(), NPC.Metadata.DEATH_SOUND);
        }

        protected awx e(bvt damagesource) {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.e(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fh() {
            return NMS.getJumpPower((NPC)this.npc, (float)super.fh());
        }

        public int cE() {
            return NMS.getFallDistance((NPC)this.npc, (int)super.cE());
        }

        public NPC getNPC() {
            return this.npc;
        }

        public eyf i_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? eyf.d : super.i_();
        }

        public boolean di() {
            if (this.npc != null && this.riding) {
                return true;
            }
            return super.di();
        }

        public boolean Q_() {
            return NMSImpl.isLeashed((NPC)this.npc, () -> super.Q_(), (byh)this);
        }

        public boolean bG() {
            return this.npc == null ? super.bG() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        public boolean bZ() {
            return this.npc != null && this.npc.getNavigator().isNavigating() ? false : super.bZ();
        }

        public void p(double strength, double dx, double dz) {
            NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.p((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected ffx c(fgc vec3) {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.c(vec3));
        }

        public boolean k_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.k_();
            }
            return false;
        }

        public void a(aku<?> datawatcherobject) {
            if (this.npc == null) {
                super.a(datawatcherobject);
                return;
            }
            NMSImpl.checkAndUpdateHeight((byf)this, datawatcherobject, x$0 -> super.a(x$0));
        }

        public void h(bxe entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean g(ua save) {
            return this.npc == null ? super.g(save) : false;
        }

        public bxe b(eza transition) {
            if (this.npc == null) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((bxe)this, transition);
        }

        public void a_(fgc vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a_(vec3d);
            } else {
                NMSImpl.moveLogic((byf)this, vec3d);
            }
        }

        public boolean a(ayc<exz> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            fgc old = this.dy().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.i(old);
            }
            return res;
        }
    }

    public static class HorseMuleNPC
    extends CraftMule
    implements ForwardingNPCHolder {
        public HorseMuleNPC(EntityHorseMuleNPC entity) {
            super((CraftServer)Bukkit.getServer(), (cmj)entity);
        }
    }
}

