/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.citizensnpcs.api.event.NPCDamageEvent;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitEventHandler;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.util.Util;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;

@TraitName(value="scaledhealthtrait")
public class ScaledMaxHealthTrait
extends Trait {
    @Persist
    private Double maxHealth;
    private static int MAX_VALUE = 2048;
    private static boolean SUPPORTS_ATTRIBUTES = true;

    public ScaledMaxHealthTrait() {
        super("scaledhealthtrait");
    }

    public Double getMaxHealth() {
        return this.maxHealth;
    }

    @TraitEventHandler(value=@EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true))
    public void onDamage(NPCDamageEvent event) {
        if (this.maxHealth == null || this.npc.getEntity() instanceof LivingEntity) {
            return;
        }
        event.setCancelled(true);
        LivingEntity entity = (LivingEntity)this.npc.getEntity();
        entity.setHealth(new BigDecimal(entity.getHealth() - Math.min(this.maxHealth, (double)MAX_VALUE) / event.getDamage()).setScale(0, RoundingMode.HALF_DOWN).doubleValue());
    }

    @Override
    public void onSpawn() {
        if (this.maxHealth != null && this.npc.getEntity() instanceof LivingEntity) {
            if (SUPPORTS_ATTRIBUTES) {
                ((LivingEntity)this.npc.getEntity()).getAttribute((Attribute)Util.getRegistryValue(Registry.ATTRIBUTE, "generic.max_health", "max_health")).setBaseValue(Math.min((double)MAX_VALUE, this.maxHealth));
            } else {
                ((LivingEntity)this.npc.getEntity()).setMaxHealth(this.maxHealth.doubleValue());
            }
        }
    }

    public void setMaxHealth(Double maxHealth) {
        this.maxHealth = maxHealth;
    }

    static {
        try {
            Class.forName("org.bukkit.attribute.Attribute");
        }
        catch (ClassNotFoundException e) {
            SUPPORTS_ATTRIBUTES = false;
        }
    }
}

