/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.skin.profile;

import java.util.Objects;
import java.util.function.Consumer;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.npc.skin.profile.ProfileFetchThread;
import net.citizensnpcs.npc.skin.profile.ProfileRequest;
import org.bukkit.Bukkit;
import org.bukkit.scheduler.BukkitTask;

public class ProfileFetcher {
    private static ProfileFetchThread PROFILE_THREAD;
    private static BukkitTask THREAD_TASK;

    ProfileFetcher() {
    }

    public static void fetch(String name, Consumer<ProfileRequest> handler) {
        Objects.requireNonNull(name);
        if (PROFILE_THREAD == null) {
            ProfileFetcher.initThread();
        }
        PROFILE_THREAD.fetch(name, handler);
    }

    public static void fetchForced(String name, Consumer<ProfileRequest> handler) {
        Objects.requireNonNull(name);
        if (PROFILE_THREAD == null) {
            ProfileFetcher.initThread();
        }
        PROFILE_THREAD.fetchForced(name, handler);
    }

    private static void initThread() {
        if (THREAD_TASK != null) {
            THREAD_TASK.cancel();
        }
        PROFILE_THREAD = new ProfileFetchThread();
        THREAD_TASK = Bukkit.getScheduler().runTaskTimerAsynchronously(CitizensAPI.getPlugin(), (Runnable)PROFILE_THREAD, 21L, 20L);
    }

    public static void reset() {
        ProfileFetcher.initThread();
    }

    public static void shutdown() {
        if (THREAD_TASK != null) {
            THREAD_TASK.cancel();
            THREAD_TASK = null;
        }
    }
}

