/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.IfElse;
import net.citizensnpcs.api.ai.tree.Loop;
import net.citizensnpcs.api.ai.tree.Selector;
import net.citizensnpcs.api.ai.tree.Sequence;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.TraitTemplateParser;
import net.citizensnpcs.api.util.DataKey;

@TraitName(value="behavior")
public class BehaviorTrait
extends Trait {
    private final Behavior root = new Behavior(){

        @Override
        public void reset() {
        }

        @Override
        public BehaviorStatus run() {
            return null;
        }

        @Override
        public boolean shouldExecute() {
            return false;
        }
    };

    public BehaviorTrait() {
        super("behavior");
    }

    @Override
    public void onDespawn() {
        this.npc.getDefaultGoalController().removeBehavior(this.root);
    }

    @Override
    public void onSpawn() {
        this.npc.getDefaultGoalController().addBehavior(this.root, 1);
    }

    public static TraitTemplateParser createTemplateParser() {
        return TraitTemplateParser.createDefault(BehaviorTrait.class);
    }

    private static Supplier<Boolean> parseCondition(String replaceFirst) {
        return null;
    }

    private static Behavior parseContainer(String name, DataKey key) {
        if (name.equalsIgnoreCase("sequence")) {
            ArrayList behaviors = Lists.newArrayList();
            for (DataKey sub : key.getSubKeys()) {
                behaviors.add(BehaviorTrait.recursiveParse(sub));
            }
            return Sequence.createSequence(behaviors);
        }
        if (name.equalsIgnoreCase("random")) {
            ArrayList behaviors = Lists.newArrayList();
            for (DataKey sub : key.getSubKeys()) {
                behaviors.add(BehaviorTrait.recursiveParse(sub));
            }
            return Selector.selecting(behaviors).build();
        }
        if (name.startsWith("loop ")) {
            Supplier<Boolean> condition = BehaviorTrait.parseCondition(name.replaceFirst("loop ", ""));
            Behavior wrapping = BehaviorTrait.parseContainer("sequence", key);
            return Loop.createWithCondition(wrapping, condition);
        }
        return null;
    }

    private static Behavior parseIfElse(DataKey ifKey, DataKey elseKey) {
        return IfElse.create(BehaviorTrait.parseCondition(ifKey.name().replaceFirst("if ", "")), BehaviorTrait.recursiveParse(ifKey), elseKey == null ? null : BehaviorTrait.recursiveParse(elseKey));
    }

    private static Behavior parseLeaf(String name) {
        return null;
    }

    private static Behavior recursiveParse(DataKey key) {
        if (key.getSubKeys().iterator().hasNext()) {
            DataKey ifKey = null;
            DataKey elseKey = key.getRelative("else");
            for (DataKey sub : key.getSubKeys()) {
                if (!sub.name().startsWith("if ")) continue;
                ifKey = sub;
            }
            if (ifKey != null) {
                return BehaviorTrait.parseIfElse(ifKey, elseKey);
            }
            return BehaviorTrait.parseContainer(key.name(), key);
        }
        return BehaviorTrait.parseLeaf(key.getString(""));
    }
}

