/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.base.Charsets;
import com.google.common.io.BaseEncoding;
import java.util.Objects;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.SkinProperty;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;

@TraitName(value="skintrait")
public class SkinTrait
extends Trait {
    @Persist
    private NamespacedKey body;
    @Persist
    private NamespacedKey cape;
    @Persist
    private NamespacedKey elytra;
    @Persist
    private boolean fetchDefaultSkin = Settings.Setting.NPC_SKIN_FETCH_DEFAULT.asBoolean();
    private String filledPlaceholder;
    @Persist
    private SkinnableEntity.PlayerSkinModelType modelType = SkinnableEntity.PlayerSkinModelType.WIDE;
    @Persist
    private String signature;
    @Persist
    private String skinName;
    @Persist
    private String textureRaw;
    private int timer;
    @Persist
    private boolean updateSkins = Settings.Setting.NPC_SKIN_USE_LATEST.asBoolean();

    public SkinTrait() {
        super("skintrait");
    }

    public void applyTextureInternal(String signature, String value) {
        this.textureRaw = value;
        this.signature = signature;
    }

    private boolean checkPlaceholder() {
        if (this.body != null || this.skinName == null) {
            return false;
        }
        String filled = ChatColor.stripColor((String)Placeholders.replace(this.skinName, null, this.npc).toLowerCase());
        if (!filled.equalsIgnoreCase(this.skinName) && !filled.equalsIgnoreCase(this.filledPlaceholder)) {
            this.filledPlaceholder = filled;
            Messaging.debug("Filled skin placeholder", filled, "from", this.skinName);
            return true;
        }
        return false;
    }

    public void clearTexture() {
        this.textureRaw = null;
        this.signature = null;
        this.skinName = null;
        this.body = null;
        this.cape = null;
        this.elytra = null;
        this.modelType = SkinnableEntity.PlayerSkinModelType.WIDE;
    }

    public boolean fetchDefaultSkin() {
        return this.fetchDefaultSkin;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getSkinName() {
        return this.filledPlaceholder != null && this.skinName != null ? this.filledPlaceholder : (this.skinName == null ? this.skinName : this.skinName.toLowerCase());
    }

    public String getTexture() {
        return this.textureRaw;
    }

    private void onSkinChange(boolean forceUpdate) {
        if (!(this.npc.getEntity() instanceof SkinnableEntity)) {
            return;
        }
        ((SkinnableEntity)this.npc.getEntity()).getSkinTracker().notifySkinChange(forceUpdate);
    }

    @Override
    public void onSpawn() {
        if (this.npc.getEntity() instanceof SkinnableEntity && this.body != null) {
            ((SkinnableEntity)this.npc.getEntity()).setSkinPatch(this.modelType, this.body, this.cape, this.elytra);
        }
    }

    @Override
    public void run() {
        if (this.timer-- > 0) {
            return;
        }
        this.timer = Settings.Setting.PLACEHOLDER_SKIN_UPDATE_FREQUENCY.asTicks();
        if (this.checkPlaceholder()) {
            this.onSkinChange(true);
        }
    }

    public void setFetchDefaultSkin(boolean fetch) {
        this.fetchDefaultSkin = fetch;
    }

    public void setShouldUpdateSkins(boolean update) {
        this.updateSkins = update;
    }

    public void setSkinName(String name) {
        this.setSkinName(name, false);
    }

    public void setSkinName(String name, boolean forceUpdate) {
        Objects.requireNonNull(name);
        this.setSkinNameInternal(name);
        this.onSkinChange(forceUpdate);
    }

    private void setSkinNameInternal(String name) {
        this.skinName = ChatColor.stripColor((String)name);
    }

    public void setSkinPatch(SkinnableEntity.PlayerSkinModelType modelType, NamespacedKey body, NamespacedKey cape, NamespacedKey elytra) {
        this.body = body;
        this.cape = cape;
        this.elytra = elytra;
        this.modelType = modelType;
        if (body != null && this.npc.getEntity() instanceof SkinnableEntity) {
            ((SkinnableEntity)this.npc.getEntity()).setSkinPatch(modelType, body, cape, elytra);
        }
    }

    public void setSkinPersistent(Player player) {
        SkinProperty sp = SkinProperty.fromMojangProfile(NMS.getProfile(player));
        this.setSkinPersistent(sp.name, sp.signature, sp.value);
    }

    public void setSkinPersistent(String skinName, String signature, String data) {
        Objects.requireNonNull(skinName);
        Objects.requireNonNull(signature);
        Objects.requireNonNull(data);
        this.setSkinNameInternal(skinName);
        String json = new String(BaseEncoding.base64().decode((CharSequence)data), Charsets.UTF_8);
        if (!json.contains("textures")) {
            throw new IllegalArgumentException("Invalid texture data");
        }
        this.signature = signature;
        this.textureRaw = data;
        this.updateSkins = false;
        this.npc.data().setPersistent("cached-skin-uuid-name", (Object)skinName.toLowerCase());
        this.onSkinChange(false);
    }

    public boolean shouldUpdateSkins() {
        return this.updateSkins;
    }
}

