/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R5.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_21_R5.network.EmptyConnection;
import net.citizensnpcs.nms.v1_21_R5.network.EmptyPacketListener;
import net.citizensnpcs.nms.v1_21_R5.util.EmptyAdvancementDataPlayer;
import net.citizensnpcs.nms.v1_21_R5.util.EmptyServerStatsCounter;
import net.citizensnpcs.nms.v1_21_R5.util.MobAI;
import net.citizensnpcs.nms.v1_21_R5.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.SkinProperty;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder,
SkinnableEntity,
MobAI.ForwardingMobAI {
    private AdvancementDataPlayer advancements;
    private final MobAI ai;
    private int jumpTicks = 0;
    private final CitizensNPC npc;
    private boolean setBukkitEntity;
    private final SkinPacketTracker skinTracker;
    private EmptyServerStatsCounter statsCache;
    private static final float EPSILON = 0.003f;
    private static final MethodHandle GAMEMODE_SETTER = NMS.getFirstMethodHandle(PlayerInteractManager.class, (boolean)true, (Class[])new Class[]{EnumGamemode.class, EnumGamemode.class});

    public EntityHumanNPC(MinecraftServer minecraftServer, WorldServer world, GameProfile gameProfile, atl ci, NPC npc) {
        super(minecraftServer, world, gameProfile, ci);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.ai = new MobAI.BasicMobAI((EntityLiving)this);
            this.skinTracker = new SkinPacketTracker((SkinnableEntity)this);
            try {
                GAMEMODE_SETTER.invoke(this.h, EnumGamemode.a, null);
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
            this.initialise(minecraftServer, ci);
        } else {
            this.ai = null;
            this.skinTracker = null;
        }
    }

    public void applyTexture(SkinProperty property) {
        this.gameProfile().getProperties().clear();
        this.gameProfile().getProperties().putAll((Object)property.name, (Iterable)ImmutableList.of((Object)new Property(property.name, property.value, property.signature)));
    }

    public boolean a(EntityPlayer player) {
        return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
    }

    public boolean a(double f, float f1, byb damagesource) {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.a(f, f1, damagesource);
        }
        return false;
    }

    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(d0, flag, iblockdata, blockposition);
        }
    }

    public void a(byb damagesource) {
        if (this.by) {
            return;
        }
        super.a(damagesource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), () -> {
            this.y().a((EntityPlayer)this, bzm.e.a);
            this.y().n().a((bzm)this);
        }, 15L);
    }

    public void h() {
        boolean navigating;
        if (this.npc == null) {
            super.h();
            return;
        }
        NMSImpl.callNPCMoveEvent((NPC)this.npc, (bzm)this);
        super.az();
        boolean bl = navigating = this.npc.getNavigator().isNavigating() || this.ai.getMoveControl().b();
        if (!(navigating || this.getBukkitEntity() == null || this.npc.hasTrait(Gravity.class) && !((Gravity)this.npc.getOrAddTrait(Gravity.class)).hasGravity() || !Util.isLoaded((Location)this.getBukkitEntity().getLocation()) || this.npc.isProtected() && !SpigotUtil.checkYSafe((double)this.dE(), (World)this.getBukkitEntity().getWorld()))) {
            this.moveWithFallDamage(Vec3D.c);
        }
        Vec3D mot = this.dA();
        if (Math.abs(mot.d) < (double)0.003f && Math.abs(mot.e) < (double)0.003f && Math.abs(mot.f) < (double)0.003f) {
            this.i(Vec3D.c);
        }
        if (navigating) {
            if (!this.ai.getNavigation().l()) {
                this.ai.getNavigation().d();
            }
            this.moveOnCurrentHeading();
        }
        this.tickAI();
        this.aL();
        this.aq = this.am();
        if (this.am()) {
            this.bb = false;
        }
        this.o();
        if (this.npc.useMinecraftAI()) {
            this.co.a((EntityPlayer)this);
        }
        if (((Boolean)this.npc.data().get(NPC.Metadata.PICKUP_ITEMS, (Object)false)).booleanValue()) {
            if (this.ct > 0) {
                --this.ct;
            }
            AxisAlignedBB axisalignedbb = this.cc() && !this.dm().dU() ? this.cV().b(this.dm().cV()).c(1.0, 0.0, 1.0) : this.cV().c(1.0, 0.5, 1.0);
            for (bzm entity : this.y().a_((bzm)this, axisalignedbb)) {
                entity.a_((EntityHuman)this);
            }
        }
        ++this.bo;
        this.gP().a();
        EntityPoseTrait ept = (EntityPoseTrait)this.npc.getTraitNullable(EntityPoseTrait.class);
        if (ept == null || ept.getPose() == null) {
            this.gl();
        }
    }

    public GameProfile gameProfile() {
        return this.gr();
    }

    public AdvancementDataPlayer S() {
        if (this.advancements == null) {
            this.advancements = new EmptyAdvancementDataPlayer(this.cX().aC(), this.cX().ag(), this);
        }
        return this.advancements;
    }

    @Override
    public MobAI getAI() {
        return this.ai;
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && !this.setBukkitEntity) {
            NMSImpl.setBukkitEntity((bzm)this, (CraftEntity)new PlayerNPC(this));
            this.setBukkitEntity = true;
        }
        return super.getBukkitEntity();
    }

    protected SoundEffect f_() {
        return NMSImpl.getSoundEffect((NPC)this.npc, super.f_(), NPC.Metadata.DEATH_SOUND);
    }

    protected SoundEffect e(byb damagesource) {
        return NMSImpl.getSoundEffect((NPC)this.npc, super.e(damagesource), NPC.Metadata.HURT_SOUND);
    }

    public float fn() {
        return NMS.getJumpPower((NPC)this.npc, (float)super.fn());
    }

    public int cI() {
        return NMS.getFallDistance((NPC)this.npc, (int)super.cI());
    }

    public NPC getNPC() {
        return this.npc;
    }

    public EnumPistonReaction k_() {
        return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.k_();
    }

    public SkinPacketTracker getSkinTracker() {
        return this.skinTracker;
    }

    public ServerStatisticManager I() {
        return this.statsCache == null ? (this.statsCache = new EmptyServerStatsCounter()) : this.statsCache;
    }

    public IChatBaseComponent O() {
        if (this.npc != null && this.npc.shouldRemoveFromTabList()) {
            return IChatMutableComponent.a((xp)new LiteralContents.a(""));
        }
        return this.npc != null ? (IChatBaseComponent)Messaging.minecraftComponentFromRawMessage((String)this.npc.getRawName()) : super.O();
    }

    public boolean a(WorldServer level, byb damagesource, float f) {
        boolean damaged = super.a(level, damagesource, f);
        if (damaged && this.ag) {
            this.ag = false;
            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), () -> {
                this.ag = true;
            });
        }
        return damaged;
    }

    private void initialise(MinecraftServer minecraftServer, atl clientInfo) {
        try {
            EmptyConnection conn = new EmptyConnection(EnumProtocolDirection.b);
            this.g = new EmptyPacketListener(minecraftServer, conn, this, aur.a((GameProfile)this.gameProfile(), (boolean)false));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.w(true);
        this.setSkinFlags((byte)-1);
    }

    public boolean bP() {
        if (this.npc == null || this.aq || this.fY()) {
            return super.bP();
        }
        return Util.inBlock((Entity)this.getBukkitEntity());
    }

    public boolean bL() {
        return this.npc == null ? super.bL() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
    }

    public void p(double strength, double dx, double dz) {
        NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.p((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
    }

    private void moveOnCurrentHeading() {
        if (this.bB) {
            if (this.bb && this.jumpTicks == 0) {
                this.s();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.bC *= 0.98f;
        this.bE *= 0.98f;
        this.moveWithFallDamage(new Vec3D((double)this.bC, (double)this.bD, (double)this.bE));
        NMS.setHeadAndBodyYaw((Entity)this.getBukkitEntity(), (float)this.dP());
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    private void moveWithFallDamage(Vec3D vec) {
        double x = this.dC();
        double y = this.dE();
        double z = this.dI();
        this.k(vec);
        if (!this.npc.isProtected()) {
            this.a(this.dC() - x, this.dE() - y, this.dI() - z, this.bb);
        }
    }

    public boolean eV() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.eV();
        }
        return false;
    }

    public void h(bzm entity) {
        super.h(entity);
        if (this.npc != null) {
            Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
        }
    }

    public void a(bzm.e reason) {
        super.a(reason);
        this.S().b();
    }

    public void setSkinFlags(byte flags) {
        this.au().a(EntityHuman.cg, (Object)flags);
    }

    public void g() {
        super.g();
        if (this.npc == null) {
            return;
        }
        if (NMSImpl.PAPER_LIVING_ENTITY_DETECT_EQUIPMENT_UPDATES != null) {
            try {
                NMSImpl.PAPER_LIVING_ENTITY_DETECT_EQUIPMENT_UPDATES.invoke(this);
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
        } else {
            this.detectEquipmentUpdatesPublic();
        }
        this.c(List.of());
        Bukkit.getServer().getPluginManager().unsubscribeFromPermission("bukkit.broadcast.user", (Permissible)this.getBukkitEntity());
        this.updatePackets(this.npc.getNavigator().isNavigating());
        this.npc.update();
        if (NMSImpl.PAPER_PLAYER_MOB_COUNTS != null && this.npc.shouldRemoveFromPlayerList()) {
            try {
                int[] counts = NMSImpl.PAPER_PLAYER_MOB_COUNTS.invoke(this);
                for (int i = 0; i < counts.length; ++i) {
                    counts[i] = 0;
                }
            }
            catch (Throwable e3) {
                e3.printStackTrace();
            }
        }
        if (this.fG()) {
            if (dcv.b((dcv)this.b(this.fH()), (dcv)this.bI)) {
                this.bI = this.b(this.fH());
                this.a(this.bI);
            } else {
                this.fM();
            }
        }
    }

    @Override
    public void tickAI() {
        this.ai.getMoveControl().a();
        this.ai.getJumpControl().b();
    }

    public void k(Vec3D vec3d) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.k(vec3d);
        } else {
            NMSImpl.moveLogic((EntityLiving)this, vec3d);
        }
    }

    public boolean a(bae<FluidType> tagkey, double d0) {
        Vec3D old = this.dA().b(0.0, 0.0, 0.0);
        boolean res = super.a(tagkey, d0);
        if (!this.npc.isPushableByFluids()) {
            this.i(old);
        }
        return res;
    }

    private void updatePackets(boolean navigating) {
        if (!this.npc.isUpdating(NPC.NPCUpdate.PACKET)) {
            return;
        }
        this.ch = true;
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder,
    SkinnableEntity.ForwardingSkinnableEntity {
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPlayer)entity);
            this.npc = entity.npc;
            this.npc.getOrAddTrait(Inventory.class);
        }

        public boolean canSee(Entity entity) {
            if (entity != null && entity.getType().name().contains("ITEM_FRAME")) {
                return false;
            }
            return super.canSee(entity);
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        public NPC getNPC() {
            return this.npc;
        }

        public SkinnableEntity getUnderlying() {
            return (SkinnableEntity)this.entity;
        }

        public boolean hasMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }
    }
}

