/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.citizensnpcs.api.npc.AbstractNPC;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.PacketNPC;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerUpdateTask
extends BukkitRunnable {
    private final List<PlayerTick> players = Lists.newArrayList();
    private final Set<UUID> uuids = Sets.newHashSet();
    private static final List<Entity> PLAYERS_PENDING_ADD = new ArrayList<Entity>();
    private static final Set<UUID> PLAYERS_PENDING_REMOVE = new HashSet<UUID>();

    public void cancel() {
        super.cancel();
        this.uuids.clear();
        this.players.clear();
        PLAYERS_PENDING_ADD.clear();
        PLAYERS_PENDING_REMOVE.clear();
    }

    public void run() {
        if (PLAYERS_PENDING_REMOVE.size() > 0) {
            this.players.removeIf(pt -> PLAYERS_PENDING_REMOVE.contains(((PlayerTick)pt).entity.getUniqueId()));
            for (UUID uuid : PLAYERS_PENDING_REMOVE) {
                this.uuids.remove(uuid);
            }
            PLAYERS_PENDING_REMOVE.clear();
        }
        for (Entity entity : PLAYERS_PENDING_ADD) {
            NPC next = ((NPCHolder)entity).getNPC();
            if (this.uuids.contains(entity.getUniqueId())) {
                NPC old;
                PlayerTick rm = null;
                Iterator<PlayerTick> itr = this.players.iterator();
                while (itr.hasNext()) {
                    PlayerTick pt2 = itr.next();
                    if (!pt2.entity.getUniqueId().equals(entity.getUniqueId())) continue;
                    rm = pt2;
                    itr.remove();
                    this.uuids.remove(pt2.entity.getUniqueId());
                    break;
                }
                if ((old = ((NPCHolder)rm.entity).getNPC()) != next) {
                    Messaging.severe("Player registered twice with different NPC instances", rm.entity.getUniqueId());
                }
                if (rm.entity instanceof Player) {
                    ((Player)rm.entity).kickPlayer(null);
                } else {
                    rm.entity.remove();
                }
            }
            if (next.hasTrait(PacketNPC.class)) {
                this.players.add(new PlayerTick(entity, () -> ((AbstractNPC)next).update()));
            } else {
                this.players.add(new PlayerTick(entity, NMS.playerTicker((Player)entity)));
            }
            this.uuids.add(entity.getUniqueId());
        }
        PLAYERS_PENDING_ADD.clear();
        for (PlayerTick player : this.players) {
            player.run();
        }
    }

    public static void deregister(Entity entity) {
        PLAYERS_PENDING_ADD.remove(entity);
        PLAYERS_PENDING_REMOVE.add(entity.getUniqueId());
    }

    public static void register(Entity entity) {
        PLAYERS_PENDING_REMOVE.remove(entity.getUniqueId());
        PLAYERS_PENDING_ADD.add(entity);
    }

    private static class PlayerTick
    implements Runnable {
        private final Entity entity;
        private final Runnable tick;

        public PlayerTick(Entity entity, Runnable tick) {
            this.entity = entity;
            this.tick = tick;
        }

        @Override
        public void run() {
            this.tick.run();
        }
    }
}

