/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import java.util.Objects;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.event.PlayerCreateNPCEvent;
import net.citizensnpcs.api.util.Messaging;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PaymentListener
implements Listener {
    private final Economy provider;

    public PaymentListener(Economy provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        this.provider = provider;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCreateNPC(PlayerCreateNPCEvent event) {
        if (!this.provider.hasAccount((OfflinePlayer)event.getCreator()) || event.getCreator().hasPermission("citizens.npc.ignore-cost")) {
            return;
        }
        double cost = Settings.Setting.NPC_COST.asDouble();
        EconomyResponse response = this.provider.withdrawPlayer((OfflinePlayer)event.getCreator(), cost);
        if (!response.transactionSuccess()) {
            event.setCancelled(true);
            event.setCancelReason(response.errorMessage);
            return;
        }
        String formattedCost = this.provider.format(cost);
        Messaging.sendTr((CommandSender)event.getCreator(), "citizens.economy.money-withdrawn", formattedCost);
    }
}

