/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.util.Vector;

public class MinecraftBlockExaminer
implements BlockExaminer {
    private static final Set<Material> CLIMBABLE = EnumSet.of(Material.LADDER, Material.VINE);
    private static final Set<Material> LIQUIDS = EnumSet.of(Material.WATER, Material.LAVA);
    private static final Set<Material> NOT_JUMPABLE = EnumSet.of(Material.SPRUCE_FENCE, Material.BIRCH_FENCE, Material.JUNGLE_FENCE, Material.ACACIA_FENCE, Material.DARK_OAK_FENCE);
    private static final Set<Material> UNWALKABLE = EnumSet.of(Material.AIR, Material.CACTUS);
    private static final Material WEB;

    @Override
    public BlockExaminer.StandableState canStandAt(BlockSource source, PathPoint point) {
        boolean canStand;
        Vector pos = point.getVector();
        if (!source.isYWithinBounds(pos.getBlockY())) {
            return BlockExaminer.StandableState.NOT_STANDABLE;
        }
        Material below = source.getMaterialAt(pos.getBlockX(), pos.getBlockY() - 1, pos.getBlockZ());
        Material in = source.getMaterialAt(pos);
        boolean bl = canStand = MinecraftBlockExaminer.canStandOn(below, source.getBlockDataAt(pos.getBlockX(), pos.getBlockY() - 1, pos.getBlockZ())) || MinecraftBlockExaminer.isLiquid(in, below) || this.isClimbable(below);
        if (!canStand) {
            return BlockExaminer.StandableState.NOT_STANDABLE;
        }
        if (!MinecraftBlockExaminer.canJumpOn(below)) {
            if (point.getParentPoint() == null) {
                return BlockExaminer.StandableState.NOT_STANDABLE;
            }
            Vector parentPos = point.getParentPoint().getVector();
            if ((parentPos.getX() != pos.getX() || parentPos.getZ() != pos.getZ()) && pos.clone().subtract(point.getParentPoint().getVector()).getY() == 1.0) {
                return BlockExaminer.StandableState.NOT_STANDABLE;
            }
        }
        return BlockExaminer.StandableState.STANDABLE;
    }

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        Material above = source.getMaterialAt(pos.getBlockX(), pos.getBlockY() + 1, pos.getBlockZ());
        Material below = source.getMaterialAt(pos.getBlockX(), pos.getBlockY() - 1, pos.getBlockZ());
        Material in = source.getMaterialAt(pos);
        if (above == WEB || in == WEB || below == Material.SOUL_SAND || below == Material.ICE) {
            return 2.0f;
        }
        if (MinecraftBlockExaminer.isLiquidOrWaterlogged(source.getMaterialAt(pos), source.getBlockDataAt(pos))) {
            if (in == Material.LAVA) {
                return 4.0f;
            }
            return 2.0f;
        }
        return 0.0f;
    }

    private boolean isClimbable(Material mat) {
        return CLIMBABLE.contains(mat);
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        Material in = source.getMaterialAt(pos);
        Material above = source.getMaterialAt(pos.getBlockX(), pos.getBlockY() + 1, pos.getBlockZ());
        Material below = source.getMaterialAt(pos.getBlockX(), pos.getBlockY() - 1, pos.getBlockZ());
        if (this.isClimbable(in) && (this.isClimbable(above) || this.isClimbable(below))) {
            point.addCallback(new LadderClimber());
            return BlockExaminer.PassableState.PASSABLE;
        }
        if (!MinecraftBlockExaminer.canStandIn(in, source.getBlockDataAt(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ())) || !MinecraftBlockExaminer.canStandIn(above, source.getBlockDataAt(pos.getBlockX(), pos.getBlockY() + 1, pos.getBlockZ()))) {
            return BlockExaminer.PassableState.IMPASSABLE;
        }
        return BlockExaminer.PassableState.PASSABLE;
    }

    private static boolean canJumpOn(Material mat) {
        return !NOT_JUMPABLE.contains(mat);
    }

    public static boolean canStandIn(Block ... blocks) {
        Block block;
        boolean passable = true;
        Block[] blockArray = blocks;
        int n = blockArray.length;
        for (int i = 0; i < n && (passable = MinecraftBlockExaminer.canStandIn((block = blockArray[i]).getType(), block.getBlockData())); ++i) {
        }
        return passable;
    }

    public static boolean canStandIn(Material ... mat) {
        boolean passable = true;
        for (Material m : mat) {
            passable &= !m.isSolid();
        }
        return passable;
    }

    public static boolean canStandIn(Material mat, BlockData data) {
        boolean passable;
        boolean bl = passable = !mat.isSolid();
        if (SpigotUtil.isUsing1_13API()) {
            if (data instanceof Slab) {
                Slab slab = (Slab)data;
                if (slab.getType() != Slab.Type.BOTTOM) {
                    passable = false;
                }
            } else if (data instanceof TrapDoor) {
                TrapDoor trapdoor = (TrapDoor)data;
                passable &= trapdoor.isOpen();
            }
        }
        return passable;
    }

    public static boolean canStandOn(Block block) {
        boolean standable = MinecraftBlockExaminer.canStandOn(block.getType(), block.getBlockData());
        if (!standable) {
            return false;
        }
        Block up = block.getRelative(BlockFace.UP);
        return MinecraftBlockExaminer.canStandIn(up, up.getRelative(BlockFace.UP));
    }

    public static boolean canStandOn(Material mat) {
        return !UNWALKABLE.contains(mat) && mat.isSolid();
    }

    public static boolean canStandOn(Material mat, BlockData data) {
        boolean stand = MinecraftBlockExaminer.canStandOn(mat);
        if (!stand && SpigotUtil.isUsing1_13API() && data instanceof TrapDoor) {
            stand = !((TrapDoor)data).isOpen();
        }
        return stand;
    }

    public static Location findRandomValidLocation(Location base, int xrange, int yrange) {
        return MinecraftBlockExaminer.findRandomValidLocation(base, xrange, yrange, null, new Random());
    }

    public static Location findRandomValidLocation(Location base, int xrange, int yrange, Function<Block, Boolean> filter) {
        return MinecraftBlockExaminer.findRandomValidLocation(base, xrange, yrange, filter, new Random());
    }

    public static Location findRandomValidLocation(Location base, int xrange, int yrange, Function<Block, Boolean> filter, Random random) {
        for (int i = 0; i < 10; ++i) {
            Block block;
            int x = base.getBlockX() + random.nextInt(2 * xrange + 1) - xrange;
            int y = base.getBlockY() + random.nextInt(2 * yrange + 1) - yrange;
            int z = base.getBlockZ() + random.nextInt(2 * xrange + 1) - xrange;
            if (!base.getWorld().isChunkLoaded(x >> 4, z >> 4) || !MinecraftBlockExaminer.canStandOn(block = base.getWorld().getBlockAt(x, y, z)) || filter != null && !filter.apply(block).booleanValue()) continue;
            return block.getLocation().add(0.0, 1.0, 0.0);
        }
        return null;
    }

    public static Location findValidLocation(Location location, int radius) {
        return MinecraftBlockExaminer.findValidLocation(location, radius, radius);
    }

    public static Location findValidLocation(Location location, int xradius, int yradius) {
        return MinecraftBlockExaminer.findValidLocation(location, xradius, yradius, b -> true);
    }

    public static Location findValidLocation(Location location, int xradius, int yradius, Function<Block, Boolean> filter) {
        Block base = location.getBlock();
        if (filter.apply(base).booleanValue() && MinecraftBlockExaminer.canStandOn(base.getRelative(BlockFace.DOWN))) {
            return location;
        }
        for (int y = -yradius; y <= yradius; ++y) {
            for (int x = -xradius; x <= xradius; ++x) {
                for (int z = -xradius; z <= xradius; ++z) {
                    Block relative;
                    if (!base.getWorld().isChunkLoaded(base.getX() + x >> 4, base.getZ() + z >> 4) || !filter.apply(relative = base.getRelative(x, y, z)).booleanValue() || !MinecraftBlockExaminer.canStandOn(relative.getRelative(BlockFace.DOWN))) continue;
                    return relative.getLocation();
                }
            }
        }
        return location;
    }

    public static Location findValidLocationAbove(Location location, int radius) {
        Block base = location.getBlock();
        if (MinecraftBlockExaminer.canStandOn(base.getRelative(BlockFace.DOWN))) {
            return location;
        }
        for (int y = 0; y <= radius; ++y) {
            Block relative = base.getRelative(0, y, 0);
            if (!MinecraftBlockExaminer.canStandOn(relative.getRelative(BlockFace.DOWN))) continue;
            return relative.getLocation();
        }
        return location;
    }

    public static boolean isDoor(Material in) {
        return in.name().contains("DOOR") && !in.name().contains("TRAPDOOR");
    }

    public static boolean isGate(Material in) {
        return in.name().contains("GATE") && !in.name().contains("GATEWAY");
    }

    public static boolean isLiquid(Material ... materials) {
        for (Material mat : materials) {
            if (!LIQUIDS.contains(mat)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLiquidOrWaterlogged(Block block) {
        return MinecraftBlockExaminer.isLiquidOrWaterlogged(block.getType(), block.getBlockData());
    }

    public static boolean isLiquidOrWaterlogged(Material type, BlockData data) {
        if (MinecraftBlockExaminer.isLiquid(type)) {
            return true;
        }
        if (!SpigotUtil.isUsing1_13API()) {
            return false;
        }
        return data instanceof Waterlogged && ((Waterlogged)data).isWaterlogged();
    }

    static {
        Material material = WEB = SpigotUtil.isUsing1_13API() ? Material.COBWEB : Material.valueOf((String)"WEB");
        if (!SpigotUtil.isUsing1_13API()) {
            LIQUIDS.add(Material.valueOf((String)"STATIONARY_LAVA"));
            LIQUIDS.add(Material.valueOf((String)"STATIONARY_WATER"));
            UNWALKABLE.add(Material.valueOf((String)"STATIONARY_LAVA"));
            NOT_JUMPABLE.addAll(Lists.newArrayList((Object[])new Material[]{Material.valueOf((String)"FENCE"), Material.valueOf((String)"IRON_FENCE"), Material.valueOf((String)"NETHER_FENCE"), Material.valueOf((String)"COBBLE_WALL")}));
        } else {
            try {
                UNWALKABLE.add(Material.valueOf((String)"CAMPFIRE"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                CLIMBABLE.add(Material.valueOf((String)"SCAFFOLDING"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            NOT_JUMPABLE.addAll(Lists.newArrayList((Object[])new Material[]{Material.valueOf((String)"OAK_FENCE"), Material.valueOf((String)"NETHER_BRICK_FENCE"), Material.valueOf((String)"COBBLESTONE_WALL")}));
            try {
                NOT_JUMPABLE.add(Material.valueOf((String)"MANGROVE_FENCE"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                NOT_JUMPABLE.add(Material.valueOf((String)"CHERRY_FENCE"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private class LadderClimber
    implements PathPoint.PathCallback {
        boolean added = false;

        private LadderClimber() {
        }

        @Override
        public void run(final NPC npc, Block point, final List<Block> path, final int index) {
            if (this.added || npc.data().get("running-ladder", Boolean.valueOf(false)).booleanValue()) {
                this.added = true;
                return;
            }
            npc.getNavigator().getLocalParameters().addRunCallback(new Runnable(){
                Location dummy = new Location(null, 0.0, 0.0, 0.0);
                boolean sneakingForScaffolding;

                private boolean isScaffolding(Material type) {
                    return type.name().contains("SCAFFOLDING");
                }

                @Override
                public void run() {
                    if (index + 1 >= path.size()) {
                        return;
                    }
                    Location loc = npc.getEntity().getLocation(this.dummy);
                    Material in = loc.getBlock().getType();
                    Block next = (Block)path.get(index + 1);
                    Block prev = (Block)path.get(index);
                    if (MinecraftBlockExaminer.this.isClimbable(in) || MinecraftBlockExaminer.this.isClimbable(loc.getBlock().getRelative(BlockFace.DOWN).getType()) || this.isScaffolding(next.getType())) {
                        if (next.getY() > prev.getY()) {
                            npc.getEntity().setVelocity(npc.getEntity().getVelocity().setY(0.3));
                            if (this.sneakingForScaffolding) {
                                this.sneakingForScaffolding = false;
                                npc.setSneaking(false);
                            }
                        } else if (this.isScaffolding(in) || this.isScaffolding(next.getType())) {
                            if (loc.distance(next.getLocation().add(0.5, 1.0, 0.5)) < 0.4) {
                                this.sneakingForScaffolding = true;
                                npc.setSneaking(true);
                            }
                        } else if (next.getY() < prev.getY()) {
                            npc.getEntity().setVelocity(npc.getEntity().getVelocity().setY(-0.2));
                        }
                    } else if (this.sneakingForScaffolding) {
                        this.sneakingForScaffolding = false;
                        npc.setSneaking(false);
                    }
                }
            });
            npc.getNavigator().getLocalParameters().addSingleUseCallback(cancelReason -> {
                npc.data().set("running-ladder", (Object)false);
                npc.setSneaking(false);
            });
            this.added = true;
        }
    }
}

