/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Tadpole;
import org.bukkit.entity.Zombie;

@TraitName(value="age")
public class Age
extends Trait {
    @Persist
    private int age = 0;
    private Ageable ageable;
    @Persist
    private boolean locked = true;

    public Age() {
        super("age");
    }

    public void describe(CommandSender sender) {
        Messaging.sendTr(sender, "citizens.traits.age-description", this.npc.getName(), this.age, this.locked);
    }

    public int getAge() {
        return this.age;
    }

    private boolean isAgeable() {
        return this.ageable != null;
    }

    @Override
    public void onSpawn() {
        if (this.npc.getEntity() instanceof Ageable) {
            Ageable entity = (Ageable)this.npc.getEntity();
            entity.setAge(this.age);
            entity.setAgeLock(this.locked);
            this.ageable = entity;
        } else {
            if (this.npc.getEntity() instanceof Zombie) {
                ((Zombie)this.npc.getEntity()).setBaby(this.age < 0);
            } else if (this.npc.isSpawned() && this.npc.getEntity().getType().name().equals("TADPOLE")) {
                ((Tadpole)this.npc.getEntity()).setAge(this.age);
            }
            this.ageable = null;
        }
    }

    @Override
    public void run() {
        if (!this.locked && this.isAgeable()) {
            this.age = this.ageable.getAge();
        }
    }

    public void setAge(int age) {
        this.age = age;
        this.onSpawn();
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        if (this.isAgeable()) {
            this.ageable.setAgeLock(locked);
        }
    }

    public boolean toggle() {
        boolean bl = this.locked = !this.locked;
        if (this.isAgeable()) {
            this.ageable.setAgeLock(this.locked);
        }
        return this.locked;
    }

    public String toString() {
        return "Age{age=" + this.age + ",locked=" + this.locked + "}";
    }
}

