/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitLookup;

public class ArrayTraitLookup
implements TraitLookup {
    private final long[] sig;
    private final Trait[] traits;

    public ArrayTraitLookup(int capacity) {
        int cap = this.roundUpPow2(capacity);
        this.traits = new Trait[cap];
        this.sig = new long[cap + 63 >>> 6];
    }

    @Override
    public void add(int typeId, Trait trait) {
        this.traits[typeId] = trait;
        int n = typeId >>> 6;
        this.sig[n] = this.sig[n] | 1L << (typeId & 0x3F);
    }

    @Override
    public void clear() {
        int i;
        for (i = 0; i < this.traits.length; ++i) {
            this.traits[i] = null;
        }
        for (i = 0; i < this.sig.length; ++i) {
            this.sig[i] = 0L;
        }
    }

    @Override
    public void forEach(Consumer<Trait> visitor) {
        for (int w = 0; w < this.sig.length; ++w) {
            for (long bits = this.sig[w]; bits != 0L; bits &= bits - 1L) {
                int bit = Long.numberOfTrailingZeros(bits);
                int typeId = (w << 6) + bit;
                visitor.accept(this.traits[typeId]);
            }
        }
    }

    @Override
    public Trait get(int typeId) {
        return this.traits[typeId];
    }

    @Override
    public boolean has(int typeId) {
        return (this.sig[typeId >>> 6] & 1L << (typeId & 0x3F)) != 0L;
    }

    @Override
    public Iterable<Trait> list() {
        ArrayList<Trait> list = new ArrayList<Trait>();
        this.forEach(list::add);
        return list;
    }

    @Override
    public Trait remove(int typeId) {
        Trait trait = this.traits[typeId];
        int n = typeId >>> 6;
        this.sig[n] = this.sig[n] & (1L << (typeId & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        return trait;
    }

    private int roundUpPow2(int x) {
        int n;
        for (n = 1; n < x; n <<= 1) {
        }
        return n;
    }
}

