/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import java.util.function.Supplier;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;

public class IfElse
implements Behavior {
    private final Supplier<Boolean> condition;
    private Behavior executing;
    private final Behavior ifBehavior;
    private final Behavior elseBehavior;

    public IfElse(Supplier<Boolean> condition, Behavior ifBehavior, Behavior elseBehavior) {
        this.condition = condition;
        this.ifBehavior = ifBehavior;
        this.elseBehavior = elseBehavior;
    }

    @Override
    public void reset() {
        if (this.executing != null) {
            this.executing.reset();
            this.executing = null;
        }
    }

    @Override
    public BehaviorStatus run() {
        return this.executing.run();
    }

    @Override
    public boolean shouldExecute() {
        boolean cond = this.condition.get();
        this.executing = cond ? this.ifBehavior : this.elseBehavior;
        if (this.executing == null || !this.executing.shouldExecute()) {
            this.executing = null;
            return false;
        }
        return true;
    }

    public static IfElse create(Supplier<Boolean> condition, Behavior ifBehavior, Behavior elseBehavior) {
        return new IfElse(condition, ifBehavior, elseBehavior);
    }
}

