/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;

@TraitName(value="foxtrait")
public class FoxTrait
extends Trait {
    @Persist
    private boolean crouching = false;
    @Persist
    private boolean faceplanted;
    @Persist
    private boolean interested;
    @Persist
    private boolean pouncing;
    @Persist
    private boolean sitting = false;
    @Persist
    private boolean sleeping = false;
    @Persist
    private Fox.Type type = Fox.Type.RED;

    public FoxTrait() {
        super("foxtrait");
    }

    public Fox.Type getType() {
        return this.type;
    }

    public boolean isCrouching() {
        return this.crouching;
    }

    public boolean isFaceplanted() {
        return this.faceplanted;
    }

    public boolean isInterested() {
        return this.interested;
    }

    public boolean isPouncing() {
        return this.pouncing;
    }

    public boolean isSitting() {
        return this.sitting;
    }

    public boolean isSleeping() {
        return this.sleeping;
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getCosmeticEntity() instanceof Fox) {
            Fox fox = (Fox)this.npc.getCosmeticEntity();
            fox.setSitting(this.sitting);
            fox.setCrouching(this.crouching);
            fox.setSleeping(this.sleeping);
            fox.setFoxType(this.type);
        }
    }

    public void setCrouching(boolean crouching) {
        this.crouching = crouching;
    }

    public void setFaceplanted(boolean faceplanted) {
        this.faceplanted = faceplanted;
    }

    public void setInterested(boolean interested) {
        this.interested = interested;
    }

    public void setPouncing(boolean pouncing) {
        this.pouncing = pouncing;
    }

    public void setSitting(boolean sitting) {
        this.sitting = sitting;
    }

    public void setSleeping(boolean sleeping) {
        this.sleeping = sleeping;
    }

    public void setType(Fox.Type type) {
        this.type = type;
    }

    @Command(aliases={"npc"}, usage="fox --type type --sleeping [true|false] --sitting [true|false] --crouching [true|false] --interested [true|false] --pouncing [true|false] --faceplanted [true|false]", desc="", modifiers={"fox"}, min=1, max=1, permission="citizens.npc.fox")
    @Requirements(selected=true, ownership=true, cosmeticTypes={EntityType.FOX})
    public static void fox(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"sleeping"}) Boolean sleeping, @Flag(value={"sitting"}) Boolean sitting, @Flag(value={"crouching"}) Boolean crouching, @Flag(value={"type"}, completions={"RED", "SNOW"}) String rawtype, @Flag(value={"pouncing"}) Boolean pouncing, @Flag(value={"interested"}) Boolean interested, @Flag(value={"faceplanted"}) Boolean faceplanted) throws CommandException {
        FoxTrait trait = npc.getOrAddTrait(FoxTrait.class);
        String output = "";
        if (rawtype != null) {
            Fox.Type type = (Fox.Type)Util.matchEnum((Enum[])Fox.Type.values(), (String)args.getFlag("type"));
            if (type == null) {
                throw new CommandUsageException(Messaging.tr("citizens.commands.npc.fox.invalid-fox-type", Util.listValuesPretty(Fox.Type.values())), null);
            }
            trait.setType(type);
            output = output + ' ' + Messaging.tr("citizens.commands.npc.fox.fox-type-set", args.getFlag("type"), npc.getName());
        }
        if (sleeping != null) {
            trait.setSleeping(sleeping);
            output = output + ' ' + Messaging.tr(sleeping != false ? "citizens.commands.npc.fox.sleeping-set" : "citizens.commands.npc.fox.sleeping-unset", npc.getName());
        }
        if (sitting != null) {
            trait.setSitting(sitting);
            output = output + ' ' + Messaging.tr(sitting != false ? "citizens.commands.npc.fox.sitting-set" : "citizens.commands.npc.fox.sitting-unset", npc.getName());
        }
        if (crouching != null) {
            trait.setCrouching(crouching);
            output = output + ' ' + Messaging.tr(crouching != false ? "citizens.commands.npc.fox.crouching-set" : "citizens.commands.npc.fox.crouching-unset", npc.getName());
        }
        if (interested != null) {
            trait.setInterested(interested);
            output = output + ' ' + Messaging.tr(interested != false ? "citizens.commands.npc.fox.interested-set" : "citizens.commands.npc.fox.interested-unset", npc.getName());
        }
        if (pouncing != null) {
            trait.setPouncing(pouncing);
            output = output + ' ' + Messaging.tr(pouncing != false ? "citizens.commands.npc.fox.pouncing-set" : "citizens.commands.npc.fox.pouncing-unset", npc.getName());
        }
        if (faceplanted != null) {
            trait.setFaceplanted(faceplanted);
            output = output + ' ' + Messaging.tr(faceplanted != false ? "citizens.commands.npc.fox.faceplanted-set" : "citizens.commands.npc.fox.faceplanted-unset", npc.getName());
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(sender, output.trim());
    }
}

