/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.OldEnumCompat;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.DyeColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ocelot;

@TraitName(value="cattrait")
public class CatTrait
extends Trait {
    @Persist
    private DyeColor collarColor = null;
    @Persist
    private boolean lying = false;
    @Persist
    private boolean sitting = false;
    @Persist
    private Cat.Type type = Cat.Type.BLACK;

    public CatTrait() {
        super("cattrait");
    }

    public boolean isLyingDown() {
        return this.lying;
    }

    @Override
    public void run() {
        if (!(this.npc.getEntity() instanceof Cat)) {
            return;
        }
        Cat cat = (Cat)this.npc.getEntity();
        cat.setSitting(this.sitting);
        cat.setCatType(this.type);
        if (this.collarColor != null) {
            cat.setCollarColor(this.collarColor);
        }
        NMS.setLyingDown((Entity)cat, this.lying);
    }

    public void setCollarColor(DyeColor color) {
        this.collarColor = color;
    }

    public void setLyingDown(boolean lying) {
        this.lying = lying;
    }

    public void setSitting(boolean sitting) {
        this.sitting = sitting;
    }

    public void setType(Cat.Type type) {
        if (type == null) {
            type = Cat.Type.BLACK;
        }
        this.type = type;
    }

    public void setType(Ocelot.Type type2) {
        if (type2 == null) {
            this.type = Cat.Type.BLACK;
            return;
        }
        switch (type2) {
            case WILD_OCELOT: {
                this.type = Cat.Type.CALICO;
                break;
            }
            case BLACK_CAT: {
                this.type = Cat.Type.BLACK;
                break;
            }
            case RED_CAT: {
                this.type = Cat.Type.RED;
                break;
            }
            case SIAMESE_CAT: {
                this.type = Cat.Type.SIAMESE;
            }
        }
    }

    @Command(aliases={"npc"}, usage="cat (-s/-n/-l) --type type --ccolor collar color", desc="", modifiers={"cat"}, min=1, max=1, flags="snl", permission="citizens.npc.cat")
    @Requirements(selected=true, ownership=true, types={EntityType.CAT})
    public static void cat(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"ccolor"}) DyeColor ccolor, @Flag(value={"type"}) Cat.Type type) throws CommandException {
        CatTrait trait = npc.getOrAddTrait(CatTrait.class);
        String output = "";
        if (args.hasValueFlag("type")) {
            if (type == null) {
                throw new CommandUsageException("citizens.commands.npc.cat.invalid-type", Util.listValuesPretty(OldEnumCompat.CatTypeEnum.values()));
            }
            trait.setType(type);
            output = output + ' ' + Messaging.tr("citizens.commands.npc.cat.type-set", args.getFlag("type"));
        }
        if (args.hasValueFlag("ccolor")) {
            if (ccolor == null) {
                throw new CommandUsageException("citizens.commands.npc.cat.invalid-collar-color", Util.listValuesPretty(DyeColor.values()));
            }
            trait.setCollarColor(ccolor);
            output = output + ' ' + Messaging.tr("citizens.commands.npc.cat.collar-color-set", args.getFlag("ccolor"));
        }
        if (args.hasFlag('s')) {
            trait.setSitting(true);
            output = output + ' ' + Messaging.tr("citizens.commands.npc.cat.sitting-start", npc.getName());
        } else if (args.hasFlag('n')) {
            trait.setSitting(false);
            output = output + ' ' + Messaging.tr("citizens.commands.npc.cat.sitting-stop", npc.getName());
        }
        if (args.hasFlag('l')) {
            trait.setLyingDown(!trait.isLyingDown());
            output = output + ' ' + Messaging.tr(trait.isLyingDown() ? "citizens.commands.npc.cat.lying-start" : "citizens.commands.npc.cat.lying-stop", npc.getName());
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(sender, output.trim());
    }
}

