/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.persistence.PersisterRegistry;
import net.citizensnpcs.trait.ShopTrait;
import net.citizensnpcs.util.InventoryMultiplexer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class NPCShopAction
implements Cloneable {
    private static final List<GUI> GUI = Lists.newArrayList();
    private static final PersisterRegistry<NPCShopAction> REGISTRY = PersistenceLoader.createRegistry(NPCShopAction.class);

    public NPCShopAction clone() {
        try {
            return (NPCShopAction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public abstract String describe();

    public abstract int getMaxRepeats(Entity var1, InventoryMultiplexer var2);

    public abstract Transaction grant(ShopTrait.NPCShopStorage var1, Entity var2, InventoryMultiplexer var3, int var4);

    public Transaction grant(Player player, int repeats) {
        return this.grant(new ShopTrait.NPCShopStorage(), (Entity)player, new InventoryMultiplexer(new Inventory[]{player.getInventory()}), repeats);
    }

    public abstract Transaction take(ShopTrait.NPCShopStorage var1, Entity var2, InventoryMultiplexer var3, int var4);

    public Transaction take(Player player, int repeats) {
        return this.take(new ShopTrait.NPCShopStorage(), (Entity)player, new InventoryMultiplexer(new Inventory[]{player.getInventory()}), repeats);
    }

    public static Iterable<GUI> getGUIs() {
        return GUI;
    }

    public static void register(Class<? extends NPCShopAction> clazz, String type, GUI gui) {
        REGISTRY.register(type, clazz);
        GUI.add(gui);
    }

    public static class Transaction {
        private final Runnable execute;
        private final Supplier<Boolean> possible;
        private final Runnable rollback;

        public Transaction(Supplier<Boolean> isPossible, Runnable execute, Runnable rollback) {
            this.possible = isPossible;
            this.execute = execute;
            this.rollback = rollback;
        }

        public boolean isPossible() {
            return this.possible.get();
        }

        public void rollback() {
            this.rollback.run();
        }

        public void run() {
            this.execute.run();
        }

        public static Transaction compose(Collection<Transaction> txn) {
            if (txn.isEmpty()) {
                return Transaction.success();
            }
            return Transaction.create(() -> txn.stream().allMatch(t -> t == null || t.isPossible()), () -> txn.forEach(Transaction::run), () -> txn.forEach(Transaction::rollback));
        }

        public static Transaction compose(Transaction ... txn) {
            return Transaction.compose(Arrays.asList(txn));
        }

        public static Transaction create(Supplier<Boolean> isPossible, Runnable execute, Runnable rollback) {
            return new Transaction(isPossible, execute, rollback);
        }

        public static Transaction fail() {
            return Transaction.create(() -> false, () -> {}, () -> {});
        }

        public static Transaction success() {
            return Transaction.create(() -> true, () -> {}, () -> {});
        }
    }

    public static interface GUI {
        public boolean canUse(HumanEntity var1);

        public InventoryMenuPage createEditor(NPCShopAction var1, Consumer<NPCShopAction> var2);

        public ItemStack createMenuItem(NPCShopAction var1);

        public boolean manages(NPCShopAction var1);
    }
}

