/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class SpigotUtil {
    private static boolean ASYNC_TELEPORT;
    private static int[] BUKKIT_VERSION;
    private static final Pattern DAY_MATCHER;
    private static boolean FOLIA_SERVER;
    private static final Map<Class<?>, Boolean> NON_REGISTRY_CLASSES;
    private static final Pattern NUMBER_MATCHER;
    private static boolean SUPPORT_WORLD_HEIGHT;
    private static boolean SUPPORTS_KEYED;
    private static Boolean using1_13API;

    public static boolean checkYSafe(double y, World world) {
        if (!SUPPORT_WORLD_HEIGHT || world == null) {
            return y >= 0.0 && y <= 255.0;
        }
        try {
            return y >= (double)world.getMinHeight() && y <= (double)world.getMaxHeight();
        }
        catch (Throwable t) {
            SUPPORT_WORLD_HEIGHT = false;
            return y >= 0.0 && y <= 255.0;
        }
    }

    public static <T extends Keyed> T getEnumValue(Class<T> clazz, String ... keyCandidates) {
        if (SpigotUtil.isRegistryKeyed(clazz)) {
            return SpigotUtil.getRegistryValue(Bukkit.getRegistry(clazz), keyCandidates);
        }
        for (String keyCandidate : keyCandidates) {
            try {
                return (T)((Keyed)Enum.valueOf(clazz, keyCandidate));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return null;
    }

    public static NamespacedKey getKey(String raw) {
        return SpigotUtil.getKey(raw, "minecraft");
    }

    public static NamespacedKey getKey(String raw, String defaultNamespace) {
        int index = raw.indexOf(58);
        raw = index == -1 ? defaultNamespace + ":" + raw.toLowerCase(Locale.ROOT) : raw.substring(0, index) + raw.substring(index).toLowerCase(Locale.ROOT);
        return NamespacedKey.fromString((String)raw);
    }

    public static int getMaxNameLength(EntityType type) {
        return SpigotUtil.isUsing1_13API() ? 256 : 64;
    }

    public static <T extends Keyed> T getRegistryValue(Registry<T> registry, String ... keyCandidates) {
        for (String keyCandidate : keyCandidates) {
            NamespacedKey key = SpigotUtil.getKey(keyCandidate);
            Keyed value = registry.get(key);
            if (value == null) continue;
            return (T)value;
        }
        return null;
    }

    public static int[] getVersion() {
        if (BUKKIT_VERSION == null) {
            String version = Bukkit.getBukkitVersion();
            if (version == null || version.isEmpty()) {
                BUKKIT_VERSION = new int[]{1, 8, 8};
                return BUKKIT_VERSION;
            }
            String[] parts = version.split("\\.");
            if (parts[1].contains("-")) {
                parts[1] = parts[1].split("-")[0];
            }
            if (parts[2].contains("-")) {
                parts[2] = parts[2].split("-")[0];
            }
            if (parts.length >= 3) {
                BUKKIT_VERSION = new int[]{Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2])};
                return BUKKIT_VERSION;
            }
            BUKKIT_VERSION = new int[]{Integer.parseInt(parts[0]), Integer.parseInt(parts[1])};
            return BUKKIT_VERSION;
        }
        return BUKKIT_VERSION;
    }

    public static boolean isFoliaServer() {
        return FOLIA_SERVER;
    }

    public static boolean isRegistryKeyed(Class<?> clazz) {
        if (NON_REGISTRY_CLASSES.containsKey(clazz)) {
            return false;
        }
        try {
            return SUPPORTS_KEYED && Keyed.class.isAssignableFrom(clazz) && Bukkit.getRegistry(clazz) != null;
        }
        catch (Exception ex) {
            NON_REGISTRY_CLASSES.put(clazz, true);
            return false;
        }
    }

    public static boolean isUsing1_13API() {
        if (using1_13API == null) {
            try {
                Enchantment.getByKey((NamespacedKey)Enchantment.getByName((String)"ARROW_DAMAGE").getKey());
                using1_13API = true;
            }
            catch (Exception ex) {
                using1_13API = false;
            }
            catch (NoSuchMethodError ex) {
                using1_13API = false;
            }
        }
        return using1_13API;
    }

    public static Duration parseDuration(String raw, TimeUnit defaultUnits) {
        if (defaultUnits == null) {
            Integer ticks = Ints.tryParse((String)raw);
            if (ticks != null) {
                return Duration.ofMillis(ticks * 50);
            }
        } else if (NUMBER_MATCHER.matcher(raw).matches()) {
            return Duration.of(Longs.tryParse((String)raw), SpigotUtil.toChronoUnit(defaultUnits));
        }
        if (raw.endsWith("t")) {
            return Duration.ofMillis(Integer.parseInt(raw.substring(0, raw.length() - 1)) * 50);
        }
        if ((raw = DAY_MATCHER.matcher(raw).replaceFirst("P$1").replace("min", "m").replace("hr", "h")).charAt(0) != 'P') {
            raw = "PT" + raw;
        }
        return Duration.parse(raw);
    }

    public static Predicate<Entity> parseEntityFilter(String raw) {
        Predicate<Entity> base = e -> true;
        block11: for (String arg : raw.split(" ")) {
            String[] parts = arg.split("=");
            String type = parts[0];
            String match = parts[1];
            switch (type) {
                case "type": {
                    Set types = Splitter.on((char)',').splitToStream((CharSequence)match).map(s -> SpigotUtil.getEnumValue(EntityType.class, s)).collect(Collectors.toSet());
                    base = base.and(e -> types.contains(e.getType()));
                    continue block11;
                }
                case "permission": 
                case "perm": {
                    List perms = Splitter.on((char)',').splitToList((CharSequence)raw);
                    base = base.and(e -> perms.stream().allMatch(perm -> e.hasPermission(perm)));
                    continue block11;
                }
                case "group": {
                    List groups = Splitter.on((char)',').splitToList((CharSequence)raw);
                    Permission permission = (Permission)Bukkit.getServicesManager().getRegistration(Permission.class).getProvider();
                    base = base.and(e -> e instanceof Player && groups.stream().allMatch(group -> permission.playerInGroup((Player)e, group)));
                }
            }
        }
        return base;
    }

    public static ItemStack parseItemStack(ItemStack base, String item) {
        if (base == null || base.getType() == Material.AIR) {
            base = new ItemStack(Material.STONE, 1);
        }
        if (item.contains("[")) {
            return Bukkit.getItemFactory().createItemStack(item);
        }
        String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)',').split((CharSequence)item), String.class);
        if (parts.length == 0) {
            return base;
        }
        Material material = Material.matchMaterial((String)parts[0]);
        if (material != null) {
            base.setType(material);
        }
        if (parts.length > 1) {
            base.setAmount(Ints.tryParse((String)parts[1]).intValue());
        }
        if (parts.length > 2) {
            Integer durability = Ints.tryParse((String)parts[2]);
            base.setDurability(durability.shortValue());
        }
        return base;
    }

    public static int parseTicks(String raw) {
        try {
            Duration duration = SpigotUtil.parseDuration(raw, null);
            return duration == null ? -1 : SpigotUtil.toTicks(duration);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static CompletableFuture<Boolean> teleportAsync(Entity entity, Location location) {
        return ASYNC_TELEPORT ? entity.teleportAsync(location) : CompletableFuture.completedFuture(entity.teleport(location));
    }

    public static CompletableFuture<Boolean> teleportAsync(Entity entity, Location location, PlayerTeleportEvent.TeleportCause cause) {
        return ASYNC_TELEPORT ? entity.teleportAsync(location, cause) : CompletableFuture.completedFuture(entity.teleport(location, cause));
    }

    private static ChronoUnit toChronoUnit(TimeUnit tu) {
        switch (tu) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new AssertionError();
    }

    public static int toTicks(Duration duration) {
        return (int)(TimeUnit.MILLISECONDS.convert(duration.getSeconds(), TimeUnit.SECONDS) + TimeUnit.MILLISECONDS.convert(duration.getNano(), TimeUnit.NANOSECONDS)) / 50;
    }

    static {
        BUKKIT_VERSION = null;
        DAY_MATCHER = Pattern.compile("(\\d+d)");
        NON_REGISTRY_CLASSES = new WeakHashMap();
        NUMBER_MATCHER = Pattern.compile("(\\d+)");
        SUPPORT_WORLD_HEIGHT = true;
        try {
            SUPPORTS_KEYED = Class.forName("org.bukkit.Keyed") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            FOLIA_SERVER = Class.forName("io.papermc.paper.threadedregions.RegionizedServer") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            ASYNC_TELEPORT = Entity.class.getMethod("teleportAsync", Location.class, PlayerTeleportEvent.TeleportCause.class) != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static class InventoryViewAPI {
        private final InventoryView view;
        private static final MethodHandle CLOSE = InventoryViewAPI.getMethod(InventoryView.class, "close", new Class[0]);
        private static final MethodHandle EQUALS = InventoryViewAPI.getMethod(Object.class, "equals", Object.class);
        private static final MethodHandle GET_PLAYER = InventoryViewAPI.getMethod(InventoryView.class, "getPlayer", new Class[0]);
        private static final MethodHandle HASHCODE = InventoryViewAPI.getMethod(Object.class, "hashCode", new Class[0]);
        private static final MethodHandle TOP_INVENTORY = InventoryViewAPI.getMethod(InventoryView.class, "getTopInventory", new Class[0]);

        public InventoryViewAPI(InventoryView view) {
            this.view = view;
        }

        public void close() {
            try {
                CLOSE.invoke(this.view);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public boolean equals(Object obj) {
            if (this == obj || obj == null) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InventoryViewAPI other = (InventoryViewAPI)obj;
            if (this.view == null) {
                if (other.view != null) {
                    return false;
                }
            } else {
                try {
                    if (!EQUALS.invoke(this.view, other.view)) {
                        return false;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }

        public Player getPlayer() {
            try {
                return GET_PLAYER.invoke(this.view);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }

        public Inventory getTopInventory() {
            try {
                return TOP_INVENTORY.invoke(this.view);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }

        public InventoryView getView() {
            return this.view;
        }

        public int hashCode() {
            try {
                return 31 + (this.view == null ? 0 : HASHCODE.invoke(this.view));
            }
            catch (Throwable e) {
                e.printStackTrace();
                return 31;
            }
        }

        private static MethodHandle getMethod(Class<?> clazz, String method, Class<?> ... params) {
            try {
                Method f = null;
                try {
                    f = clazz.getMethod(method, params);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return MethodHandles.publicLookup().unreflect(f);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

