/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.CopperGolem;
import org.bukkit.entity.EntityType;

@TraitName(value="coppergolemtrait")
public class CopperGolemTrait
extends Trait {
    @Persist
    private CopperGolem.CopperWeatherState weather;

    public CopperGolemTrait() {
        super("coppergolemtrait");
    }

    @Override
    public void run() {
        if (this.weather != null && this.npc.getEntity() instanceof CopperGolem) {
            CopperGolem golem = (CopperGolem)this.npc.getEntity();
            golem.setWeatherState(this.weather);
        }
    }

    public void setWeatherState(CopperGolem.CopperWeatherState weather) {
        this.weather = weather;
    }

    @Command(aliases={"npc"}, usage="coppergolem (--weatherstate state)", desc="", modifiers={"coppergolem"}, min=1, max=1, permission="citizens.npc.coppergolem")
    @Requirements(selected=true, ownership=true, types={EntityType.COPPER_GOLEM})
    public static void CopperGolem(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"weatherstate"}) CopperGolem.CopperWeatherState state) throws CommandException {
        CopperGolemTrait trait = npc.getOrAddTrait(CopperGolemTrait.class);
        String output = "";
        if (args.hasValueFlag("variant")) {
            if (state == null) {
                throw new CommandException("citizens.commands.npc.coppergolem.invalid-weather-state", Util.listValuesPretty(CopperGolem.CopperWeatherState.values()));
            }
            trait.setWeatherState(state);
            output = output + Messaging.tr("citizens.commands.npc.coppergolem.weather-state-set", state);
        }
        if (!output.isEmpty()) {
            Messaging.send(sender, output);
        }
    }
}

