/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import clib.net.kyori.adventure.platform.bukkit.BukkitComponentSerializer;
import clib.net.kyori.adventure.text.Component;
import clib.net.kyori.adventure.text.serializer.ComponentSerializer;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class TemporaryMinecraftComponentSerializer
implements ComponentSerializer<Component, Component, Object> {
    @Nullable
    private static final Class<?> CLASS_CHAT_COMPONENT;
    @Nullable
    private static final Class<?> CLASS_COMPONENT_SERIALIZATION;
    @Nullable
    private static final Class<?> CLASS_CRAFT_REGISTRY;
    @Nullable
    private static final Class<?> CLASS_HOLDERLOOKUP_PROVIDER;
    @Nullable
    private static final Class<?> CLASS_JSON_DESERIALIZER;
    @Nullable
    private static final Class<?> CLASS_JSON_ELEMENT;
    @Nullable
    private static final Class<?> CLASS_JSON_OPS;
    @Nullable
    private static final Class<?> CLASS_JSON_PARSER;
    @Nullable
    private static final Class<?> CLASS_REGISTRY_ACCESS;
    private static final MethodHandle COMPONENTSERIALIZATION_CODEC_DECODE;
    private static final MethodHandle COMPONENTSERIALIZATION_CODEC_ENCODE;
    private static final String CRAFT_SERVER = "CraftServer";
    private static final MethodHandle CREATE_SERIALIZATION_CONTEXT;
    @Nullable
    private static final MethodHandle GET_REGISTRY;
    private static final AtomicReference<RuntimeException> INITIALIZATION_ERROR;
    private static final TemporaryMinecraftComponentSerializer INSTANCE;
    private static final Object JSON_OPS_INSTANCE;
    private static final Object JSON_PARSER_INSTANCE;
    private static final MethodHandles.Lookup LOOKUP;
    private static final Object MC_TEXT_GSON;
    @Nullable
    private static final MethodHandle PARSE_JSON;
    private static final String PREFIX_CRAFTBUKKIT = "org.bukkit.craftbukkit";
    private static final String PREFIX_MC = "net.minecraft.";
    private static final String PREFIX_NMS = "net.minecraft.server";
    private static final Object REGISTRY_ACCESS;
    private static final boolean SUPPORTED;
    private static final MethodHandle TEXT_SERIALIZER_DESERIALIZE;
    private static final MethodHandle TEXT_SERIALIZER_DESERIALIZE_TREE;
    private static final MethodHandle TEXT_SERIALIZER_SERIALIZE;
    private static final MethodHandle TEXT_SERIALIZER_SERIALIZE_TREE;
    @Nullable
    private static final String VERSION;

    @NotNull
    public Component deserialize(@NotNull Object input) {
        if (!SUPPORTED) {
            throw INITIALIZATION_ERROR.get();
        }
        try {
            Object element;
            if (TEXT_SERIALIZER_SERIALIZE_TREE != null) {
                element = TEXT_SERIALIZER_SERIALIZE_TREE.invoke(input);
            } else if (MC_TEXT_GSON != null) {
                element = ((Gson)MC_TEXT_GSON).toJsonTree(input);
            } else {
                if (COMPONENTSERIALIZATION_CODEC_ENCODE != null && CREATE_SERIALIZATION_CONTEXT != null) {
                    Object serializationContext = CREATE_SERIALIZATION_CONTEXT.bindTo(REGISTRY_ACCESS).invoke(JSON_OPS_INSTANCE);
                    Object result = COMPONENTSERIALIZATION_CODEC_ENCODE.invoke(input, serializationContext, null);
                    Method getOrThrow = result.getClass().getMethod("getOrThrow", Function.class);
                    Object jsonElement = getOrThrow.invoke(result, RuntimeException::new);
                    return (Component)BukkitComponentSerializer.gson().serializer().fromJson(jsonElement.toString(), Component.class);
                }
                return BukkitComponentSerializer.gson().deserialize((Object)TEXT_SERIALIZER_SERIALIZE.invoke(input));
            }
            return (Component)BukkitComponentSerializer.gson().serializer().fromJson(element.toString(), Component.class);
        }
        catch (Throwable error) {
            throw new UnsupportedOperationException(error);
        }
    }

    @NotNull
    public Object serialize(@NotNull Component component) {
        if (!SUPPORTED) {
            throw INITIALIZATION_ERROR.get();
        }
        if (TEXT_SERIALIZER_DESERIALIZE_TREE != null || MC_TEXT_GSON != null) {
            JsonElement json = BukkitComponentSerializer.gson().serializer().toJsonTree((Object)component);
            try {
                if (TEXT_SERIALIZER_DESERIALIZE_TREE != null) {
                    Object unRelocatedJsonElement = PARSE_JSON.invoke(JSON_PARSER_INSTANCE, json.toString());
                    return TEXT_SERIALIZER_DESERIALIZE_TREE.invoke(unRelocatedJsonElement);
                }
                return ((Gson)MC_TEXT_GSON).fromJson(json, CLASS_CHAT_COMPONENT);
            }
            catch (Throwable error) {
                throw new UnsupportedOperationException(error);
            }
        }
        try {
            if (COMPONENTSERIALIZATION_CODEC_DECODE != null && CREATE_SERIALIZATION_CONTEXT != null) {
                Object serializationContext = CREATE_SERIALIZATION_CONTEXT.bindTo(REGISTRY_ACCESS).invoke(JSON_OPS_INSTANCE);
                Object result = COMPONENTSERIALIZATION_CODEC_DECODE.invoke(serializationContext, BukkitComponentSerializer.gson().serializeToTree(component));
                Method getOrThrow = result.getClass().getMethod("getOrThrow", Function.class);
                Object pair = getOrThrow.invoke(result, RuntimeException::new);
                Method getFirst = pair.getClass().getMethod("getFirst", new Class[0]);
                return getFirst.invoke(pair, new Object[0]);
            }
            return TEXT_SERIALIZER_DESERIALIZE.invoke((String)BukkitComponentSerializer.gson().serialize(component));
        }
        catch (Throwable error) {
            throw new UnsupportedOperationException(error);
        }
    }

    @Nullable
    public static Class<?> findClass(String ... classNames) {
        for (String clazz : classNames) {
            if (clazz == null) continue;
            try {
                Class<?> classObj = Class.forName(clazz);
                return classObj;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static MethodHandle findConstructor(@Nullable Class<?> holderClass, Class<?> ... parameterClasses) {
        if (holderClass == null) {
            return null;
        }
        for (Class<?> parameterClass : parameterClasses) {
            if (parameterClass != null) continue;
            return null;
        }
        try {
            return LOOKUP.findConstructor(holderClass, MethodType.methodType(Void.TYPE, parameterClasses));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    public static Class<?> findCraftClass(@NotNull String className) {
        String craftClassName = TemporaryMinecraftComponentSerializer.findCraftClassName(className);
        if (craftClassName == null) {
            return null;
        }
        return TemporaryMinecraftComponentSerializer.findClass(craftClassName);
    }

    @Nullable
    public static <T> Class<? extends T> findCraftClass(@NotNull String className, @NotNull Class<T> superClass) {
        Class<?> craftClass = TemporaryMinecraftComponentSerializer.findCraftClass(className);
        if (craftClass == null || !Objects.requireNonNull(superClass, "superClass").isAssignableFrom(craftClass)) {
            return null;
        }
        return craftClass.asSubclass(superClass);
    }

    @Nullable
    public static String findCraftClassName(@NotNull String className) {
        return TemporaryMinecraftComponentSerializer.isCraftBukkit() ? PREFIX_CRAFTBUKKIT + VERSION + className : null;
    }

    @Nullable
    public static Object findEnum(@Nullable Class<?> enumClass, @NotNull String enumName) {
        return TemporaryMinecraftComponentSerializer.findEnum(enumClass, enumName, Integer.MAX_VALUE);
    }

    @Nullable
    public static Object findEnum(@Nullable Class<?> enumClass, @NotNull String enumName, int enumFallbackOrdinal) {
        if (enumClass == null || !Enum.class.isAssignableFrom(enumClass)) {
            return null;
        }
        try {
            return Enum.valueOf(enumClass.asSubclass(Enum.class), enumName);
        }
        catch (IllegalArgumentException e) {
            ?[] constants = enumClass.getEnumConstants();
            if (constants.length > enumFallbackOrdinal) {
                return constants[enumFallbackOrdinal];
            }
            return null;
        }
    }

    @Nullable
    public static Field findField(@Nullable Class<?> holderClass, @Nullable Class<?> expectedType, String ... fieldNames) {
        if (holderClass == null) {
            return null;
        }
        for (String fieldName : fieldNames) {
            Field field;
            try {
                field = holderClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException ex) {
                continue;
            }
            field.setAccessible(true);
            if (expectedType != null && !expectedType.isAssignableFrom(field.getType())) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static Field findField(@Nullable Class<?> holderClass, String ... fieldName) {
        return TemporaryMinecraftComponentSerializer.findField(holderClass, null, fieldName);
    }

    @Nullable
    public static MethodHandle findGetterOf(@Nullable Field field) {
        if (field == null) {
            return null;
        }
        try {
            return LOOKUP.unreflectGetter(field);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Nullable
    public static Class<?> findMcClass(String ... classNames) {
        for (String clazz : classNames) {
            Class<?> candidate;
            String nmsClassName = TemporaryMinecraftComponentSerializer.findMcClassName(clazz);
            if (nmsClassName == null || (candidate = TemporaryMinecraftComponentSerializer.findClass(nmsClassName)) == null) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    public static String findMcClassName(@NotNull String className) {
        return TemporaryMinecraftComponentSerializer.isCraftBukkit() ? PREFIX_MC + className : null;
    }

    @Nullable
    public static MethodHandle findMethod(@Nullable Class<?> holderClass, String methodName, @Nullable Class<?> returnClass, Class<?> ... parameterClasses) {
        return TemporaryMinecraftComponentSerializer.findMethod(holderClass, new String[]{methodName}, returnClass, parameterClasses);
    }

    @Nullable
    public static MethodHandle findMethod(@Nullable Class<?> holderClass, @Nullable String @NotNull [] methodNames, @Nullable Class<?> returnClass, Class<?> ... parameterClasses) {
        if (holderClass == null || returnClass == null) {
            return null;
        }
        for (Class<?> parameterClass : parameterClasses) {
            if (parameterClass != null) continue;
            return null;
        }
        for (String methodName : methodNames) {
            if (methodName == null) continue;
            try {
                return LOOKUP.findVirtual(holderClass, methodName, MethodType.methodType(returnClass, parameterClasses));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static Class<?> findNmsClass(@NotNull String className) {
        String nmsClassName = TemporaryMinecraftComponentSerializer.findNmsClassName(className);
        if (nmsClassName == null) {
            return null;
        }
        return TemporaryMinecraftComponentSerializer.findClass(nmsClassName);
    }

    @Nullable
    public static String findNmsClassName(@NotNull String className) {
        return TemporaryMinecraftComponentSerializer.isCraftBukkit() ? PREFIX_NMS + VERSION + className : null;
    }

    @Nullable
    public static MethodHandle findSetterOf(@Nullable Field field) {
        if (field == null) {
            return null;
        }
        try {
            return LOOKUP.unreflectSetter(field);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Nullable
    public static MethodHandle findStaticMethod(@Nullable Class<?> holderClass, String methodNames, @Nullable Class<?> returnClass, Class<?> ... parameterClasses) {
        return TemporaryMinecraftComponentSerializer.findStaticMethod(holderClass, new String[]{methodNames}, returnClass, parameterClasses);
    }

    @Nullable
    public static MethodHandle findStaticMethod(@Nullable Class<?> holderClass, String[] methodNames, @Nullable Class<?> returnClass, Class<?> ... parameterClasses) {
        if (holderClass == null || returnClass == null) {
            return null;
        }
        for (Class<?> parameterClass : parameterClasses) {
            if (parameterClass != null) continue;
            return null;
        }
        for (String methodName : methodNames) {
            try {
                return LOOKUP.findStatic(holderClass, methodName, MethodType.methodType(returnClass, parameterClasses));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            }
        }
        return null;
    }

    @NotNull
    public static TemporaryMinecraftComponentSerializer get() {
        return INSTANCE;
    }

    public static boolean hasClass(String ... classNames) {
        return TemporaryMinecraftComponentSerializer.findClass(classNames) != null;
    }

    public static boolean hasField(@Nullable Class<?> holderClass, Class<?> type, String ... names) {
        if (holderClass == null) {
            return false;
        }
        for (String name : names) {
            try {
                Field field = holderClass.getDeclaredField(name);
                if (field.getType() != type) continue;
                return true;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasMethod(@Nullable Class<?> holderClass, String methodName, Class<?> ... parameterClasses) {
        return TemporaryMinecraftComponentSerializer.hasMethod(holderClass, new String[]{methodName}, parameterClasses);
    }

    public static boolean hasMethod(@Nullable Class<?> holderClass, String[] methodNames, Class<?> ... parameterClasses) {
        if (holderClass == null) {
            return false;
        }
        for (Class<?> parameterClass : parameterClasses) {
            if (parameterClass != null) continue;
            return false;
        }
        for (String methodName : methodNames) {
            try {
                holderClass.getMethod(methodName, parameterClasses);
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return false;
    }

    public static boolean isCraftBukkit() {
        return VERSION != null;
    }

    public static boolean isSupported() {
        return SUPPORTED;
    }

    public static @NotNull MethodHandles.Lookup lookup() {
        return LOOKUP;
    }

    @NotNull
    public static Class<?> needClass(String ... className) {
        return Objects.requireNonNull(TemporaryMinecraftComponentSerializer.findClass(className), "Could not find class from candidates" + Arrays.toString(className));
    }

    @NotNull
    public static Class<?> needCraftClass(@NotNull String className) {
        return Objects.requireNonNull(TemporaryMinecraftComponentSerializer.findCraftClass(className), "Could not find org.bukkit.craftbukkit class " + className);
    }

    @NotNull
    public static Field needField(@NotNull Class<?> holderClass, @NotNull String fieldName) throws NoSuchFieldException {
        Field field = holderClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }

    @NotNull
    public static Class<?> needMcClass(String ... className) {
        return Objects.requireNonNull(TemporaryMinecraftComponentSerializer.findMcClass(className), "Could not find net.minecraft class from candidates" + Arrays.toString(className));
    }

    @NotNull
    public static Class<?> needNmsClass(@NotNull String className) {
        return Objects.requireNonNull(TemporaryMinecraftComponentSerializer.findNmsClass(className), "Could not find net.minecraft.server class " + className);
    }

    public static MethodHandle searchMethod(@Nullable Class<?> holderClass, @Nullable Integer modifier, String methodName, @Nullable Class<?> returnClass, Class<?> ... parameterClasses) {
        return TemporaryMinecraftComponentSerializer.searchMethod(holderClass, modifier, new String[]{methodName}, returnClass, parameterClasses);
    }

    public static MethodHandle searchMethod(@Nullable Class<?> holderClass, @Nullable Integer modifier, @Nullable String @NotNull [] methodNames, @Nullable Class<?> returnClass, Class<?> ... parameterClasses) {
        if (holderClass == null || returnClass == null) {
            return null;
        }
        for (Class<?> parameterClass : parameterClasses) {
            if (parameterClass != null) continue;
            return null;
        }
        for (String methodName : methodNames) {
            if (methodName == null) continue;
            try {
                if (modifier != null && Modifier.isStatic(modifier)) {
                    return LOOKUP.findStatic(holderClass, methodName, MethodType.methodType(returnClass, parameterClasses));
                }
                return LOOKUP.findVirtual(holderClass, methodName, MethodType.methodType(returnClass, parameterClasses));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        for (Method method : holderClass.getDeclaredMethods()) {
            if (modifier == null || (method.getModifiers() & modifier) == 0 || !Arrays.equals(method.getParameterTypes(), parameterClasses)) continue;
            try {
                if (Modifier.isStatic(modifier)) {
                    return LOOKUP.findStatic(holderClass, method.getName(), MethodType.methodType(returnClass, parameterClasses));
                }
                return LOOKUP.findVirtual(holderClass, method.getName(), MethodType.methodType(returnClass, parameterClasses));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        MethodHandle createContext;
        MethodHandle codecDecode;
        MethodHandle codecEncode;
        MethodHandle textSerializerSerializeTree;
        MethodHandle textSerializerDeserializeTree;
        MethodHandle textSerializerSerialize;
        MethodHandle textSerializerDeserialize;
        Object registryAccessInstance;
        Object jsonParserInstance;
        Object jsonOpsInstance;
        Object gson;
        block22: {
            CLASS_JSON_ELEMENT = TemporaryMinecraftComponentSerializer.findClass("com.goo".concat("gle.gson.JsonElement"));
            CLASS_JSON_OPS = TemporaryMinecraftComponentSerializer.findClass("com.mo".concat("jang.serialization.JsonOps"));
            CLASS_JSON_PARSER = TemporaryMinecraftComponentSerializer.findClass("com.goo".concat("gle.gson.JsonParser"));
            INITIALIZATION_ERROR = new AtomicReference<UnsupportedOperationException>(new UnsupportedOperationException());
            INSTANCE = new TemporaryMinecraftComponentSerializer();
            LOOKUP = MethodHandles.lookup();
            PARSE_JSON = TemporaryMinecraftComponentSerializer.findMethod(CLASS_JSON_PARSER, "parse", CLASS_JSON_ELEMENT, String.class);
            Class serverClass = Bukkit.getServer().getClass();
            if (!serverClass.getSimpleName().equals(CRAFT_SERVER)) {
                VERSION = null;
            } else if (serverClass.getName().equals("org.bukkit.craftbukkit.CraftServer")) {
                VERSION = ".";
            } else {
                String name = serverClass.getName();
                name = name.substring(PREFIX_CRAFTBUKKIT.length());
                VERSION = name = name.substring(0, name.length() - CRAFT_SERVER.length());
            }
            CLASS_JSON_DESERIALIZER = TemporaryMinecraftComponentSerializer.findClass("com.goo".concat("gle.gson.JsonDeserializer"));
            CLASS_REGISTRY_ACCESS = TemporaryMinecraftComponentSerializer.findClass(TemporaryMinecraftComponentSerializer.findMcClassName("core.IRegistryCustom"), TemporaryMinecraftComponentSerializer.findMcClassName("core.RegistryAccess"));
            CLASS_CRAFT_REGISTRY = TemporaryMinecraftComponentSerializer.findCraftClass("CraftRegistry");
            GET_REGISTRY = TemporaryMinecraftComponentSerializer.findStaticMethod(CLASS_CRAFT_REGISTRY, "getMinecraftRegistry", CLASS_REGISTRY_ACCESS, new Class[0]);
            CLASS_CHAT_COMPONENT = TemporaryMinecraftComponentSerializer.findClass(TemporaryMinecraftComponentSerializer.findNmsClassName("IChatBaseComponent"), TemporaryMinecraftComponentSerializer.findMcClassName("network.chat.IChatBaseComponent"), TemporaryMinecraftComponentSerializer.findMcClassName("network.chat.Component"));
            CLASS_COMPONENT_SERIALIZATION = TemporaryMinecraftComponentSerializer.findClass(TemporaryMinecraftComponentSerializer.findMcClassName("network.chat.ComponentSerialization"));
            CLASS_HOLDERLOOKUP_PROVIDER = TemporaryMinecraftComponentSerializer.findClass(TemporaryMinecraftComponentSerializer.findMcClassName("core.HolderLookup$Provider"), TemporaryMinecraftComponentSerializer.findMcClassName("core.HolderLookup$a"));
            gson = null;
            jsonOpsInstance = null;
            jsonParserInstance = null;
            registryAccessInstance = null;
            textSerializerDeserialize = null;
            textSerializerSerialize = null;
            textSerializerDeserializeTree = null;
            textSerializerSerializeTree = null;
            codecEncode = null;
            codecDecode = null;
            createContext = null;
            try {
                Field gsonField;
                Object registryAccess;
                if (CLASS_JSON_OPS != null) {
                    Field instanceField = CLASS_JSON_OPS.getField("INSTANCE");
                    instanceField.setAccessible(true);
                    jsonOpsInstance = instanceField.get(null);
                }
                if (CLASS_JSON_PARSER != null) {
                    jsonParserInstance = CLASS_JSON_PARSER.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if (CLASS_CHAT_COMPONENT == null) break block22;
                registryAccessInstance = registryAccess = GET_REGISTRY != null ? GET_REGISTRY.invoke() : null;
                Class<?> chatSerializerClass = Arrays.stream(CLASS_CHAT_COMPONENT.getClasses()).filter(c -> {
                    if (CLASS_JSON_DESERIALIZER != null) {
                        return CLASS_JSON_DESERIALIZER.isAssignableFrom((Class<?>)c);
                    }
                    for (Class<?> itf : c.getInterfaces()) {
                        if (!itf.getSimpleName().equals("JsonDeserializer")) continue;
                        return true;
                    }
                    return false;
                }).findAny().orElse(TemporaryMinecraftComponentSerializer.findNmsClass("ChatSerializer"));
                if (chatSerializerClass != null && (gsonField = (Field)Arrays.stream(chatSerializerClass.getDeclaredFields()).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> m.getType().equals(Gson.class)).findFirst().orElse(null)) != null) {
                    gsonField.setAccessible(true);
                    gson = gsonField.get(null);
                }
                ArrayList candidates = new ArrayList();
                if (chatSerializerClass != null) {
                    candidates.add(chatSerializerClass);
                }
                candidates.addAll(Arrays.asList(CLASS_CHAT_COMPONENT.getClasses()));
                for (Class clazz : candidates) {
                    Method[] declaredMethods = clazz.getDeclaredMethods();
                    Method method = Arrays.stream(declaredMethods).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> CLASS_CHAT_COMPONENT.isAssignableFrom(m.getReturnType())).filter(m -> m.getParameterCount() == 1 && m.getParameterTypes()[0].equals(String.class)).min(Comparator.comparing(Method::getName)).orElse(null);
                    Method serialize = Arrays.stream(declaredMethods).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> m.getReturnType().equals(String.class)).filter(m -> m.getParameterCount() == 1 && CLASS_CHAT_COMPONENT.isAssignableFrom(m.getParameterTypes()[0])).findFirst().orElse(null);
                    Method deserializeTree = Arrays.stream(declaredMethods).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> CLASS_CHAT_COMPONENT.isAssignableFrom(m.getReturnType())).filter(m -> m.getParameterCount() == 1 && m.getParameterTypes()[0].equals(CLASS_JSON_ELEMENT)).findFirst().orElse(null);
                    Method serializeTree = Arrays.stream(declaredMethods).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> m.getReturnType().equals(CLASS_JSON_ELEMENT)).filter(m -> m.getParameterCount() == 1 && CLASS_CHAT_COMPONENT.isAssignableFrom(m.getParameterTypes()[0])).findFirst().orElse(null);
                    Method deserializeTreeWithRegistryAccess = Arrays.stream(declaredMethods).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> CLASS_CHAT_COMPONENT.isAssignableFrom(m.getReturnType())).filter(m -> m.getParameterCount() == 2).filter(m -> m.getParameterTypes()[0].equals(CLASS_JSON_ELEMENT)).filter(m -> m.getParameterTypes()[1].isInstance(registryAccess)).findFirst().orElse(null);
                    Method serializeTreeWithRegistryAccess = Arrays.stream(declaredMethods).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> m.getReturnType().equals(CLASS_JSON_ELEMENT)).filter(m -> m.getParameterCount() == 2).filter(m -> CLASS_CHAT_COMPONENT.isAssignableFrom(m.getParameterTypes()[0])).filter(m -> m.getParameterTypes()[1].isInstance(registryAccess)).findFirst().orElse(null);
                    if (method != null) {
                        textSerializerDeserialize = TemporaryMinecraftComponentSerializer.lookup().unreflect(method);
                    }
                    if (serialize != null) {
                        textSerializerSerialize = TemporaryMinecraftComponentSerializer.lookup().unreflect(serialize);
                    }
                    if (deserializeTree != null) {
                        textSerializerDeserializeTree = TemporaryMinecraftComponentSerializer.lookup().unreflect(deserializeTree);
                    } else if (deserializeTreeWithRegistryAccess != null) {
                        deserializeTreeWithRegistryAccess.setAccessible(true);
                        textSerializerDeserializeTree = MethodHandles.insertArguments(TemporaryMinecraftComponentSerializer.lookup().unreflect(deserializeTreeWithRegistryAccess), 1, registryAccess);
                    }
                    if (serializeTree != null) {
                        textSerializerSerializeTree = TemporaryMinecraftComponentSerializer.lookup().unreflect(serializeTree);
                        continue;
                    }
                    if (serializeTreeWithRegistryAccess == null) continue;
                    serializeTreeWithRegistryAccess.setAccessible(true);
                    textSerializerSerializeTree = MethodHandles.insertArguments(TemporaryMinecraftComponentSerializer.lookup().unreflect(serializeTreeWithRegistryAccess), 1, registryAccess);
                }
                if (registryAccess != null && CLASS_HOLDERLOOKUP_PROVIDER != null) {
                    for (AccessibleObject accessibleObject : CLASS_HOLDERLOOKUP_PROVIDER.getDeclaredMethods()) {
                        ((Method)accessibleObject).setAccessible(true);
                        if (((Method)accessibleObject).getParameterCount() != 1 || !((Method)accessibleObject).getParameterTypes()[0].getSimpleName().equals("DynamicOps") || !((Method)accessibleObject).getReturnType().getSimpleName().contains("RegistryOps")) continue;
                        createContext = TemporaryMinecraftComponentSerializer.lookup().unreflect((Method)accessibleObject);
                        break;
                    }
                }
                if (CLASS_COMPONENT_SERIALIZATION == null) break block22;
                for (AccessibleObject accessibleObject : CLASS_COMPONENT_SERIALIZATION.getDeclaredFields()) {
                    if (!Modifier.isStatic(((Field)accessibleObject).getModifiers()) || !((Field)accessibleObject).getType().getSimpleName().equals("Codec")) continue;
                    ((Field)accessibleObject).setAccessible(true);
                    Object codecInstance = ((Field)accessibleObject).get(null);
                    Class<?> codecClass = codecInstance.getClass();
                    for (Method m3 : codecClass.getDeclaredMethods()) {
                        if (m3.getName().equals("decode")) {
                            codecDecode = TemporaryMinecraftComponentSerializer.lookup().unreflect(m3).bindTo(codecInstance);
                            continue;
                        }
                        if (!m3.getName().equals("encode")) continue;
                        codecEncode = TemporaryMinecraftComponentSerializer.lookup().unreflect(m3).bindTo(codecInstance);
                    }
                    break;
                }
            }
            catch (Throwable error) {
                INITIALIZATION_ERROR.set(new UnsupportedOperationException("Error occurred during initialization", error));
            }
        }
        MC_TEXT_GSON = gson;
        JSON_OPS_INSTANCE = jsonOpsInstance;
        JSON_PARSER_INSTANCE = jsonParserInstance;
        TEXT_SERIALIZER_DESERIALIZE = textSerializerDeserialize;
        TEXT_SERIALIZER_SERIALIZE = textSerializerSerialize;
        TEXT_SERIALIZER_DESERIALIZE_TREE = textSerializerDeserializeTree;
        TEXT_SERIALIZER_SERIALIZE_TREE = textSerializerSerializeTree;
        COMPONENTSERIALIZATION_CODEC_ENCODE = codecEncode;
        COMPONENTSERIALIZATION_CODEC_DECODE = codecDecode;
        CREATE_SERIALIZATION_CONTEXT = createContext;
        REGISTRY_ACCESS = registryAccessInstance;
        SUPPORTED = MC_TEXT_GSON != null || TEXT_SERIALIZER_DESERIALIZE != null && TEXT_SERIALIZER_SERIALIZE != null || TEXT_SERIALIZER_DESERIALIZE_TREE != null && TEXT_SERIALIZER_SERIALIZE_TREE != null || COMPONENTSERIALIZATION_CODEC_ENCODE != null && COMPONENTSERIALIZATION_CODEC_DECODE != null && CREATE_SERIALIZATION_CONTEXT != null && JSON_OPS_INSTANCE != null;
    }
}

