/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.skin;

import java.util.Objects;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.skin.Skin;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class SkinPacketTracker {
    private final SkinnableEntity entity;
    private boolean isRemoved;
    private Skin skin;

    public SkinPacketTracker(SkinnableEntity entity) {
        Objects.requireNonNull(entity);
        this.entity = entity;
        this.skin = Skin.get(entity);
    }

    public Skin getSkin() {
        return this.skin;
    }

    public void notifySkinChange(boolean forceUpdate) {
        this.skin = Skin.get(this.entity, forceUpdate);
        this.skin.applyAndRespawn(this.entity);
    }

    public void onSpawnNPC() {
        this.isRemoved = false;
        new BukkitRunnable(){

            public void run() {
                if (!SkinPacketTracker.this.entity.getNPC().isSpawned()) {
                    return;
                }
                SkinPacketTracker.this.updateNearbyViewers(SkinPacketTracker.this.entity.getNPC().data().get(NPC.Metadata.TRACKING_RANGE, Integer.valueOf(Settings.Setting.NPC_SKIN_VIEW_DISTANCE.asInt())).intValue());
            }
        }.runTaskLater(CitizensAPI.getPlugin(), 15L);
    }

    public void updateNearbyViewers(double radius) {
        Player from = this.entity.getBukkitEntity();
        CitizensAPI.getLocationLookup().getNearbyPlayers(from.getLocation(), radius).forEach(player -> {
            if (!player.canSee(from) || player.hasMetadata("NPC")) {
                return;
            }
            this.updateViewer((Player)player);
        });
    }

    public void updateViewer(Player player) {
        Objects.requireNonNull(player);
        if (this.isRemoved || player.hasMetadata("NPC")) {
            return;
        }
        this.skin.apply(this.entity);
        if (NMS.sendTabListAdd(player, this.entity.getBukkitEntity())) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> NMS.sendTabListRemove(player, this.entity.getBukkitEntity()), (long)Settings.Setting.TABLIST_REMOVE_PACKET_DELAY.asTicks());
        }
    }
}

