/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.util.Util;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.LivingEntity;

@TraitName(value="attributetrait")
public class AttributeTrait
extends Trait {
    @Persist(keyType=Attribute.class)
    private final Map<Attribute, Double> attributes = Maps.newHashMap();

    public AttributeTrait() {
        super("attributetrait");
    }

    public Double getAttributeValue(Attribute attribute) {
        return this.attributes.get(attribute);
    }

    public boolean hasAttribute(Attribute attribute) {
        return this.attributes.containsKey(attribute);
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        for (DataKey subkey : key.getRelative("attributes").getSubKeys()) {
            if (Util.getAttribute(subkey.name()) != null) continue;
            key.removeKey("attributes." + subkey.name());
        }
        this.attributes.remove(null);
    }

    @Override
    public void onSpawn() {
        if (!(this.npc.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)this.npc.getEntity();
        for (Map.Entry<Attribute, Double> entry : this.attributes.entrySet()) {
            Attribute key = entry.getKey();
            AttributeInstance attributeInstance = le.getAttribute(key);
            if (attributeInstance == null) continue;
            attributeInstance.setBaseValue(entry.getValue().doubleValue());
        }
    }

    public void setAttributeValue(Attribute attribute, double value) {
        this.attributes.put(attribute, value);
        this.onSpawn();
    }

    public void resetToDefaultValue(Attribute attribute) {
        this.attributes.remove(attribute);
        if (!(this.npc.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)this.npc.getEntity();
        AttributeInstance instance = le.getAttribute(attribute);
        instance.setBaseValue(instance.getDefaultValue());
    }
}

