/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.EntityTarget;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.PathStrategy;
import net.citizensnpcs.api.ai.PathfinderType;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.ai.event.NavigationReplaceEvent;
import net.citizensnpcs.api.ai.event.NavigationStuckEvent;
import net.citizensnpcs.api.ai.event.NavigatorCallback;
import net.citizensnpcs.api.astar.pathfinder.DoorExaminer;
import net.citizensnpcs.api.astar.pathfinder.FlyingBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.SwimmingExaminer;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.npc.ai.AStarNavigationStrategy;
import net.citizensnpcs.npc.ai.BoundingBoxExaminer;
import net.citizensnpcs.npc.ai.FallingExaminer;
import net.citizensnpcs.npc.ai.FlyingAStarNavigationStrategy;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.ai.StraightLineNavigationStrategy;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class CitizensNavigator
implements Navigator,
Runnable {
    private Location activeTicket;
    private final NavigatorParameters defaultParams;
    private PathStrategy executing;
    private int lastX;
    private int lastY;
    private int lastZ;
    private NavigatorParameters localParams;
    private final NPC npc;
    private boolean paused;
    private RotationTrait.PacketRotationSession session;
    private int stationaryTicks;
    private static boolean SUPPORT_CHUNK_TICKETS = true;
    private static final float UNINITIALISED_SPEED = 0.3f;

    public CitizensNavigator(NPC npc) {
        this.localParams = this.defaultParams = new NavigatorParameters().baseSpeed(0.3f).range(Settings.Setting.DEFAULT_PATHFINDING_RANGE.asFloat()).debug(Settings.Setting.DEBUG_PATHFINDING.asBoolean()).defaultAttackStrategy((attacker, target) -> {
            NMS.attack(attacker, target);
            return true;
        }).attackRange(Settings.Setting.NPC_ATTACK_DISTANCE.asDouble()).updatePathRate(Settings.Setting.DEFAULT_PATHFINDER_UPDATE_PATH_RATE.asTicks()).distanceMargin(Settings.Setting.DEFAULT_DISTANCE_MARGIN.asDouble()).pathDistanceMargin(Settings.Setting.DEFAULT_PATH_DISTANCE_MARGIN.asDouble()).stationaryTicks(Settings.Setting.DEFAULT_STATIONARY_DURATION.asTicks()).stuckAction(TeleportStuckAction.INSTANCE).examiner(new MinecraftBlockExaminer()).pathfinderType(PathfinderType.valueOf(Settings.Setting.PATHFINDER_TYPE.asString())).straightLineTargetingDistance(Settings.Setting.DEFAULT_STRAIGHT_LINE_TARGETING_DISTANCE.asFloat()).destinationTeleportMargin(Settings.Setting.DEFAULT_DESTINATION_TELEPORT_MARGIN.asDouble()).fallDistance(Settings.Setting.PATHFINDER_FALL_DISTANCE.asInt());
        this.npc = npc;
        if (npc.data().get(NPC.Metadata.DISABLE_DEFAULT_STUCK_ACTION, Boolean.valueOf(!Settings.Setting.DEFAULT_STUCK_ACTION.asString().contains("teleport"))).booleanValue()) {
            this.defaultParams.stuckAction(null);
        }
        this.defaultParams.examiner(new SwimmingExaminer(npc));
    }

    @Override
    public void cancelNavigation() {
        this.stopNavigating(CancelReason.PLUGIN);
    }

    @Override
    public void cancelNavigation(CancelReason reason) {
        this.stopNavigating(reason);
    }

    @Override
    public boolean canNavigateTo(Location dest) {
        return this.canNavigateTo(dest, this.defaultParams.clone());
    }

    @Override
    public boolean canNavigateTo(Location dest, NavigatorParameters params) {
        if (this.defaultParams.pathfinderType() == PathfinderType.CITIZENS || !(this.npc.getEntity() instanceof LivingEntity)) {
            if (this.npc.isFlyable()) {
                params.examiner(new FlyingBlockExaminer());
            }
            AStarNavigationStrategy.AStarPlanner planner = new AStarNavigationStrategy.AStarPlanner(params, this.npc.getStoredLocation(), dest);
            planner.tick(Settings.Setting.MAXIMUM_ASTAR_ITERATIONS.asInt(), Settings.Setting.MAXIMUM_ASTAR_ITERATIONS.asInt());
            return planner.plan != null;
        }
        return NMS.canNavigateTo(this.npc.getEntity(), dest, params);
    }

    @Override
    public NavigatorParameters getDefaultParameters() {
        return this.defaultParams;
    }

    @Override
    public EntityTarget getEntityTarget() {
        return this.executing instanceof EntityTarget ? (EntityTarget)((Object)this.executing) : null;
    }

    @Override
    public NavigatorParameters getLocalParameters() {
        return this.isNavigating() ? this.localParams : this.defaultParams;
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    @Override
    public PathStrategy getPathStrategy() {
        return this.executing;
    }

    @Override
    public Location getTargetAsLocation() {
        return this.isNavigating() ? this.executing.getTargetAsLocation() : null;
    }

    @Override
    public TargetType getTargetType() {
        return this.isNavigating() ? this.executing.getTargetType() : null;
    }

    @Override
    public boolean isNavigating() {
        return this.executing != null && !this.isPaused();
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    public void load(DataKey root) {
        if (root.keyExists("pathfindingrange")) {
            this.defaultParams.range((float)root.getDouble("pathfindingrange"));
        }
        if (root.keyExists("pathfindertype")) {
            this.defaultParams.pathfinderType(PathfinderType.valueOf(root.getString("pathfindertype")));
        }
        if (root.keyExists("stationaryticks")) {
            this.defaultParams.stationaryTicks(root.getInt("stationaryticks"));
        }
        if (root.keyExists("distancemargin")) {
            this.defaultParams.distanceMargin(root.getDouble("distancemargin"));
        }
        if (root.keyExists("destinationteleportmargin")) {
            this.defaultParams.destinationTeleportMargin(root.getDouble("destinationteleportmargin"));
        }
        if (root.keyExists("updatepathrate")) {
            this.defaultParams.updatePathRate(root.getInt("updatepathrate"));
        }
        if (root.keyExists("falldistance")) {
            this.defaultParams.fallDistance(root.getInt("falldistance"));
        }
        this.defaultParams.speedModifier((float)root.getDouble("speedmodifier", 1.0));
        this.defaultParams.avoidWater(root.getBoolean("avoidwater"));
        if (!root.getBoolean("usedefaultstuckaction") && this.defaultParams.stuckAction() == TeleportStuckAction.INSTANCE) {
            this.defaultParams.stuckAction(null);
        }
    }

    public void onDespawn() {
        this.stopNavigating(CancelReason.NPC_DESPAWNED);
    }

    public void onSpawn() {
        this.defaultParams.baseSpeed(NMS.getMovementSpeed(this.npc.getEntity()));
        this.updatePathfindingRange();
    }

    @Override
    public void run() {
        this.updateMountedStatus();
        if (!this.isNavigating() || !this.npc.isSpawned() || this.isPaused()) {
            return;
        }
        Location npcLoc = this.npc.getStoredLocation();
        Location targetLoc = this.getTargetAsLocation();
        if (!npcLoc.getWorld().equals((Object)targetLoc.getWorld()) || (double)this.localParams.range() < npcLoc.distance(targetLoc)) {
            this.stopNavigating(CancelReason.STUCK);
            return;
        }
        if (this.updateStationaryStatus()) {
            return;
        }
        this.updatePathfindingRange();
        boolean finished = this.executing.update();
        if (!finished) {
            this.localParams.run();
        }
        if (this.localParams.lookAtFunction() != null) {
            if (this.session == null) {
                RotationTrait trait = this.npc.getOrAddTrait(RotationTrait.class);
                this.session = trait.createPacketSession(trait.getGlobalParameters().clone().filter(p -> true).persist(true));
            }
            this.session.getSession().rotateToFace(this.localParams.lookAtFunction().apply(this));
        }
        if (this.localParams.destinationTeleportMargin() > 0.0 && npcLoc.distance(targetLoc) <= this.localParams.destinationTeleportMargin()) {
            this.npc.teleport(targetLoc, PlayerTeleportEvent.TeleportCause.PLUGIN);
            finished = true;
        }
        if (!finished) {
            return;
        }
        if (this.executing.getCancelReason() != null) {
            this.stopNavigating(this.executing.getCancelReason());
        } else {
            NavigationCompleteEvent event = new NavigationCompleteEvent(this);
            PathStrategy old = this.executing;
            Bukkit.getPluginManager().callEvent((Event)event);
            if (old == this.executing) {
                this.stopNavigating(null);
            }
        }
    }

    public void save(DataKey root) {
        if (this.defaultParams.range() != Settings.Setting.DEFAULT_PATHFINDING_RANGE.asFloat()) {
            root.setDouble("pathfindingrange", this.defaultParams.range());
        } else {
            root.removeKey("pathfindingrange");
        }
        if (this.defaultParams.stationaryTicks() != Settings.Setting.DEFAULT_STATIONARY_DURATION.asTicks()) {
            root.setInt("stationaryticks", this.defaultParams.stationaryTicks());
        } else {
            root.removeKey("stationaryticks");
        }
        if (this.defaultParams.destinationTeleportMargin() != Settings.Setting.DEFAULT_DESTINATION_TELEPORT_MARGIN.asDouble()) {
            root.setDouble("destinationteleportmargin", this.defaultParams.destinationTeleportMargin());
        } else {
            root.removeKey("destinationteleportmargin");
        }
        if (this.defaultParams.distanceMargin() != Settings.Setting.DEFAULT_DISTANCE_MARGIN.asDouble()) {
            root.setDouble("distancemargin", this.defaultParams.distanceMargin());
        } else {
            root.removeKey("distancemargin");
        }
        if (this.defaultParams.updatePathRate() != Settings.Setting.DEFAULT_PATHFINDER_UPDATE_PATH_RATE.asTicks()) {
            root.setInt("updatepathrate", this.defaultParams.updatePathRate());
        } else {
            root.removeKey("updatepathrate");
        }
        if (this.defaultParams.fallDistance() != Settings.Setting.PATHFINDER_FALL_DISTANCE.asTicks()) {
            root.setInt("falldistance", this.defaultParams.fallDistance());
        } else {
            root.removeKey("falldistance");
        }
        if (this.defaultParams.pathfinderType() != PathfinderType.valueOf(Settings.Setting.PATHFINDER_TYPE.asString())) {
            root.setString("pathfindertype", this.defaultParams.pathfinderType().name());
        } else {
            root.removeKey("pathfindertype");
        }
        root.setDouble("speedmodifier", this.defaultParams.speedModifier());
        root.setBoolean("avoidwater", this.defaultParams.avoidWater());
        root.setBoolean("usedefaultstuckaction", this.defaultParams.stuckAction() == TeleportStuckAction.INSTANCE);
    }

    @Override
    public void setPaused(boolean paused) {
        if (paused && this.isNavigating()) {
            NMS.cancelMoveDestination(this.npc.getEntity());
        }
        this.paused = paused;
    }

    @Override
    public void setStraightLineTarget(Entity target, boolean aggressive) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (target == null) {
            this.cancelNavigation();
            return;
        }
        this.setTarget((NavigatorParameters params) -> {
            params.straightLineTargetingDistance(100000.0f);
            return new MCTargetStrategy(this.npc, target, aggressive, (NavigatorParameters)params);
        });
    }

    @Override
    public void setStraightLineTarget(Location target) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (target == null) {
            this.cancelNavigation();
            return;
        }
        this.setTarget((NavigatorParameters params) -> new StraightLineNavigationStrategy(this.npc, target.clone(), (NavigatorParameters)params));
    }

    @Override
    public void setTarget(Entity target, boolean aggressive) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (target == null) {
            this.cancelNavigation();
            return;
        }
        this.setTarget((NavigatorParameters params) -> new MCTargetStrategy(this.npc, target, aggressive, (NavigatorParameters)params));
    }

    @Override
    public void setTarget(Function<NavigatorParameters, PathStrategy> strategy) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (this.executing != null) {
            this.stopNavigating(CancelReason.REPLACE);
        }
        this.localParams = this.defaultParams.clone();
        if (this.localParams.pathfinderType() == PathfinderType.CITIZENS) {
            int fallDistance = this.localParams.fallDistance();
            if (fallDistance != -1) {
                this.localParams.examiner(new FallingExaminer(fallDistance));
            }
            if (this.npc.data().get(NPC.Metadata.PATHFINDER_OPEN_DOORS, Boolean.valueOf(Settings.Setting.NEW_PATHFINDER_OPENS_DOORS.asBoolean())).booleanValue()) {
                this.localParams.examiner(new DoorExaminer());
            }
            if (Settings.Setting.NEW_PATHFINDER_CHECK_BOUNDING_BOXES.asBoolean()) {
                this.localParams.examiner(new BoundingBoxExaminer(this.npc.getEntity()));
            }
        }
        this.updatePathfindingRange();
        this.executing = strategy.apply(this.localParams);
        this.stationaryTicks = 0;
        if (this.npc.isSpawned()) {
            NMS.updateNavigationWorld(this.npc.getEntity(), this.npc.getEntity().getWorld());
            this.updateTicket(this.executing.getTargetAsLocation());
        }
        Bukkit.getPluginManager().callEvent((Event)new NavigationBeginEvent(this));
    }

    @Override
    public void setTarget(Iterable<Vector> path) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (path == null || Iterables.size(path) == 0) {
            this.cancelNavigation();
            return;
        }
        this.setTarget((NavigatorParameters params) -> {
            if (this.npc.isFlyable()) {
                return new FlyingAStarNavigationStrategy(this.npc, path, (NavigatorParameters)params);
            }
            if (params.pathfinderType() == PathfinderType.CITIZENS || !(this.npc.getEntity() instanceof LivingEntity)) {
                return new AStarNavigationStrategy(this.npc, path, (NavigatorParameters)params);
            }
            return new MCNavigationStrategy(this.npc, path, (NavigatorParameters)params);
        });
    }

    @Override
    public void setTarget(Location targetIn) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (targetIn == null) {
            this.cancelNavigation();
            return;
        }
        Location target = targetIn.clone();
        this.setTarget((NavigatorParameters params) -> {
            if (this.npc.isFlyable()) {
                return new FlyingAStarNavigationStrategy(this.npc, target, (NavigatorParameters)params);
            }
            if (params.pathfinderType() == PathfinderType.CITIZENS || !(this.npc.getEntity() instanceof LivingEntity)) {
                return new AStarNavigationStrategy(this.npc, target, (NavigatorParameters)params);
            }
            return new MCNavigationStrategy(this.npc, target, (NavigatorParameters)params);
        });
    }

    private void stopNavigating() {
        if (this.executing != null) {
            this.executing.stop();
        }
        this.executing = null;
        this.localParams = this.defaultParams;
        this.stationaryTicks = 0;
        if (this.npc.isSpawned()) {
            Vector velocity = this.npc.getEntity().getVelocity();
            velocity.setX(0).setY(0).setZ(0);
            this.npc.getEntity().setVelocity(velocity);
            NMS.cancelMoveDestination(this.npc.getEntity());
        }
        if (!(SUPPORT_CHUNK_TICKETS && CitizensAPI.hasImplementation() && CitizensAPI.getPlugin().isEnabled())) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> this.updateTicket(this.isNavigating() ? this.executing.getTargetAsLocation() : null), 10L);
    }

    private void stopNavigating(CancelReason reason) {
        if (!this.isNavigating()) {
            return;
        }
        if (reason == CancelReason.STUCK && Messaging.isDebugging()) {
            Messaging.debug(this.npc, "navigation ended, stuck", this.executing);
        }
        if (this.session != null) {
            this.session.end();
            this.session = null;
        }
        Iterator<NavigatorCallback> itr = this.localParams.callbacks().iterator();
        ArrayList<NavigatorCallback> callbacks = new ArrayList<NavigatorCallback>();
        while (itr.hasNext()) {
            callbacks.add(itr.next());
            itr.remove();
        }
        for (NavigatorCallback callback : callbacks) {
            callback.onCompletion(reason);
        }
        if (reason == null) {
            this.stopNavigating();
            return;
        }
        if (reason == CancelReason.STUCK) {
            boolean shouldContinue;
            StuckAction action = this.localParams.stuckAction();
            NavigationStuckEvent event = new NavigationStuckEvent(this, action);
            Bukkit.getPluginManager().callEvent((Event)event);
            action = event.getAction();
            boolean bl = shouldContinue = action != null ? action.run(this.npc, this) : false;
            if (shouldContinue) {
                this.stationaryTicks = 0;
                this.executing.clearCancelReason();
                return;
            }
        }
        NavigationCancelEvent event = reason == CancelReason.REPLACE ? new NavigationReplaceEvent(this) : new NavigationCancelEvent(this, reason);
        PathStrategy old = this.executing;
        Bukkit.getPluginManager().callEvent((Event)event);
        if (old == this.executing) {
            this.stopNavigating();
        }
    }

    private void updateMountedStatus() {
        if (this.isNavigating()) {
            // empty if block
        }
    }

    private void updatePathfindingRange() {
        NMS.updatePathfindingRange(this.npc, this.localParams.range());
    }

    private boolean updateStationaryStatus() {
        if (this.localParams.stationaryTicks() < 0) {
            return false;
        }
        Location current = this.npc.getEntity().getLocation();
        if (!SpigotUtil.checkYSafe(current.getY(), current.getWorld())) {
            this.stopNavigating(CancelReason.STUCK);
            return true;
        }
        if (this.lastX == current.getBlockX() && this.lastY == current.getBlockY() && this.lastZ == current.getBlockZ()) {
            if (++this.stationaryTicks >= this.localParams.stationaryTicks()) {
                this.stopNavigating(CancelReason.STUCK);
                return true;
            }
        } else {
            this.stationaryTicks = 0;
        }
        this.lastX = current.getBlockX();
        this.lastY = current.getBlockY();
        this.lastZ = current.getBlockZ();
        return false;
    }

    private void updateTicket(Location target) {
        if (!(SUPPORT_CHUNK_TICKETS && CitizensAPI.hasImplementation() && CitizensAPI.getPlugin().isEnabled())) {
            return;
        }
        if (target != null && this.activeTicket != null && target.getBlockX() >> 4 == this.activeTicket.getBlockX() >> 4 && target.getBlockZ() >> 4 == this.activeTicket.getBlockZ() >> 4 && target.getWorld().equals((Object)this.activeTicket.getWorld())) {
            return;
        }
        if (this.activeTicket != null) {
            this.activeTicket.getChunk().removePluginChunkTicket(CitizensAPI.getPlugin());
        }
        if (target == null) {
            this.activeTicket = null;
            return;
        }
        this.activeTicket = target.clone();
        this.activeTicket.getChunk().addPluginChunkTicket(CitizensAPI.getPlugin());
    }

    static {
        try {
            Chunk.class.getMethod("removePluginChunkTicket", Plugin.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            SUPPORT_CHUNK_TICKETS = false;
        }
    }
}

