/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.Pair;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.event.NPCAddTraitEvent;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.HologramTrait;
import net.citizensnpcs.trait.MirrorTrait;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.SkinProperty;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ProtocolLibListener
implements Listener {
    private final ProtocolManager manager;
    private final Map<UUID, MirrorTrait> mirrorTraits = Maps.newConcurrentMap();
    private final Citizens plugin;
    private final Map<Integer, RotationTrait> rotationTraits = Maps.newConcurrentMap();
    private static boolean LOGGED_ERROR = false;

    public ProtocolLibListener(Citizens plugin) {
        this.plugin = plugin;
        this.manager = ProtocolLibrary.getProtocolManager();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.manager.addPacketListener((PacketListener)new PacketAdapter(plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.ENTITY_EQUIPMENT}){

            private Equipment.EquipmentSlot convert(EnumWrappers.ItemSlot slot) {
                if (slot.name().equals("BODY")) {
                    return Equipment.EquipmentSlot.BODY;
                }
                switch (slot) {
                    case CHEST: {
                        return Equipment.EquipmentSlot.CHESTPLATE;
                    }
                    case FEET: {
                        return Equipment.EquipmentSlot.BOOTS;
                    }
                    case HEAD: {
                        return Equipment.EquipmentSlot.HELMET;
                    }
                    case LEGS: {
                        return Equipment.EquipmentSlot.LEGGINGS;
                    }
                    case MAINHAND: {
                        return Equipment.EquipmentSlot.HAND;
                    }
                    case OFFHAND: {
                        return Equipment.EquipmentSlot.OFF_HAND;
                    }
                }
                return null;
            }

            public void onPacketSending(PacketEvent event) {
                NPC npc = ProtocolLibListener.this.getNPCFromPacket(event);
                if (npc == null) {
                    return;
                }
                MirrorTrait mirror = npc.getTraitNullable(MirrorTrait.class);
                if (mirror != null && mirror.getEquipmentFunction() != null && mirror.isMirroring(event.getPlayer())) {
                    StructureModifier modifier = event.getPacket().getLists(BukkitConverters.getPairConverter((EquivalentConverter)EnumWrappers.getItemSlotConverter(), (EquivalentConverter)BukkitConverters.getItemStackConverter()));
                    ArrayList equipment = Lists.newArrayList();
                    equipment.add(new Pair((Object)EnumWrappers.ItemSlot.CHEST, (Object)mirror.getEquipmentFunction().apply(event.getPlayer(), Equipment.EquipmentSlot.CHESTPLATE)));
                    equipment.add(new Pair((Object)EnumWrappers.ItemSlot.FEET, (Object)mirror.getEquipmentFunction().apply(event.getPlayer(), Equipment.EquipmentSlot.BOOTS)));
                    equipment.add(new Pair((Object)EnumWrappers.ItemSlot.HEAD, (Object)mirror.getEquipmentFunction().apply(event.getPlayer(), Equipment.EquipmentSlot.HELMET)));
                    equipment.add(new Pair((Object)EnumWrappers.ItemSlot.LEGS, (Object)mirror.getEquipmentFunction().apply(event.getPlayer(), Equipment.EquipmentSlot.LEGGINGS)));
                    equipment.add(new Pair((Object)EnumWrappers.ItemSlot.MAINHAND, (Object)mirror.getEquipmentFunction().apply(event.getPlayer(), Equipment.EquipmentSlot.HAND)));
                    equipment.add(new Pair((Object)EnumWrappers.ItemSlot.OFFHAND, (Object)mirror.getEquipmentFunction().apply(event.getPlayer(), Equipment.EquipmentSlot.OFF_HAND)));
                    modifier.write(0, (Object)equipment);
                    return;
                }
                Equipment trait = npc.getTraitNullable(Equipment.class);
                if (trait == null) {
                    return;
                }
                PacketContainer packet = event.getPacket();
                StructureModifier modifier = packet.getLists(BukkitConverters.getPairConverter((EquivalentConverter)EnumWrappers.getItemSlotConverter(), (EquivalentConverter)BukkitConverters.getItemStackConverter()));
                for (int i = 0; i < modifier.getValues().size(); ++i) {
                    List pairs = (List)modifier.read(i);
                    boolean modified = false;
                    for (Pair pair : pairs) {
                        ItemStack cosmetic;
                        Equipment.EquipmentSlot converted = this.convert((EnumWrappers.ItemSlot)pair.getFirst());
                        if (converted == null || (cosmetic = trait.getCosmetic(converted)) == null) continue;
                        pair.setSecond((Object)cosmetic);
                        modified = true;
                    }
                    if (!modified) continue;
                    modifier.write(i, (Object)pairs);
                }
            }
        });
        this.manager.addPacketListener((PacketListener)new PacketAdapter(plugin, ListenerPriority.HIGHEST, new PacketType[]{PacketType.Play.Server.ENTITY_METADATA}){

            public void onPacketSending(PacketEvent event) {
                NPC npc = ProtocolLibListener.this.getNPCFromPacket(event);
                if (npc == null) {
                    return;
                }
                PacketContainer packet = event.getPacket();
                int version = ProtocolLibListener.this.manager.getProtocolVersion(event.getPlayer());
                if (npc.data().has(NPC.Metadata.HOLOGRAM_RENDERER)) {
                    HologramTrait.HologramRenderer hr = (HologramTrait.HologramRenderer)npc.data().get(NPC.Metadata.HOLOGRAM_RENDERER);
                    String fakeName = null;
                    String suppliedName = hr.getPerPlayerText(npc, event.getPlayer());
                    fakeName = version <= 340 ? suppliedName : Optional.of(Messaging.minecraftComponentFromRawMessage(suppliedName));
                    boolean sneaking = hr.isSneaking(npc, event.getPlayer());
                    boolean delta = false;
                    if (version < 761) {
                        List wwo = (List)packet.getWatchableCollectionModifier().readSafely(0);
                        if (wwo == null) {
                            return;
                        }
                        for (WrappedWatchableObject wo : wwo) {
                            if (fakeName != null && wo.getIndex() == 2) {
                                wo.setValue((Object)fakeName);
                                delta = true;
                                continue;
                            }
                            if (!sneaking || wo.getIndex() != 0) continue;
                            byte b = (byte)(((Number)wo.getValue()).byteValue() | 2);
                            wo.setValue((Object)b);
                            delta = true;
                        }
                        if (delta) {
                            packet.getWatchableCollectionModifier().write(0, (Object)wwo);
                        }
                    } else {
                        List wdvs = (List)packet.getDataValueCollectionModifier().readSafely(0);
                        if (wdvs == null) {
                            return;
                        }
                        for (WrappedDataValue wdv : wdvs) {
                            switch (wdv.getIndex()) {
                                case 0: {
                                    if (!sneaking) break;
                                    byte flags = (byte)(((Number)wdv.getValue()).byteValue() | 2);
                                    wdv.setValue((Object)flags);
                                    delta = true;
                                    break;
                                }
                                case 2: {
                                    if (fakeName == null) break;
                                    wdv.setRawValue((Object)fakeName);
                                    delta = true;
                                    break;
                                }
                                case 22: {
                                    if (version > 762 || fakeName == null || npc.getEntity().getType() != EntityType.TEXT_DISPLAY) break;
                                    wdv.setRawValue(((Optional)((Object)fakeName)).get());
                                    delta = true;
                                    break;
                                }
                                case 23: {
                                    if (version <= 762 || fakeName == null || npc.getEntity().getType() != EntityType.TEXT_DISPLAY) break;
                                    wdv.setRawValue(((Optional)((Object)fakeName)).get());
                                    delta = true;
                                }
                            }
                        }
                        if (delta) {
                            packet.getDataValueCollectionModifier().write(0, (Object)wdvs);
                        }
                    }
                }
            }
        });
        this.manager.addPacketListener((PacketListener)new PacketAdapter(plugin, ListenerPriority.HIGHEST, Arrays.asList(PacketType.Play.Server.PLAYER_INFO), new ListenerOptions[]{ListenerOptions.ASYNC}){

            public void onPacketSending(PacketEvent event) {
                int version = ProtocolLibListener.this.manager.getProtocolVersion(event.getPlayer());
                if (version >= 761) {
                    NMS.onPlayerInfoAdd(event.getPlayer(), event.getPacket().getHandle(), uuid -> (MirrorTrait)ProtocolLibListener.this.mirrorTraits.get(uuid));
                    return;
                }
                List list = (List)event.getPacket().getPlayerInfoDataLists().readSafely(0);
                if (list == null) {
                    return;
                }
                boolean changed = false;
                GameProfile playerProfile = null;
                WrappedGameProfile wgp = null;
                WrappedChatComponent playerName = null;
                for (int i = 0; i < list.size(); ++i) {
                    MirrorTrait trait;
                    PlayerInfoData npcInfo = (PlayerInfoData)list.get(i);
                    if (npcInfo == null || (trait = (MirrorTrait)ProtocolLibListener.this.mirrorTraits.get(npcInfo.getProfile().getUUID())) == null || !trait.isMirroring(event.getPlayer())) continue;
                    if (playerProfile == null) {
                        playerProfile = NMS.getProfile(event.getPlayer());
                        wgp = WrappedGameProfile.fromPlayer((Player)event.getPlayer());
                        playerName = WrappedChatComponent.fromText((String)Util.possiblyStripBedrockPrefix(event.getPlayer().getDisplayName(), wgp.getUUID()));
                    }
                    if (trait.mirrorName()) {
                        list.set(i, new PlayerInfoData(wgp.withId(npcInfo.getProfile().getId()), npcInfo.getLatency(), npcInfo.getGameMode(), playerName));
                        continue;
                    }
                    Collection textures = playerProfile.getProperties().get((Object)"textures");
                    if (textures == null || textures.size() == 0) continue;
                    npcInfo.getProfile().getProperties().clear();
                    for (String key : playerProfile.getProperties().keySet()) {
                        npcInfo.getProfile().getProperties().putAll((Object)key, Iterables.transform((Iterable)playerProfile.getProperties().get((Object)key), skin -> {
                            SkinProperty sp = SkinProperty.fromMojang(skin);
                            return new WrappedSignedProperty(sp.name, sp.value, sp.signature);
                        }));
                    }
                    changed = true;
                }
                if (changed) {
                    event.getPacket().getPlayerInfoDataLists().write(0, (Object)list);
                }
            }
        });
        this.manager.addPacketListener((PacketListener)new PacketAdapter(plugin, ListenerPriority.HIGHEST, Arrays.asList(PacketType.Play.Server.ENTITY_HEAD_ROTATION, PacketType.Play.Server.ENTITY_LOOK, PacketType.Play.Server.REL_ENTITY_MOVE_LOOK, PacketType.Play.Server.ENTITY_MOVE_LOOK, PacketType.Play.Server.ENTITY_TELEPORT), new ListenerOptions[]{ListenerOptions.ASYNC}){

            public void onPacketSending(PacketEvent event) {
                Integer eid = null;
                try {
                    eid = (Integer)event.getPacket().getIntegers().readSafely(0);
                    if (eid == null) {
                        return;
                    }
                }
                catch (FieldAccessException | IllegalArgumentException ex) {
                    if (!LOGGED_ERROR) {
                        Messaging.severe("Error retrieving entity from ID: ProtocolLib error? Suppressing further exceptions unless debugging.");
                        ex.printStackTrace();
                        LOGGED_ERROR = true;
                    } else if (Messaging.isDebugging()) {
                        ex.printStackTrace();
                    }
                    return;
                }
                RotationTrait trait = (RotationTrait)ProtocolLibListener.this.rotationTraits.get(eid);
                if (trait == null) {
                    return;
                }
                RotationTrait.PacketRotationSession session = trait.getPacketSession(event.getPlayer());
                if (session == null || !session.isActive()) {
                    return;
                }
                PacketContainer packet = event.getPacket();
                PacketType type = event.getPacketType();
                Messaging.debug("Modifying body/head yaw for", eid, "->", event.getPlayer().getName(), Float.valueOf(session.getBodyYaw()), ProtocolLibListener.degToByte(session.getBodyYaw()), Float.valueOf(session.getHeadYaw()), ProtocolLibListener.degToByte(session.getHeadYaw()), Float.valueOf(session.getPitch()), type);
                if (type == PacketType.Play.Server.ENTITY_HEAD_ROTATION) {
                    packet.getBytes().write(0, (Object)ProtocolLibListener.degToByte(session.getHeadYaw()));
                } else if (type == PacketType.Play.Server.ENTITY_LOOK || type == PacketType.Play.Server.ENTITY_MOVE_LOOK || type == PacketType.Play.Server.REL_ENTITY_MOVE_LOOK) {
                    packet.getBytes().write(0, (Object)ProtocolLibListener.degToByte(session.getBodyYaw()));
                    packet.getBytes().write(1, (Object)ProtocolLibListener.degToByte(session.getPitch()));
                } else if (type == PacketType.Play.Server.ENTITY_TELEPORT) {
                    packet.getFloat().write(0, (Object)Float.valueOf(session.getBodyYaw()));
                    packet.getFloat().write(1, (Object)Float.valueOf(session.getPitch()));
                }
                session.onPacketOverwritten();
            }
        });
    }

    private NPC getNPCFromPacket(PacketEvent event) {
        PacketContainer packet = event.getPacket();
        try {
            Object entityModifier = packet.getEntityModifier(event).read(0);
            return entityModifier instanceof NPCHolder ? ((NPCHolder)entityModifier).getNPC() : null;
        }
        catch (FieldAccessException | IllegalArgumentException ex) {
            if (!LOGGED_ERROR) {
                Messaging.severe("Error retrieving entity from ID: ProtocolLib error? Suppressing further exceptions unless debugging.");
                ex.printStackTrace();
                LOGGED_ERROR = true;
            } else if (Messaging.isDebugging()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        this.rotationTraits.remove(event.getEntity().getEntityId());
    }

    @EventHandler(ignoreCancelled=true)
    public void onNPCDespawn(NPCDespawnEvent event) {
        if (event.getNPC().getEntity() == null) {
            return;
        }
        this.rotationTraits.remove(event.getNPC().getEntity().getEntityId());
        this.mirrorTraits.remove(event.getNPC().getEntity().getUniqueId());
    }

    @EventHandler(ignoreCancelled=true)
    public void onNPCSpawn(NPCSpawnEvent event) {
        this.onSpawn(event);
    }

    private void onSpawn(NPCEvent event) {
        if (event.getNPC().hasTrait(RotationTrait.class)) {
            this.rotationTraits.put(event.getNPC().getEntity().getEntityId(), event.getNPC().getTraitNullable(RotationTrait.class));
        }
        if (event.getNPC().hasTrait(MirrorTrait.class) && event.getNPC().getOrAddTrait(MobType.class).getType() == EntityType.PLAYER) {
            this.mirrorTraits.put(event.getNPC().getEntity().getUniqueId(), event.getNPC().getTraitNullable(MirrorTrait.class));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTraitAdd(NPCAddTraitEvent event) {
        if (!event.getNPC().isSpawned()) {
            return;
        }
        this.onSpawn(event);
    }

    private static byte degToByte(float in) {
        return (byte)(in * 256.0f / 360.0f);
    }
}

