/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.api.util.EntityDim;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.MirrorTrait;
import net.citizensnpcs.trait.versioned.ArmadilloTrait;
import net.citizensnpcs.trait.versioned.CamelTrait;
import net.citizensnpcs.trait.versioned.SnifferTrait;
import net.citizensnpcs.util.EntityPacketTracker;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wither;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public interface NMSBridge {
    default public void activate(Entity entity) {
    }

    public boolean addEntityToWorld(Entity var1, CreatureSpawnEvent.SpawnReason var2);

    public void addOrRemoveFromPlayerList(Entity var1, boolean var2);

    public void attack(LivingEntity var1, LivingEntity var2);

    public void cancelMoveDestination(Entity var1);

    public boolean canNavigateTo(Entity var1, Location var2, NavigatorParameters var3);

    default public Iterable<Object> createBundlePacket(List<Object> packets) {
        return packets;
    }

    public EntityPacketTracker createPacketTracker(Entity var1, EntityPacketTracker.PacketAggregator var2);

    public GameProfile fillProfileProperties(GameProfile var1, boolean var2) throws Throwable;

    public BlockBreaker getBlockBreaker(Entity var1, Block var2, BlockBreaker.BlockBreakerConfiguration var3);

    default public Object getBossBar(Entity entity) {
        throw new UnsupportedOperationException();
    }

    public BoundingBox getBoundingBox(Entity var1);

    default public double getBoundingBoxHeight(Entity entity) {
        return entity.getHeight();
    }

    public BoundingBox getCollisionBox(Block var1);

    default public BoundingBox getCollisionBox(Object blockdata) {
        return BoundingBox.ONE;
    }

    default public Map<String, Object> getComponentMap(ItemStack item) {
        return item.getItemMeta().serialize();
    }

    public Location getDestination(Entity var1);

    public float getForwardBackwardMovement(Entity var1);

    public GameProfileRepository getGameProfileRepository();

    public float getHeadYaw(Entity var1);

    public float getMovementSpeed(Entity var1);

    public EntityPacketTracker getPacketTracker(Entity var1);

    public List<Entity> getPassengers(Entity var1);

    public GameProfile getProfile(Player var1);

    public GameProfile getProfile(SkullMeta var1);

    default public float getRidingHeightOffset(Entity entity, Entity mount) {
        return 0.0f;
    }

    public String getSoundPath(Sound var1) throws CommandException;

    public Entity getSource(BlockCommandSender var1);

    public float getStepHeight(Entity var1);

    public MCTargetStrategy.TargetNavigator getTargetNavigator(Entity var1, Entity var2, NavigatorParameters var3);

    public MCNavigationStrategy.MCNavigator getTargetNavigator(Entity var1, Iterable<Vector> var2, NavigatorParameters var3);

    public MCNavigationStrategy.MCNavigator getTargetNavigator(Entity var1, Location var2, NavigatorParameters var3);

    public Entity getVehicle(Entity var1);

    default public Collection<Player> getViewingPlayers(Entity entity) {
        return entity.getTrackedBy();
    }

    public double getWidth(Entity var1);

    public float getXZMovement(Entity var1);

    public float getYaw(Entity var1);

    public boolean isOnGround(Entity var1);

    default public boolean isSneaking(Entity entity) {
        if (entity instanceof Player) {
            return ((Player)entity).isSneaking();
        }
        return false;
    }

    public boolean isSolid(Block var1);

    default public boolean isSprinting(Entity entity) {
        return entity instanceof Player ? ((Player)entity).isSprinting() : false;
    }

    public boolean isValid(Entity var1);

    public void load(CommandManager var1);

    public void look(Entity var1, Entity var2);

    public void look(Entity var1, float var2, float var3);

    public void look(Entity var1, Location var2, boolean var3, boolean var4);

    default public void markPoseDirty(Entity tracker) {
    }

    public void mount(Entity var1, Entity var2);

    default public void onPlayerInfoAdd(Player player, Object source, Function<UUID, MirrorTrait> mirrorTraits) {
    }

    public InventoryView openAnvilInventory(Player var1, Inventory var2, String var3);

    public void openHorseInventory(Tameable var1, Player var2);

    public void playAnimation(PlayerAnimation var1, Player var2, Iterable<Player> var3);

    public Runnable playerTicker(NPC var1, Player var2);

    default public void positionInteractionText(Player player, Entity interaction, Entity mount, double height) {
    }

    public void registerEntityClass(Class<?> var1, Object var2);

    public void remove(Entity var1);

    public void removeFromServerPlayerList(Player var1);

    public void removeFromWorld(Entity var1);

    public void removeHookIfNecessary(FishHook var1);

    public void replaceTrackerEntry(Entity var1);

    public void sendComponent(Player var1, Object var2);

    public void sendPositionUpdate(Entity var1, Collection<Player> var2, boolean var3, Float var4, Float var5, Float var6);

    public boolean sendTabListAdd(Player var1, Player var2);

    public void sendTabListRemove(Player var1, Collection<Player> var2);

    public void sendTeamPacket(Player var1, Team var2, int var3);

    default public void setAggressive(Entity entity, boolean aggro) {
    }

    default public void setAllayDancing(Entity entity, boolean dancing) {
        throw new UnsupportedOperationException();
    }

    default public void setArmadilloState(Entity entity, ArmadilloTrait.ArmadilloState state) {
    }

    public void setBodyYaw(Entity var1, float var2);

    public void setBoundingBox(Entity var1, BoundingBox var2);

    default public void setCamelPose(Entity entity, CamelTrait.CamelPose pose) {
        throw new UnsupportedOperationException();
    }

    public void setCustomName(Entity var1, Object var2, String var3);

    public void setDestination(Entity var1, double var2, double var4, double var6, float var8);

    public void setDimensions(Entity var1, EntityDim var2);

    public void setEndermanAngry(Enderman var1, boolean var2);

    public void setHeadAndBodyYaw(Entity var1, float var2);

    public void setHeadYaw(Entity var1, float var2);

    public void setKnockbackResistance(LivingEntity var1, double var2);

    public void setLocationDirectly(Entity var1, Location var2);

    default public void setLyingDown(Entity cat, boolean lying) {
        throw new UnsupportedOperationException();
    }

    public void setNavigationTarget(Entity var1, Entity var2, float var3);

    public void setNavigationType(Entity var1, NMS.MinecraftNavigationType var2);

    public void setNoGravity(Entity var1, boolean var2);

    public void setOpWithoutSaving(Player var1, boolean var2);

    default public void setPandaSitting(Entity entity, boolean sitting) {
        throw new UnsupportedOperationException();
    }

    default public void setPeekShulker(Entity entity, int peek) {
        throw new UnsupportedOperationException();
    }

    default public void setPiglinDancing(Entity entity, boolean dancing) {
        throw new UnsupportedOperationException();
    }

    public void setPitch(Entity var1, float var2);

    default public void setPolarBearRearing(Entity entity, boolean rearing) {
        throw new UnsupportedOperationException();
    }

    default public void setPose(Entity entity, EntityPoseTrait.EntityPose pose) {
    }

    public void setProfile(SkullMeta var1, GameProfile var2);

    public void setShouldJump(Entity var1);

    public void setSitting(Ocelot var1, boolean var2);

    public void setSitting(Tameable var1, boolean var2);

    default public void setSneaking(Entity entity, boolean sneaking) {
        if (entity instanceof Player) {
            ((Player)entity).setSneaking(sneaking);
        }
    }

    default public void setSnifferState(Entity entity, SnifferTrait.SnifferState state) {
    }

    public void setStepHeight(Entity var1, float var2);

    default public void setTeamNameTagVisible(Team team, boolean visible) {
        team.setOption(Team.Option.NAME_TAG_VISIBILITY, visible ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER);
    }

    default public void setTextDisplayComponent(Entity entity, Object component) {
    }

    public void setVerticalMovement(Entity var1, double var2);

    default public void setWardenPose(Entity entity, Object pose) {
    }

    default public void setWitherInvulnerableTicks(Wither wither, int ticks) {
        wither.setInvulnerabilityTicks(ticks);
    }

    public boolean shouldJump(Entity var1);

    public void shutdown();

    public void sleep(Player var1, boolean var2);

    public void trySwim(Entity var1);

    public void trySwim(Entity var1, float var2);

    public void updateInventoryTitle(Player var1, SpigotUtil.InventoryViewAPI var2, String var3);

    public void updateNavigationWorld(Entity var1, World var2);

    public void updatePathfindingRange(NPC var1, float var2);
}

