/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc.templates;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitTemplateParser;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class TraitLoaderAction
implements Consumer<NPC> {
    private final List<Function<NPC, Trait>> actions = Lists.newArrayList();

    public TraitLoaderAction(DataKey traits) {
        for (DataKey key : traits.getIntegerSubKeys()) {
            ImmutableList list = ImmutableList.copyOf(key.getSubKeys());
            if (list.isEmpty()) {
                String shortTraitDescriptor = key.getString("").trim();
                String[] parts = shortTraitDescriptor.split(" ");
                String traitNamePartial = parts[0];
                TraitTemplateParser parser = CitizensAPI.getTraitFactory().getTemplateParser(traitNamePartial);
                if (parser == null) {
                    Messaging.severe("Unknown trait", traitNamePartial);
                    continue;
                }
                TraitTemplateParser.ShortTemplateParser stp = parser.getShortTemplateParser();
                if (stp == null) continue;
                CommandContext ctx = new CommandContext((CommandSender)Bukkit.getConsoleSender(), parts);
                this.actions.add(npc -> (Trait)stp.apply(npc, ctx));
                continue;
            }
            if (!key.keyExists("name")) {
                Messaging.severe("Missing trait name");
                continue;
            }
            String traitName = key.getString("name");
            TraitTemplateParser parser = CitizensAPI.getTraitFactory().getTemplateParser(traitName);
            if (parser == null) {
                Messaging.severe("Unknown trait", traitName);
                continue;
            }
            TraitTemplateParser.TemplateParser tp = parser.getTemplateParser();
            if (tp == null) continue;
            this.actions.add(npc -> (Trait)tp.apply(npc, key));
        }
    }

    @Override
    public void accept(NPC npc) {
        for (Function<NPC, Trait> action : this.actions) {
            Trait trait = action.apply(npc);
            if (trait == null) continue;
            npc.addTrait(trait);
        }
    }
}

