/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import org.bukkit.Location;
import org.bukkit.event.player.PlayerTeleportEvent;

@TraitName(value="hometrait")
public class HomeTrait
extends Trait {
    @Persist
    private int delay = -1;
    @Persist
    private double distance = -1.0;
    @Persist
    private Location location;
    @Persist
    private ReturnStrategy strategy = ReturnStrategy.TELEPORT;
    private int t;

    public HomeTrait() {
        super("hometrait");
    }

    public int getDelayTicks() {
        return this.delay;
    }

    public double getDistanceBlocks() {
        return this.distance;
    }

    public Location getHomeLocation() {
        return this.location.clone();
    }

    public ReturnStrategy getReturnStrategy() {
        return this.strategy;
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned() || this.location == null || this.npc.getNavigator().isNavigating() || this.npc.getStoredLocation().distance(this.location) < 0.1) {
            this.t = 0;
            return;
        }
        ++this.t;
        if (!(this.t <= this.delay && this.delay != -1 || this.distance != -1.0 && !(this.npc.getStoredLocation().distance(this.location) >= this.distance))) {
            if (this.strategy == ReturnStrategy.TELEPORT) {
                this.npc.teleport(this.location, PlayerTeleportEvent.TeleportCause.PLUGIN);
            } else if (this.strategy == ReturnStrategy.PATHFIND) {
                this.npc.getNavigator().setTarget(this.location);
                this.npc.getNavigator().getLocalParameters().distanceMargin(0.9).pathDistanceMargin(0.0).destinationTeleportMargin(1.0);
            }
        }
    }

    public void setDelayTicks(int delay) {
        this.delay = delay;
    }

    public void setDistanceBlocks(double distance) {
        this.distance = distance;
    }

    public void setHomeLocation(Location location) {
        this.location = location.clone();
    }

    public void setReturnStrategy(ReturnStrategy strategy) {
        this.strategy = strategy;
    }

    public static enum ReturnStrategy {
        PATHFIND,
        TELEPORT;

    }
}

