/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.CitizensGetSelectedNPCEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.event.NPCSelectEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.Directional;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;

public class NPCSelector
implements Listener,
net.citizensnpcs.api.npc.NPCSelector {
    private UUID consoleSelectedNPC;
    private final Plugin plugin;

    public NPCSelector(Plugin plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    @Override
    public void deselect(CommandSender sender) {
        if (sender instanceof ConsoleCommandSender) {
            this.consoleSelectedNPC = null;
        } else if (sender instanceof Metadatable) {
            this.removeMetadata((Metadatable)sender);
        }
    }

    @Override
    public NPC getSelected(CommandSender sender) {
        CitizensGetSelectedNPCEvent event = new CitizensGetSelectedNPCEvent(sender);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.getSelected() != null) {
            return event.getSelected();
        }
        if (sender instanceof Player) {
            return this.getSelectedFromMetadatable((Metadatable)((Player)sender));
        }
        if (sender instanceof BlockCommandSender) {
            return this.getSelectedFromMetadatable((Metadatable)((BlockCommandSender)sender).getBlock());
        }
        if (sender instanceof ConsoleCommandSender) {
            if (this.consoleSelectedNPC == null) {
                return null;
            }
            return CitizensAPI.getNPCRegistry().getByUniqueIdGlobal(this.consoleSelectedNPC);
        }
        return null;
    }

    private NPC getSelectedFromMetadatable(Metadatable sender) {
        List metadata = sender.getMetadata("selected");
        if (metadata.size() == 0) {
            return null;
        }
        if (((MetadataValue)metadata.get(0)).value() == null) {
            sender.removeMetadata("selected", this.plugin);
            return null;
        }
        return CitizensAPI.getNPCRegistry().getByUniqueIdGlobal((UUID)((MetadataValue)metadata.get(0)).value());
    }

    @EventHandler
    private void onNPCRemove(NPCRemoveEvent event) {
        NPC npc = event.getNPC();
        List selectors = (List)npc.data().get("selectors");
        if (selectors == null) {
            return;
        }
        for (String value : selectors) {
            if (value.equals("console")) {
                this.consoleSelectedNPC = null;
                continue;
            }
            if (value.startsWith("@")) {
                String[] parts = value.substring(1).split(":");
                World world = Bukkit.getWorld((String)parts[0]);
                if (world == null) continue;
                Block block = world.getBlockAt(Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3]));
                this.removeMetadata((Metadatable)block);
                continue;
            }
            this.removeMetadata((Metadatable)Bukkit.getPlayer((UUID)UUID.fromString(value)));
        }
        npc.data().remove("selectors");
    }

    @EventHandler
    private void onNPCRightClick(NPCRightClickEvent event) {
        Player player = event.getClicker();
        NPC npc = event.getNPC();
        List selected = player.getMetadata("selected");
        if ((selected == null || selected.size() == 0 || ((MetadataValue)selected.get(0)).asInt() != npc.getId()) && Util.matchesItemInHand(player, Settings.Setting.SELECTION_ITEM.asString()) && npc.getOrAddTrait(Owner.class).isOwnedBy((CommandSender)player)) {
            player.removeMetadata("selected", this.plugin);
            this.select((CommandSender)player, npc);
            if (!Settings.Setting.SELECTION_MESSAGE.asString().isEmpty()) {
                Messaging.sendWithNPC((CommandSender)player, Settings.Setting.SELECTION_MESSAGE.asString(), npc);
            }
            event.setDelayedCancellation(true);
        }
    }

    private void removeMetadata(Metadatable metadatable) {
        if (metadatable != null) {
            metadatable.removeMetadata("selected", this.plugin);
        }
    }

    @Override
    public void select(CommandSender sender, NPC npc) {
        List selectors = (List)npc.data().get("selectors");
        if (selectors == null) {
            selectors = Lists.newArrayList();
            npc.data().set("selectors", (Object)selectors);
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.setMetadata(npc, (Metadatable)player);
            selectors.add(player.getUniqueId().toString());
            Editor.leave(player);
        } else if (sender instanceof BlockCommandSender) {
            Block block = ((BlockCommandSender)sender).getBlock();
            while (block != null) {
                this.setMetadata(npc, (Metadatable)block);
                selectors.add(this.toName(block));
                if (block.getBlockData() instanceof Directional) {
                    if ((block = block.getRelative(((Directional)block.getBlockData()).getFacing())).getType().name().contains("COMMAND_BLOCK")) continue;
                    block = null;
                    continue;
                }
                block = null;
            }
        } else if (sender instanceof ConsoleCommandSender) {
            this.consoleSelectedNPC = npc.getUniqueId();
            selectors.add("console");
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCSelectEvent(npc, sender));
    }

    private void setMetadata(NPC npc, Metadatable metadatable) {
        if (metadatable.hasMetadata("selected")) {
            metadatable.removeMetadata("selected", this.plugin);
        }
        metadatable.setMetadata("selected", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)npc.getUniqueId()));
    }

    private String toName(Block block) {
        return '@' + block.getWorld().getName() + ":" + Integer.toString(block.getX()) + ":" + Integer.toString(block.getY()) + ":" + Integer.toString(block.getZ());
    }
}

