/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.commands;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.Vector;
import java.util.stream.Collectors;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.PathfinderType;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.ai.tree.StatusMapper;
import net.citizensnpcs.api.command.Arg;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.command.exception.NoPermissionsException;
import net.citizensnpcs.api.command.exception.RequirementMissingException;
import net.citizensnpcs.api.command.exception.ServerCommandException;
import net.citizensnpcs.api.event.CommandSenderCloneNPCEvent;
import net.citizensnpcs.api.event.CommandSenderCreateNPCEvent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCTeleportEvent;
import net.citizensnpcs.api.event.PlayerCloneNPCEvent;
import net.citizensnpcs.api.event.PlayerCreateNPCEvent;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.gui.InventoryMenu;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.npc.templates.Template;
import net.citizensnpcs.api.npc.templates.TemplateRegistry;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.trait.trait.PlayerFilter;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.EntityDim;
import net.citizensnpcs.api.util.MemoryDataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Paginator;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.commands.NPCCommandSelector;
import net.citizensnpcs.commands.TemplateCommands;
import net.citizensnpcs.commands.gui.NPCConfigurator;
import net.citizensnpcs.commands.history.CommandHistory;
import net.citizensnpcs.commands.history.CreateNPCHistoryItem;
import net.citizensnpcs.commands.history.RemoveNPCHistoryItem;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.NPCSelector;
import net.citizensnpcs.trait.Age;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.trait.AttributeTrait;
import net.citizensnpcs.trait.BatTrait;
import net.citizensnpcs.trait.BehaviorTrait;
import net.citizensnpcs.trait.BoundingBoxTrait;
import net.citizensnpcs.trait.ClickRedirectTrait;
import net.citizensnpcs.trait.CommandTrait;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.DropsTrait;
import net.citizensnpcs.trait.EnderCrystalTrait;
import net.citizensnpcs.trait.EndermanTrait;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.FollowTrait;
import net.citizensnpcs.trait.ForcefieldTrait;
import net.citizensnpcs.trait.GameModeTrait;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.HologramTrait;
import net.citizensnpcs.trait.HomeTrait;
import net.citizensnpcs.trait.HorseModifiers;
import net.citizensnpcs.trait.ItemFrameTrait;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.MirrorTrait;
import net.citizensnpcs.trait.MountTrait;
import net.citizensnpcs.trait.OcelotModifiers;
import net.citizensnpcs.trait.PacketNPC;
import net.citizensnpcs.trait.PaintingTrait;
import net.citizensnpcs.trait.PausePathfindingTrait;
import net.citizensnpcs.trait.Poses;
import net.citizensnpcs.trait.Powered;
import net.citizensnpcs.trait.RabbitType;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.trait.ScaledMaxHealthTrait;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.trait.SheepTrait;
import net.citizensnpcs.trait.ShopTrait;
import net.citizensnpcs.trait.SitTrait;
import net.citizensnpcs.trait.SkinLayers;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.trait.SlimeSize;
import net.citizensnpcs.trait.TargetableTrait;
import net.citizensnpcs.trait.WitherTrait;
import net.citizensnpcs.trait.WolfModifiers;
import net.citizensnpcs.trait.shop.StoredShops;
import net.citizensnpcs.trait.waypoint.WanderWaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoints;
import net.citizensnpcs.util.Anchor;
import net.citizensnpcs.util.MojangSkinGenerator;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.StringHelper;
import net.citizensnpcs.util.Util;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Rotation;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.util.RayTraceResult;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@Requirements(selected=true, ownership=true)
public class NPCCommands {
    private final CommandHistory history;
    private final NPCSelector selector;
    private final StoredShops shops;
    private final TemplateRegistry templateRegistry;
    private final NPCRegistry temporaryRegistry;
    private static boolean SUPPORT_RAYTRACE = false;

    public NPCCommands(Citizens plugin) {
        this.selector = plugin.getNPCSelector();
        this.shops = plugin.getShops();
        this.templateRegistry = plugin.getTemplateRegistry();
        this.temporaryRegistry = plugin.getTemporaryNPCRegistry();
        this.history = new CommandHistory(this.selector);
    }

    @Command(aliases={"npc"}, usage="activationrange [range]", desc="", modifiers={"activationrange"}, min=1, max=2, permission="citizens.npc.activationrange")
    public void activationrange(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) Integer range) {
        if (range == null) {
            npc.data().remove(NPC.Metadata.ACTIVATION_RANGE);
        } else {
            npc.data().setPersistent(NPC.Metadata.ACTIVATION_RANGE, (Object)range);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.activationrange.set", range);
    }

    @Command(aliases={"npc"}, usage="age [age] (-l(ock))", desc="", flags="l", modifiers={"age"}, min=1, max=2, permission="citizens.npc.age")
    public void age(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (!npc.isSpawned() || !(npc.getEntity() instanceof Ageable) && !(npc.getEntity() instanceof Zombie) && !npc.getEntity().getType().name().equals("TADPOLE")) {
            throw new CommandException("citizens.commands.npc.age.cannot-be-aged", npc.getName());
        }
        Age trait = npc.getOrAddTrait(Age.class);
        boolean toggleLock = args.hasFlag('l');
        if (toggleLock) {
            Messaging.sendTr(sender, trait.toggle() ? "citizens.commands.npc.age.locked" : "citizens.commands.npc.age.unlocked", new Object[0]);
        }
        if (args.argsLength() <= 1) {
            if (!toggleLock) {
                trait.describe(sender);
            }
            return;
        }
        int age = 0;
        try {
            age = args.getInteger(1);
            if (age > 0) {
                throw new CommandException("citizens.commands.npc.age.invalid-age");
            }
            Messaging.sendTr(sender, "citizens.commands.npc.age.set-normal", npc.getName(), age);
        }
        catch (NumberFormatException ex) {
            if (args.getString(1).equalsIgnoreCase("baby")) {
                age = -24000;
                Messaging.sendTr(sender, "citizens.commands.npc.age.set-baby", npc.getName());
            }
            if (args.getString(1).equalsIgnoreCase("adult")) {
                age = 0;
                Messaging.sendTr(sender, "citizens.commands.npc.age.set-adult", npc.getName());
            }
            throw new CommandException("citizens.commands.npc.age.invalid-age");
        }
        trait.setAge(age);
    }

    @Command(aliases={"npc"}, usage="aggressive [true|false] (-t(emporary))", desc="", flags="t", modifiers={"aggressive"}, min=1, max=2, permission="citizens.npc.aggressive")
    public void aggressive(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) Boolean aggressive) {
        boolean aggro;
        boolean bl = aggressive != null ? aggressive : (aggro = npc.data().get(NPC.Metadata.AGGRESSIVE, Boolean.valueOf(false)) == false);
        if (args.hasFlag('t')) {
            npc.data().set(NPC.Metadata.AGGRESSIVE, (Object)aggressive);
        } else {
            npc.data().setPersistent(NPC.Metadata.AGGRESSIVE, (Object)aggro);
        }
        NMS.setAggressive(npc.getEntity(), aggro);
    }

    @Command(aliases={"npc"}, usage="ai (true|false)", desc="", modifiers={"ai"}, min=1, max=2, permission="citizens.npc.ai")
    public void ai(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) Boolean explicit) throws CommandException {
        boolean useAI = explicit == null ? !npc.useMinecraftAI() : explicit;
        npc.setUseMinecraftAI(useAI);
        Messaging.sendTr(sender, useAI ? "citizens.commands.npc.ai.started" : "citizens.commands.npc.ai.stopped", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Command(aliases={"npc"}, usage="anchor (--save [name]|--assume [name]|--remove [name]) (-a) (-c)", desc="", flags="ac", modifiers={"anchor"}, min=1, max=3, permission="citizens.npc.anchor")
    public void anchor(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"save"}) String save, @Flag(value={"assume"}) String assume, @Flag(value={"remove"}) String remove) throws CommandException {
        Anchors trait = npc.getOrAddTrait(Anchors.class);
        if (save != null) {
            if (save.isEmpty()) {
                throw new CommandException("citizens.commands.npc.anchor.invalid-name");
            }
            if (args.getSenderLocation() == null) {
                throw new ServerCommandException();
            }
            if (args.hasFlag('c')) {
                if (!trait.addAnchor(save, args.getSenderTargetBlockLocation())) throw new CommandException("citizens.commands.npc.anchor.already-exists", save);
                Messaging.sendTr(sender, "citizens.commands.npc.anchor.added", new Object[0]);
            } else {
                if (!trait.addAnchor(save, args.getSenderLocation())) throw new CommandException("citizens.commands.npc.anchor.already-exists", save);
                Messaging.sendTr(sender, "citizens.commands.npc.anchor.added", new Object[0]);
            }
        } else if (assume != null) {
            if (assume.isEmpty()) {
                throw new CommandException("citizens.commands.npc.anchor.invalid-name");
            }
            Anchor anchor = trait.getAnchor(assume);
            if (anchor == null) {
                throw new CommandException("citizens.commands.npc.anchor.missing", assume);
            }
            npc.teleport(anchor.getLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
        } else if (remove != null) {
            if (remove.isEmpty()) {
                throw new CommandException("citizens.commands.npc.anchor.invalid-name");
            }
            if (!trait.removeAnchor(trait.getAnchor(remove))) throw new CommandException("citizens.commands.npc.anchor.missing", remove);
            Messaging.sendTr(sender, "citizens.commands.npc.anchor.removed", new Object[0]);
        } else if (!args.hasFlag('a')) {
            Paginator paginator = new Paginator().header("Anchors").console(sender instanceof ConsoleCommandSender);
            paginator.addLine("Key: [[ID]]  <blue>Name  <red>World  <gray>Location (X,Y,Z)");
            for (int i = 0; i < trait.getAnchors().size(); ++i) {
                if (trait.getAnchors().get(i).isLoaded()) {
                    String line = i + "<blue>  " + trait.getAnchors().get(i).getName() + "<yellow>  " + trait.getAnchors().get(i).getLocation().getWorld().getName() + "<gray>  " + trait.getAnchors().get(i).getLocation().getBlockX() + ", " + trait.getAnchors().get(i).getLocation().getBlockY() + ", " + trait.getAnchors().get(i).getLocation().getBlockZ();
                    paginator.addLine(line);
                    continue;
                }
                String[] parts = trait.getAnchors().get(i).getUnloadedValue();
                String line = i + "<blue>  " + trait.getAnchors().get(i).getName() + "<red>  " + parts[0] + "<gray>  " + parts[1] + ", " + parts[2] + ", " + parts[3] + " <white>(unloaded)";
                paginator.addLine(line);
            }
            int page = args.getInteger(1, 1);
            if (!paginator.sendPage(sender, page)) {
                throw new CommandException("citizens.commands.page-missing", page);
            }
        }
        if (!args.hasFlag('a')) {
            return;
        }
        if (sender instanceof ConsoleCommandSender) {
            throw new ServerCommandException();
        }
        npc.teleport(args.getSenderLocation(), PlayerTeleportEvent.TeleportCause.COMMAND);
    }

    @Command(aliases={"npc"}, usage="armorstand --visible [visible] --small [small] --marker [marker] --gravity [gravity] --arms [arms] --baseplate [baseplate] --(head|body|leftarm|leftleg|rightarm|rightleg)pose [angle x,y,z]", desc="", modifiers={"armorstand"}, min=1, max=1, valueFlags={"bodypose", "leftarmpose", "rightarmpose", "leftlegpose", "rightlegpose"}, permission="citizens.npc.armorstand")
    @Requirements(selected=true, ownership=true, types={EntityType.ARMOR_STAND})
    public void armorstand(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"visible"}) Boolean visible, @Flag(value={"small"}) Boolean small, @Flag(value={"gravity"}) Boolean gravity, @Flag(value={"arms"}) Boolean arms, @Flag(value={"marker"}) Boolean marker, @Flag(value={"baseplate"}) Boolean baseplate) throws CommandException {
        ArmorStandTrait trait = npc.getOrAddTrait(ArmorStandTrait.class);
        if (visible != null) {
            trait.setVisible(visible);
        }
        if (small != null) {
            trait.setSmall(small);
        }
        if (gravity != null) {
            trait.setGravity(gravity);
        }
        if (marker != null) {
            trait.setMarker(marker);
        }
        if (arms != null) {
            trait.setHasArms(arms);
        }
        if (baseplate != null) {
            trait.setHasBaseplate(baseplate);
        }
        ArmorStand ent = (ArmorStand)npc.getEntity();
        if (args.hasValueFlag("headpose")) {
            ent.setHeadPose(args.parseEulerAngle(args.getFlag("headpose")));
        }
        if (args.hasValueFlag("bodypose")) {
            ent.setBodyPose(args.parseEulerAngle(args.getFlag("bodypose")));
        }
        if (args.hasValueFlag("leftarmpose")) {
            ent.setLeftArmPose(args.parseEulerAngle(args.getFlag("leftarmpose")));
        }
        if (args.hasValueFlag("leftlegpose")) {
            ent.setLeftLegPose(args.parseEulerAngle(args.getFlag("leftlegpose")));
        }
        if (args.hasValueFlag("rightarmpose")) {
            ent.setRightArmPose(args.parseEulerAngle(args.getFlag("rightarmpose")));
        }
        if (args.hasValueFlag("rightlegpose")) {
            ent.setRightLegPose(args.parseEulerAngle(args.getFlag("rightlegpose")));
        }
    }

    @Command(aliases={"npc"}, usage="attribute [attribute] [value]", desc="", modifiers={"attribute"}, min=2, max=3, permission="citizens.npc.attribute")
    public void attribute(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1, completionsProvider=OptionalAttributeCompletions.class) String attribute, @Arg(value=2) Double value) {
        Attribute attr = Util.getAttribute(attribute);
        if (attr == null) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.attribute.not-found", attribute);
            return;
        }
        AttributeTrait trait = npc.getOrAddTrait(AttributeTrait.class);
        if (value == null) {
            trait.resetToDefaultValue(attr);
            Messaging.sendTr(sender, "citizens.commands.npc.attribute.reset", attribute);
        } else {
            trait.setAttributeValue(attr, value);
            Messaging.sendTr(sender, "citizens.commands.npc.attribute.set", attribute, value);
        }
    }

    @Command(aliases={"npc"}, usage="bat --awake [awake]", desc="", modifiers={"bat"}, min=1, max=1, permission="citizens.npc.bat")
    @Requirements(selected=true, ownership=true, types={EntityType.BAT})
    public void bat(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"awake"}) Boolean awake) throws CommandException {
        if (awake == null) {
            throw new CommandException();
        }
        npc.getOrAddTrait(BatTrait.class).setAwake(awake);
        Messaging.sendTr(sender, awake != false ? "citizens.commands.npc.bat.awake-set" : "citizens.commands.npc.bat.awake-unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="behavior [file.yml]", desc="", modifiers={"behavior"}, min=1, max=1, permission="citizens.npc.behavior")
    public void behavior(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) String file) throws CommandException {
        BehaviorTrait trait = npc.getOrAddTrait(BehaviorTrait.class);
        File src = new File(CitizensAPI.getDataFolder(), "behaviors");
        File f = new File(src, file);
        if (!f.exists() || !f.getParentFile().equals(src)) {
            throw new CommandException("citizens.commands.npc.behavior.invalid-file");
        }
        trait.applyBehaviorsFromFile(f);
        Messaging.sendTr(sender, "citizens.commands.npc.behavior.tree-applied", npc.getName(), file);
    }

    @Command(aliases={"npc"}, usage="breakblock --location [x,y,z] --radius [radius]", desc="", modifiers={"breakblock"}, min=1, max=1, valueFlags={"location"}, permission="citizens.npc.breakblock")
    public void breakblock(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"radius"}) Double radius) throws CommandException {
        BlockBreaker.BlockBreakerConfiguration cfg = new BlockBreaker.BlockBreakerConfiguration();
        if (radius != null) {
            cfg.radius(radius);
        } else if (Settings.Setting.DEFAULT_BLOCK_BREAKER_RADIUS.asDouble() > 0.0) {
            cfg.radius(Settings.Setting.DEFAULT_BLOCK_BREAKER_RADIUS.asDouble());
        }
        if (npc.getEntity() instanceof InventoryHolder) {
            cfg.blockBreaker((block, itemstack) -> {
                Inventory inventory = ((InventoryHolder)npc.getEntity()).getInventory();
                Location location = npc.getEntity().getLocation();
                Collection drops = block.getDrops(itemstack);
                block.setType(Material.AIR);
                for (ItemStack drop : drops) {
                    for (ItemStack unadded : inventory.addItem(new ItemStack[]{drop}).values()) {
                        location.getWorld().dropItemNaturally(npc.getEntity().getLocation(), unadded);
                    }
                }
            });
        }
        BlockBreaker breaker = npc.getBlockBreaker(args.getSenderTargetBlockLocation().getBlock(), cfg);
        npc.getDefaultGoalController().addBehavior(StatusMapper.singleUse(breaker), 1);
    }

    @Command(aliases={"npc"}, usage="chunkload (-t(emporary))", desc="", modifiers={"chunkload", "cload"}, min=1, max=1, flags="t", permission="citizens.npc.chunkload")
    public void chunkload(CommandContext args, CommandSender sender, NPC npc) {
        boolean enabled;
        boolean bl = enabled = npc.data().get(NPC.Metadata.KEEP_CHUNK_LOADED, Boolean.valueOf(Settings.Setting.KEEP_CHUNKS_LOADED.asBoolean())) == false;
        if (args.hasFlag('t')) {
            npc.data().set(NPC.Metadata.KEEP_CHUNK_LOADED, (Object)enabled);
        } else {
            npc.data().setPersistent(NPC.Metadata.KEEP_CHUNK_LOADED, (Object)enabled);
        }
        Messaging.sendTr(sender, enabled ? "citizens.commands.npc.chunkload.set" : "citizens.commands.npc.chunkload.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="collidable --fluids [true|false]", desc="", modifiers={"collidable", "pushable"}, min=1, max=1, permission="citizens.npc.collidable")
    public void collidable(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"fluids"}) Boolean fluids) throws CommandException {
        if (fluids != null) {
            npc.data().setPersistent(NPC.Metadata.FLUID_PUSHABLE, (Object)fluids);
            Messaging.sendTr(sender, fluids != false ? "citizens.commands.npc.collidable.fluid-set" : "citizens.commands.npc.collidable.fluid-unset", npc.getName());
            return;
        }
        npc.data().setPersistent(NPC.Metadata.COLLIDABLE, (Object)(npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!npc.isProtected())) == false ? 1 : 0));
        Messaging.sendTr(sender, (Boolean)npc.data().get(NPC.Metadata.COLLIDABLE) != false ? "citizens.commands.npc.collidable.set" : "citizens.commands.npc.collidable.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="command (add [command] | execute [player UUID] [hand] | remove [id|all] | permissions [permissions] (duration) | sequential | cycle | random | forgetplayer (uuid) | clearerror [type] (name|uuid) | errormsg [type] [msg] | persistsequence [true|false] | cost [cost] (id) | expcost [cost] (id) | itemcost (id)) (-s(hift)) (-l[eft]/-r[ight]) (-p[layer] -o[p]), --cooldown --gcooldown [seconds] --delay [ticks] --permissions [perms] --n [max # of uses] --gn [max # of global uses]", desc="", modifiers={"command", "cmd"}, min=1, flags="sproln", permission="citizens.npc.command")
    public void command(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"permissions", "permission"}) String permissions, @Flag(value={"cost"}, defValue="-1") Double cost, @Flag(value={"expcost"}, defValue="-1") Integer experienceCost, @Flag(value={"cooldown"}, defValue="0") Duration cooldown, @Flag(value={"gcooldown"}, defValue="0") Duration gcooldown, @Flag(value={"n"}, defValue="-1") int n, @Flag(value={"gn"}, defValue="-1") int gn, @Flag(value={"delay"}, defValue="0") Duration delay, @Arg(value=1, completions={"add", "execute", "remove", "permissions", "persistsequence", "sequential", "cycle", "random", "forgetplayer", "hideerrors", "errormessage", "clearerror", "expcost", "itemcost", "cost"}) String action) throws CommandException {
        CommandTrait commands = npc.getOrAddTrait(CommandTrait.class);
        if (args.argsLength() == 1) {
            commands.describe(sender);
        } else {
            if (action.equalsIgnoreCase("add")) {
                CommandTrait.Hand hand;
                if (args.argsLength() == 2) {
                    throw new CommandUsageException();
                }
                if (args.hasFlag('o') && !sender.hasPermission("citizens.admin")) {
                    throw new NoPermissionsException();
                }
                String command = args.getJoinedStrings(2);
                CommandTrait.Hand hand2 = args.hasFlag('l') && args.hasFlag('r') ? CommandTrait.Hand.BOTH : (hand = args.hasFlag('l') ? CommandTrait.Hand.LEFT : CommandTrait.Hand.RIGHT);
                if (args.hasFlag('s') && hand != CommandTrait.Hand.BOTH) {
                    hand = hand == CommandTrait.Hand.LEFT ? CommandTrait.Hand.SHIFT_LEFT : CommandTrait.Hand.SHIFT_RIGHT;
                }
                ArrayList perms = Lists.newArrayList();
                if (permissions != null) {
                    perms.addAll(Arrays.asList(permissions.split(",")));
                }
                if (command.startsWith("npc select")) {
                    throw new CommandException("npc select not currently supported within commands. Use --id <id> instead");
                }
                try {
                    int id = commands.addCommand(new CommandTrait.NPCCommandBuilder(command, hand).addPerms(perms).player(args.hasFlag('p') || args.hasFlag('o')).op(args.hasFlag('o')).cooldown(cooldown).cost(cost).experienceCost(experienceCost).globalCooldown(gcooldown).n(n).globalN(gn).delay(delay).npc(args.hasFlag('n')));
                    Messaging.sendTr(sender, "citizens.commands.npc.command.command-added", command, id);
                }
                catch (NumberFormatException ex) {
                    throw new CommandException("citizens.commands.invalid-number");
                }
            }
            if (action.equalsIgnoreCase("execute")) {
                if (args.argsLength() < 4) {
                    throw new CommandUsageException();
                }
                Player player = null;
                try {
                    UUID uuid = UUID.fromString(args.getString(2));
                    player = Bukkit.getPlayer((UUID)uuid);
                }
                catch (IllegalArgumentException ex) {
                    player = Bukkit.getPlayer((String)args.getString(2));
                }
                if (player == null) {
                    throw new CommandException("citizens.commands.npc.command.invalid-player", args.getString(2));
                }
                CommandTrait.Hand hand = (CommandTrait.Hand)Util.matchEnum((Enum[])CommandTrait.Hand.values(), (String)args.getString(3));
                if (hand == null) {
                    throw new CommandException("citizens.commands.npc.command.invalid-hand", Util.listValuesPretty((Object[])CommandTrait.Hand.values()));
                }
                commands.dispatch(player, hand);
            } else if (action.equalsIgnoreCase("forgetplayer")) {
                if (args.argsLength() < 3) {
                    commands.clearPlayerHistory(null);
                    Messaging.sendTr(sender, "citizens.commands.npc.command.all-players-forgotten", npc.getName());
                    return;
                }
                String raw = args.getString(2);
                Player who = Bukkit.getPlayerExact((String)raw);
                if (who == null) {
                    who = Bukkit.getOfflinePlayer((UUID)UUID.fromString(raw));
                }
                if (who == null || !who.hasPlayedBefore()) {
                    throw new CommandException("citizens.commands.npc.command.invalid-player", raw);
                }
                commands.clearPlayerHistory(who.getUniqueId());
                Messaging.sendTr(sender, "citizens.commands.npc.command.player-forgotten", who.getUniqueId());
            } else if (action.equalsIgnoreCase("clearerror")) {
                if (args.argsLength() < 3) {
                    throw new CommandException("citizens.commands.npc.command.invalid-error-message", Util.listValuesPretty((Object[])CommandTrait.CommandTraitError.values()));
                }
                CommandTrait.CommandTraitError which = (CommandTrait.CommandTraitError)Util.matchEnum((Enum[])CommandTrait.CommandTraitError.values(), (String)args.getString(2));
                if (which == null) {
                    throw new CommandException("citizens.commands.npc.command.invalid-error-message", Util.listValuesPretty((Object[])CommandTrait.CommandTraitError.values()));
                }
                if (args.argsLength() < 4) {
                    commands.clearHistory(which, null);
                    Messaging.sendTr(sender, "citizens.commands.npc.command.all-errors-cleared", npc.getName(), Util.prettyEnum(which));
                    return;
                }
                String raw = args.getString(3);
                Player who = Bukkit.getPlayerExact((String)raw);
                if (who == null) {
                    who = Bukkit.getOfflinePlayer((UUID)UUID.fromString(raw));
                }
                if (who == null || !who.hasPlayedBefore()) {
                    throw new CommandException("citizens.commands.npc.command.invalid-player", raw);
                }
                commands.clearHistory(which, who.getUniqueId());
                Messaging.sendTr(sender, "citizens.commands.npc.command.errors-cleared", Util.prettyEnum(which), who.getUniqueId());
            } else if (action.equalsIgnoreCase("sequential")) {
                commands.setExecutionMode(commands.getExecutionMode() == CommandTrait.ExecutionMode.SEQUENTIAL ? CommandTrait.ExecutionMode.LINEAR : CommandTrait.ExecutionMode.SEQUENTIAL);
                Messaging.sendTr(sender, commands.getExecutionMode() == CommandTrait.ExecutionMode.SEQUENTIAL ? "citizens.commands.npc.commands.sequential-set" : "citizens.commands.npc.commands.sequential-unset", new Object[0]);
            } else if (action.equalsIgnoreCase("cycle")) {
                commands.setExecutionMode(commands.getExecutionMode() == CommandTrait.ExecutionMode.CYCLE ? CommandTrait.ExecutionMode.LINEAR : CommandTrait.ExecutionMode.CYCLE);
                Messaging.sendTr(sender, commands.getExecutionMode() == CommandTrait.ExecutionMode.CYCLE ? "citizens.commands.npc.command.cycle-set" : "citizens.commands.npc.command.cycle-unset", new Object[0]);
            } else if (action.equalsIgnoreCase("rememberlastused")) {
                if (args.argsLength() == 2) {
                    commands.setRememberLastUsed(!commands.rememberLastUsed());
                } else {
                    commands.setRememberLastUsed(Boolean.parseBoolean(args.getString(3)));
                }
                Messaging.sendTr(sender, commands.rememberLastUsed() ? "citizens.commands.npc.command.remember-last-used-set" : "citizens.commands.npc.command.remember-last-used-unset", new Object[0]);
            } else if (action.equalsIgnoreCase("remove")) {
                if (args.argsLength() == 2) {
                    throw new CommandUsageException();
                }
                if (args.getString(2).equalsIgnoreCase("all")) {
                    commands.clear();
                    Messaging.sendTr(sender, "citizens.commands.npc.command.cleared", npc.getName());
                } else {
                    int id = args.getInteger(2, -1);
                    if (!commands.hasCommandId(id)) {
                        throw new CommandException("citizens.commands.npc.command.unknown-id", id);
                    }
                    commands.removeCommandById(id);
                    Messaging.sendTr(sender, "citizens.commands.npc.command.command-removed", id);
                }
            } else if (action.equalsIgnoreCase("permissions") || action.equalsIgnoreCase("perms")) {
                if (!sender.hasPermission("citizens.admin")) {
                    throw new NoPermissionsException();
                }
                List<String> temporaryPermissions = Arrays.asList(args.getString(2).split(","));
                int duration = -1;
                if (args.argsLength() == 4) {
                    duration = SpigotUtil.parseTicks(args.getString(3));
                }
                commands.setTemporaryPermissions(temporaryPermissions, duration);
                Messaging.sendTr(sender, "citizens.commands.npc.command.temporary-permissions-set", Joiner.on((char)' ').join(temporaryPermissions), duration);
            } else if (action.equalsIgnoreCase("cost")) {
                if (args.argsLength() == 2) {
                    throw new CommandException("citizens.commands.npc.command.cost-missing");
                }
                commands.setCost(args.getDouble(2));
                Messaging.sendTr(sender, "citizens.commands.npc.command.cost-set", args.getDouble(2));
            } else if (action.equalsIgnoreCase("expcost")) {
                if (args.argsLength() == 2) {
                    throw new CommandException("citizens.commands.npc.command.cost-missing");
                }
                commands.setExperienceCost(args.getInteger(2));
                Messaging.sendTr(sender, "citizens.commands.npc.command.experience-cost-set", args.getInteger(2));
            } else if (action.equalsIgnoreCase("hideerrors")) {
                commands.setHideErrorMessages(!commands.isHideErrorMessages());
                Messaging.sendTr(sender, commands.isHideErrorMessages() ? "citizens.commands.npc.command.hide-error-messages-set" : "citizens.commands.npc.command.hide-error-messages-unset", new Object[0]);
            } else if (action.equalsIgnoreCase("random")) {
                commands.setExecutionMode(commands.getExecutionMode() == CommandTrait.ExecutionMode.RANDOM ? CommandTrait.ExecutionMode.LINEAR : CommandTrait.ExecutionMode.RANDOM);
                Messaging.sendTr(sender, commands.getExecutionMode() == CommandTrait.ExecutionMode.RANDOM ? "citizens.commands.npc.commands.random-set" : "citizens.commands.npc.commands.random-unset", new Object[0]);
            } else if (action.equalsIgnoreCase("itemcost")) {
                if (!(sender instanceof Player)) {
                    throw new CommandException("citizens.commands.requirements.must-be-ingame");
                }
                if (args.argsLength() == 2) {
                    InventoryMenu.createSelfRegistered(new CommandTrait.ItemRequirementGUI(commands)).present((HumanEntity)((Player)sender));
                } else {
                    InventoryMenu.createSelfRegistered(new CommandTrait.ItemRequirementGUI(commands, args.getInteger(2))).present((HumanEntity)((Player)sender));
                }
            } else if (action.equalsIgnoreCase("errormessage")) {
                CommandTrait.CommandTraitError which = (CommandTrait.CommandTraitError)Util.matchEnum((Enum[])CommandTrait.CommandTraitError.values(), (String)args.getString(2));
                if (which == null) {
                    throw new CommandException("citizens.commands.npc.command.invalid-error-message", Util.listValuesPretty((Object[])CommandTrait.CommandTraitError.values()));
                }
                commands.setCustomErrorMessage(which, args.getString(3));
            } else {
                throw new CommandUsageException();
            }
        }
    }

    @Command(aliases={"npc"}, usage="configgui", desc="", modifiers={"configgui"}, min=1, max=1, permission="citizens.npc.configgui")
    public void configgui(CommandContext args, Player sender, NPC npc) {
        InventoryMenu.createSelfRegistered(new NPCConfigurator(npc)).present((HumanEntity)sender);
    }

    @Command(aliases={"npc"}, usage="controllable|control (-m(ount),-o(wner required)) (--controls [controls]) (--enabled [true|false])", desc="", modifiers={"controllable", "control"}, min=1, max=1, flags="mo")
    public void controllable(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"controls"}) Controllable.BuiltInControls controls, @Flag(value={"enabled"}) Boolean enabled) throws CommandException {
        if (npc.isSpawned() && !sender.hasPermission("citizens.npc.controllable." + npc.getEntity().getType().name().toLowerCase(Locale.ROOT)) || !sender.hasPermission("citizens.npc.controllable")) {
            throw new NoPermissionsException();
        }
        if (!npc.hasTrait(Controllable.class) && enabled == null) {
            npc.getOrAddTrait(Controllable.class).setEnabled(false);
        }
        Controllable trait = npc.getOrAddTrait(Controllable.class);
        if (controls != null) {
            trait.setControls(controls);
            Messaging.sendTr(sender, "citizens.commands.npc.controllable.controls-set", new Object[]{controls});
            return;
        }
        if (enabled != null) {
            trait.setEnabled(enabled);
        } else {
            enabled = trait.toggle();
        }
        trait.setOwnerRequired(args.hasFlag('o'));
        String key = enabled != false ? "citizens.commands.npc.controllable.set" : "citizens.commands.npc.controllable.removed";
        Messaging.sendTr(sender, key, npc.getName());
        if (trait.isEnabled() && args.hasFlag('m') && sender instanceof Player) {
            trait.mount((Player)sender);
        }
    }

    @Command(aliases={"npc"}, usage="copy (--name newname)", desc="", modifiers={"copy"}, min=1, max=1, permission="citizens.npc.copy")
    public void copy(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"name"}) String name) throws CommandException {
        NPC copy;
        if (name == null) {
            name = npc.getRawName();
        }
        if (!(copy = npc.clone()).getRawName().equals(name)) {
            copy.setName(name);
        }
        if (copy.getOrAddTrait(Spawned.class).shouldSpawn() && args.getSenderLocation() != null) {
            Location location = args.getSenderLocation();
            location.getChunk().load();
            copy.teleport(location, PlayerTeleportEvent.TeleportCause.COMMAND);
            copy.getOrAddTrait(CurrentLocation.class).setLocation(location);
        }
        CommandSenderCreateNPCEvent event = sender instanceof Player ? new PlayerCloneNPCEvent((Player)sender, npc, copy) : new CommandSenderCloneNPCEvent(sender, npc, copy);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            event.getNPC().destroy();
            String reason = "Couldn't create NPC";
            if (!event.getCancelReason().isEmpty()) {
                reason = reason + ": [[" + event.getCancelReason();
            }
            throw new CommandException(reason);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.copy.copied", npc.getName());
        this.selector.select(sender, copy);
        this.history.add(sender, new CreateNPCHistoryItem(copy));
    }

    @Command(aliases={"npc"}, usage="create [name] ((-b(aby),u(nspawned),s(ilent),t(emporary),c(enter),p(acket)) --at [x,y,z,world] --type [type] --item (item) --trait ['trait1, trait2...'] --model [model name] --nameplate [true|false|hover] --temporaryduration [duration] --registry [registry name]", desc="", flags="bustpc", modifiers={"create"}, min=2, permission="citizens.npc.create")
    @Requirements
    public void create(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"at"}) Location at, @Flag(value={"type"}, defValue="PLAYER") EntityType type, @Flag(value={"trait"}) String traits, @Flag(value={"nameplate"}, completions={"true", "false", "hover"}) String nameplate, @Flag(value={"temporaryduration"}) Duration temporaryDuration, @Flag(value={"item"}) String item, @Flag(value={"template"}, completionsProvider=TemplateCommands.TemplateCompletions.class) String templateName, @Flag(value={"registry"}) String registryName) throws CommandException {
        StringBuilder builder;
        Iterable parts;
        String name = args.getJoinedStrings(1).trim();
        if (args.hasValueFlag("type")) {
            if (type == null) {
                throw new CommandException(Messaging.tr("citizens.commands.npc.create.invalid-mobtype", args.getFlag("type")));
            }
            if (!EntityControllers.controllerExistsForType(type)) {
                throw new CommandException(Messaging.tr("citizens.commands.npc.create.mobtype-missing", args.getFlag("type")));
            }
        }
        int nameLength = SpigotUtil.getMaxNameLength(type);
        if (Placeholders.replace(Messaging.stripColor(name), sender, npc).length() > nameLength) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.create.npc-name-too-long", nameLength);
            name = name.substring(0, nameLength);
        }
        if (name.length() == 0) {
            throw new CommandException();
        }
        if (!(sender.hasPermission("citizens.npc.create.*") || sender.hasPermission("citizens.npc.createall") || sender.hasPermission("citizens.npc.create." + type.name().toLowerCase(Locale.ROOT)))) {
            throw new NoPermissionsException();
        }
        if (!(at == null && registryName == null && traits == null && templateName == null || sender.hasPermission("citizens.npc.admin"))) {
            throw new NoPermissionsException();
        }
        NPCRegistry registry = CitizensAPI.getNPCRegistry();
        if (registryName != null && (registry = CitizensAPI.getNamedNPCRegistry(registryName)) == null) {
            registry = CitizensAPI.createNamedNPCRegistry(registryName, new MemoryNPCDataStore());
            Messaging.send(sender, "An in-memory registry has been created named [[" + registryName + "]].");
        }
        if (args.hasFlag('t') || temporaryDuration != null) {
            registry = this.temporaryRegistry;
        }
        if (item != null) {
            ItemStack stack = SpigotUtil.parseItemStack(null, item);
            npc = registry.createNPCUsingItem(type, name, stack);
        } else {
            npc = registry.createNPC(type, name);
        }
        String msg = "Created [[" + npc.getName() + "]] (ID [[" + npc.getId() + "]])";
        if (args.hasFlag('b')) {
            msg = msg + " as a baby";
            npc.getOrAddTrait(Age.class).setAge(-24000);
        }
        if (args.hasFlag('s')) {
            npc.data().setPersistent(NPC.Metadata.SILENT, (Object)true);
        }
        if (nameplate != null) {
            npc.data().setPersistent(NPC.Metadata.NAMEPLATE_VISIBLE, nameplate.equalsIgnoreCase("hover") ? nameplate.toLowerCase() : Boolean.valueOf(Boolean.parseBoolean(nameplate)));
        }
        if (!Settings.Setting.SERVER_OWNS_NPCS.asBoolean()) {
            npc.getOrAddTrait(Owner.class).setOwner(sender);
        }
        if (temporaryDuration != null) {
            NPC temp = npc;
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                if (this.temporaryRegistry.getByUniqueId(temp.getUniqueId()) == temp) {
                    temp.destroy();
                }
            }, (long)SpigotUtil.toTicks(temporaryDuration));
        }
        npc.getOrAddTrait(MobType.class).setType(type);
        if (args.hasFlag('p')) {
            npc.addTrait(PacketNPC.class);
        }
        Location spawnLoc = args.getSenderLocation();
        CommandSenderCreateNPCEvent event = sender instanceof Player ? new PlayerCreateNPCEvent((Player)sender, npc) : new CommandSenderCreateNPCEvent(sender, npc);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            npc.destroy();
            String reason = "Couldn't create NPC.";
            if (!event.getCancelReason().isEmpty()) {
                reason = reason + " Reason: " + event.getCancelReason();
            }
            throw new CommandException(reason);
        }
        if (at != null) {
            spawnLoc = at;
            spawnLoc.getChunk().load();
        }
        if (args.hasFlag('c') && spawnLoc != null) {
            spawnLoc = Util.getCenterLocation(spawnLoc.getBlock());
        }
        if (traits != null) {
            parts = Splitter.on((char)',').trimResults().split((CharSequence)traits);
            builder = new StringBuilder();
            for (String tr : parts) {
                Object trait = CitizensAPI.getTraitFactory().getTrait(tr);
                if (trait == null) continue;
                npc.addTrait((Trait)trait);
                builder.append(StringHelper.wrap(tr) + ", ");
            }
            if (builder.length() > 0) {
                builder.delete(builder.length() - 2, builder.length());
            }
            msg = msg + " with traits " + builder.toString();
        }
        if (templateName != null) {
            parts = Splitter.on((char)',').trimResults().split((CharSequence)templateName);
            builder = new StringBuilder();
            for (String part : parts) {
                if (part.contains(":")) {
                    Template template = this.templateRegistry.getTemplateByKey(SpigotUtil.getKey(part));
                    if (template == null) continue;
                    template.apply(npc);
                    builder.append(StringHelper.wrap(part) + ", ");
                    continue;
                }
                Collection<Template> templates = this.templateRegistry.getTemplates(part);
                if (templates.size() != 1) continue;
                templates.iterator().next().apply(npc);
                builder.append(StringHelper.wrap(part) + ", ");
            }
            if (builder.length() > 0) {
                builder.delete(builder.length() - 2, builder.length());
            }
            msg = msg + " with templates " + builder.toString();
        }
        if (!args.hasFlag('u') && spawnLoc != null) {
            npc.spawn(spawnLoc, SpawnReason.CREATE);
        }
        this.selector.select(sender, npc);
        this.history.add(sender, new CreateNPCHistoryItem(npc));
        Messaging.send(sender, msg + '.');
    }

    @Command(aliases={"npc"}, usage="debug -p(aths) -n(avigation) -i(tem in hand)", desc="", modifiers={"debug"}, min=1, max=1, flags="pni", permission="citizens.npc.debug")
    @Requirements(ownership=true, selected=true)
    public void debug(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (args.hasFlag('p')) {
            npc.getNavigator().getDefaultParameters().debug(!npc.getNavigator().getDefaultParameters().debug());
            Messaging.send(sender, "Path debugging set to " + npc.getNavigator().getDefaultParameters().debug());
        } else if (args.hasFlag('n')) {
            String output = "Pathfinder type [[" + (Object)((Object)npc.getNavigator().getDefaultParameters().pathfinderType());
            output = output + "]] distance margin [[" + npc.getNavigator().getDefaultParameters().distanceMargin() + "]] (path margin [[" + npc.getNavigator().getDefaultParameters().pathDistanceMargin() + "]])<br>";
            output = output + "Teleport if below " + npc.getNavigator().getDefaultParameters().destinationTeleportMargin() + " blocks<br>";
            output = output + "Range [[" + npc.getNavigator().getDefaultParameters().range() + "]] speed [[" + npc.getNavigator().getDefaultParameters().speed() + "]]<br>";
            output = output + "Stuck action [[" + npc.getNavigator().getDefaultParameters().stuckAction() + "]]<br>";
            Messaging.send(sender, output);
        } else if (args.hasFlag('i')) {
            if (!(sender instanceof Player)) {
                throw new CommandException("citizens.commands.requirements.must-be-ingame");
            }
            Messaging.send(sender, NMS.getComponentMap(((Player)sender).getItemInHand()));
        }
    }

    @Command(aliases={"npc"}, usage="deselect", desc="", modifiers={"deselect", "desel"}, min=1, max=1, permission="citizens.npc.deselect")
    @Requirements
    public void deselect(CommandContext args, CommandSender sender, NPC npc) {
        this.selector.deselect(sender);
        Messaging.sendTr(sender, "citizens.commands.npc.deselect", new Object[0]);
    }

    @Command(aliases={"npc"}, usage="despawn (id)", desc="", modifiers={"despawn"}, min=1, max=2, permission="citizens.npc.despawn")
    @Requirements
    public void despawn(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        NPCCommandSelector.Callback callback = npc1 -> {
            if (npc1 == null) {
                throw new CommandException("citizens.commands.npc.spawn.missing-npc-id", args.getString(1));
            }
            npc1.getOrAddTrait(Spawned.class).setSpawned(false);
            npc1.despawn(DespawnReason.REMOVAL);
            Messaging.sendTr(sender, "citizens.commands.npc.despawn.despawned", npc1.getName());
        };
        if (npc == null || args.argsLength() == 2) {
            if (args.argsLength() < 2) {
                throw new CommandException("citizens.commands.requirements.must-have-selected");
            }
            NPCCommandSelector.startWithCallback(callback, CitizensAPI.getNPCRegistry(), sender, args, args.getString(1));
        } else {
            callback.run(npc);
        }
    }

    @Command(aliases={"npc"}, usage="drops", desc="", modifiers={"drops"}, min=1, max=1, permission="citizens.npc.drops")
    @Requirements(ownership=true, selected=true)
    public void drops(CommandContext args, Player sender, NPC npc) throws CommandException {
        DropsTrait trait = npc.getOrAddTrait(DropsTrait.class);
        trait.displayEditor(sender);
    }

    @Command(aliases={"npc"}, usage="endercrystal -b(ottom)", desc="", modifiers={"endercrystal"}, min=1, max=1, flags="b", permission="citizens.npc.endercrystal")
    @Requirements(ownership=true, selected=true)
    public void endercrystal(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (!npc.getOrAddTrait(MobType.class).getType().name().equals("END_CRYSTAL") && !npc.getOrAddTrait(MobType.class).getType().name().equals("ENDER_CRYSTAL")) {
            throw new CommandException();
        }
        if (args.hasFlag('b')) {
            EnderCrystalTrait trait = npc.getOrAddTrait(EnderCrystalTrait.class);
            boolean showing = !trait.isShowBase();
            trait.setShowBase(showing);
            Messaging.sendTr(sender, showing ? "citizens.commands.npc.endercrystal.showing-bottom" : "citizens.commands.npc.endercrystal.not-showing-bottom", npc.getName());
            return;
        }
        throw new CommandException();
    }

    @Command(aliases={"npc"}, usage="enderman -a(ngry)", desc="", flags="a", modifiers={"enderman"}, min=1, max=2, permission="citizens.npc.enderman")
    public void enderman(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (args.hasFlag('a')) {
            boolean angry = npc.getOrAddTrait(EndermanTrait.class).toggleAngry();
            Messaging.sendTr(sender, angry ? "citizens.commands.npc.enderman.angry-set" : "citizens.commands.npc.enderman.angry-unset", npc.getName());
        }
        throw new CommandUsageException();
    }

    @Command(aliases={"npc"}, usage="entitypose [pose]", desc="", modifiers={"entitypose"}, min=2, max=2, permission="citizens.npc.entitypose")
    public void entitypose(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) EntityPoseTrait.EntityPose pose) throws CommandException {
        if (pose == null) {
            throw new CommandUsageException();
        }
        npc.getOrAddTrait(EntityPoseTrait.class).setPose(pose);
        Messaging.sendTr(sender, "citizens.commands.npc.entitypose.set", new Object[]{pose});
    }

    @Command(aliases={"npc"}, usage="flyable (true|false)", desc="", modifiers={"flyable"}, min=1, max=2, permission="citizens.npc.flyable")
    public void flyable(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) Boolean explicit) throws CommandException {
        if (Util.isAlwaysFlyable(npc.getOrAddTrait(MobType.class).getType())) {
            throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.disallowed-mobtype", Util.prettyEnum(npc.getOrAddTrait(MobType.class).getType())));
        }
        boolean flyable = explicit != null ? explicit : !npc.isFlyable();
        npc.setFlyable(flyable);
        flyable = npc.isFlyable();
        Messaging.sendTr(sender, flyable ? "citizens.commands.npc.flyable.set" : "citizens.commands.npc.flyable.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="follow (player name|NPC id) (-p[rotect]) (--margin [margin]) (--enable [boolean])", desc="", flags="p", modifiers={"follow"}, min=1, max=2, permission="citizens.npc.follow")
    public void follow(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"margin"}) Double margin, @Flag(value={"enable"}) Boolean explicit) throws CommandException {
        OfflinePlayer player;
        boolean protect = args.hasFlag('p');
        FollowTrait trait = npc.getOrAddTrait(FollowTrait.class);
        if (margin != null) {
            trait.setFollowingMargin(margin);
            Messaging.sendTr(sender, "citizens.commands.npc.follow.margin-set", npc.getName(), margin);
            return;
        }
        trait.setProtect(protect);
        String name = sender.getName();
        if (args.argsLength() > 1) {
            name = args.getString(1);
        }
        if (!(player = Bukkit.getOfflinePlayer((String)name)).hasPlayedBefore() && !player.isOnline()) {
            NPCCommandSelector.Callback callback = followingNPC -> {
                if (followingNPC == null) {
                    throw new CommandException("citizens.commands.requirements.must-have-selected");
                }
                if (!(sender instanceof ConsoleCommandSender) && !followingNPC.getOrAddTrait(Owner.class).isOwnedBy(sender)) {
                    throw new CommandException("citizens.commands.requirements.must-be-owner");
                }
                boolean following = explicit == null ? !trait.isEnabled() : explicit;
                trait.follow(following ? followingNPC.getEntity() : null);
                Messaging.sendTr(sender, following ? "citizens.commands.npc.follow.set" : "citizens.commands.npc.follow.unset", npc.getName(), followingNPC.getName());
            };
            NPCCommandSelector.startWithCallback(callback, CitizensAPI.getNPCRegistry(), sender, args, args.getString(1));
            return;
        }
        boolean following = explicit == null ? !trait.isEnabled() : explicit;
        trait.follow((Entity)(following ? player.getPlayer() : null));
        Messaging.sendTr(sender, following ? "citizens.commands.npc.follow.set" : "citizens.commands.npc.follow.unset", npc.getName(), player.getName());
    }

    @Command(aliases={"npc"}, usage="forcefield --width [width] --height [height] --strength [strength] --vertical-strength [vertical strength]", desc="", modifiers={"forcefield"}, min=1, max=1, permission="citizens.npc.forcefield")
    public void forcefield(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"width"}) Double width, @Flag(value={"height"}) Double height, @Flag(value={"strength"}) Double strength, @Flag(value={"vertical-strength"}) Double verticalStrength) throws CommandException {
        ForcefieldTrait trait = npc.getOrAddTrait(ForcefieldTrait.class);
        String output = "";
        if (width != null) {
            trait.setWidth(width);
            output = output + Messaging.tr("citizens.commands.npc.forcefield.width-set", width);
        }
        if (height != null) {
            trait.setHeight(height);
            output = output + Messaging.tr("citizens.commands.npc.forcefield.height-set", height);
        }
        if (strength != null) {
            trait.setStrength(strength);
            output = output + Messaging.tr("citizens.commands.npc.forcefield.strength-set", strength);
        }
        if (verticalStrength != null) {
            trait.setVerticalStrength(verticalStrength);
            output = output + Messaging.tr("citizens.commands.npc.forcefield.vertical-strength-set", verticalStrength);
        }
        if (!output.isEmpty()) {
            Messaging.send(sender, output);
        } else {
            Messaging.sendTr(sender, "citizens.commands.npc.forcefield.describe", npc.getName(), trait.getHeight(), trait.getWidth(), trait.getStrength());
        }
    }

    @Command(aliases={"npc"}, usage="gamemode [gamemode]", desc="", modifiers={"gamemode"}, min=1, max=2, permission="citizens.npc.gamemode")
    @Requirements(selected=true, ownership=true, types={EntityType.PLAYER})
    public void gamemode(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) GameMode mode) {
        Player player = (Player)npc.getEntity();
        if (args.argsLength() == 1) {
            Messaging.sendTr(sender, "citizens.commands.npc.gamemode.describe", npc.getName(), Util.prettyEnum(player.getGameMode()));
            return;
        }
        if (mode == null) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.gamemode.invalid", args.getString(1));
            return;
        }
        npc.getOrAddTrait(GameModeTrait.class).setGameMode(mode);
        Messaging.sendTr(sender, "citizens.commands.npc.gamemode.set", Util.prettyEnum(mode));
    }

    @Command(aliases={"npc"}, usage="glowing --color [minecraft chat color]", desc="", modifiers={"glowing"}, min=1, max=1, permission="citizens.npc.glowing")
    public void glowing(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"color"}) ChatColor color) throws CommandException {
        if (color != null) {
            if (color.isFormat()) {
                throw new CommandException("citizens.commands.npc.glowing.color-cannot-be-format", color.name());
            }
            npc.getOrAddTrait(ScoreboardTrait.class).setColor(color);
            if (!npc.data().has(NPC.Metadata.GLOWING)) {
                npc.data().setPersistent(NPC.Metadata.GLOWING, (Object)true);
            }
            Messaging.sendTr(sender, "citizens.commands.npc.glowing.color-set", npc.getName(), color + Util.prettyEnum(color));
            return;
        }
        npc.data().setPersistent(NPC.Metadata.GLOWING, (Object)(npc.data().get(NPC.Metadata.GLOWING, Boolean.valueOf(false)) == false ? 1 : 0));
        boolean glowing = (Boolean)npc.data().get(NPC.Metadata.GLOWING);
        Messaging.sendTr(sender, glowing ? "citizens.commands.npc.glowing.set" : "citizens.commands.npc.glowing.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="gravity", desc="", modifiers={"gravity"}, min=1, max=1, permission="citizens.npc.gravity")
    public void gravity(CommandContext args, CommandSender sender, NPC npc) {
        boolean nogravity = npc.getOrAddTrait(Gravity.class).toggle();
        String key = !nogravity ? "citizens.commands.npc.gravity.enabled" : "citizens.commands.npc.gravity.disabled";
        Messaging.sendTr(sender, key, npc.getName());
    }

    @Command(aliases={"npc"}, usage="hitbox --scale [scale] --width/height [value] --offset [x,y,z]", desc="", modifiers={"hitbox"}, min=1, max=1, permission="citizens.npc.hitbox")
    public void hitbox(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"scale"}) Float scale, @Flag(value={"width"}) Float width, @Flag(value={"height"}) Float height, @Flag(value={"offset"}) org.bukkit.util.Vector offset) {
        if (scale != null) {
            npc.getOrAddTrait(BoundingBoxTrait.class).setScale(scale.floatValue());
        }
        if (width != null) {
            npc.getOrAddTrait(BoundingBoxTrait.class).setWidth(width.floatValue());
        }
        if (height != null) {
            npc.getOrAddTrait(BoundingBoxTrait.class).setHeight(height.floatValue());
        }
        if (offset != null) {
            npc.getOrAddTrait(BoundingBoxTrait.class).setOffset(offset);
        }
        EntityDim dim = npc.getOrAddTrait(BoundingBoxTrait.class).getAdjustedDimensions();
        Messaging.sendTr(sender, "citizens.commands.npc.hitbox.set", "width " + dim.width + " height " + dim.height);
    }

    @Command(aliases={"npc"}, usage="hologram add [text] (--duration [duration]) | insert [line #] [text] | set [line #] [text] | remove [line #] | edit_npc [template | name | line #] | clear | lineheight [height] | viewrange [range] | margintop [line #] [margin] | marginbottom [line #] [margin]", desc="", modifiers={"hologram"}, min=1, max=-1, permission="citizens.npc.hologram")
    public void hologram(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1, completions={"add", "insert", "set", "edit_npc", "remove", "clear", "lineheight", "viewrange", "margintop", "marginbottom"}) String action, @Arg(value=2, completionsProvider=HologramTrait.TabCompletions.class) String secondCompletion, @Flag(value={"duration"}) Duration duration) throws CommandException {
        HologramTrait trait = npc.getOrAddTrait(HologramTrait.class);
        if (args.argsLength() == 1) {
            String output = Messaging.tr("citizens.commands.npc.hologram.text-describe-header", npc.getName());
            List<String> lines = trait.getLines();
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                output = output + "<br>    [[" + i + "]] - " + line;
            }
            Messaging.send(sender, output);
            return;
        }
        if (action.equalsIgnoreCase("set")) {
            int idx;
            if (args.argsLength() == 2) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            int n = args.getString(2).equals("bottom") ? 0 : (idx = args.getString(2).equals("top") ? trait.getLines().size() - 1 : Math.max(0, args.getInteger(2)));
            if (idx >= trait.getLines().size()) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            if (args.argsLength() == 3) {
                throw new CommandException("citizens.commands.npc.hologram.text-missing");
            }
            trait.setLine(idx, args.getJoinedStrings(3));
            Messaging.sendTr(sender, "citizens.commands.npc.hologram.text-set", idx, args.getJoinedStrings(3));
        } else if (action.equalsIgnoreCase("edit_npc")) {
            HologramTrait.HologramRenderer hr = null;
            if (args.getString(2).equals("name")) {
                hr = trait.getNameRenderer();
            } else if (args.getString(2).equals("template")) {
                hr = trait.getTemplateRenderer();
            } else {
                int idx;
                int n = args.getString(2).equals("bottom") ? 0 : (idx = args.getString(2).equals("top") ? trait.getLines().size() - 1 : Math.max(0, args.getInteger(2)));
                if (idx >= trait.getLines().size()) {
                    throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
                }
                Iterator<HologramTrait.HologramRenderer> itr = trait.getHologramRenderers().iterator();
                for (int i = 0; i <= idx; ++i) {
                    hr = itr.next();
                }
            }
            if (hr != null && hr.getTemplateNPC() != null) {
                this.selector.select(sender, hr.getTemplateNPC());
                Messaging.sendTr(sender, "citizens.commands.npc.hologram.renderer-selected", new Object[0]);
            }
        } else if (action.equalsIgnoreCase("viewrange")) {
            if (args.argsLength() == 2) {
                throw new CommandUsageException();
            }
            trait.setViewRange(args.getInteger(2));
            Messaging.sendTr(sender, "citizens.commands.npc.hologram.view-range-set", npc.getName(), args.getInteger(2));
        } else if (action.equalsIgnoreCase("add")) {
            if (args.argsLength() == 2) {
                throw new CommandException("citizens.commands.npc.hologram.text-missing");
            }
            if (duration != null) {
                trait.addTemporaryLine(args.getJoinedStrings(2), SpigotUtil.toTicks(duration));
            } else {
                trait.addLine(args.getJoinedStrings(2));
            }
            Messaging.sendTr(sender, "citizens.commands.npc.hologram.line-add", args.getJoinedStrings(2));
        } else if (action.equalsIgnoreCase("insert")) {
            int idx;
            if (args.argsLength() == 2) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            if (args.argsLength() == 3) {
                throw new CommandException("citizens.commands.npc.hologram.text-missing");
            }
            int n = args.getString(2).equals("bottom") ? 0 : (idx = args.getString(2).equals("top") ? trait.getLines().size() - 1 : Math.max(0, args.getInteger(2)));
            if (idx > trait.getLines().size()) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            trait.insertLine(idx, args.getJoinedStrings(3));
            Messaging.sendTr(sender, "citizens.commands.npc.hologram.line-add", args.getJoinedStrings(3));
        } else if (action.equalsIgnoreCase("remove")) {
            int idx;
            if (args.argsLength() == 2) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            int n = args.getString(2).equals("bottom") ? 0 : (idx = args.getString(2).equals("top") ? trait.getLines().size() - 1 : Math.max(0, args.getInteger(2)));
            if (idx >= trait.getLines().size()) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            trait.removeLine(idx);
            Messaging.sendTr(sender, "citizens.commands.npc.hologram.line-removed", idx);
        } else if (action.equalsIgnoreCase("clear")) {
            trait.clear();
            Messaging.sendTr(sender, "citizens.commands.npc.hologram.cleared", new Object[0]);
        } else if (action.equalsIgnoreCase("lineheight")) {
            if (args.argsLength() == 2) {
                throw new CommandUsageException();
            }
            trait.setLineHeight(args.getDouble(2));
            Messaging.sendTr(sender, "citizens.commands.npc.hologram.line-height-set", args.getDouble(2));
        } else if (action.equalsIgnoreCase("margintop")) {
            int idx;
            if (args.argsLength() == 2) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            int n = args.getString(2).equals("bottom") ? 0 : (idx = args.getString(2).equals("top") ? trait.getLines().size() - 1 : Math.max(0, args.getInteger(2)));
            if (idx >= trait.getLines().size()) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            if (args.argsLength() == 3) {
                throw new CommandException("citizens.commands.npc.hologram.margin-missing");
            }
            trait.setMargin(idx, "top", args.getDouble(3));
            Messaging.sendTr(sender, "citizens.commands.npc.hologram.margin-set", idx, "top", args.getDouble(3));
        } else if (action.equalsIgnoreCase("marginbottom")) {
            int idx;
            if (args.argsLength() == 2) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            int n = args.getString(2).equals("bottom") ? 0 : (idx = args.getString(2).equals("top") ? trait.getLines().size() - 1 : Math.max(0, args.getInteger(2)));
            if (idx >= trait.getLines().size()) {
                throw new CommandException("citizens.commands.npc.hologram.invalid-text-id");
            }
            if (args.argsLength() == 3) {
                throw new CommandException("citizens.commands.npc.hologram.margin-missing");
            }
            trait.setMargin(idx, "bottom", args.getDouble(3));
            Messaging.sendTr(sender, "citizens.commands.npc.hologram.margin-set", idx, "bottom", args.getDouble(3));
        }
    }

    @Command(aliases={"npc"}, usage="home --location [loc] --delay [delay] --distance [distance] -h(ere) -p(athfind) -t(eleport)", desc="", modifiers={"home"}, min=1, max=1, flags="pth", permission="citizens.npc.home")
    @Requirements(ownership=true, selected=true)
    public void home(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"location"}) Location loc, @Flag(value={"delay"}) Duration delay, @Flag(value={"distance"}) Double distance) throws CommandException {
        HomeTrait trait = npc.getOrAddTrait(HomeTrait.class);
        String output = "";
        if (args.hasFlag('h')) {
            if (!(sender instanceof Player)) {
                throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.living-entity", new Object[0]));
            }
            trait.setHomeLocation(((Player)sender).getLocation());
            output = output + Messaging.tr("citizens.commands.npc.home.home-set", Util.prettyPrintLocation(trait.getHomeLocation()));
        }
        if (loc != null) {
            trait.setHomeLocation(loc);
            output = output + " " + Messaging.tr("citizens.commands.npc.home.home-set", Util.prettyPrintLocation(trait.getHomeLocation()));
        }
        if (distance != null) {
            trait.setDistanceBlocks(distance);
            output = output + " " + Messaging.tr("citizens.commands.npc.home.distance-set", trait.getDistanceBlocks());
        }
        if (args.hasFlag('p')) {
            trait.setReturnStrategy(HomeTrait.ReturnStrategy.PATHFIND);
            output = output + " " + Messaging.tr("citizens.commands.npc.home.pathfind-set", npc.getName());
        }
        if (args.hasFlag('t')) {
            trait.setReturnStrategy(HomeTrait.ReturnStrategy.TELEPORT);
            output = output + " " + Messaging.tr("citizens.commands.npc.home.teleport-set", npc.getName());
        }
        if (delay != null) {
            trait.setDelayTicks(SpigotUtil.toTicks(delay));
            output = output + " " + Messaging.tr("citizens.commands.npc.home.delay-set", SpigotUtil.toTicks(delay));
        }
        if (!output.isEmpty()) {
            Messaging.send(sender, output.trim());
        }
    }

    @Command(aliases={"npc"}, usage="horse|donkey|mule (--color color) (--type type) (--style style) (-cbt)", desc="", modifiers={"horse", "donkey", "mule"}, min=1, max=1, flags="cbt", permission="citizens.npc.horse")
    public void horse(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"color", "colour"}) Horse.Color color, @Flag(value={"style"}) Horse.Style style) throws CommandException {
        EntityType type = npc.getOrAddTrait(MobType.class).getType();
        if (!Util.isHorse(type)) {
            throw new CommandException("citizens.commands.requirements.disallowed-mobtype", Util.prettyEnum(type));
        }
        HorseModifiers horse = npc.getOrAddTrait(HorseModifiers.class);
        String output = "";
        if (args.hasFlag('c')) {
            horse.setCarryingChest(true);
            output = output + Messaging.tr("citizens.commands.npc.horse.chest-set", new Object[0]) + " ";
        } else if (args.hasFlag('b')) {
            horse.setCarryingChest(false);
            output = output + Messaging.tr("citizens.commands.npc.horse.chest-unset", new Object[0]) + " ";
        }
        if (args.hasFlag('t')) {
            horse.setTamed(!horse.isTamed());
            output = output + Messaging.tr(horse.isTamed() ? "citizens.commands.npc.horse.tamed-set" : "citizens.commands.npc.horse.tamed-unset", npc.getName()) + " ";
        }
        if (type == EntityType.HORSE && (args.hasValueFlag("color") || args.hasValueFlag("colour"))) {
            if (color == null) {
                String valid = Util.listValuesPretty(Horse.Color.values());
                throw new CommandException("citizens.commands.npc.horse.invalid-color", valid);
            }
            horse.setColor(color);
            output = output + Messaging.tr("citizens.commands.npc.horse.color-set", Util.prettyEnum(color));
        }
        if (type == EntityType.HORSE && args.hasValueFlag("style")) {
            if (style == null) {
                String valid = Util.listValuesPretty(Horse.Style.values());
                throw new CommandException("citizens.commands.npc.horse.invalid-style", valid);
            }
            horse.setStyle(style);
            output = output + Messaging.tr("citizens.commands.npc.horse.style-set", Util.prettyEnum(style));
        }
        if (output.isEmpty()) {
            Messaging.sendTr(sender, "citizens.commands.npc.horse.describe", Util.prettyEnum(horse.getColor()), Util.prettyEnum(type), Util.prettyEnum(horse.getStyle()));
        } else {
            Messaging.send(sender, output);
        }
    }

    @Command(aliases={"npc"}, usage="hurt [damage]", desc="", modifiers={"hurt"}, min=2, max=2, permission="citizens.npc.hurt")
    public void hurt(CommandContext args, CommandSender sender, NPC npc) {
        if (!(npc.getEntity() instanceof Damageable)) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.hurt.not-damageable", Util.prettyEnum(npc.getOrAddTrait(MobType.class).getType()));
            return;
        }
        if (npc.isProtected()) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.hurt.protected", new Object[0]);
            return;
        }
        ((Damageable)npc.getEntity()).damage((double)args.getInteger(1));
    }

    @Command(aliases={"npc"}, usage="id", desc="", modifiers={"id"}, min=1, max=1, permission="citizens.npc.id")
    public void id(CommandContext args, CommandSender sender, NPC npc) {
        sender.sendMessage(Integer.toString(npc.getId()));
    }

    @Command(aliases={"npc"}, usage="inventory (player name/uuid)", desc="", modifiers={"inventory"}, min=1, max=2, permission="citizens.npc.inventory")
    public void inventory(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) Player player) {
        if (player != null) {
            sender = player;
        }
        npc.getOrAddTrait(net.citizensnpcs.api.trait.trait.Inventory.class).openInventory((Player)sender);
    }

    private boolean isInDirectory(File file, File directory) {
        Path filePath = Paths.get(file.toURI()).toAbsolutePath().normalize();
        Path directoryPath = Paths.get(directory.toURI()).toAbsolutePath().normalize();
        return filePath.startsWith(directoryPath);
    }

    @Command(aliases={"npc"}, usage="item [item] (-h(and))", desc="", modifiers={"item"}, min=1, max=2, flags="h", permission="citizens.npc.item")
    public void item(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) ItemStack item) throws CommandException {
        ItemStack stack;
        EntityType type = npc.getOrAddTrait(MobType.class).getType();
        if (!(type.name().equals("OMINOUS_ITEM_SPAWNER") || type.name().contains("ITEM_FRAME") || type.name().contains("MINECART") || type.name().contains("ITEM_DISPLAY") || type.name().contains("BLOCK_DISPLAY") || type.name().equals("DROPPED_ITEM") || type.name().equals("ITEM") || type == EntityType.FALLING_BLOCK)) {
            throw new CommandException("citizens.commands.requirements.disallowed-mobtype", Util.prettyEnum(type));
        }
        ItemStack itemStack = stack = args.hasFlag('h') ? ((Player)sender).getItemInHand() : item;
        if (item == null && !args.hasFlag('h')) {
            throw new CommandException("citizens.commands.npc.item.unknown-material");
        }
        ItemStack fstack = stack;
        npc.setItemProvider(() -> fstack.clone());
        if (npc.isSpawned()) {
            npc.despawn(DespawnReason.PENDING_RESPAWN);
            npc.spawn(npc.getStoredLocation(), SpawnReason.RESPAWN);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.item.item-set", npc.getName(), Util.prettyEnum(stack.getType()));
    }

    @Command(aliases={"npc"}, usage="itemframe --visible [true|false] --fixed [true|false] --rotation [rotation] --item [item] --face [face]", desc="", modifiers={"itemframe"}, min=1, max=1, flags="", permission="citizens.npc.itemframe")
    @Requirements(ownership=true, selected=true, types={EntityType.ITEM_FRAME})
    public void itemframe(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"visible"}) Boolean visible, @Flag(value={"fixed"}) Boolean fixed, @Flag(value={"rotation"}) Rotation rotation, @Flag(value={"item"}) ItemStack item, @Flag(value={"face"}) BlockFace face) throws CommandException {
        ItemFrameTrait ift = npc.getOrAddTrait(ItemFrameTrait.class);
        String msg = "";
        if (visible != null) {
            ift.setVisible(visible);
            msg = msg + " " + Messaging.tr("citizens.commands.npc.itemframe.visible-set", visible);
        }
        if (fixed != null) {
            ift.setFixed(fixed);
            msg = msg + " " + Messaging.tr("citizens.commands.npc.itemframe.fixed-set", fixed);
        }
        if (item != null) {
            ift.setItem(item);
            msg = msg + " " + Messaging.tr("citizens.commands.npc.itemframe.item-set", item);
        }
        if (face != null) {
            ift.setFacing(face);
            msg = msg + " " + Messaging.tr("citizens.commands.npc.itemframe.blockface-set", face);
        }
        if (rotation != null) {
            ift.setRotation(rotation);
            msg = msg + " " + Messaging.tr("citizens.commands.npc.itemframe.rotation-set", rotation);
        }
        if (msg.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(sender, msg.trim());
    }

    @Command(aliases={"npc"}, usage="jump", desc="", modifiers={"jump"}, min=1, max=1, permission="citizens.npc.jump")
    public void jump(CommandContext args, CommandSender sender, NPC npc) {
        NMS.setShouldJump(npc.getEntity());
    }

    @Command(aliases={"npc"}, usage="knockback (--explicit true|false)", desc="", modifiers={"knockback"}, min=1, max=1, permission="citizens.npc.knockback")
    public void knockback(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"explicit"}) Boolean explicit) {
        boolean kb;
        boolean bl = kb = npc.data().get(NPC.Metadata.KNOCKBACK, Boolean.valueOf(true)) == false;
        if (explicit != null) {
            kb = explicit;
        }
        npc.data().set(NPC.Metadata.KNOCKBACK, (Object)kb);
        Messaging.sendTr(sender, kb ? "citizens.commands.npc.knockback.set" : "citizens.commands.npc.knockback.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="leashable", desc="", modifiers={"leashable"}, min=1, max=1, flags="t", permission="citizens.npc.leashable")
    @Requirements(selected=true, ownership=true, excludedTypes={EntityType.PLAYER})
    public void leashable(CommandContext args, CommandSender sender, NPC npc) {
        boolean vulnerable;
        boolean bl = vulnerable = npc.data().get(NPC.Metadata.LEASH_PROTECTED, Boolean.valueOf(true)) == false;
        if (args.hasFlag('t')) {
            npc.data().set(NPC.Metadata.LEASH_PROTECTED, (Object)vulnerable);
        } else {
            npc.data().setPersistent(NPC.Metadata.LEASH_PROTECTED, (Object)vulnerable);
        }
        String key = vulnerable ? "citizens.commands.npc.leashable.stopped" : "citizens.commands.npc.leashable.set";
        Messaging.sendTr(sender, key, npc.getName());
    }

    @Command(aliases={"npc"}, usage="list (page) ((-a) --owner (owner) --type (type) --char (char) --registry (name))", desc="", flags="a", modifiers={"list"}, min=1, max=2, permission="citizens.npc.list")
    @Requirements
    public void list(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"owner"}) String owner, @Flag(value={"type"}) EntityType type, @Flag(value={"page"}) Integer page, @Flag(value={"registry"}) String registry) throws CommandException {
        int op;
        NPCRegistry source;
        NPCRegistry nPCRegistry = source = registry != null ? CitizensAPI.getNamedNPCRegistry(registry) : CitizensAPI.getNPCRegistry();
        if (source == null) {
            throw new CommandException();
        }
        ArrayList<NPC> npcs = new ArrayList<NPC>();
        if (args.hasFlag('a')) {
            for (NPC add : source.sorted()) {
                npcs.add(add);
            }
        } else if (owner != null) {
            for (NPC add : source.sorted()) {
                if (npcs.contains(add) || !add.getOrAddTrait(Owner.class).isOwnedBy(owner)) continue;
                npcs.add(add);
            }
        } else if (sender instanceof Player) {
            for (NPC add : source.sorted()) {
                if (npcs.contains(add) || !add.getOrAddTrait(Owner.class).isOwnedBy(sender)) continue;
                npcs.add(add);
            }
        }
        if (args.hasValueFlag("type")) {
            if (type == null) {
                throw new CommandException("citizens.commands.invalid-mobtype", type);
            }
            Iterator iterator = npcs.iterator();
            while (iterator.hasNext()) {
                if (((NPC)iterator.next()).getOrAddTrait(MobType.class).getType() == type) continue;
                iterator.remove();
            }
        }
        Paginator paginator = new Paginator().header("NPCs").console(sender instanceof ConsoleCommandSender).enablePageSwitcher('/' + args.getRawCommand() + " --page $page");
        for (int i = 0; i < npcs.size(); ++i) {
            String id = ((NPC)npcs.get(i)).getUniqueId().toString();
            String line = StringHelper.wrap(((NPC)npcs.get(i)).getId()) + " " + ((NPC)npcs.get(i)).getName() + " (<click:run_command:/npc tp --uuid " + id + "><hover:show_text:Teleport to this NPC>[[tp]]</hover></click>) (<click:run_command:/npc tph --uuid " + id + "><hover:show_text:Teleport NPC to me>[[summon]]</hover></click>) (<click:run_command:/npc remove " + id + "><hover:show_text:Remove this NPC><red>-</red></hover></click>)";
            paginator.addLine(line);
        }
        int n = op = page == null ? args.getInteger(1, 1) : page.intValue();
        if (!paginator.sendPage(sender, op)) {
            throw new CommandException("citizens.commands.page-missing", op);
        }
    }

    @Command(aliases={"npc"}, usage="lookclose --range [range] -r[ealistic looking] --randomlook [true|false] --perplayer [true|false] --randomswitchtargets [true|false] --randompitchrange [min,max] --randomyawrange [min,max] --disablewhennavigating [true|false] --targetnpcs [true|false]", desc="", modifiers={"lookclose", "look"}, min=1, max=1, flags="r", permission="citizens.npc.lookclose")
    public void lookClose(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"randomlook", "rlook"}) Boolean randomlook, @Flag(value={"range"}) Double range, @Flag(value={"randomlookdelay"}) Duration randomLookDelay, @Flag(value={"randomyawrange"}) String randomYaw, @Flag(value={"randompitchrange"}) String randomPitch, @Flag(value={"randomswitchtargets"}) Boolean randomSwitchTargets, @Flag(value={"headonly"}) Boolean headonly, @Flag(value={"linkedbody"}) Boolean linkedbody, @Flag(value={"disablewhennavigating"}) Boolean disableWhenNavigating, @Flag(value={"perplayer"}) Boolean perPlayer, @Flag(value={"targetnpcs"}) Boolean targetNPCs) throws CommandException {
        float max;
        float min;
        String[] parts;
        boolean toggle = true;
        LookClose trait = npc.getOrAddTrait(LookClose.class);
        if (randomlook != null) {
            trait.setRandomLook(randomlook);
            Messaging.sendTr(sender, randomlook != false ? "citizens.commands.npc.lookclose.random-set" : "citizens.commands.npc.lookclose.random-stopped", npc.getName());
            toggle = false;
        }
        if (perPlayer != null) {
            if (((Citizens)CitizensAPI.getPlugin()).getPacketEventsListener() == null) {
                throw new CommandException("PacketEvents must be enabled to use this feature");
            }
            trait.setPerPlayer(perPlayer);
            Messaging.sendTr(sender, perPlayer != false ? "citizens.commands.npc.lookclose.perplayer-set" : "citizens.commands.npc.lookclose.perplayer-unset", npc.getName());
            toggle = false;
        }
        if (headonly != null) {
            trait.setHeadOnly(headonly);
            Messaging.sendTr(sender, headonly != false ? "citizens.commands.npc.lookclose.headonly-set" : "citizens.commands.npc.lookclose.headonly-unset", npc.getName());
            toggle = false;
        }
        if (linkedbody != null) {
            trait.setLinkedBody(linkedbody);
            Messaging.sendTr(sender, linkedbody != false ? "citizens.commands.npc.lookclose.linkedbody-set" : "citizens.commands.npc.lookclose.linkedbody-unset", npc.getName());
            toggle = false;
        }
        if (randomSwitchTargets != null) {
            trait.setRandomlySwitchTargets(randomSwitchTargets);
            Messaging.sendTr(sender, randomSwitchTargets != false ? "citizens.commands.npc.lookclose.random-target-switch-enabled" : "citizens.commands.npc.lookclose.random-target-switch-disabled", npc.getName());
            toggle = false;
        }
        if (targetNPCs != null) {
            trait.setTargetNPCs(targetNPCs);
            Messaging.sendTr(sender, targetNPCs != false ? "citizens.commands.npc.lookclose.target-npcs-set" : "citizens.commands.npc.lookclose.target-npcs-unset", npc.getName());
            toggle = false;
        }
        if (disableWhenNavigating != null) {
            trait.setDisableWhileNavigating(disableWhenNavigating);
            Messaging.sendTr(sender, disableWhenNavigating != false ? "citizens.commands.npc.lookclose.disable-when-navigating" : "citizens.commands.npc.lookclose.enable-when-navigating", npc.getName());
            toggle = false;
        }
        if (range != null) {
            trait.setRange(range);
            Messaging.sendTr(sender, "citizens.commands.npc.lookclose.range-set", npc.getName(), range);
            toggle = false;
        }
        if (args.hasFlag('r')) {
            trait.setRealisticLooking(!trait.useRealisticLooking());
            Messaging.sendTr(sender, trait.useRealisticLooking() ? "citizens.commands.npc.lookclose.rl-set" : "citizens.commands.npc.lookclose.rl-unset", npc.getName());
            toggle = false;
        }
        if (randomLookDelay != null) {
            trait.setRandomLookDelay(Math.max(1, SpigotUtil.toTicks(randomLookDelay)));
            Messaging.sendTr(sender, "citizens.commands.npc.lookclose.random-look-delay-set", npc.getName(), SpigotUtil.toTicks(randomLookDelay));
            toggle = false;
        }
        if (randomPitch != null) {
            try {
                parts = randomPitch.split(",");
                min = Float.parseFloat(parts[0]);
                max = Float.parseFloat(parts[1]);
                if (min > max) {
                    throw new IllegalArgumentException();
                }
                trait.setRandomLookPitchRange(min, max);
            }
            catch (Exception e) {
                throw new CommandException(Messaging.tr("citizens.commands.npc.lookclose.error-random-range", randomPitch));
            }
            Messaging.sendTr(sender, "citizens.commands.npc.lookclose.random-pitch-range-set", npc.getName(), randomPitch);
            toggle = false;
        }
        if (randomYaw != null) {
            try {
                parts = randomYaw.split(",");
                min = Float.parseFloat(parts[0]);
                max = Float.parseFloat(parts[1]);
                if (min > max) {
                    throw new IllegalArgumentException();
                }
                trait.setRandomLookYawRange(min, max);
            }
            catch (Exception e) {
                throw new CommandException(Messaging.tr("citizens.commands.npc.lookclose.error-random-range", randomYaw));
            }
            Messaging.sendTr(sender, "citizens.commands.npc.lookclose.random-yaw-range-set", npc.getName(), randomYaw);
            toggle = false;
        }
        if (toggle) {
            Messaging.sendTr(sender, trait.toggle() ? "citizens.commands.npc.lookclose.set" : "citizens.commands.npc.lookclose.stopped", npc.getName());
        }
    }

    @Command(aliases={"npc"}, usage="metadata set|get|remove [key] (value) (-t(emporary))", desc="", modifiers={"metadata"}, flags="t", min=3, max=4, permission="citizens.npc.metadata")
    public void metadata(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1, completions={"set", "get", "remove"}) String command, @Arg(value=2) NPC.Metadata enumKey) throws CommandException {
        String key = args.getString(2);
        if (command.equals("set")) {
            if (args.argsLength() != 4) {
                throw new CommandException();
            }
            Object metadata = args.getString(3);
            if (metadata.equals("false") || metadata.equals("true")) {
                metadata = Boolean.parseBoolean(args.getString(3));
            }
            try {
                metadata = Integer.parseInt(args.getString(3));
            }
            catch (NumberFormatException nfe) {
                try {
                    metadata = Double.parseDouble(args.getString(3));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (args.hasFlag('t')) {
                if (enumKey != null) {
                    npc.data().set(enumKey, metadata);
                } else {
                    npc.data().set(key, metadata);
                }
            } else if (enumKey != null) {
                npc.data().setPersistent(enumKey, metadata);
            } else {
                npc.data().setPersistent(key, metadata);
            }
            Messaging.sendTr(sender, "citizens.commands.npc.metadata.set", enumKey != null ? enumKey : key, args.getString(3));
        } else if (command.equals("get")) {
            Object data;
            if (args.argsLength() != 3) {
                throw new CommandException();
            }
            Object object = data = enumKey != null ? npc.data().get(enumKey) : npc.data().get(key);
            if (data == null) {
                data = "null";
            }
            sender.sendMessage(data.toString());
        } else if (command.equals("remove")) {
            if (args.argsLength() != 3) {
                throw new CommandException();
            }
            if (enumKey != null) {
                npc.data().remove(enumKey);
            } else {
                npc.data().remove(key);
            }
            Messaging.sendTr(sender, "citizens.commands.npc.metadata.unset", enumKey != null ? enumKey : key, npc.getName());
        } else {
            throw new CommandUsageException();
        }
    }

    @Command(aliases={"npc"}, usage="minecart (--offset offset)", desc="", modifiers={"minecart"}, min=1, max=1, flags="", permission="citizens.npc.minecart")
    public void minecart(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"item"}) String item) throws CommandException {
        if (!npc.getOrAddTrait(MobType.class).getType().name().contains("MINECRAFT")) {
            throw new CommandUsageException();
        }
        if (args.hasValueFlag("offset")) {
            npc.data().setPersistent(NPC.Metadata.MINECART_OFFSET, (Object)args.getFlagInteger("offset"));
        }
        Messaging.sendTr(sender, "citizens.commands.npc.minecart.set", npc.getName(), npc.data().get(NPC.Metadata.MINECART_OFFSET, Integer.valueOf(0)));
    }

    @Command(aliases={"npc"}, modifiers={"mirror"}, usage="mirror --name [true|false] --equipment [true|false]", desc="", min=1, max=1, permission="citizens.npc.mirror")
    public void mirror(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"name"}) Boolean name, @Flag(value={"equipment"}) Boolean equipment) throws CommandException {
        if (((Citizens)CitizensAPI.getPlugin()).getPacketEventsListener() == null) {
            throw new CommandException("PacketEvents must be enabled to use this feature");
        }
        MirrorTrait trait = npc.getOrAddTrait(MirrorTrait.class);
        if (equipment != null) {
            trait.setMirrorEquipment(equipment);
        }
        if (name != null) {
            trait.setEnabled(true);
            trait.setMirrorName(name);
            Messaging.sendTr(sender, name != false ? "citizens.commands.npc.mirror.namemirror-set" : "citizens.commands.npc.mirror.namemirror-unset", npc.getName());
        } else {
            boolean enabled = !trait.isEnabled();
            trait.setEnabled(enabled);
            Messaging.sendTr(sender, enabled ? "citizens.commands.npc.mirror.set" : "citizens.commands.npc.mirror.unset", npc.getName());
        }
    }

    @Command(aliases={"npc"}, usage="mount (--onnpc <npc id|uuid>) (-d(ismount)) (-c(ancel))", desc="", modifiers={"mount"}, min=1, max=1, flags="cd", permission="citizens.npc.mount")
    public void mount(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"onnpc"}) String onnpc) throws CommandException {
        boolean enabled;
        if (args.hasFlag('d')) {
            if (sender instanceof Player) {
                ((Player)sender).leaveVehicle();
            }
            return;
        }
        if (onnpc != null) {
            NPC mount;
            try {
                UUID uuid = UUID.fromString(onnpc);
                mount = CitizensAPI.getNPCRegistry().getByUniqueId(uuid);
            }
            catch (IllegalArgumentException ex) {
                mount = CitizensAPI.getNPCRegistry().getById(args.getFlagInteger("onnpc"));
            }
            if (mount == null || !mount.isSpawned()) {
                throw new CommandException(Messaging.tr("citizens.commands.npc.mount.must-be-spawned", onnpc));
            }
            if (mount.equals(npc)) {
                throw new CommandException("citizens.commands.npc.mount.mount-on-itself");
            }
            npc.getOrAddTrait(MountTrait.class).setMountedOn(mount.getUniqueId());
            return;
        }
        if (args.hasFlag('c')) {
            npc.getOrAddTrait(MountTrait.class).unmount();
            return;
        }
        boolean bl = enabled = npc.hasTrait(Controllable.class) && npc.getOrAddTrait(Controllable.class).isEnabled();
        if (!enabled) {
            Messaging.sendTr(sender, "citizens.commands.npc.controllable.not-controllable", npc.getName());
            return;
        }
        if (!(sender instanceof Player)) {
            throw new CommandException("citizens.commands.requirements.must-be-ingame");
        }
        Player player = (Player)sender;
        boolean success = npc.getOrAddTrait(Controllable.class).mount(player);
        if (!success) {
            Messaging.sendTr((CommandSender)player, "citizens.commands.npc.mount.failed", npc.getName());
        }
    }

    @Command(aliases={"npc"}, usage="moveto x:y:z:world | x y z world", desc="", modifiers={"moveto"}, min=1, valueFlags={"x", "y", "z", "yaw", "pitch", "world"}, permission="citizens.npc.moveto")
    public void moveto(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Location to;
        if (!npc.isSpawned()) {
            npc.spawn(npc.getOrAddTrait(CurrentLocation.class).getLocation(), SpawnReason.COMMAND);
            if (!npc.isSpawned()) {
                throw new CommandException("NPC could not be spawned.");
            }
        }
        Location current = npc.getEntity().getLocation();
        if (args.argsLength() > 1) {
            World world;
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)':').split((CharSequence)args.getJoinedStrings(1, ':')), String.class);
            if (parts.length != 4 && parts.length != 3) {
                throw new CommandException("citizens.commands.npc.moveto.format");
            }
            double x = Double.parseDouble(parts[0]);
            double y = Double.parseDouble(parts[1]);
            double z = Double.parseDouble(parts[2]);
            World world2 = world = parts.length == 4 ? Bukkit.getWorld((String)parts[3]) : current.getWorld();
            if (world == null) {
                throw new CommandException("citizens.commands.errors.missing-world");
            }
            to = new Location(world, x, y, z, current.getYaw(), current.getPitch());
        } else {
            to = current.clone();
            if (args.hasValueFlag("x")) {
                to.setX(args.getFlagDouble("x"));
            }
            if (args.hasValueFlag("y")) {
                to.setY(args.getFlagDouble("y"));
            }
            if (args.hasValueFlag("z")) {
                to.setZ(args.getFlagDouble("z"));
            }
            if (args.hasValueFlag("yaw")) {
                to.setYaw((float)args.getFlagDouble("yaw"));
            }
            if (args.hasValueFlag("pitch")) {
                to.setPitch((float)args.getFlagDouble("pitch"));
            }
            if (args.hasValueFlag("world")) {
                World world = Bukkit.getWorld((String)args.getFlag("world"));
                if (world == null) {
                    throw new CommandException("citizens.commands.errors.missing-world");
                }
                to.setWorld(world);
            }
        }
        npc.teleport(to, PlayerTeleportEvent.TeleportCause.COMMAND);
        NMS.look(npc.getEntity(), to.getYaw(), to.getPitch());
        Messaging.sendTr(sender, "citizens.commands.npc.moveto.teleported", npc.getName(), Util.prettyPrintLocation(to));
    }

    @Command(aliases={"npc"}, modifiers={"name", "hidename"}, usage="name (-h(over))", desc="", min=1, max=1, flags="h", permission="citizens.npc.name")
    public void name(CommandContext args, CommandSender sender, NPC npc) {
        String old = ((Object)npc.data().get(NPC.Metadata.NAMEPLATE_VISIBLE, Boolean.valueOf(true))).toString();
        old = args.hasFlag('h') ? "hover" : (old.equals("hover") ? "true" : "" + !Boolean.parseBoolean(old));
        npc.data().setPersistent(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)old);
        npc.scheduleUpdate(NPC.NPCUpdate.PACKET);
        Messaging.sendTr(sender, "citizens.commands.npc.nameplate.set", old);
    }

    @Command(aliases={"npc"}, desc="", max=0, permission="citizens.npc.info")
    public void npc(CommandContext args, CommandSender sender, NPC npc) {
        Messaging.send(sender, StringHelper.wrapHeader(npc.getName()));
        Messaging.send(sender, "    ID: [[" + npc.getId());
        EntityType type = npc.getOrAddTrait(MobType.class).getType();
        Messaging.send(sender, "    UUID: [[" + npc.getUniqueId());
        Messaging.send(sender, "    Type: [[" + type);
        if (npc.isSpawned()) {
            Location loc = npc.getEntity().getLocation();
            String format = "    Spawned at [[%d, %d, %d, %.2f, %.2f (head %.2f)]] [[%s";
            Messaging.send(sender, String.format(format, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), Float.valueOf(NMS.getYaw(npc.getEntity())), Float.valueOf(loc.getPitch()), Float.valueOf(NMS.getHeadYaw(npc.getEntity())), loc.getWorld().getName()));
        }
        Messaging.send(sender, "    Traits");
        for (Trait trait : npc.getTraits()) {
            String message = "     - [[" + trait.getName();
            Messaging.send(sender, message);
        }
    }

    @Command(aliases={"npc"}, usage="ocelot (--type type) (-s(itting), -n(ot sitting))", desc="", modifiers={"ocelot"}, min=1, max=1, requiresFlags=true, flags="sn", permission="citizens.npc.ocelot")
    @Requirements(selected=true, ownership=true, types={EntityType.OCELOT})
    public void ocelot(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"type"}) Ocelot.Type type) throws CommandException {
        OcelotModifiers trait = npc.getOrAddTrait(OcelotModifiers.class);
        if (args.hasFlag('s')) {
            trait.setSitting(true);
        } else if (args.hasFlag('n')) {
            trait.setSitting(false);
        }
        if (args.hasValueFlag("type")) {
            if (type == null) {
                String valid = Util.listValuesPretty(Ocelot.Type.values());
                throw new CommandException("citizens.commands.npc.ocelot.invalid-type", valid);
            }
            trait.setType(type);
            if (!trait.supportsOcelotType()) {
                Messaging.sendErrorTr(sender, "citizens.commands.npc.ocelot.deprecated", new Object[0]);
            }
        }
    }

    @Command(aliases={"npc"}, usage="owner [uuid|SERVER]", desc="", modifiers={"owner"}, min=1, max=2, permission="citizens.npc.owner")
    public void owner(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        OfflinePlayer p;
        Owner ownerTrait = npc.getOrAddTrait(Owner.class);
        if (args.argsLength() == 1) {
            Messaging.sendTr(sender, "citizens.commands.npc.owner.owner", npc.getName(), ownerTrait.getOwner());
            return;
        }
        UUID uuid = args.getString(1).equalsIgnoreCase("SERVER") ? null : ((p = Bukkit.getOfflinePlayer((String)args.getString(1))).hasPlayedBefore() || p.isOnline() ? p.getUniqueId() : UUID.fromString(args.getString(1)));
        if (ownerTrait.isOwnedBy(uuid)) {
            throw new CommandException("citizens.commands.npc.owner.already-owner", uuid, npc.getName());
        }
        ownerTrait.setOwner(uuid);
        boolean serverOwner = uuid == null;
        Messaging.sendTr(sender, serverOwner ? "citizens.commands.npc.owner.set-server" : "citizens.commands.npc.owner.set", npc.getName(), uuid);
    }

    @Command(aliases={"npc"}, usage="packet --enabled [true|false]", desc="", modifiers={"packet"}, min=1, max=1, permission="citizens.npc.packet")
    public void packet(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"enabled"}) Boolean explicit) throws CommandException {
        if (explicit == null) {
            explicit = !npc.hasTrait(PacketNPC.class);
        }
        if (explicit.booleanValue()) {
            npc.getOrAddTrait(PacketNPC.class);
            Messaging.sendTr(sender, "citizens.commands.npc.packet.enabled", npc.getName());
        } else {
            npc.removeTrait(PacketNPC.class);
            Messaging.sendTr(sender, "citizens.commands.npc.packet.disabled", npc.getName());
        }
    }

    @Command(aliases={"npc"}, usage="painting (--art art)", desc="", modifiers={"painting"}, min=1, max=1, permission="citizens.npc.painting")
    @Requirements(selected=true, ownership=true, types={EntityType.PAINTING})
    public void painting(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"art"}) Art art) throws CommandException {
        PaintingTrait trait = npc.getOrAddTrait(PaintingTrait.class);
        if (art != null) {
            trait.setArt(art);
            Messaging.sendTr(sender, "citizens.commands.npc.painting.art-set", npc.getName(), art);
            return;
        }
        throw new CommandUsageException();
    }

    @Command(aliases={"npc"}, usage="passive (--set [true|false])", desc="", modifiers={"passive"}, min=1, max=1, permission="citizens.npc.passive")
    public void passive(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"set"}) Boolean set) throws CommandException {
        boolean damageOthers = set != null ? set : npc.data().get(NPC.Metadata.DAMAGE_OTHERS, Boolean.valueOf(true)) == false;
        npc.data().setPersistent(NPC.Metadata.DAMAGE_OTHERS, (Object)damageOthers);
        Messaging.sendTr(sender, damageOthers ? "citizens.commands.npc.passive.unset" : "citizens.commands.npc.passive.set", npc.getName());
    }

    @Command(aliases={"npc"}, usage="pathopt --avoid-water|aw [true|false] --attack-delay-duration [duration] --open-doors [true|false] --path-range [range] --stationary-ticks [ticks] --attack-range [range] --distance-margin [margin] --path-distance-margin [margin] --pathfinder-type [CITIZENS|MINECRAFT] --falling-distance [distance]", desc="", modifiers={"pathopt", "po", "patho"}, min=1, max=1, permission="citizens.npc.pathfindingoptions")
    public void pathfindingOptions(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"path-range"}) Float range, @Flag(value={"avoid-water"}) Boolean avoidwater, @Flag(value={"open-doors"}) Boolean opendoors, @Flag(value={"stationary-ticks"}) Integer stationaryTicks, @Flag(value={"distance-margin"}) Double distanceMargin, @Flag(value={"attack-delay-duration"}) Duration duration, @Flag(value={"path-distance-margin"}) Double pathDistanceMargin, @Flag(value={"attack-range"}) Double attackRange, @Flag(value={"falling-distance"}) Integer fallingDistance, @Flag(value={"pathfinder-type"}) PathfinderType pathfinderType) throws CommandException {
        String output = "";
        if (avoidwater != null) {
            npc.getNavigator().getDefaultParameters().avoidWater(avoidwater);
            output = output + Messaging.tr(avoidwater != false ? "citizens.commands.npc.pathopt.avoid-water-set" : "citizens.commands.npc.pathopt.avoid-water-unset", npc.getName());
        }
        if (duration != null) {
            npc.getNavigator().getDefaultParameters().attackDelayTicks(SpigotUtil.toTicks(duration));
            output = output + Messaging.tr("citizens.commands.npc.pathopt.attack-delay-set", npc.getName(), SpigotUtil.toTicks(duration));
        }
        if (opendoors != null) {
            npc.data().setPersistent(NPC.Metadata.PATHFINDER_OPEN_DOORS, (Object)opendoors);
            output = output + Messaging.tr(opendoors != false ? "citizens.commands.npc.pathopt.open-doors-set" : "citizens.commands.npc.pathopt.avoid-water-set", npc.getName());
        }
        if (stationaryTicks != null) {
            if (stationaryTicks < 0) {
                throw new CommandUsageException();
            }
            npc.getNavigator().getDefaultParameters().stationaryTicks(stationaryTicks);
            output = output + " " + Messaging.tr("citizens.commands.npc.pathopt.stationary-ticks-set", npc.getName(), stationaryTicks);
        }
        if (distanceMargin != null) {
            if (distanceMargin < 0.0) {
                throw new CommandUsageException();
            }
            npc.getNavigator().getDefaultParameters().distanceMargin(distanceMargin);
            output = output + " " + Messaging.tr("citizens.commands.npc.pathopt.distance-margin-set", npc.getName(), distanceMargin);
        }
        if (range != null) {
            if (range.floatValue() < 1.0f) {
                throw new CommandUsageException();
            }
            npc.getNavigator().getDefaultParameters().range(range.floatValue());
            output = output + " " + Messaging.tr("citizens.commands.npc.pathfindingrange.set", range);
        }
        if (pathDistanceMargin != null) {
            if (pathDistanceMargin < 0.0) {
                throw new CommandUsageException();
            }
            npc.getNavigator().getDefaultParameters().pathDistanceMargin(pathDistanceMargin);
            output = output + " " + Messaging.tr("citizens.commands.npc.pathopt.path-distance-margin-set", npc.getName(), pathDistanceMargin);
        }
        if (attackRange != null) {
            if (attackRange < 0.0) {
                throw new CommandUsageException();
            }
            npc.getNavigator().getDefaultParameters().attackRange(attackRange);
            output = output + " " + Messaging.tr("citizens.commands.npc.pathopt.attack-range-set", npc.getName(), attackRange);
        }
        if (pathfinderType != null) {
            npc.getNavigator().getDefaultParameters().pathfinderType(pathfinderType);
            output = output + " " + Messaging.tr("citizens.commands.npc.pathopt.pathfinder-type-set", new Object[]{npc.getName(), pathfinderType});
        }
        if (fallingDistance != null) {
            npc.getNavigator().getDefaultParameters().fallDistance(fallingDistance);
            output = output + " " + Messaging.tr("citizens.commands.npc.pathopt.falling-distance-set", npc.getName(), fallingDistance);
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(sender, output.trim());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Command(aliases={"npc"}, usage="pathto me | here | cursor | [x] [y] [z] (--margin [distance margin]) (-s[traight line])", desc="", modifiers={"pathto"}, min=2, max=4, flags="s", permission="citizens.npc.pathto")
    public void pathto(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1, completions={"me", "here", "cursor"}) String option, @Flag(value={"margin"}) Double margin) throws CommandException {
        Location loc = npc.getStoredLocation();
        if (args.argsLength() == 2) {
            if (option.equalsIgnoreCase("me") || option.equalsIgnoreCase("here")) {
                loc = args.getSenderLocation();
            } else {
                if (!option.equalsIgnoreCase("cursor")) throw new CommandUsageException();
                loc = ((Player)sender).getTargetBlockExact(32).getLocation();
            }
        } else {
            loc.setX(args.getDouble(1));
            loc.setY(args.getDouble(2));
            loc.setZ(args.getDouble(3));
        }
        if (args.hasFlag('s')) {
            npc.getNavigator().setStraightLineTarget(loc);
        } else {
            npc.getNavigator().setTarget(loc);
        }
        if (margin == null) return;
        npc.getNavigator().getLocalParameters().distanceMargin(margin);
    }

    @Command(aliases={"npc"}, usage="pausepathfinding --onrightclick [true|false] --when-player-within [range in blocks] --pauseduration [duration] --lockoutduration [duration]", desc="", modifiers={"pausepathfinding"}, min=1, max=1, permission="citizens.npc.pausepathfinding")
    public void pausepathfinding(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"onrightclick"}) Boolean rightclick, @Flag(value={"when-player-within"}) Double playerRange, @Flag(value={"pauseduration"}) Duration pauseDuration, @Flag(value={"lockoutduration"}) Duration lockoutDuration) throws CommandException {
        PausePathfindingTrait trait = npc.getOrAddTrait(PausePathfindingTrait.class);
        if (playerRange != null) {
            if (playerRange <= 0.0) {
                throw new CommandException("Invalid range");
            }
            trait.setPlayerRange(playerRange);
            Messaging.sendTr(sender, "citizens.commands.npc.pausepathfinding.pause-range-set", npc.getName(), playerRange);
        }
        if (rightclick != null) {
            trait.setPauseOnRightClick(rightclick);
            Messaging.sendTr(sender, rightclick != false ? "citizens.commands.npc.pausepathfinding.rightclick-set" : "citizens.commands.npc.pausepathfinding.rightclick-unset", npc.getName());
        }
        if (lockoutDuration != null) {
            trait.setLockoutDuration(SpigotUtil.toTicks(lockoutDuration));
            Messaging.sendTr(sender, "citizens.commands.npc.pausepathfinding.lockout-duration-set", npc.getName(), lockoutDuration);
        }
        if (pauseDuration != null) {
            trait.setPauseDuration(SpigotUtil.toTicks(pauseDuration));
            Messaging.sendTr(sender, "citizens.commands.npc.pausepathfinding.pause-ticks-set", npc.getName(), pauseDuration);
        }
    }

    @Command(aliases={"npc"}, usage="pickupitems (--set [true|false])", desc="", modifiers={"pickupitems"}, min=1, max=1, permission="citizens.npc.pickupitems")
    public void pickupitems(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"set"}) Boolean set) throws CommandException {
        boolean pickup = set == null ? !npc.data().get(NPC.Metadata.PICKUP_ITEMS, Boolean.valueOf(!npc.isProtected())).booleanValue() : set;
        npc.data().setPersistent(NPC.Metadata.PICKUP_ITEMS, (Object)pickup);
        Messaging.sendTr(sender, pickup ? "citizens.commands.npc.pickupitems.set" : "citizens.commands.npc.pickupitems.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="panimate [animation]", desc="", modifiers={"panimate"}, min=2, max=2, permission="citizens.npc.panimate")
    @Requirements(selected=true, ownership=true, types={EntityType.PLAYER})
    public void playeranimate(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) PlayerAnimation animation) throws CommandException {
        if (animation == null) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.panimate.unknown-animation", Util.listValuesPretty((Object[])PlayerAnimation.values()));
            return;
        }
        animation.play((Player)npc.getEntity(), 64);
    }

    @Command(aliases={"npc"}, usage="playerfilter -a(llowlist) -e(mpty) -d(enylist) --add [uuid] --remove [uuid] --addpermission [permission] --removepermission [permission] --addgroup [group] --removegroup [group] -c(lear) --applywithin [blocks range]", desc="", modifiers={"playerfilter"}, min=1, max=1, flags="adce", permission="citizens.npc.playerfilter")
    public void playerfilter(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"add"}) UUID add, @Flag(value={"remove"}) UUID remove, @Flag(value={"removegroup"}) String removegroup, @Flag(value={"addgroup"}) String addgroup, @Flag(value={"addpermission"}) String addpermission, @Flag(value={"removepermission"}) String removepermission, @Flag(value={"applywithin"}) Double applyRange) {
        PlayerFilter trait = npc.getOrAddTrait(PlayerFilter.class);
        if (add != null) {
            trait.addPlayer(add);
            Messaging.sendTr(sender, "citizens.commands.npc.playerfilter.added", add, npc.getName());
        }
        if (remove != null) {
            trait.removePlayer(remove);
            Messaging.sendTr(sender, "citizens.commands.npc.playerfilter.removed", remove, npc.getName());
        }
        if (addgroup != null) {
            trait.addGroup(addgroup);
            Messaging.sendTr(sender, "citizens.commands.npc.playerfilter.group-added", addgroup, npc.getName());
        }
        if (removegroup != null) {
            trait.removeGroup(removegroup);
            Messaging.sendTr(sender, "citizens.commands.npc.playerfilter.group-removed", removegroup, npc.getName());
        }
        if (addpermission != null) {
            trait.addPermission(addpermission);
            Messaging.sendTr(sender, "citizens.commands.npc.playerfilter.permission-added", addpermission, npc.getName());
        }
        if (removepermission != null) {
            trait.removePermission(removepermission);
            Messaging.sendTr(sender, "citizens.commands.npc.playerfilter.permission-removed", removepermission, npc.getName());
        }
        if (applyRange != null) {
            trait.setApplyRange(applyRange);
            Messaging.sendTr(sender, "citizens.commands.npc.playerfilter.applyrange-set", npc.getName(), applyRange);
        }
        if (args.hasFlag('e')) {
            trait.setPlayers(Collections.emptySet());
            Messaging.sendTr(sender, "citizens.commands.npc.playerfilter.emptied", npc.getName());
        }
        if (args.hasFlag('a')) {
            trait.setAllowlist();
            Messaging.sendTr(sender, "citizens.commands.npc.playerfilter.allowlist-set", npc.getName());
        }
        if (args.hasFlag('d')) {
            trait.setDenylist();
            Messaging.sendTr(sender, "citizens.commands.npc.playerfilter.denylist-set", npc.getName());
        }
        if (args.hasFlag('c')) {
            trait.clear();
            Messaging.sendTr(sender, "citizens.commands.npc.playerfilter.cleared", npc.getName());
        }
    }

    @Command(aliases={"npc"}, usage="playerlist (-a(dd),r(emove))", desc="", modifiers={"playerlist"}, min=1, max=1, flags="ar", permission="citizens.npc.playerlist")
    @Requirements(selected=true, ownership=true, types={EntityType.PLAYER})
    public void playerlist(CommandContext args, CommandSender sender, NPC npc) {
        boolean remove;
        boolean bl = remove = !npc.shouldRemoveFromPlayerList();
        if (args.hasFlag('a')) {
            remove = false;
        } else if (args.hasFlag('r')) {
            remove = true;
        }
        npc.data().setPersistent(NPC.Metadata.REMOVE_FROM_PLAYERLIST, (Object)remove);
        if (npc.isSpawned()) {
            NMS.addOrRemoveFromPlayerList(npc.getEntity(), remove);
        }
        Messaging.sendTr(sender, remove ? "citizens.commands.npc.playerlist.removed" : "citizens.commands.npc.playerlist.added", npc.getName());
    }

    @Command(aliases={"npc"}, usage="playsound [sound] (category) (volume) (pitch) (--to [player]) (--at x:y:z:world)", desc="", modifiers={"playsound"}, min=2, max=5, permission="citizens.npc.playsound")
    public void playsound(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) String sound, @Arg(value=2, defValue="master") SoundCategory category, @Arg(value=3, defValue="1") Float volume, @Arg(value=4, defValue="1") Float pitch, @Flag(value={"to"}) String to, @Flag(value={"at"}) Location at) throws CommandException {
        if (to != null) {
            Player player;
            try {
                UUID uuid = UUID.fromString(to);
                player = Bukkit.getPlayer((UUID)uuid);
            }
            catch (IllegalArgumentException ex) {
                player = Bukkit.getPlayerExact((String)to);
            }
            if (player != null) {
                player.playSound(at == null ? npc.getStoredLocation() : at, sound, category, volume.floatValue(), pitch.floatValue());
            }
            return;
        }
        Location loc = at == null ? npc.getStoredLocation() : at;
        loc.getWorld().playSound(loc, sound, category, volume.floatValue(), pitch.floatValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Command(aliases={"npc"}, usage="pose (--save [name] (-d) | --mirror [name] (-d) | --assume [name] | --remove [name] | --default [name]) (--yaw yaw) (--pitch pitch) (-a)", desc="", flags="ad", modifiers={"pose"}, min=1, max=2, permission="citizens.npc.pose")
    public void pose(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"save"}) String save, @Flag(value={"mirror"}) String mirror, @Flag(value={"assume"}) String assume, @Flag(value={"remove"}) String remove, @Flag(value={"default"}) String defaultPose, @Flag(value={"yaw"}) Float yaw, @Flag(value={"pitch"}) Float pitch) throws CommandException {
        Poses trait = npc.getOrAddTrait(Poses.class);
        if (save != null) {
            if (save.isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            Location loc = npc.getStoredLocation();
            if (yaw != null) {
                loc.setYaw(yaw.floatValue());
            }
            if (pitch != null) {
                loc.setPitch(pitch.floatValue());
            }
            if (!trait.addPose(save, loc, args.hasFlag('d'))) throw new CommandException("citizens.commands.npc.pose.already-exists", save);
            Messaging.sendTr(sender, "citizens.commands.npc.pose.added", new Object[0]);
        } else if (mirror != null) {
            if (mirror.isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            if (args.getSenderLocation() == null) {
                throw new ServerCommandException();
            }
            if (!trait.addPose(mirror, args.getSenderLocation(), args.hasFlag('d'))) throw new CommandException("citizens.commands.npc.pose.already-exists", mirror);
            Messaging.sendTr(sender, "citizens.commands.npc.pose.added", new Object[0]);
        } else if (defaultPose != null) {
            if (!trait.hasPose(defaultPose)) {
                throw new CommandException("citizens.commands.npc.pose.missing", defaultPose);
            }
            trait.setDefaultPose(defaultPose);
            Messaging.sendTr(sender, "citizens.commands.npc.pose.default-pose-set", defaultPose);
        } else if (assume != null) {
            if (assume.isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            if (!trait.hasPose(assume)) {
                throw new CommandException("citizens.commands.npc.pose.missing", assume);
            }
            trait.assumePose(assume);
        } else if (remove != null) {
            if (remove.isEmpty()) {
                throw new CommandException("citizens.commands.npc.pose.invalid-name");
            }
            if (!trait.removePose(remove)) throw new CommandException("citizens.commands.npc.pose.missing", remove);
            Messaging.sendTr(sender, "citizens.commands.npc.pose.removed", new Object[0]);
        } else if (!args.hasFlag('a')) {
            trait.describe(sender, args.getInteger(1, 1));
        }
        if (!args.hasFlag('a')) return;
        if (args.getSenderLocation() == null) {
            throw new ServerCommandException();
        }
        trait.assumePose(args.getSenderLocation());
    }

    @Command(aliases={"npc"}, usage="powered (--set true|false)", desc="", modifiers={"powered"}, min=1, max=1, permission="citizens.npc.powered")
    @Requirements(selected=true, ownership=true, types={EntityType.CREEPER})
    public void power(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"set"}) Boolean explicit) {
        boolean value = explicit != null ? explicit : !npc.getOrAddTrait(Powered.class).isPowered();
        npc.getOrAddTrait(Powered.class).setPowered(value);
        Messaging.sendTr(sender, value ? "citizens.commands.npc.powered.set" : "citizens.commands.npc.powered.stopped", new Object[0]);
    }

    @Command(aliases={"npc"}, usage="rabbittype [type]", desc="", modifiers={"rabbittype", "rbtype"}, min=2, permission="citizens.npc.rabbittype")
    @Requirements(selected=true, ownership=true, types={EntityType.RABBIT})
    public void rabbitType(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) Rabbit.Type type) throws CommandException {
        if (type == null) {
            throw new CommandException("citizens.commands.npc.rabbittype.invalid-type", Util.listValuesPretty(Rabbit.Type.values()));
        }
        npc.getOrAddTrait(RabbitType.class).setType(type);
        Messaging.sendTr(sender, "citizens.commands.npc.rabbittype.type-set", npc.getName(), type.name());
    }

    @Command(aliases={"npc"}, usage="remove|rem (all|id|name| --owner [owner] | --eid [entity uuid] | --world [world])", desc="", modifiers={"remove", "rem"}, min=1, max=2)
    @Requirements
    public void remove(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"owner"}) String owner, @Flag(value={"eid"}) UUID eid, @Flag(value={"world"}) String world, @Arg(value=1, completions={"all"}) String action) throws CommandException {
        if (owner != null) {
            UUID uuid = null;
            try {
                uuid = UUID.fromString(owner);
            }
            catch (IllegalArgumentException ex) {
                try {
                    uuid = Bukkit.getOfflinePlayer((String)owner).getUniqueId();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (NPC rem : Lists.newArrayList((Iterable)CitizensAPI.getNPCRegistry())) {
                if (!rem.getOrAddTrait(Owner.class).isOwnedBy(sender) || (uuid == null || !rem.getOrAddTrait(Owner.class).isOwnedBy(uuid)) && !rem.getOrAddTrait(Owner.class).isOwnedBy(owner)) continue;
                this.history.add(sender, new RemoveNPCHistoryItem(rem));
                rem.destroy(sender);
            }
            Messaging.sendTr(sender, "citizens.commands.npc.remove.npcs-removed", new Object[0]);
            return;
        }
        if (world != null) {
            for (NPC rem : Lists.newArrayList((Iterable)CitizensAPI.getNPCRegistry())) {
                Location loc = rem.getStoredLocation();
                if (loc == null || !rem.getOrAddTrait(Owner.class).isOwnedBy(sender) || loc.getWorld() == null || !loc.getWorld().getUID().toString().equals(world) && !loc.getWorld().getName().equalsIgnoreCase(world)) continue;
                this.history.add(sender, new RemoveNPCHistoryItem(rem));
                rem.destroy(sender);
            }
            Messaging.sendTr(sender, "citizens.commands.npc.remove.npcs-removed", new Object[0]);
            return;
        }
        if (eid != null) {
            Entity entity = Bukkit.getServer().getEntity(eid);
            if (entity != null && (npc = CitizensAPI.getNPCRegistry().getNPC(entity)) != null && npc.getOrAddTrait(Owner.class).isOwnedBy(sender)) {
                this.history.add(sender, new RemoveNPCHistoryItem(npc));
                npc.destroy(sender);
                Messaging.sendTr(sender, "citizens.commands.npc.remove.removed", npc.getName(), npc.getId());
            } else {
                Messaging.sendErrorTr(sender, "citizens.notifications.npc-not-found", new Object[0]);
            }
            return;
        }
        if (args.argsLength() == 2) {
            if ("all".equalsIgnoreCase(action)) {
                if (!sender.hasPermission("citizens.admin.remove.all") && !sender.hasPermission("citizens.admin")) {
                    throw new NoPermissionsException();
                }
                for (NPC rem : CitizensAPI.getNPCRegistry()) {
                    this.history.add(sender, new RemoveNPCHistoryItem(rem));
                }
                CitizensAPI.getNPCRegistry().deregisterAll();
                Messaging.sendTr(sender, "citizens.commands.npc.remove.removed-all", new Object[0]);
            } else {
                NPCCommandSelector.Callback callback = npc1 -> {
                    if (npc1 == null) {
                        throw new CommandException("citizens.commands.requirements.must-have-selected");
                    }
                    if (!(sender instanceof ConsoleCommandSender) && !npc1.getOrAddTrait(Owner.class).isOwnedBy(sender)) {
                        throw new CommandException("citizens.commands.requirements.must-be-owner");
                    }
                    if (!sender.hasPermission("citizens.npc.remove") && !sender.hasPermission("citizens.admin")) {
                        throw new NoPermissionsException();
                    }
                    this.history.add(sender, new RemoveNPCHistoryItem(npc1));
                    npc1.destroy(sender);
                    Messaging.sendTr(sender, "citizens.commands.npc.remove.removed", npc1.getName(), npc1.getId());
                };
                NPCCommandSelector.startWithCallback(callback, CitizensAPI.getNPCRegistry(), sender, args, args.getString(1));
            }
            return;
        }
        if (npc == null) {
            throw new CommandException("citizens.commands.requirements.must-have-selected");
        }
        if (!(sender instanceof ConsoleCommandSender) && !npc.getOrAddTrait(Owner.class).isOwnedBy(sender)) {
            throw new CommandException("citizens.commands.requirements.must-be-owner");
        }
        if (!sender.hasPermission("citizens.npc.remove") && !sender.hasPermission("citizens.admin")) {
            throw new NoPermissionsException();
        }
        this.history.add(sender, new RemoveNPCHistoryItem(npc));
        npc.destroy(sender);
        Messaging.sendTr(sender, "citizens.commands.npc.remove.removed", npc.getName(), npc.getId());
    }

    @Command(aliases={"npc"}, usage="rename [name]", desc="", modifiers={"rename"}, min=2, permission="citizens.npc.rename")
    public void rename(CommandContext args, CommandSender sender, NPC npc) {
        String oldName = npc.getName();
        String newName = args.getJoinedStrings(1);
        int nameLength = SpigotUtil.getMaxNameLength(npc.getOrAddTrait(MobType.class).getType());
        if (Placeholders.replace(Messaging.stripColor(newName), sender, npc).length() > nameLength) {
            Messaging.sendErrorTr(sender, "citizens.commands.npc.create.npc-name-too-long", nameLength);
            newName = newName.substring(0, nameLength);
        }
        npc.setName(newName);
        Messaging.sendTr(sender, "citizens.commands.npc.rename.renamed", oldName, newName);
    }

    @Command(aliases={"npc"}, usage="respawn [delay]", desc="", modifiers={"respawn"}, min=1, max=2, permission="citizens.npc.respawn")
    public void respawn(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) Duration delay) {
        if (delay != null) {
            npc.data().setPersistent(NPC.Metadata.RESPAWN_DELAY, (Object)SpigotUtil.toTicks(delay));
            Messaging.sendTr(sender, "citizens.commands.npc.respawn.delay-set", SpigotUtil.toTicks(delay));
        } else {
            Messaging.sendTr(sender, "citizens.commands.npc.respawn.describe", npc.data().get(NPC.Metadata.RESPAWN_DELAY, Integer.valueOf(-1)));
        }
    }

    @Command(aliases={"npc"}, usage="rotate (--towards [x,y,z]) (--toentity [name|uuid|me]) (--body [yaw]) (--head [yaw]) (--pitch [pitch]) (-s(mooth))", desc="", flags="s", modifiers={"rotate"}, min=1, max=1, permission="citizens.npc.rotate")
    public void rotate(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"body"}) Float yaw, @Flag(value={"head"}) Float head, @Flag(value={"pitch"}) Float pitch, @Flag(value={"towards"}) Location towards, @Flag(value={"toentity"}) String entity) throws CommandException {
        if (args.hasFlag('s')) {
            if (pitch == null) {
                pitch = Float.valueOf(npc.getStoredLocation().getPitch());
            }
            if (yaw == null) {
                yaw = head != null ? head : Float.valueOf(NMS.getHeadYaw(npc.getEntity()));
            }
            npc.getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToHave(yaw.floatValue(), pitch.floatValue());
            return;
        }
        if (entity != null) {
            if (entity.equals("me")) {
                towards = args.getSenderLocation();
            } else {
                try {
                    UUID uuid = UUID.fromString(entity);
                    towards = Bukkit.getPlayer((UUID)uuid).getLocation();
                }
                catch (IllegalArgumentException ex) {
                    towards = Bukkit.getPlayerExact((String)entity).getLocation();
                }
            }
        }
        if (towards != null) {
            npc.getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToFace(towards);
            return;
        }
        if (yaw != null) {
            NMS.setBodyYaw(npc.getEntity(), yaw.floatValue());
            if (npc.getEntity().getType() == EntityType.PLAYER) {
                NMS.sendRotationPacketNearby(npc.getEntity(), yaw, Float.valueOf(npc.getEntity().getLocation().getPitch()), null);
                PlayerAnimation.ARM_SWING.play((Player)npc.getEntity());
            }
        }
        if (pitch != null) {
            NMS.setPitch(npc.getEntity(), pitch.floatValue());
        }
        if (head != null) {
            NMS.setHeadYaw(npc.getEntity(), head.floatValue());
        }
    }

    @Command(aliases={"npc"}, usage="rotationsettings [linear|immediate] (--link_body) (--head_only) (--max_pitch_per_tick) (--max_yaw_per_tick) (--pitch_range) (--yaw_range)", desc="", modifiers={"rotationsettings"}, min=2, max=2, permission="citizens.npc.rotationsettings")
    public void rotationsettings(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1, completions={"linear", "immediate"}) String type, @Flag(value={"link_body"}) Boolean linkBody, @Flag(value={"head_only"}) Boolean headOnly, @Flag(value={"max_pitch_per_tick"}) Float maxPitchPerTick, @Flag(value={"max_yaw_per_tick"}) Float maxYawPerTick, @Flag(value={"pitch_range"}, validator=Arg.FloatArrayFlagValidator.class) float[] pitchRange, @Flag(value={"yaw_range"}, validator=Arg.FloatArrayFlagValidator.class) float[] yawRange) throws CommandException {
        if (!"linear".equalsIgnoreCase(type) && !"immediate".equalsIgnoreCase(type)) {
            throw new CommandUsageException();
        }
        RotationTrait.RotationParams params = npc.getOrAddTrait(RotationTrait.class).getGlobalParameters();
        params.immediate("immediate".equalsIgnoreCase(type));
        if (linkBody != null) {
            params.linkedBody(linkBody);
        }
        if (headOnly != null) {
            params.headOnly(headOnly);
        }
        if (maxPitchPerTick != null) {
            params.maxPitchPerTick(maxPitchPerTick.floatValue());
        }
        if (maxYawPerTick != null) {
            params.maxYawPerTick(maxYawPerTick.floatValue());
        }
        if (pitchRange != null) {
            params.pitchRange(pitchRange);
        }
        if (yawRange != null) {
            params.yawRange(yawRange);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.rotationsettings.describe", params.describe());
    }

    @Command(aliases={"npc"}, usage="scaledmaxhealth [health]", desc="", modifiers={"scaledmaxhealth"}, min=1, max=2, permission="citizens.npc.scaledmaxhealth")
    public void scaledhealth(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) Double scaled) {
        npc.getOrAddTrait(ScaledMaxHealthTrait.class).setMaxHealth(scaled);
        Messaging.sendTr(sender, "citizens.commands.npc.scaledmaxhealth.set", scaled);
    }

    @Command(aliases={"npc"}, usage="select|sel [id|name] (--range range) (--registry [name])", desc="", modifiers={"select", "sel"}, min=1, max=2, permission="citizens.npc.select")
    @Requirements
    public void select(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"range"}, defValue="15") double range, @Flag(value={"registry"}) String registryName) throws CommandException {
        NPCRegistry registry;
        NPCCommandSelector.Callback callback = toSelect -> {
            if (toSelect == null) {
                throw new CommandException("citizens.notifications.npc-not-found");
            }
            if (npc != null && toSelect.getId() == npc.getId()) {
                throw new CommandException("citizens.commands.npc.select.already-selected");
            }
            this.selector.select(sender, toSelect);
            if (!Settings.Setting.SELECTION_MESSAGE.asString().isEmpty()) {
                Messaging.sendWithNPC(sender, Settings.Setting.SELECTION_MESSAGE.asString(), toSelect);
            }
        };
        NPCRegistry nPCRegistry = registry = registryName != null ? CitizensAPI.getNamedNPCRegistry(registryName) : CitizensAPI.getNPCRegistry();
        if (registry == null) {
            throw new CommandException("citizens.commands.errors.unknown-registry", args.getFlag("registry"));
        }
        if (args.argsLength() <= 1) {
            Location eyeLoc;
            RayTraceResult res;
            if (args.getSenderLocation() == null) {
                throw new ServerCommandException();
            }
            Location location = args.getSenderLocation();
            if (SUPPORT_RAYTRACE && sender instanceof Player && (res = (eyeLoc = ((Player)sender).getEyeLocation()).getWorld().rayTraceEntities(eyeLoc, eyeLoc.getDirection(), range, 0.1, e -> !e.equals((Object)sender))) != null && registry.isNPC(res.getHitEntity())) {
                NPC hit = registry.getNPC(res.getHitEntity());
                if (hit.hasTrait(ClickRedirectTrait.class)) {
                    hit = hit.getTraitNullable(ClickRedirectTrait.class).getRedirectToNPC();
                }
                callback.run(hit);
                return;
            }
            List search = location.getWorld().getNearbyEntities(location, range, range, range).stream().map(registry::getNPC).filter(Objects::nonNull).collect(Collectors.toList());
            search.sort((o1, o2) -> Double.compare(o1.getEntity().getLocation().distanceSquared(location), o2.getEntity().getLocation().distanceSquared(location)));
            Iterator iterator = search.iterator();
            if (iterator.hasNext()) {
                NPC test = (NPC)iterator.next();
                if (test.hasTrait(ClickRedirectTrait.class)) {
                    test = test.getTraitNullable(ClickRedirectTrait.class).getRedirectToNPC();
                }
                callback.run(test);
            }
        } else {
            NPCCommandSelector.startWithCallback(callback, registry, sender, args, args.getString(1));
        }
    }

    @Command(aliases={"npc"}, usage="setequipment (-c(osmetic)) [slot] [item]", desc="", flags="c", modifiers={"setequipment"}, min=2, max=3, permission="citizens.npc.setequipment")
    public void setequipment(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) Equipment.EquipmentSlot slot, @Arg(value=2) ItemStack item) throws CommandException {
        if (slot == null) {
            throw new CommandUsageException();
        }
        if (args.argsLength() == 3 && args.getString(2).equalsIgnoreCase("hand")) {
            if (!(sender instanceof Player)) {
                throw new ServerCommandException();
            }
            item = ((Player)sender).getItemInHand().clone();
        }
        if (args.hasFlag('c')) {
            npc.getOrAddTrait(Equipment.class).setCosmetic(slot, item);
            Messaging.sendTr(sender, "citizens.commands.npc.setequipment.cosmetic-set", new Object[]{slot, item});
        } else {
            npc.getOrAddTrait(Equipment.class).set(slot, item);
            Messaging.sendTr(sender, "citizens.commands.npc.setequipment.set", new Object[]{slot, item});
        }
    }

    @Command(aliases={"npc"}, usage="sheep (--color [color]) (--sheared [sheared])", desc="", modifiers={"sheep"}, min=1, max=1, permission="citizens.npc.sheep")
    @Requirements(selected=true, ownership=true, types={EntityType.SHEEP})
    public void sheep(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"color"}) DyeColor color, @Flag(value={"sheared"}) Boolean sheared) throws CommandException {
        SheepTrait trait = npc.getOrAddTrait(SheepTrait.class);
        boolean hasArg = false;
        if (sheared != null) {
            trait.setSheared(sheared);
            hasArg = true;
        }
        if (args.hasValueFlag("color")) {
            if (color != null) {
                trait.setColor(color);
                Messaging.sendTr(sender, "citizens.commands.npc.sheep.color-set", Util.prettyEnum(color));
            } else {
                Messaging.sendErrorTr(sender, "citizens.commands.npc.sheep.invalid-color", Util.listValuesPretty(DyeColor.values()));
            }
            hasArg = true;
        }
        if (!hasArg) {
            throw new CommandException();
        }
    }

    @Command(aliases={"npc"}, usage="shop (edit|show|delete|copyfrom) (name) (new_name)", desc="", modifiers={"shop"}, min=1, max=4, permission="citizens.npc.shop")
    @Requirements(selected=false, ownership=true)
    public void shop(CommandContext args, Player sender, NPC npc, @Arg(value=1, completions={"edit", "show", "delete", "copyfrom"}) String action) throws CommandException {
        ShopTrait.NPCShop shop;
        if (args.argsLength() == 1) {
            if (npc != null) {
                npc.getOrAddTrait(ShopTrait.class).getDefaultShop().display(sender);
            }
            return;
        }
        ShopTrait.NPCShop nPCShop = shop = npc != null ? npc.getOrAddTrait(ShopTrait.class).getDefaultShop() : null;
        if (args.argsLength() >= 3 && (shop = this.shops.getShop(args.getString(2))) == null && action.equalsIgnoreCase("edit")) {
            shop = this.shops.addNamedShop(args.getString(2));
        }
        if (shop == null) {
            throw new CommandException("citizens.commands.npc.shop.shop-not-found", args.argsLength() >= 3 ? args.getString(2) : "");
        }
        if (action.equalsIgnoreCase("delete")) {
            if (!shop.canEdit(npc, sender)) {
                throw new NoPermissionsException();
            }
            this.shops.deleteShop(shop);
            Messaging.sendTr((CommandSender)sender, "citizens.commands.npc.shop.deleted", shop.getName());
        } else if (action.equalsIgnoreCase("edit")) {
            if (!shop.canEdit(npc, sender)) {
                throw new NoPermissionsException();
            }
            shop.displayEditor(npc == null ? null : npc.getOrAddTrait(ShopTrait.class), sender);
        } else if (action.equalsIgnoreCase("copyfrom")) {
            if (!shop.canEdit(npc, sender) || !npc.getOrAddTrait(ShopTrait.class).getDefaultShop().canEdit(npc, sender)) {
                throw new NoPermissionsException();
            }
            String newName = args.argsLength() == 4 ? args.getString(3) : UUID.randomUUID().toString();
            MemoryDataKey key = new MemoryDataKey().getRelative(newName);
            PersistenceLoader.save(shop, key);
            ShopTrait.NPCShop copy = (ShopTrait.NPCShop)((Object)PersistenceLoader.load(ShopTrait.NPCShop.class, (DataKey)key));
            npc.getOrAddTrait(ShopTrait.class).setDefaultShop(copy);
        } else if (action.equalsIgnoreCase("show")) {
            if (args.argsLength() == 4 && (sender = Bukkit.getPlayer((String)args.getString(3))) == null) {
                throw new CommandException("citizens.commands.npc.shop.show-player-not-found", args.getString(3));
            }
            shop.display(sender);
        } else {
            throw new CommandUsageException();
        }
    }

    @Command(aliases={"npc"}, usage="sitting (--explicit [true|false]) (--at [at])", desc="", modifiers={"sitting"}, min=1, max=2, permission="citizens.npc.sitting")
    public void sitting(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"explicit"}) Boolean explicit, @Flag(value={"at"}) Location at) {
        boolean toSit;
        SitTrait trait = npc.getOrAddTrait(SitTrait.class);
        boolean bl = explicit != null ? explicit : (toSit = !trait.isSitting());
        if (!toSit) {
            trait.setSitting(null);
            Messaging.sendTr(sender, "citizens.commands.npc.sitting.unset", npc.getName());
            return;
        }
        if (at == null) {
            at = npc.getStoredLocation();
        }
        trait.setSitting(at);
        Messaging.sendTr(sender, "citizens.commands.npc.sitting.set", npc.getName(), Util.prettyPrintLocation(at));
    }

    @Command(aliases={"npc"}, usage="skin (-e(xport) -c(lear) -l(atest) -s(kull) -b(edrock)) [name] (or --url [url] --file [file] (-s(lim)) or -t [uuid/name] [data] [signature])", desc="", modifiers={"skin"}, min=1, max=4, flags="bectls", permission="citizens.npc.skin")
    public void skin(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"url"}) String url, @Flag(value={"file"}) String file) throws CommandException {
        EntityType type = npc.getOrAddTrait(MobType.class).getType();
        if (type != EntityType.PLAYER && !type.name().equals("MANNEQUIN")) {
            throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.disallowed-mobtype", Util.prettyEnum(type)));
        }
        String skinName = npc.getName();
        SkinTrait trait = npc.getOrAddTrait(SkinTrait.class);
        if (args.hasFlag('c')) {
            trait.clearTexture();
            Messaging.sendTr(sender, "citizens.commands.npc.skin.cleared", new Object[0]);
            return;
        }
        if (args.hasFlag('e')) {
            File skin;
            if (trait.getTexture() == null) {
                throw new CommandException("citizens.commands.npc.skin.missing-skin");
            }
            File skinsFolder = new File(CitizensAPI.getDataFolder(), "skins");
            File file2 = skin = file == null ? new File(skinsFolder, npc.getUniqueId().toString() + ".png") : new File(skinsFolder, file);
            if (!this.isInDirectory(skin, skinsFolder) || !skin.getName().endsWith(".png")) {
                throw new CommandException("citizens.commands.npc.skin.invalid-file", skin.getName());
            }
            try {
                JSONObject data = (JSONObject)new JSONParser().parse(new String(BaseEncoding.base64().decode((CharSequence)trait.getTexture())));
                JSONObject textures = (JSONObject)data.get((Object)"textures");
                JSONObject skinObj = (JSONObject)textures.get((Object)"SKIN");
                URL textureUrl = new URL(skinObj.get((Object)"url").toString().replace("\\", ""));
                if (!textureUrl.getHost().equals("textures.minecraft.net")) {
                    throw new CommandException("citizens.commands.npc.skin.error-setting-url", "Mojang");
                }
                try (ReadableByteChannel in = Channels.newChannel(textureUrl.openStream());
                     FileOutputStream out = new FileOutputStream(skin);){
                    out.getChannel().transferFrom(in, 0L, 10000L);
                }
                Messaging.sendTr(sender, "citizens.commands.npc.skin.exported", skin.getName());
            }
            catch (Exception e) {
                throw new CommandException("Couldn't parse texture: " + e.getMessage());
            }
            return;
        }
        if (url != null || file != null) {
            Messaging.sendTr(sender, "citizens.commands.npc.skin.fetching", url == null ? file : url);
            Bukkit.getScheduler().runTaskAsynchronously(CitizensAPI.getPlugin(), () -> {
                try {
                    JSONObject data = null;
                    if (file != null) {
                        File skinsFolder = new File(CitizensAPI.getDataFolder(), "skins");
                        File skin = new File(skinsFolder, Placeholders.replace(file, sender, npc));
                        if (!skin.exists() || !skin.isFile() || skin.isHidden() || !this.isInDirectory(skin, skinsFolder)) {
                            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), () -> Messaging.sendErrorTr(sender, "citizens.commands.npc.skin.invalid-file", file));
                            return;
                        }
                        data = MojangSkinGenerator.generateFromPNG(Files.readAllBytes(skin.toPath()), args.hasFlag('s'));
                    } else {
                        data = MojangSkinGenerator.generateFromURL(Placeholders.replace(url, sender, npc), args.hasFlag('s'));
                    }
                    String uuid = (String)data.get((Object)"uuid");
                    JSONObject texture = (JSONObject)data.get((Object)"texture");
                    String textureEncoded = (String)texture.get((Object)"value");
                    String signature = (String)texture.get((Object)"signature");
                    Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), () -> {
                        try {
                            trait.setSkinPersistent(uuid, signature, textureEncoded);
                            Messaging.sendTr(sender, "citizens.commands.npc.skin.skin-url-set", npc.getName(), url == null ? file : url);
                        }
                        catch (IllegalArgumentException e) {
                            Messaging.sendErrorTr(sender, "citizens.commands.npc.skin.error-setting-url", url == null ? file : url);
                        }
                    });
                }
                catch (Throwable t) {
                    if (Messaging.isDebugging()) {
                        t.printStackTrace();
                    }
                    Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), () -> Messaging.sendErrorTr(sender, "citizens.commands.npc.skin.error-setting-url", url == null ? file : url));
                }
            });
            return;
        }
        if (args.hasFlag('t')) {
            if (args.argsLength() != 4) {
                throw new CommandException("citizens.commands.npc.skin.missing-skin");
            }
            trait.setSkinPersistent(args.getString(1), args.getString(3), args.getString(2));
            Messaging.sendTr(sender, "citizens.commands.npc.skin.set", npc.getName(), args.getString(1));
            return;
        }
        if (args.hasFlag('s') && npc.getEntity() instanceof Player) {
            ItemStack is = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta sm = (SkullMeta)is.getItemMeta();
            NMS.setProfile(sm, NMS.getProfile((Player)npc.getEntity()));
            is.setItemMeta((ItemMeta)sm);
            if (!(sender instanceof Player) || !((Player)sender).getInventory().addItem(new ItemStack[]{is}).isEmpty()) {
                if (args.getSenderLocation() != null) {
                    args.getSenderLocation().getWorld().dropItem(args.getSenderLocation(), is);
                } else {
                    throw new ServerCommandException();
                }
            }
            return;
        }
        if (args.hasFlag('l')) {
            trait.setShouldUpdateSkins(!trait.shouldUpdateSkins());
            Messaging.sendTr(sender, "citizens.commands.npc.skin.latest-set", npc.getName(), skinName != null ? skinName : trait.getSkinName());
            if (args.argsLength() != 2) {
                return;
            }
        }
        if (args.argsLength() != 2) {
            Messaging.send(sender, trait.getSkinName());
            return;
        }
        skinName = args.getString(1);
        if (args.hasFlag('b')) {
            skinName = Util.possiblyConvertToBedrockName(skinName);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.skin.set", npc.getName(), skinName);
        trait.setSkinName(skinName, true);
    }

    @Command(aliases={"npc"}, usage="skinlayers (--cape [true|false]) (--hat [true|false]) (--jacket [true|false]) (--sleeves [true|false]) (--pants [true|false])", desc="", modifiers={"skinlayers"}, min=1, max=5, permission="citizens.npc.skinlayers")
    public void skinLayers(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"cape"}) Boolean cape, @Flag(value={"hat"}) Boolean hat, @Flag(value={"jacket"}) Boolean jacket, @Flag(value={"sleeves"}) Boolean sleeves, @Flag(value={"pants"}) Boolean pants) throws CommandException {
        EntityType type = npc.getOrAddTrait(MobType.class).getType();
        if (type != EntityType.PLAYER && !type.name().equals("MANNEQUIN")) {
            throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.disallowed-mobtype", Util.prettyEnum(type)));
        }
        SkinLayers trait = npc.getOrAddTrait(SkinLayers.class);
        if (cape != null) {
            trait.setVisible(SkinLayers.Layer.CAPE, cape);
        }
        if (hat != null) {
            trait.setVisible(SkinLayers.Layer.HAT, hat);
        }
        if (jacket != null) {
            trait.setVisible(SkinLayers.Layer.JACKET, jacket);
        }
        if (sleeves != null) {
            trait.setVisible(SkinLayers.Layer.LEFT_SLEEVE, sleeves);
            trait.setVisible(SkinLayers.Layer.RIGHT_SLEEVE, sleeves);
        }
        if (pants != null) {
            trait.setVisible(SkinLayers.Layer.LEFT_PANTS, pants);
            trait.setVisible(SkinLayers.Layer.RIGHT_PANTS, pants);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.skin.layers-set", npc.getName(), trait.isVisible(SkinLayers.Layer.CAPE), trait.isVisible(SkinLayers.Layer.HAT), trait.isVisible(SkinLayers.Layer.JACKET), trait.isVisible(SkinLayers.Layer.LEFT_SLEEVE) || trait.isVisible(SkinLayers.Layer.RIGHT_SLEEVE), trait.isVisible(SkinLayers.Layer.LEFT_PANTS) || trait.isVisible(SkinLayers.Layer.RIGHT_PANTS));
    }

    @Command(aliases={"npc"}, usage="slimesize [size]", desc="", modifiers={"slimesize"}, min=1, max=2, permission="citizens.npc.slimesize")
    @Requirements(selected=true, ownership=true, types={EntityType.MAGMA_CUBE, EntityType.SLIME})
    public void slimeSize(CommandContext args, CommandSender sender, NPC npc) {
        SlimeSize trait = npc.getOrAddTrait(SlimeSize.class);
        if (args.argsLength() <= 1) {
            trait.describe(sender);
            return;
        }
        int size = Math.max(-2, args.getInteger(1));
        trait.setSize(size);
        Messaging.sendTr(sender, "citizens.commands.npc.size.set", npc.getName(), size);
    }

    @Command(aliases={"npc"}, usage="sound (--death [death sound|d]) (--ambient [ambient sound|d]) (--hurt [hurt sound|d]) (-n(one)/-s(ilent)) (-d(efault))", desc="", modifiers={"sound"}, flags="dns", min=1, max=1, permission="citizens.npc.sound")
    @Requirements(selected=true, ownership=true, livingEntity=true)
    public void sound(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"death"}) Sound death, @Flag(value={"ambient"}) Sound ambient, @Flag(value={"hurt"}) Sound hurt) throws CommandException {
        String ambientSound = (String)npc.data().get(NPC.Metadata.AMBIENT_SOUND);
        String deathSound = (String)npc.data().get(NPC.Metadata.DEATH_SOUND);
        String hurtSound = (String)npc.data().get(NPC.Metadata.HURT_SOUND);
        if (args.getValueFlags().size() == 0 && args.getFlags().size() == 0) {
            Messaging.sendTr(sender, "citizens.commands.npc.sound.info", npc.getName(), ambientSound, hurtSound, deathSound);
            return;
        }
        if (args.hasFlag('n')) {
            hurtSound = "";
            deathSound = "";
            ambientSound = "";
            npc.data().setPersistent(NPC.Metadata.SILENT, (Object)true);
        }
        if (args.hasFlag('s')) {
            npc.data().setPersistent(NPC.Metadata.SILENT, (Object)(npc.data().get(NPC.Metadata.SILENT, Boolean.valueOf(false)) == false ? 1 : 0));
        }
        if (args.hasFlag('d')) {
            hurtSound = null;
            deathSound = null;
            ambientSound = null;
            npc.data().setPersistent(NPC.Metadata.SILENT, (Object)false);
        } else {
            if (death != null) {
                deathSound = NMS.getSoundPath(death);
            } else if (args.hasValueFlag("death")) {
                String string = deathSound = args.getFlag("death").equals("d") ? null : args.getFlag("death");
            }
            if (ambient != null) {
                ambientSound = NMS.getSoundPath(ambient);
            } else if (args.hasValueFlag("ambient")) {
                String string = ambientSound = args.getFlag("ambient").equals("d") ? null : args.getFlag("ambient");
            }
            if (hurt != null) {
                hurtSound = NMS.getSoundPath(hurt);
            } else if (args.hasValueFlag("hurt")) {
                String string = hurtSound = args.getFlag("hurt").equals("d") ? null : args.getFlag("hurt");
            }
        }
        if (deathSound == null) {
            npc.data().remove(NPC.Metadata.DEATH_SOUND);
        } else {
            npc.data().setPersistent(NPC.Metadata.DEATH_SOUND, (Object)deathSound);
        }
        if (hurtSound == null) {
            npc.data().remove(NPC.Metadata.HURT_SOUND);
        } else {
            npc.data().setPersistent(NPC.Metadata.HURT_SOUND, (Object)hurtSound);
        }
        if (ambientSound == null) {
            npc.data().remove(NPC.Metadata.AMBIENT_SOUND);
        } else {
            npc.data().setPersistent(NPC.Metadata.AMBIENT_SOUND, (Object)ambientSound);
        }
        if (ambientSound != null && ambientSound.isEmpty()) {
            ambientSound = "none";
        }
        if (hurtSound != null && hurtSound.isEmpty()) {
            hurtSound = "none";
        }
        if (deathSound != null && deathSound.isEmpty()) {
            deathSound = "none";
        }
        if (!Strings.isNullOrEmpty((String)ambientSound) && !ambientSound.equals("none") || !Strings.isNullOrEmpty((String)deathSound) && !deathSound.equals("none") || !Strings.isNullOrEmpty((String)hurtSound) && !hurtSound.equals("none")) {
            npc.data().setPersistent(NPC.Metadata.SILENT, (Object)false);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.sound.set", npc.getName(), ambientSound, hurtSound, deathSound);
    }

    @Command(aliases={"npc"}, usage="spawn (id|name) -l(oad chunks)", desc="", modifiers={"spawn"}, min=1, max=2, flags="l", permission="citizens.npc.spawn")
    @Requirements(ownership=true)
    public void spawn(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        NPCCommandSelector.Callback callback = respawn -> {
            if (respawn == null) {
                if (args.argsLength() > 1) {
                    throw new CommandException("citizens.commands.npc.spawn.missing-npc-id", args.getString(1));
                }
                throw new CommandException("citizens.commands.requirements.must-have-selected");
            }
            if (respawn.isSpawned()) {
                throw new CommandException("citizens.commands.npc.spawn.already-spawned", respawn.getName());
            }
            Location location = respawn.getOrAddTrait(CurrentLocation.class).getLocation();
            if (location == null || args.hasValueFlag("location")) {
                if (args.getSenderLocation() == null) {
                    throw new CommandException("citizens.commands.npc.spawn.no-location");
                }
                location = args.getSenderLocation();
            }
            if (args.hasFlag('l') && !Util.isLoaded(location)) {
                location.getChunk().load();
            }
            if (respawn.spawn(location, SpawnReason.COMMAND)) {
                this.selector.select(sender, respawn);
                Messaging.sendTr(sender, "citizens.commands.npc.spawn.spawned", respawn.getName());
            }
        };
        if (args.argsLength() > 1) {
            NPCCommandSelector.startWithCallback(callback, CitizensAPI.getNPCRegistry(), sender, args, args.getString(1));
        } else {
            callback.run(npc);
        }
    }

    @Command(aliases={"npc"}, usage="speak [message] --bubble [duration] --target [npcid|player name] --range (range to look for entities to speak to in blocks)", desc="", modifiers={"speak"}, min=2, permission="citizens.npc.speak")
    public void speak(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"bubble"}) Duration bubbleDuration, @Flag(value={"type"}) String type, @Flag(value={"target"}) String target, @Flag(value={"range"}) Float range) throws CommandException {
        String message = args.getJoinedStrings(1);
        SpeechContext context = new SpeechContext(message);
        Player playerRecipient = null;
        if (target != null) {
            if (Ints.tryParse((String)target) != null) {
                NPC targetNPC = CitizensAPI.getNPCRegistry().getById(Integer.parseInt(args.getFlag("target")));
                if (targetNPC != null) {
                    context.addRecipient(targetNPC.getEntity());
                }
            } else {
                Player player = Bukkit.getPlayerExact((String)target);
                if (player != null) {
                    context.addRecipient((Entity)player);
                    playerRecipient = player;
                }
            }
        }
        if (bubbleDuration != null) {
            HologramTrait trait = npc.getOrAddTrait(HologramTrait.class);
            trait.addTemporaryLine(Placeholders.replace(message, playerRecipient, npc), SpigotUtil.toTicks(bubbleDuration));
            return;
        }
        if (range != null) {
            npc.getEntity().getNearbyEntities((double)range.floatValue(), (double)range.floatValue(), (double)range.floatValue()).forEach(e -> {
                if (!CitizensAPI.getNPCRegistry().isNPC((Entity)e)) {
                    context.addRecipient((Entity)e);
                }
            });
        }
        npc.getDefaultSpeechController().speak(context);
    }

    @Command(aliases={"npc"}, usage="spectate (-r(eset))", desc="", flags="r", modifiers={"spectate"}, min=2, max=2, permission="citizens.npc.spectate")
    public void spectate(CommandContext args, Player sender, NPC npc) throws CommandException {
        NMS.sendCameraPacket(sender, args.hasFlag('r') ? null : npc.getEntity());
    }

    @Command(aliases={"npc"}, usage="speed [speed]", desc="", modifiers={"speed"}, min=2, max=2, permission="citizens.npc.speed")
    public void speed(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        float newSpeed = (float)Math.abs(args.getDouble(1));
        npc.getNavigator().getDefaultParameters().speedModifier(newSpeed);
        Messaging.sendTr(sender, "citizens.commands.npc.speed.set", Float.valueOf(newSpeed));
    }

    @Command(aliases={"npc"}, usage="swim (--set [true|false])", desc="", modifiers={"swim"}, min=1, max=1, permission="citizens.npc.swim")
    public void swim(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"set"}) Boolean set) throws CommandException {
        boolean swim = set != null ? set : npc.data().get(NPC.Metadata.SWIM, Boolean.valueOf(true)) == false;
        npc.data().setPersistent(NPC.Metadata.SWIM, (Object)swim);
        Messaging.sendTr(sender, swim ? "citizens.commands.npc.swim.set" : "citizens.commands.npc.swim.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="target [name|UUID] (-a[ggressive]) (-c[ancel])", desc="", modifiers={"target"}, flags="ac", min=1, max=2, permission="citizens.npc.target")
    public void target(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) Player player) throws CommandUsageException {
        Player toTarget;
        if (args.hasFlag('c')) {
            npc.getNavigator().cancelNavigation();
            return;
        }
        Object object = player != null ? player : (toTarget = sender instanceof Player ? (Player)sender : null);
        if (toTarget == null) {
            throw new CommandUsageException();
        }
        npc.getNavigator().setTarget((Entity)toTarget, args.hasFlag('a'));
    }

    @Command(aliases={"npc"}, usage="targetable", desc="", modifiers={"targetable"}, min=1, max=1, permission="citizens.npc.targetable")
    public void targetable(CommandContext args, CommandSender sender, NPC npc) {
        boolean targetable = !npc.getOrAddTrait(TargetableTrait.class).isTargetable();
        npc.getOrAddTrait(TargetableTrait.class).setTargetable(targetable);
        if (targetable && npc.getOrAddTrait(MobType.class).getType() == EntityType.PLAYER && npc.shouldRemoveFromPlayerList()) {
            Messaging.sendTr(sender, "citizens.commands.npc.targetable.playerlist-warning", new Object[0]);
            if (args.hasFlag('t')) {
                npc.data().set(NPC.Metadata.REMOVE_FROM_PLAYERLIST, (Object)false);
            } else {
                npc.data().setPersistent(NPC.Metadata.REMOVE_FROM_PLAYERLIST, (Object)false);
            }
            if (npc.isSpawned()) {
                NMS.addOrRemoveFromPlayerList(npc.getEntity(), false);
            }
        }
        Messaging.sendTr(sender, targetable ? "citizens.commands.npc.targetable.set" : "citizens.commands.npc.targetable.unset", npc.getName());
    }

    @Command(aliases={"npc"}, usage="tp (-e(xact))", desc="", modifiers={"tp", "teleport"}, min=1, max=1, flags="e", permission="citizens.npc.tp")
    public void tp(CommandContext args, Player player, NPC npc) {
        Location to = npc.getOrAddTrait(CurrentLocation.class).getLocation();
        if (to == null) {
            Messaging.sendError((CommandSender)player, "citizens.commands.npc.tp.location-not-found");
            return;
        }
        if (!args.hasFlag('e')) {
            to = to.clone().add(to.getDirection().setY(0));
            to.setDirection(to.getDirection().multiply(-1)).setPitch(0.0f);
        }
        player.teleport(to, PlayerTeleportEvent.TeleportCause.COMMAND);
        Messaging.sendTr((CommandSender)player, "citizens.commands.npc.tp.teleported", npc.getName());
    }

    @Command(aliases={"npc"}, usage="tphere (cursor) -c(enter) -f(ront)", desc="", flags="cf", modifiers={"tphere", "tph", "move"}, min=1, max=2, permission="citizens.npc.tphere")
    public void tphere(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Location to = args.getSenderLocation();
        if (to == null) {
            throw new ServerCommandException();
        }
        if (args.argsLength() > 1 && args.getString(1).equalsIgnoreCase("cursor")) {
            if (!(sender instanceof Player)) {
                throw new ServerCommandException();
            }
            Block target = ((Player)sender).getTargetBlock(null, 64);
            if (target == null) {
                throw new CommandException("citizens.commands.npc.tphere.missing-cursor-block");
            }
            to = target.getRelative(BlockFace.UP).getLocation();
        }
        if (!sender.hasPermission("citizens.npc.tphere.multiworld") && npc.getStoredLocation().getWorld() != args.getSenderLocation().getWorld()) {
            throw new CommandException("citizens.commands.npc.tphere.multiworld-not-allowed");
        }
        if (args.hasFlag('c')) {
            to = to.getBlock().getLocation();
            to.setX(to.getX() + 0.5);
            to.setZ(to.getZ() + 0.5);
        }
        if (args.hasFlag('f')) {
            to = to.clone().add(to.getDirection().setY(0));
            to.setDirection(to.getDirection().multiply(-1)).setPitch(0.0f);
        }
        if (!npc.isSpawned()) {
            NPCTeleportEvent event = new NPCTeleportEvent(npc, to);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            npc.spawn(to, SpawnReason.COMMAND);
        } else {
            npc.teleport(to, PlayerTeleportEvent.TeleportCause.COMMAND);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.tphere.teleported", npc.getName(), Util.prettyPrintLocation(args.getSenderLocation()));
    }

    @Command(aliases={"npc"}, usage="tpto [player name|npc id] [player name|npc id]", desc="", modifiers={"tpto"}, min=2, max=3, permission="citizens.npc.tpto", parsePlaceholders=true)
    @Requirements
    public void tpto(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        Player to;
        Entity from;
        block14: {
            int id;
            from = null;
            to = null;
            boolean firstWasPlayer = false;
            if (npc != null) {
                from = npc.getEntity();
            }
            try {
                id = args.getInteger(1);
                NPC fromNPC = CitizensAPI.getNPCRegistry().getById(id);
                if (fromNPC != null) {
                    if (args.argsLength() == 2) {
                        to = fromNPC.getEntity();
                    } else {
                        from = fromNPC.getEntity();
                    }
                }
            }
            catch (NumberFormatException e) {
                if (args.argsLength() == 2) {
                    to = Bukkit.getPlayerExact((String)args.getString(1));
                } else {
                    from = Bukkit.getPlayerExact((String)args.getString(1));
                }
                firstWasPlayer = true;
            }
            if (args.argsLength() == 3) {
                try {
                    id = args.getInteger(2);
                    NPC toNPC = CitizensAPI.getNPCRegistry().getById(id);
                    if (toNPC != null) {
                        to = toNPC.getEntity();
                    }
                }
                catch (NumberFormatException e) {
                    if (firstWasPlayer) break block14;
                    to = Bukkit.getPlayerExact((String)args.getString(2));
                }
            }
        }
        if (from == null) {
            throw new CommandException("citizens.commands.npc.tpto.from-not-found");
        }
        if (to == null) {
            throw new CommandException("citizens.commands.npc.tpto.to-not-found");
        }
        from.teleport((Entity)to);
        Messaging.sendTr(sender, "citizens.commands.npc.tpto.success", new Object[0]);
    }

    @Command(aliases={"npc"}, usage="trackingrange [range]", desc="", modifiers={"trackingrange"}, min=1, max=2, permission="citizens.npc.trackingrange")
    public void trackingrange(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) Integer range) {
        if (range == null) {
            npc.data().remove(NPC.Metadata.TRACKING_RANGE);
        } else {
            npc.data().setPersistent(NPC.Metadata.TRACKING_RANGE, (Object)range);
        }
        Messaging.sendTr(sender, "citizens.commands.npc.trackingrange.set", range);
    }

    @Command(aliases={"npc"}, usage="type [type]", desc="", modifiers={"type"}, min=2, max=2, permission="citizens.npc.type")
    public void type(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1) EntityType type) throws CommandException {
        if (type == null) {
            throw new CommandException("citizens.commands.npc.type.invalid", args.getString(1));
        }
        npc.setBukkitEntityType(type);
        Messaging.sendTr(sender, "citizens.commands.npc.type.set", npc.getName(), args.getString(1));
    }

    @Command(aliases={"npc"}, usage="undo (all)", desc="", modifiers={"undo"}, min=1, max=2, permission="citizens.npc.undo")
    @Requirements
    public void undo(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1, completions={"all"}) String action) throws CommandException {
        if ("all".equalsIgnoreCase(action)) {
            while (this.history.undo(sender)) {
            }
        } else if (this.history.undo(sender)) {
            Messaging.sendTr(sender, "citizens.commands.npc.undo.successful", new Object[0]);
        } else {
            Messaging.sendTr(sender, "citizens.commands.npc.undo.unsuccessful", new Object[0]);
        }
    }

    @Command(aliases={"npc"}, usage="useitem (-o(ffhand))", desc="", modifiers={"useitem"}, min=1, max=1, flags="o", permission="citizens.npc.useitem")
    public void useitem(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        boolean offhand = args.hasFlag('o');
        if (offhand) {
            npc.data().setPersistent(NPC.Metadata.USING_OFFHAND_ITEM, (Object)(npc.data().get(NPC.Metadata.USING_OFFHAND_ITEM, Boolean.valueOf(false)) == false ? 1 : 0));
            Messaging.sendTr(sender, "citizens.commands.npc.useitem.offhand-item-toggled", Boolean.toString((Boolean)npc.data().get(NPC.Metadata.USING_OFFHAND_ITEM)));
        } else {
            npc.data().setPersistent(NPC.Metadata.USING_HELD_ITEM, (Object)(npc.data().get(NPC.Metadata.USING_HELD_ITEM, Boolean.valueOf(false)) == false ? 1 : 0));
            Messaging.sendTr(sender, "citizens.commands.npc.useitem.held-item-toggled", Boolean.toString((Boolean)npc.data().get(NPC.Metadata.USING_HELD_ITEM)));
        }
    }

    @Command(aliases={"npc"}, usage="vulnerable (-t(emporary))", desc="", modifiers={"vulnerable"}, min=1, max=1, flags="t", permission="citizens.npc.vulnerable")
    public void vulnerable(CommandContext args, CommandSender sender, NPC npc) {
        boolean vulnerable;
        boolean bl = vulnerable = !npc.isProtected();
        if (args.hasFlag('t')) {
            npc.data().set(NPC.Metadata.DEFAULT_PROTECTED, (Object)vulnerable);
        } else {
            npc.data().setPersistent(NPC.Metadata.DEFAULT_PROTECTED, (Object)vulnerable);
        }
        String key = vulnerable ? "citizens.commands.npc.vulnerable.stopped" : "citizens.commands.npc.vulnerable.set";
        Messaging.sendTr(sender, key, npc.getName());
    }

    @Command(aliases={"npc"}, usage="wander (add x y z world) | (worldguardregion [region]) | (xyrange [xrange] [yrange])", desc="", modifiers={"wander"}, min=1, max=6, permission="citizens.npc.wander")
    public void wander(CommandContext args, CommandSender sender, NPC npc, @Arg(value=1, completions={"add", "worldguardregion", "xyrange", "pathfind", "delay"}) String command) throws CommandException {
        Waypoints trait = npc.getOrAddTrait(Waypoints.class);
        if (args.argsLength() == 1) {
            if (sender instanceof Player && Editor.hasEditor((Player)sender)) {
                Editor.leave((Player)sender);
            }
            trait.setWaypointProvider(trait.getCurrentProviderName().equals("wander") ? "linear" : "wander");
            Messaging.sendTr(sender, "citizens.commands.waypoints.set-provider", trait.getCurrentProviderName());
            return;
        }
        if (!(trait.getCurrentProvider() instanceof WanderWaypointProvider)) {
            trait.setWaypointProvider("wander");
        }
        WanderWaypointProvider provider = (WanderWaypointProvider)trait.getCurrentProvider();
        if (command.equals("add")) {
            World world;
            if (args.argsLength() < 5) {
                throw new CommandUsageException();
            }
            World world2 = world = args.argsLength() > 5 ? Bukkit.getWorld((String)args.getString(5)) : npc.getStoredLocation().getWorld();
            if (world == null) {
                throw new CommandException("citizens.commands.errors.missing-world");
            }
            Location loc = new Location(world, (double)args.getInteger(2), (double)args.getInteger(3), (double)args.getInteger(4));
            provider.addRegionCentre(loc);
            Messaging.sendTr(sender, "citizens.commands.waypoints.add.waypoint-added", Util.prettyPrintLocation(loc));
        } else if (command.equals("worldguardregion")) {
            if (args.argsLength() != 3) {
                throw new CommandUsageException();
            }
            String region = args.getString(2);
            provider.setWorldGuardRegion(region);
            Messaging.sendTr(sender, "citizens.commands.npc.wander.worldguard-region-set", region);
        } else if (command.equals("xyrange")) {
            if (args.argsLength() != 4) {
                throw new CommandUsageException();
            }
            provider.setXYRange(args.getInteger(2), args.getInteger(3));
            Messaging.sendTr(sender, "citizens.commands.npc.wander.xyrange-set", provider.getXRange(), provider.getYRange());
        } else if (command.equals("pathfind")) {
            if (args.argsLength() != 3) {
                throw new CommandUsageException();
            }
            provider.setPathfind(Boolean.parseBoolean(args.getString(2)));
            Messaging.sendTr(sender, "citizens.commands.npc.wander.pathfind-set", provider.isPathfind());
        } else if (command.equals("delay")) {
            if (args.argsLength() != 3) {
                throw new CommandUsageException();
            }
            provider.setDelay(SpigotUtil.parseTicks(args.getString(2)));
            Messaging.sendTr(sender, "citizens.commands.npc.wander.delay-set", provider.getDelay());
        }
    }

    @Command(aliases={"npc"}, usage="wither (--invulnerable [true|false]) (--invulnerable-ticks [ticks]) (--arrow-shield [true|false])", desc="", modifiers={"wither"}, min=1, requiresFlags=true, max=1, permission="citizens.npc.wither")
    @Requirements(selected=true, ownership=true, types={EntityType.WITHER})
    public void wither(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"invulnerable"}) Boolean invulnerable, @Flag(value={"arrow-shield"}) Boolean arrows, @Flag(value={"invulnerable-ticks"}) Integer invulnerableTicks) throws CommandException {
        WitherTrait trait = npc.getOrAddTrait(WitherTrait.class);
        if (invulnerable != null) {
            trait.setInvulnerable(invulnerable);
        }
        if (invulnerableTicks != null) {
            trait.setInvulnerableTicks(invulnerableTicks);
        }
        if (arrows != null) {
            trait.setBlocksArrows(arrows);
        }
    }

    @Command(aliases={"npc"}, usage="wolf (-s(itting) a(ngry) t(amed) i(nterested)) --collar [hex rgb color|name] --variant [variant]", desc="", modifiers={"wolf"}, min=1, max=1, requiresFlags=true, flags="sati", permission="citizens.npc.wolf")
    @Requirements(selected=true, ownership=true, types={EntityType.WOLF})
    public void wolf(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"collar"}) String collar, @Flag(value={"variant"}, completions={"ASHEN", "BLACK", "CHESTNUT", "PALE", "RUSTY", "SNOWY", "STRIPED", "WOODS", "SPOTTED"}) String variant) throws CommandException {
        WolfModifiers trait = npc.getOrAddTrait(WolfModifiers.class);
        if (args.hasFlag('a')) {
            trait.setAngry(!trait.isAngry());
        }
        if (args.hasFlag('s')) {
            trait.setSitting(!trait.isSitting());
        }
        if (args.hasFlag('t')) {
            trait.setTamed(!trait.isTamed());
        }
        if (args.hasFlag('i')) {
            trait.setInterested(!trait.isInterested());
        }
        if (variant != null) {
            variant = variant.toUpperCase(Locale.ROOT);
            try {
                Wolf.Variant.class.getField(variant);
            }
            catch (Throwable t) {
                throw new CommandUsageException();
            }
            trait.setVariant(variant);
        }
        if (collar != null) {
            String unparsed = collar;
            DyeColor color = null;
            try {
                color = DyeColor.valueOf((String)unparsed.toUpperCase().replace(' ', '_'));
            }
            catch (IllegalArgumentException e) {
                try {
                    int rgb = Integer.parseInt(unparsed.replace("#", ""), 16);
                    color = DyeColor.getByColor((Color)Color.fromRGB((int)rgb));
                }
                catch (NumberFormatException ex) {
                    throw new CommandException("citizens.commands.npc.wolf.unknown-collar-color", unparsed);
                }
            }
            if (color == null) {
                throw new CommandException("citizens.commands.npc.wolf.collar-color-unsupported", unparsed);
            }
            trait.setCollarColor(color);
        }
        Messaging.sendTr(sender, "citizens.commands.wolf.traits-updated", npc.getName(), trait.isAngry(), trait.isSitting(), trait.isTamed(), trait.getCollarColor().name());
    }

    static {
        try {
            SUPPORT_RAYTRACE = World.class.getMethod("rayTraceEntities", Location.class, Vector.class, Double.TYPE) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class OptionalAttributeCompletions
    extends Arg.CompletionsProvider.OptionalKeyedCompletions {
        public OptionalAttributeCompletions() {
            super("org.bukkit.attribute.Attribute");
        }
    }
}

