/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai;

import net.citizensnpcs.api.ai.BehaviorController;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.Selector;

public class SimpleBehaviorController
implements BehaviorController {
    private boolean executing;
    private boolean paused;
    private final Selector selector = Selector.selecting(new Behavior[0]).build();

    @Override
    public void addBehavior(Behavior behavior) {
        this.selector.addBehavior(behavior);
    }

    @Override
    public void clear() {
        this.selector.reset();
        this.selector.getBehaviors().clear();
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void removeBehavior(Behavior behavior) {
        this.selector.removeBehavior(behavior);
    }

    @Override
    public void run() {
        if (this.paused || !this.executing && !this.selector.shouldExecute()) {
            return;
        }
        this.executing = true;
        switch (this.selector.run()) {
            case FAILURE: 
            case SUCCESS: {
                this.selector.reset();
                this.executing = false;
            }
        }
    }

    @Override
    public void setPaused(boolean paused) {
        this.paused = paused;
    }
}

