/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.NMS;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Allay;
import org.bukkit.entity.EntityType;

@TraitName(value="allaytrait")
public class AllayTrait
extends Trait {
    @Persist
    private boolean dancing = false;

    public AllayTrait() {
        super("allaytrait");
    }

    public boolean isDancing() {
        return this.dancing;
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned() || !(this.npc.getCosmeticEntity() instanceof Allay)) {
            return;
        }
        NMS.setAllayDancing(this.npc.getCosmeticEntity(), this.dancing);
    }

    public void setDancing(boolean dance) {
        this.dancing = dance;
    }

    @Command(aliases={"npc"}, usage="allay (-d(ancing))", desc="", modifiers={"allay"}, min=1, max=1, flags="d", permission="citizens.npc.allay")
    @Requirements(selected=true, ownership=true, cosmeticTypes={EntityType.ALLAY})
    public static void allay(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        AllayTrait trait = npc.getOrAddTrait(AllayTrait.class);
        String output = "";
        if (args.hasFlag('d')) {
            trait.setDancing(!trait.isDancing());
            output = output + ' ' + (trait.isDancing() ? Messaging.tr("citizens.commands.npc.allay.dancing-set", npc.getName()) : Messaging.tr("citizens.commands.npc.allay.dancing-unset", npc.getName()));
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(sender, output.trim());
    }
}

