/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.util;

import com.google.common.collect.ForwardingSet;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.citizensnpcs.api.event.NPCLinkToPlayerEvent;
import net.citizensnpcs.api.event.NPCSeenByPlayerEvent;
import net.citizensnpcs.api.event.NPCUnlinkFromPlayerEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_19_R3.entity.EntityHumanNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class CitizensEntityTracker
extends aic.b {
    private final bfh tracker;
    private static final MethodHandle E = NMS.getGetter(aio.class, (String)"e");
    private static final MethodHandle F = NMS.getGetter(aio.class, (String)"f");
    private static volatile Boolean REQUIRES_SYNC = false;
    private static final MethodHandle TRACKER = NMS.getFirstGetter(aic.b.class, bfh.class);
    private static final MethodHandle TRACKER_ENTRY = NMS.getFirstGetter(aic.b.class, aio.class);
    private static final MethodHandle TRACKING_RANGE = NMS.getFirstGetter(aic.b.class, Integer.TYPE);
    private static final MethodHandle TRACKING_RANGE_SETTER = NMS.getFirstFinalSetter(aic.b.class, Integer.TYPE);
    private static final MethodHandle TRACKING_SET_GETTER = NMS.getFirstGetter(aic.b.class, Set.class);
    private static final MethodHandle TRACKING_SET_SETTER = NMS.getFirstFinalSetter(aic.b.class, Set.class);

    public CitizensEntityTracker(aic map, bfh entity, int i, int j2, boolean flag) {
        aic aic2 = map;
        Objects.requireNonNull(aic2);
        super(aic2, entity, i, j2, flag);
        this.tracker = entity;
        try {
            final Set set = TRACKING_SET_GETTER.invoke(this);
            TRACKING_SET_SETTER.invoke(this, new ForwardingSet<ajl>(){

                public boolean add(ajl conn) {
                    boolean res = super.add((Object)conn);
                    if (res) {
                        Bukkit.getPluginManager().callEvent((Event)new NPCLinkToPlayerEvent(((NPCHolder)CitizensEntityTracker.this.tracker).getNPC(), (Player)conn.f().getBukkitEntity()));
                    }
                    return res;
                }

                protected Set<ajl> delegate() {
                    return set;
                }

                public boolean remove(Object conn) {
                    boolean removed = super.remove(conn);
                    if (removed) {
                        Bukkit.getPluginManager().callEvent((Event)new NPCUnlinkFromPlayerEvent(((NPCHolder)CitizensEntityTracker.this.tracker).getNPC(), (Player)((ajl)conn).f().getBukkitEntity()));
                    }
                    return removed;
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public CitizensEntityTracker(aic map, aic.b entry) {
        this(map, CitizensEntityTracker.getTracker(entry), CitizensEntityTracker.getTrackingDistance(entry), CitizensEntityTracker.getE(entry), CitizensEntityTracker.getF(entry));
    }

    public void b(aiq entityplayer) {
        if (entityplayer instanceof EntityHumanNPC) {
            return;
        }
        if (!this.f.contains(entityplayer.b) && this.tracker instanceof NPCHolder) {
            boolean cancelled;
            NPC npc = ((NPCHolder)this.tracker).getNPC();
            if (REQUIRES_SYNC == null) {
                REQUIRES_SYNC = !Bukkit.isPrimaryThread();
            }
            if (cancelled = ((Boolean)Util.callPossiblySync(() -> {
                NPCSeenByPlayerEvent event = new NPCSeenByPlayerEvent(npc, (Player)entityplayer.getBukkitEntity());
                try {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                catch (IllegalStateException e) {
                    REQUIRES_SYNC = true;
                    throw e;
                }
                if (event.isCancelled()) {
                    return true;
                }
                Integer trackingRange = (Integer)npc.data().get(NPC.Metadata.TRACKING_RANGE);
                if (TRACKING_RANGE_SETTER != null && trackingRange != null && ((Integer)npc.data().get("last-tracking-range", (Object)-1)).intValue() != trackingRange.intValue()) {
                    try {
                        TRACKING_RANGE_SETTER.invoke(this, trackingRange);
                        npc.data().set("last-tracking-range", (Object)trackingRange);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                return false;
            }, (boolean)REQUIRES_SYNC)).booleanValue()) {
                return;
            }
        }
        super.b(entityplayer);
    }

    private static int getE(aic.b entry) {
        try {
            return E.invoke(TRACKER_ENTRY.invoke(entry));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static boolean getF(aic.b entry) {
        try {
            return F.invoke(TRACKER_ENTRY.invoke(entry));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Collection<Player> getSeenBy(aic.b tracker) {
        return tracker.f.stream().map(c2 -> c2.f().getBukkitEntity()).collect(Collectors.toSet());
    }

    private static bfh getTracker(aic.b entry) {
        try {
            return TRACKER.invoke(entry);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static int getTrackingDistance(aic.b entry) {
        try {
            return TRACKING_RANGE.invoke(entry);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 0;
        }
    }
}

