/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.util;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import net.citizensnpcs.nms.v1_19_R3.util.EntityNodeEvaluatorBase;

public class EntityNodeEvaluator
extends EntityNodeEvaluatorBase {
    private final Object2BooleanMap collisionCache = new Object2BooleanOpenHashMap();
    protected float oldWaterCost;
    private final Long2ObjectMap pathTypesByPosCache = new Long2ObjectOpenHashMap();
    private static final double DEFAULT_MOB_JUMP_HEIGHT = 1.125;
    public static final double SPACE_BETWEEN_WALL_POSTS = 0.5;

    private boolean canReachWithoutCollision(dwx var0) {
        ecz var1 = this.mob.cD();
        ede var2 = new ede((double)var0.a - this.mob.dl() + var1.b() / 2.0, (double)var0.b - this.mob.dn() + var1.c() / 2.0, (double)var0.c - this.mob.dr() + var1.d() / 2.0);
        int var3 = apj.c((double)(var2.f() / var1.a()));
        var2 = var2.a((double)(1.0f / (float)var3));
        for (int var4 = 1; var4 <= var3; ++var4) {
            if (!this.hasCollisions(var1 = var1.c(var2))) continue;
            return false;
        }
        return true;
    }

    protected boolean canStartAt(gt var0) {
        dwv var1 = this.getBlockPathType(this.mob, var0);
        return var1 != dwv.b && this.mvmt.getPathfindingMalus(var1) >= 0.0f;
    }

    @Override
    public void b() {
        this.mvmt.setPathfindingMalus(dwv.j, this.oldWaterCost);
        this.pathTypesByPosCache.clear();
        this.collisionCache.clear();
        super.b();
    }

    protected dwv evaluateBlockPathType(clo var0, gt var1, dwv var2) {
        boolean var3 = this.d();
        if (var2 == dwv.s && this.e() && var3) {
            var2 = dwv.d;
        }
        if (var2 == dwv.r && !var3) {
            var2 = dwv.a;
        }
        if (var2 == dwv.l && !(var0.a_(var1).b() instanceof coy) && !(var0.a_(var1.d()).b() instanceof coy)) {
            var2 = dwv.m;
        }
        return var2;
    }

    protected dwx findAcceptedNode(int var0, int var1, int var2, int var3, double var4, gz var6, dwv var7) {
        dwx var8 = null;
        gt.a var9 = new gt.a();
        double var10 = this.getFloorLevel((gt)var9.d(var0, var1, var2));
        if (var10 - var4 > this.getMobJumpHeight()) {
            return null;
        }
        dwv var12 = this.getCachedBlockType(this.mob, var0, var1, var2);
        float var13 = this.mvmt.getPathfindingMalus(var12);
        double var14 = (double)this.mob.dc() / 2.0;
        if (var13 >= 0.0f) {
            var8 = this.getNodeAndUpdateCostToMax(var0, var1, var2, var12, var13);
        }
        if (EntityNodeEvaluator.doesBlockHavePartialCollision(var7) && var8 != null && var8.k >= 0.0f && !this.canReachWithoutCollision(var8)) {
            var8 = null;
        }
        if (var12 == dwv.c || this.isAmphibious() && var12 == dwv.j) {
            double var18;
            double var16;
            ecz var20;
            if ((var8 == null || var8.k < 0.0f) && var3 > 0 && (var12 != dwv.h || this.g()) && var12 != dwv.m && var12 != dwv.e && var12 != dwv.f && (var8 = this.findAcceptedNode(var0, var1 + 1, var2, var3 - 1, var4, var6, var7)) != null && (var8.l == dwv.b || var8.l == dwv.c) && this.mob.dc() < 1.0f && this.hasCollisions(var20 = new ecz((var16 = (double)(var0 - var6.j()) + 0.5) - var14, this.getFloorLevel((gt)var9.b(var16, (double)(var1 + 1), var18 = (double)(var2 - var6.l()) + 0.5)) + 0.001, var18 - var14, var16 + var14, (double)this.mob.dd() + this.getFloorLevel((gt)var9.b((double)var8.a, (double)var8.b, (double)var8.c)) - 0.002, var18 + var14))) {
                var8 = null;
            }
            if (!this.isAmphibious() && var12 == dwv.j && !this.f()) {
                if (this.getCachedBlockType(this.mob, var0, var1 - 1, var2) != dwv.j) {
                    return var8;
                }
                while (var1 > this.mob.H.v_()) {
                    if ((var12 = this.getCachedBlockType(this.mob, var0, --var1, var2)) != dwv.j) {
                        return var8;
                    }
                    var8 = this.getNodeAndUpdateCostToMax(var0, var1, var2, var12, this.mvmt.getPathfindingMalus(var12));
                }
            }
            if (var12 == dwv.b) {
                int var162 = 0;
                int var17 = var1;
                while (var12 == dwv.b) {
                    if (--var1 < this.mob.H.v_()) {
                        return this.getBlockedNode(var0, var17, var2);
                    }
                    if (var162++ >= this.mob.cp()) {
                        return this.getBlockedNode(var0, var1, var2);
                    }
                    var12 = this.getCachedBlockType(this.mob, var0, var1, var2);
                    var13 = this.mvmt.getPathfindingMalus(var12);
                    if (var12 != dwv.b && var13 >= 0.0f) {
                        var8 = this.getNodeAndUpdateCostToMax(var0, var1, var2, var12, var13);
                        break;
                    }
                    if (!(var13 < 0.0f)) continue;
                    return this.getBlockedNode(var0, var1, var2);
                }
            }
            if (EntityNodeEvaluator.doesBlockHavePartialCollision(var12) && var8 == null) {
                var8 = this.b(var0, var1, var2);
                var8.i = true;
                var8.l = var12;
                var8.k = var12.a();
            }
        }
        return var8;
    }

    private dwx getBlockedNode(int var0, int var1, int var2) {
        dwx var3 = this.b(var0, var1, var2);
        var3.l = dwv.a;
        var3.k = -1.0f;
        return var3;
    }

    public dwv a(clo var0, int var1, int var2, int var3) {
        return EntityNodeEvaluator.getBlockPathTypeStatic(var0, new gt.a(var1, var2, var3));
    }

    public dwv getBlockPathType(clo var0, int var1, int var2, int var3, bfx var4) {
        EnumSet<dwv> var5 = EnumSet.noneOf(dwv.class);
        dwv var6 = dwv.a;
        var6 = this.getBlockPathTypes(var0, var1, var2, var3, var5, var6, var4.dg());
        if (var5.contains(dwv.h)) {
            return dwv.h;
        }
        if (var5.contains(dwv.m)) {
            return dwv.m;
        }
        dwv var7 = dwv.a;
        for (dwv varr9 : var5) {
            if (this.mvmt.getPathfindingMalus(varr9) < 0.0f) {
                return varr9;
            }
            if (!(this.mvmt.getPathfindingMalus(varr9) >= this.mvmt.getPathfindingMalus(var7))) continue;
            var7 = varr9;
        }
        if (var6 == dwv.b && this.mvmt.getPathfindingMalus(var7) == 0.0f && this.d <= 1) {
            return dwv.b;
        }
        return var7;
    }

    public dwv a(clo var0, int var1, int var2, int var3, bfz var4) {
        EnumSet<dwv> var5 = EnumSet.noneOf(dwv.class);
        dwv var6 = dwv.a;
        var6 = this.getBlockPathTypes(var0, var1, var2, var3, var5, var6, var4.dg());
        if (var5.contains(dwv.h)) {
            return dwv.h;
        }
        if (var5.contains(dwv.m)) {
            return dwv.m;
        }
        dwv var7 = dwv.a;
        for (dwv varr9 : var5) {
            if (var4.a(varr9) < 0.0f) {
                return varr9;
            }
            if (!(var4.a(varr9) >= var4.a(var7))) continue;
            var7 = varr9;
        }
        if (var6 == dwv.b && var4.a(var7) == 0.0f && this.d <= 1) {
            return dwv.b;
        }
        return var7;
    }

    protected dwv getBlockPathType(bfx var0, gt var1) {
        return this.getCachedBlockType(var0, var1.u(), var1.v(), var1.w());
    }

    public dwv getBlockPathTypes(clo var0, int var1, int var2, int var3, EnumSet var4, dwv var5, gt var6) {
        for (int var7 = 0; var7 < this.d; ++var7) {
            for (int var8 = 0; var8 < this.e; ++var8) {
                for (int var9 = 0; var9 < this.f; ++var9) {
                    int var10 = var7 + var1;
                    int var11 = var8 + var2;
                    int var12 = var9 + var3;
                    dwv var13 = this.a(var0, var10, var11, var12);
                    var13 = this.evaluateBlockPathType(var0, var6, var13);
                    if (var7 == 0 && var8 == 0 && var9 == 0) {
                        var5 = var13;
                    }
                    var4.add(var13);
                }
            }
        }
        return var5;
    }

    protected dwv getCachedBlockType(bfx var0, int var1, int var2, int var3) {
        return (dwv)this.pathTypesByPosCache.computeIfAbsent(gt.a((int)var1, (int)var2, (int)var3), var4 -> this.getBlockPathType((clo)this.a, var1, var2, var3, var0));
    }

    protected double getFloorLevel(gt var0) {
        return (this.f() || this.isAmphibious()) && this.a.b_(var0).a(anl.a) ? (double)var0.v() + 0.5 : EntityNodeEvaluator.getFloorLevel((clo)this.a, var0);
    }

    public dxd a(double var0, double var2, double var4) {
        return this.a(this.b(apj.a((double)var0), apj.a((double)var2), apj.a((double)var4)));
    }

    private double getMobJumpHeight() {
        return Math.max(1.125, (double)this.mob.dA());
    }

    public int a(dwx[] var0, dwx var1) {
        dwx var15;
        dwx var14;
        dwx var13;
        dwx var12;
        dwx var11;
        dwx var10;
        dwx var9;
        double var6;
        dwx var8;
        int var2 = 0;
        int var3 = 0;
        dwv var4 = this.getCachedBlockType(this.mob, var1.a, var1.b + 1, var1.c);
        dwv var5 = this.getCachedBlockType(this.mob, var1.a, var1.b, var1.c);
        if (this.mvmt.getPathfindingMalus(var4) >= 0.0f && var5 != dwv.w) {
            var3 = apj.d((float)Math.max(1.0f, this.mob.dA()));
        }
        if (this.isNeighborValid(var8 = this.findAcceptedNode(var1.a, var1.b, var1.c + 1, var3, var6 = this.getFloorLevel(new gt(var1.a, var1.b, var1.c)), gz.d, var5), var1)) {
            var0[var2++] = var8;
        }
        if (this.isNeighborValid(var9 = this.findAcceptedNode(var1.a - 1, var1.b, var1.c, var3, var6, gz.e, var5), var1)) {
            var0[var2++] = var9;
        }
        if (this.isNeighborValid(var10 = this.findAcceptedNode(var1.a + 1, var1.b, var1.c, var3, var6, gz.f, var5), var1)) {
            var0[var2++] = var10;
        }
        if (this.isNeighborValid(var11 = this.findAcceptedNode(var1.a, var1.b, var1.c - 1, var3, var6, gz.c, var5), var1)) {
            var0[var2++] = var11;
        }
        if (this.isDiagonalValid(var1, var9, var11, var12 = this.findAcceptedNode(var1.a - 1, var1.b, var1.c - 1, var3, var6, gz.c, var5))) {
            var0[var2++] = var12;
        }
        if (this.isDiagonalValid(var1, var10, var11, var13 = this.findAcceptedNode(var1.a + 1, var1.b, var1.c - 1, var3, var6, gz.c, var5))) {
            var0[var2++] = var13;
        }
        if (this.isDiagonalValid(var1, var9, var8, var14 = this.findAcceptedNode(var1.a - 1, var1.b, var1.c + 1, var3, var6, gz.d, var5))) {
            var0[var2++] = var14;
        }
        if (this.isDiagonalValid(var1, var10, var8, var15 = this.findAcceptedNode(var1.a + 1, var1.b, var1.c + 1, var3, var6, gz.d, var5))) {
            var0[var2++] = var15;
        }
        return var2;
    }

    private dwx getNodeAndUpdateCostToMax(int var0, int var1, int var2, dwv var3, float var4) {
        dwx var5 = this.b(var0, var1, var2);
        var5.l = var3;
        var5.k = Math.max(var5.k, var4);
        return var5;
    }

    public dwx a() {
        gt var3;
        int var0;
        gt.a var1;
        block12: {
            var1 = new gt.a();
            var0 = this.mob.dm();
            dbq var2 = this.a.a_((gt)var1.b(this.mob.dl(), (double)var0, this.mob.dr()));
            if (!this.mob.a(var2.r())) {
                if (this.f() && this.mob.aT()) {
                    while (true) {
                        if (!var2.a(cpj.G) && var2.r() != dwk.c.a(false)) {
                            --var0;
                            break block12;
                        }
                        var2 = this.a.a_((gt)var1.b(this.mob.dl(), (double)(++var0), this.mob.dr()));
                    }
                }
                if (this.mob.ax()) {
                    var0 = apj.a((double)(this.mob.dn() + 0.5));
                } else {
                    var3 = this.mob.dg();
                    while ((this.a.a_(var3).h() || this.a.a_(var3).a((clo)this.a, var3, dxa.a)) && var3.v() > this.mob.H.v_()) {
                        var3 = var3.d();
                    }
                    var0 = var3.c().v();
                }
            } else {
                while (true) {
                    if (!this.mob.a(var2.r())) {
                        --var0;
                        break;
                    }
                    var2 = this.a.a_((gt)var1.b(this.mob.dl(), (double)(++var0), this.mob.dr()));
                }
            }
        }
        var3 = this.mob.dg();
        if (!this.canStartAt((gt)var1.d(var3.u(), var0, var3.w()))) {
            ecz var4 = this.mob.cD();
            if (this.canStartAt((gt)var1.b(var4.a, (double)var0, var4.c)) || this.canStartAt((gt)var1.b(var4.a, (double)var0, var4.f)) || this.canStartAt((gt)var1.b(var4.d, (double)var0, var4.c)) || this.canStartAt((gt)var1.b(var4.d, (double)var0, var4.f))) {
                return this.getStartNode((gt)var1);
            }
        }
        return this.getStartNode(new gt(var3.u(), var0, var3.w()));
    }

    protected dwx getStartNode(gt var0) {
        dwx var1 = this.b(var0);
        var1.l = this.getBlockPathType(this.mob, var1.a());
        var1.k = this.mvmt.getPathfindingMalus(var1.l);
        return var1;
    }

    private boolean hasCollisions(ecz var0) {
        return this.collisionCache.computeIfAbsent((Object)var0, var1 -> !this.a.a((bfh)this.mob, var0));
    }

    protected boolean isAmphibious() {
        return false;
    }

    protected boolean isDiagonalValid(dwx var0, dwx var1, dwx var2, dwx var3) {
        if (var3 == null || var2 == null || var1 == null || var3.i) {
            return false;
        }
        if (var2.b <= var0.b && var1.b <= var0.b) {
            if (var1.l != dwv.d && var2.l != dwv.d && var3.l != dwv.d) {
                boolean var4 = var2.l == dwv.h && var1.l == dwv.h && (double)this.mob.dc() < 0.5;
                return var3.k >= 0.0f && (var2.b < var0.b || var2.k >= 0.0f || var4) && (var1.b < var0.b || var1.k >= 0.0f || var4);
            }
            return false;
        }
        return false;
    }

    protected boolean isNeighborValid(dwx var0, dwx var1) {
        return var0 != null && !var0.i && (var0.k >= 0.0f || var1.k < 0.0f);
    }

    @Override
    public void prepare(cmv var0, bfx var1) {
        super.prepare(var0, var1);
        this.oldWaterCost = this.mvmt.getPathfindingMalus(dwv.j);
    }

    @Override
    public void a(cmv var0, bfz var1) {
        super.a(var0, var1);
        this.oldWaterCost = var1.a(dwv.j);
    }

    public static dwv checkNeighbourBlocks(clo var0, gt.a var1, dwv var2) {
        int var3 = var1.u();
        int var4 = var1.v();
        int var5 = var1.w();
        for (int var6 = -1; var6 <= 1; ++var6) {
            for (int var7 = -1; var7 <= 1; ++var7) {
                for (int var8 = -1; var8 <= 1; ++var8) {
                    if (var6 == 0 && var8 == 0) continue;
                    var1.d(var3 + var6, var4 + var7, var5 + var8);
                    dbq var9 = var0.a_((gt)var1);
                    if (var9.a(cpj.dP) || var9.a(cpj.oe)) {
                        return dwv.p;
                    }
                    if (EntityNodeEvaluator.isBurningBlock(var9)) {
                        return dwv.n;
                    }
                    if (!var0.b_((gt)var1).a(anl.a)) continue;
                    return dwv.k;
                }
            }
        }
        return var2;
    }

    private static boolean doesBlockHavePartialCollision(dwv var0) {
        return var0 == dwv.h || var0 == dwv.s || var0 == dwv.t;
    }

    protected static dwv getBlockPathTypeRaw(clo var0, gt var1) {
        dbq var2 = var0.a_(var1);
        cpi var3 = var2.b();
        dwn var4 = var2.d();
        if (var2.h()) {
            return dwv.b;
        }
        if (!(var2.a(ang.O) || var2.a(cpj.fl) || var2.a(cpj.rx))) {
            if (var2.a(cpj.qy)) {
                return dwv.f;
            }
            if (!var2.a(cpj.dP) && !var2.a(cpj.oe)) {
                if (var2.a(cpj.pc)) {
                    return dwv.w;
                }
                if (var2.a(cpj.fB)) {
                    return dwv.x;
                }
                dwj var5 = var0.b_(var1);
                if (var5.a(anl.b)) {
                    return dwv.i;
                }
                if (EntityNodeEvaluator.isBurningBlock(var2)) {
                    return dwv.o;
                }
                if (cri.n((dbq)var2) && !((Boolean)var2.c((dcu)cri.b)).booleanValue()) {
                    return dwv.s;
                }
                if (var3 instanceof cri && var4 == dwn.K && !((Boolean)var2.c((dcu)cri.b)).booleanValue()) {
                    return dwv.t;
                }
                if (var3 instanceof cri && ((Boolean)var2.c((dcu)cri.b)).booleanValue()) {
                    return dwv.r;
                }
                if (var3 instanceof coy) {
                    return dwv.l;
                }
                if (var3 instanceof ctm) {
                    return dwv.v;
                }
                if (var2.a(ang.R) || var2.a(ang.K) || var3 instanceof csa && !((Boolean)var2.c((dcu)csa.a)).booleanValue()) {
                    return dwv.h;
                }
                if (!var2.a(var0, var1, dxa.a)) {
                    return dwv.a;
                }
                return var5.a(anl.a) ? dwv.j : dwv.b;
            }
            return dwv.q;
        }
        return dwv.e;
    }

    public static dwv getBlockPathTypeStatic(clo var0, gt.a var1) {
        int var2 = var1.u();
        int var3 = var1.v();
        int var4 = var1.w();
        dwv var5 = EntityNodeEvaluator.getBlockPathTypeRaw(var0, (gt)var1);
        if (var5 == dwv.b && var3 >= var0.v_() + 1) {
            dwv var6 = EntityNodeEvaluator.getBlockPathTypeRaw(var0, (gt)var1.d(var2, var3 - 1, var4));
            dwv dwv2 = var5 = var6 != dwv.c && var6 != dwv.b && var6 != dwv.j && var6 != dwv.i ? dwv.c : dwv.b;
            if (var6 == dwv.o) {
                var5 = dwv.o;
            }
            if (var6 == dwv.q) {
                var5 = dwv.q;
            }
            if (var6 == dwv.w) {
                var5 = dwv.w;
            }
            if (var6 == dwv.f) {
                var5 = dwv.g;
            }
        }
        if (var5 == dwv.c) {
            var5 = EntityNodeEvaluator.checkNeighbourBlocks(var0, var1.d(var2, var3, var4), var5);
        }
        return var5;
    }

    public static double getFloorLevel(clo var0, gt var1) {
        gt var2 = var1.d();
        edx var3 = var0.a_(var2).k(var0, var2);
        return (double)var2.v() + (var3.b() ? 0.0 : var3.c(gz.a.b));
    }

    public static boolean isBurningBlock(dbq var0) {
        return var0.a(ang.aH) || var0.a(cpj.H) || var0.a(cpj.kG) || cpt.g((dbq)var0) || var0.a(cpj.fu);
    }
}

