/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_19_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_19_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_19_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_19_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Position;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPillager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Pillager;
import org.bukkit.util.Vector;

public class PillagerController
extends MobEntityController {
    public PillagerController() {
        super(EntityPillagerNPC.class);
    }

    public Pillager getBukkitEntity() {
        return (Pillager)super.getBukkitEntity();
    }

    public static class EntityPillagerNPC
    extends EntityPillager
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityPillagerNPC(EntityTypes<? extends EntityPillager> types, World level) {
            this(types, level, null);
        }

        public EntityPillagerNPC(EntityTypes<? extends EntityPillager> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        protected boolean l(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.l(entity);
        }

        public boolean a(float f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public void ds() {
            if (this.npc == null) {
                super.ds();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public void U() {
            super.U();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState((NPC)this.npc, (EntityInsentient)this);
                this.npc.update();
            }
        }

        protected SoundEffect s() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.s(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new PillagerNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect x_() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.x_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect d(DamageSource damagesource) {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.d(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float eQ() {
            return NMS.getJumpPower((NPC)this.npc, (float)super.eQ());
        }

        public int cp() {
            return NMS.getFallDistance((NPC)this.npc, (int)super.cp());
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction C_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.C_();
        }

        public boolean fI() {
            return NMSImpl.isLeashed((NPC)this.npc, () -> super.fI(), (EntityInsentient)this);
        }

        public boolean bn() {
            return this.npc == null ? super.bn() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        public void q(double strength, double dx, double dz) {
            NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.q((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB am() {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.am());
        }

        public boolean z_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.z_();
            }
            return false;
        }

        public void a(DataWatcherObject<?> datawatcherobject) {
            if (this.npc == null) {
                super.a(datawatcherobject);
                return;
            }
            NMSImpl.checkAndUpdateHeight((EntityLiving)this, datawatcherobject, x$0 -> super.a(x$0));
        }

        public void j(double x, double y, double z) {
            Vector vector = Util.callPushEvent((NPC)this.npc, (double)x, (double)y, (double)z);
            if (vector != null) {
                super.j(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(net.minecraft.world.entity.Entity entity) {
            super.g(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(WorldServer worldserver, Position location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void h(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.h(vec3d);
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dj().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.f(old);
            }
            return res;
        }
    }

    public static class PillagerNPC
    extends CraftPillager
    implements ForwardingNPCHolder {
        public PillagerNPC(EntityPillagerNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPillager)entity);
        }
    }
}

