/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.util;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import net.citizensnpcs.nms.v1_19_R3.util.EntityNodeEvaluatorBase;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntityNodeEvaluator
extends EntityNodeEvaluatorBase {
    private final Object2BooleanMap collisionCache = new Object2BooleanOpenHashMap();
    protected float oldWaterCost;
    private final Long2ObjectMap pathTypesByPosCache = new Long2ObjectOpenHashMap();
    private static final double DEFAULT_MOB_JUMP_HEIGHT = 1.125;
    public static final double SPACE_BETWEEN_WALL_POSTS = 0.5;

    private boolean canReachWithoutCollision(PathPoint var0) {
        AxisAlignedBB var1 = this.mob.cD();
        Vec3D var2 = new Vec3D((double)var0.a - this.mob.dl() + var1.b() / 2.0, (double)var0.b - this.mob.dn() + var1.c() / 2.0, (double)var0.c - this.mob.dr() + var1.d() / 2.0);
        int var3 = MathHelper.c((double)(var2.f() / var1.a()));
        var2 = var2.a((double)(1.0f / (float)var3));
        for (int var4 = 1; var4 <= var3; ++var4) {
            if (!this.hasCollisions(var1 = var1.c(var2))) continue;
            return false;
        }
        return true;
    }

    protected boolean canStartAt(BlockPosition var0) {
        PathType var1 = this.getBlockPathType(this.mob, var0);
        return var1 != PathType.b && this.mvmt.getPathfindingMalus(var1) >= 0.0f;
    }

    @Override
    public void b() {
        this.mvmt.setPathfindingMalus(PathType.j, this.oldWaterCost);
        this.pathTypesByPosCache.clear();
        this.collisionCache.clear();
        super.b();
    }

    protected PathType evaluateBlockPathType(IBlockAccess var0, BlockPosition var1, PathType var2) {
        boolean var3 = this.d();
        if (var2 == PathType.s && this.e() && var3) {
            var2 = PathType.d;
        }
        if (var2 == PathType.r && !var3) {
            var2 = PathType.a;
        }
        if (var2 == PathType.l && !(var0.a_(var1).b() instanceof BlockMinecartTrackAbstract) && !(var0.a_(var1.d()).b() instanceof BlockMinecartTrackAbstract)) {
            var2 = PathType.m;
        }
        return var2;
    }

    protected PathPoint findAcceptedNode(int var0, int var1, int var2, int var3, double var4, EnumDirection var6, PathType var7) {
        PathPoint var8 = null;
        BlockPosition.MutableBlockPosition var9 = new BlockPosition.MutableBlockPosition();
        double var10 = this.getFloorLevel((BlockPosition)var9.d(var0, var1, var2));
        if (var10 - var4 > this.getMobJumpHeight()) {
            return null;
        }
        PathType var12 = this.getCachedBlockType(this.mob, var0, var1, var2);
        float var13 = this.mvmt.getPathfindingMalus(var12);
        double var14 = (double)this.mob.dc() / 2.0;
        if (var13 >= 0.0f) {
            var8 = this.getNodeAndUpdateCostToMax(var0, var1, var2, var12, var13);
        }
        if (EntityNodeEvaluator.doesBlockHavePartialCollision(var7) && var8 != null && var8.k >= 0.0f && !this.canReachWithoutCollision(var8)) {
            var8 = null;
        }
        if (var12 == PathType.c || this.isAmphibious() && var12 == PathType.j) {
            double var18;
            double var16;
            AxisAlignedBB var20;
            if ((var8 == null || var8.k < 0.0f) && var3 > 0 && (var12 != PathType.h || this.g()) && var12 != PathType.m && var12 != PathType.e && var12 != PathType.f && (var8 = this.findAcceptedNode(var0, var1 + 1, var2, var3 - 1, var4, var6, var7)) != null && (var8.l == PathType.b || var8.l == PathType.c) && this.mob.dc() < 1.0f && this.hasCollisions(var20 = new AxisAlignedBB((var16 = (double)(var0 - var6.j()) + 0.5) - var14, this.getFloorLevel((BlockPosition)var9.b(var16, (double)(var1 + 1), var18 = (double)(var2 - var6.l()) + 0.5)) + 0.001, var18 - var14, var16 + var14, (double)this.mob.dd() + this.getFloorLevel((BlockPosition)var9.b((double)var8.a, (double)var8.b, (double)var8.c)) - 0.002, var18 + var14))) {
                var8 = null;
            }
            if (!this.isAmphibious() && var12 == PathType.j && !this.f()) {
                if (this.getCachedBlockType(this.mob, var0, var1 - 1, var2) != PathType.j) {
                    return var8;
                }
                while (var1 > this.mob.H.v_()) {
                    if ((var12 = this.getCachedBlockType(this.mob, var0, --var1, var2)) != PathType.j) {
                        return var8;
                    }
                    var8 = this.getNodeAndUpdateCostToMax(var0, var1, var2, var12, this.mvmt.getPathfindingMalus(var12));
                }
            }
            if (var12 == PathType.b) {
                int var162 = 0;
                int var17 = var1;
                while (var12 == PathType.b) {
                    if (--var1 < this.mob.H.v_()) {
                        return this.getBlockedNode(var0, var17, var2);
                    }
                    if (var162++ >= this.mob.cp()) {
                        return this.getBlockedNode(var0, var1, var2);
                    }
                    var12 = this.getCachedBlockType(this.mob, var0, var1, var2);
                    var13 = this.mvmt.getPathfindingMalus(var12);
                    if (var12 != PathType.b && var13 >= 0.0f) {
                        var8 = this.getNodeAndUpdateCostToMax(var0, var1, var2, var12, var13);
                        break;
                    }
                    if (!(var13 < 0.0f)) continue;
                    return this.getBlockedNode(var0, var1, var2);
                }
            }
            if (EntityNodeEvaluator.doesBlockHavePartialCollision(var12) && var8 == null) {
                var8 = this.b(var0, var1, var2);
                var8.i = true;
                var8.l = var12;
                var8.k = var12.a();
            }
        }
        return var8;
    }

    private PathPoint getBlockedNode(int var0, int var1, int var2) {
        PathPoint var3 = this.b(var0, var1, var2);
        var3.l = PathType.a;
        var3.k = -1.0f;
        return var3;
    }

    public PathType a(IBlockAccess var0, int var1, int var2, int var3) {
        return EntityNodeEvaluator.getBlockPathTypeStatic(var0, new BlockPosition.MutableBlockPosition(var1, var2, var3));
    }

    public PathType getBlockPathType(IBlockAccess var0, int var1, int var2, int var3, EntityLiving var4) {
        EnumSet<PathType> var5 = EnumSet.noneOf(PathType.class);
        PathType var6 = PathType.a;
        var6 = this.getBlockPathTypes(var0, var1, var2, var3, var5, var6, var4.dg());
        if (var5.contains(PathType.h)) {
            return PathType.h;
        }
        if (var5.contains(PathType.m)) {
            return PathType.m;
        }
        PathType var7 = PathType.a;
        for (PathType varr9 : var5) {
            if (this.mvmt.getPathfindingMalus(varr9) < 0.0f) {
                return varr9;
            }
            if (!(this.mvmt.getPathfindingMalus(varr9) >= this.mvmt.getPathfindingMalus(var7))) continue;
            var7 = varr9;
        }
        if (var6 == PathType.b && this.mvmt.getPathfindingMalus(var7) == 0.0f && this.d <= 1) {
            return PathType.b;
        }
        return var7;
    }

    public PathType a(IBlockAccess var0, int var1, int var2, int var3, EntityInsentient var4) {
        EnumSet<PathType> var5 = EnumSet.noneOf(PathType.class);
        PathType var6 = PathType.a;
        var6 = this.getBlockPathTypes(var0, var1, var2, var3, var5, var6, var4.dg());
        if (var5.contains(PathType.h)) {
            return PathType.h;
        }
        if (var5.contains(PathType.m)) {
            return PathType.m;
        }
        PathType var7 = PathType.a;
        for (PathType varr9 : var5) {
            if (var4.a(varr9) < 0.0f) {
                return varr9;
            }
            if (!(var4.a(varr9) >= var4.a(var7))) continue;
            var7 = varr9;
        }
        if (var6 == PathType.b && var4.a(var7) == 0.0f && this.d <= 1) {
            return PathType.b;
        }
        return var7;
    }

    protected PathType getBlockPathType(EntityLiving var0, BlockPosition var1) {
        return this.getCachedBlockType(var0, var1.u(), var1.v(), var1.w());
    }

    public PathType getBlockPathTypes(IBlockAccess var0, int var1, int var2, int var3, EnumSet var4, PathType var5, BlockPosition var6) {
        for (int var7 = 0; var7 < this.d; ++var7) {
            for (int var8 = 0; var8 < this.e; ++var8) {
                for (int var9 = 0; var9 < this.f; ++var9) {
                    int var10 = var7 + var1;
                    int var11 = var8 + var2;
                    int var12 = var9 + var3;
                    PathType var13 = this.a(var0, var10, var11, var12);
                    var13 = this.evaluateBlockPathType(var0, var6, var13);
                    if (var7 == 0 && var8 == 0 && var9 == 0) {
                        var5 = var13;
                    }
                    var4.add(var13);
                }
            }
        }
        return var5;
    }

    protected PathType getCachedBlockType(EntityLiving var0, int var1, int var2, int var3) {
        return (PathType)this.pathTypesByPosCache.computeIfAbsent(BlockPosition.a((int)var1, (int)var2, (int)var3), var4 -> this.getBlockPathType((IBlockAccess)this.a, var1, var2, var3, var0));
    }

    protected double getFloorLevel(BlockPosition var0) {
        return (this.f() || this.isAmphibious()) && this.a.b_(var0).a(TagsFluid.a) ? (double)var0.v() + 0.5 : EntityNodeEvaluator.getFloorLevel((IBlockAccess)this.a, var0);
    }

    public PathDestination a(double var0, double var2, double var4) {
        return this.a(this.b(MathHelper.a((double)var0), MathHelper.a((double)var2), MathHelper.a((double)var4)));
    }

    private double getMobJumpHeight() {
        return Math.max(1.125, (double)this.mob.dA());
    }

    public int a(PathPoint[] var0, PathPoint var1) {
        PathPoint var15;
        PathPoint var14;
        PathPoint var13;
        PathPoint var12;
        PathPoint var11;
        PathPoint var10;
        PathPoint var9;
        double var6;
        PathPoint var8;
        int var2 = 0;
        int var3 = 0;
        PathType var4 = this.getCachedBlockType(this.mob, var1.a, var1.b + 1, var1.c);
        PathType var5 = this.getCachedBlockType(this.mob, var1.a, var1.b, var1.c);
        if (this.mvmt.getPathfindingMalus(var4) >= 0.0f && var5 != PathType.w) {
            var3 = MathHelper.d((float)Math.max(1.0f, this.mob.dA()));
        }
        if (this.isNeighborValid(var8 = this.findAcceptedNode(var1.a, var1.b, var1.c + 1, var3, var6 = this.getFloorLevel(new BlockPosition(var1.a, var1.b, var1.c)), EnumDirection.d, var5), var1)) {
            var0[var2++] = var8;
        }
        if (this.isNeighborValid(var9 = this.findAcceptedNode(var1.a - 1, var1.b, var1.c, var3, var6, EnumDirection.e, var5), var1)) {
            var0[var2++] = var9;
        }
        if (this.isNeighborValid(var10 = this.findAcceptedNode(var1.a + 1, var1.b, var1.c, var3, var6, EnumDirection.f, var5), var1)) {
            var0[var2++] = var10;
        }
        if (this.isNeighborValid(var11 = this.findAcceptedNode(var1.a, var1.b, var1.c - 1, var3, var6, EnumDirection.c, var5), var1)) {
            var0[var2++] = var11;
        }
        if (this.isDiagonalValid(var1, var9, var11, var12 = this.findAcceptedNode(var1.a - 1, var1.b, var1.c - 1, var3, var6, EnumDirection.c, var5))) {
            var0[var2++] = var12;
        }
        if (this.isDiagonalValid(var1, var10, var11, var13 = this.findAcceptedNode(var1.a + 1, var1.b, var1.c - 1, var3, var6, EnumDirection.c, var5))) {
            var0[var2++] = var13;
        }
        if (this.isDiagonalValid(var1, var9, var8, var14 = this.findAcceptedNode(var1.a - 1, var1.b, var1.c + 1, var3, var6, EnumDirection.d, var5))) {
            var0[var2++] = var14;
        }
        if (this.isDiagonalValid(var1, var10, var8, var15 = this.findAcceptedNode(var1.a + 1, var1.b, var1.c + 1, var3, var6, EnumDirection.d, var5))) {
            var0[var2++] = var15;
        }
        return var2;
    }

    private PathPoint getNodeAndUpdateCostToMax(int var0, int var1, int var2, PathType var3, float var4) {
        PathPoint var5 = this.b(var0, var1, var2);
        var5.l = var3;
        var5.k = Math.max(var5.k, var4);
        return var5;
    }

    public PathPoint a() {
        BlockPosition var3;
        int var0;
        BlockPosition.MutableBlockPosition var1;
        block12: {
            var1 = new BlockPosition.MutableBlockPosition();
            var0 = this.mob.dm();
            IBlockData var2 = this.a.a_((BlockPosition)var1.b(this.mob.dl(), (double)var0, this.mob.dr()));
            if (!this.mob.a(var2.r())) {
                if (this.f() && this.mob.aT()) {
                    while (true) {
                        if (!var2.a(Blocks.G) && var2.r() != FluidTypes.c.a(false)) {
                            --var0;
                            break block12;
                        }
                        var2 = this.a.a_((BlockPosition)var1.b(this.mob.dl(), (double)(++var0), this.mob.dr()));
                    }
                }
                if (this.mob.ax()) {
                    var0 = MathHelper.a((double)(this.mob.dn() + 0.5));
                } else {
                    var3 = this.mob.dg();
                    while ((this.a.a_(var3).h() || this.a.a_(var3).a((IBlockAccess)this.a, var3, PathMode.a)) && var3.v() > this.mob.H.v_()) {
                        var3 = var3.d();
                    }
                    var0 = var3.c().v();
                }
            } else {
                while (true) {
                    if (!this.mob.a(var2.r())) {
                        --var0;
                        break;
                    }
                    var2 = this.a.a_((BlockPosition)var1.b(this.mob.dl(), (double)(++var0), this.mob.dr()));
                }
            }
        }
        var3 = this.mob.dg();
        if (!this.canStartAt((BlockPosition)var1.d(var3.u(), var0, var3.w()))) {
            AxisAlignedBB var4 = this.mob.cD();
            if (this.canStartAt((BlockPosition)var1.b(var4.a, (double)var0, var4.c)) || this.canStartAt((BlockPosition)var1.b(var4.a, (double)var0, var4.f)) || this.canStartAt((BlockPosition)var1.b(var4.d, (double)var0, var4.c)) || this.canStartAt((BlockPosition)var1.b(var4.d, (double)var0, var4.f))) {
                return this.getStartNode((BlockPosition)var1);
            }
        }
        return this.getStartNode(new BlockPosition(var3.u(), var0, var3.w()));
    }

    protected PathPoint getStartNode(BlockPosition var0) {
        PathPoint var1 = this.b(var0);
        var1.l = this.getBlockPathType(this.mob, var1.a());
        var1.k = this.mvmt.getPathfindingMalus(var1.l);
        return var1;
    }

    private boolean hasCollisions(AxisAlignedBB var0) {
        return this.collisionCache.computeIfAbsent((Object)var0, var1 -> !this.a.a((Entity)this.mob, var0));
    }

    protected boolean isAmphibious() {
        return false;
    }

    protected boolean isDiagonalValid(PathPoint var0, PathPoint var1, PathPoint var2, PathPoint var3) {
        if (var3 == null || var2 == null || var1 == null || var3.i) {
            return false;
        }
        if (var2.b <= var0.b && var1.b <= var0.b) {
            if (var1.l != PathType.d && var2.l != PathType.d && var3.l != PathType.d) {
                boolean var4 = var2.l == PathType.h && var1.l == PathType.h && (double)this.mob.dc() < 0.5;
                return var3.k >= 0.0f && (var2.b < var0.b || var2.k >= 0.0f || var4) && (var1.b < var0.b || var1.k >= 0.0f || var4);
            }
            return false;
        }
        return false;
    }

    protected boolean isNeighborValid(PathPoint var0, PathPoint var1) {
        return var0 != null && !var0.i && (var0.k >= 0.0f || var1.k < 0.0f);
    }

    @Override
    public void prepare(ChunkCache var0, EntityLiving var1) {
        super.prepare(var0, var1);
        this.oldWaterCost = this.mvmt.getPathfindingMalus(PathType.j);
    }

    @Override
    public void a(ChunkCache var0, EntityInsentient var1) {
        super.a(var0, var1);
        this.oldWaterCost = var1.a(PathType.j);
    }

    public static PathType checkNeighbourBlocks(IBlockAccess var0, BlockPosition.MutableBlockPosition var1, PathType var2) {
        int var3 = var1.u();
        int var4 = var1.v();
        int var5 = var1.w();
        for (int var6 = -1; var6 <= 1; ++var6) {
            for (int var7 = -1; var7 <= 1; ++var7) {
                for (int var8 = -1; var8 <= 1; ++var8) {
                    if (var6 == 0 && var8 == 0) continue;
                    var1.d(var3 + var6, var4 + var7, var5 + var8);
                    IBlockData var9 = var0.a_((BlockPosition)var1);
                    if (var9.a(Blocks.dP) || var9.a(Blocks.oe)) {
                        return PathType.p;
                    }
                    if (EntityNodeEvaluator.isBurningBlock(var9)) {
                        return PathType.n;
                    }
                    if (!var0.b_((BlockPosition)var1).a(TagsFluid.a)) continue;
                    return PathType.k;
                }
            }
        }
        return var2;
    }

    private static boolean doesBlockHavePartialCollision(PathType var0) {
        return var0 == PathType.h || var0 == PathType.s || var0 == PathType.t;
    }

    protected static PathType getBlockPathTypeRaw(IBlockAccess var0, BlockPosition var1) {
        IBlockData var2 = var0.a_(var1);
        Block var3 = var2.b();
        Material var4 = var2.d();
        if (var2.h()) {
            return PathType.b;
        }
        if (!(var2.a(TagsBlock.O) || var2.a(Blocks.fl) || var2.a(Blocks.rx))) {
            if (var2.a(Blocks.qy)) {
                return PathType.f;
            }
            if (!var2.a(Blocks.dP) && !var2.a(Blocks.oe)) {
                if (var2.a(Blocks.pc)) {
                    return PathType.w;
                }
                if (var2.a(Blocks.fB)) {
                    return PathType.x;
                }
                Fluid var5 = var0.b_(var1);
                if (var5.a(TagsFluid.b)) {
                    return PathType.i;
                }
                if (EntityNodeEvaluator.isBurningBlock(var2)) {
                    return PathType.o;
                }
                if (BlockDoor.n((IBlockData)var2) && !((Boolean)var2.c((IBlockState)BlockDoor.b)).booleanValue()) {
                    return PathType.s;
                }
                if (var3 instanceof BlockDoor && var4 == Material.K && !((Boolean)var2.c((IBlockState)BlockDoor.b)).booleanValue()) {
                    return PathType.t;
                }
                if (var3 instanceof BlockDoor && ((Boolean)var2.c((IBlockState)BlockDoor.b)).booleanValue()) {
                    return PathType.r;
                }
                if (var3 instanceof BlockMinecartTrackAbstract) {
                    return PathType.l;
                }
                if (var3 instanceof BlockLeaves) {
                    return PathType.v;
                }
                if (var2.a(TagsBlock.R) || var2.a(TagsBlock.K) || var3 instanceof BlockFenceGate && !((Boolean)var2.c((IBlockState)BlockFenceGate.a)).booleanValue()) {
                    return PathType.h;
                }
                if (!var2.a(var0, var1, PathMode.a)) {
                    return PathType.a;
                }
                return var5.a(TagsFluid.a) ? PathType.j : PathType.b;
            }
            return PathType.q;
        }
        return PathType.e;
    }

    public static PathType getBlockPathTypeStatic(IBlockAccess var0, BlockPosition.MutableBlockPosition var1) {
        int var2 = var1.u();
        int var3 = var1.v();
        int var4 = var1.w();
        PathType var5 = EntityNodeEvaluator.getBlockPathTypeRaw(var0, (BlockPosition)var1);
        if (var5 == PathType.b && var3 >= var0.v_() + 1) {
            PathType var6 = EntityNodeEvaluator.getBlockPathTypeRaw(var0, (BlockPosition)var1.d(var2, var3 - 1, var4));
            PathType pathType = var5 = var6 != PathType.c && var6 != PathType.b && var6 != PathType.j && var6 != PathType.i ? PathType.c : PathType.b;
            if (var6 == PathType.o) {
                var5 = PathType.o;
            }
            if (var6 == PathType.q) {
                var5 = PathType.q;
            }
            if (var6 == PathType.w) {
                var5 = PathType.w;
            }
            if (var6 == PathType.f) {
                var5 = PathType.g;
            }
        }
        if (var5 == PathType.c) {
            var5 = EntityNodeEvaluator.checkNeighbourBlocks(var0, var1.d(var2, var3, var4), var5);
        }
        return var5;
    }

    public static double getFloorLevel(IBlockAccess var0, BlockPosition var1) {
        BlockPosition var2 = var1.d();
        VoxelShape var3 = var0.a_(var2).k(var0, var2);
        return (double)var2.v() + (var3.b() ? 0.0 : var3.c(EnumDirection.EnumAxis.b));
    }

    public static boolean isBurningBlock(IBlockData var0) {
        return var0.a(TagsBlock.aH) || var0.a(Blocks.H) || var0.a(Blocks.kG) || BlockCampfire.g((IBlockData)var0) || var0.a(Blocks.fu);
    }
}

