/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.nms.v1_19_R3.util.NMSImpl;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class PlayerAnimationImpl {
    private static Map<PlayerAnimation, Integer> DEFAULTS = Maps.newEnumMap(PlayerAnimation.class);

    public static void play(PlayerAnimation animation, Player bplayer, Iterable<Player> to) {
        aiq player = (aiq)NMSImpl.getHandle((Entity)bplayer);
        if (DEFAULTS.containsKey(animation)) {
            PlayerAnimationImpl.playDefaultAnimation(player, to, DEFAULTS.get(animation));
            return;
        }
        switch (animation) {
            case HURT: {
                PlayerAnimationImpl.sendPacketNearby(new wm((bfx)player), to);
                break;
            }
            case SNEAK: {
                player.b(bgj.f);
                PlayerAnimationImpl.sendEntityData(to, player);
                break;
            }
            case START_ELYTRA: {
                player.fP();
                break;
            }
            case STOP_ELYTRA: {
                player.fQ();
                break;
            }
            case START_USE_MAINHAND_ITEM: {
                player.c(bdx.a);
                PlayerAnimationImpl.sendEntityData(to, player);
                player.getBukkitEntity().setMetadata("citizens-using-item-remaining-ticks", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)player.fh()));
                break;
            }
            case START_USE_OFFHAND_ITEM: {
                player.c(bdx.b);
                PlayerAnimationImpl.sendEntityData(to, player);
                player.getBukkitEntity().setMetadata("citizens-using-item-remaining-ticks", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)player.fh()));
                break;
            }
            case STOP_SNEAKING: {
                player.b(bgj.a);
                PlayerAnimationImpl.sendEntityData(to, player);
                break;
            }
            case STOP_USE_ITEM: {
                player.fk();
                PlayerAnimationImpl.sendEntityData(to, player);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static void playDefaultAnimation(aiq player, Iterable<Player> to, int code) {
        vi packet = new vi((bfh)player, code);
        PlayerAnimationImpl.sendPacketNearby(packet, to);
    }

    private static void sendEntityData(Iterable<Player> to, aiq player) {
        if (!player.aj().a()) {
            return;
        }
        PlayerAnimationImpl.sendPacketNearby(new yj(player.af(), player.aj().b()), to);
    }

    protected static void sendPacketNearby(vb<?> packet, Iterable<Player> to) {
        for (Player player : to) {
            NMSImpl.sendPacket(player, packet);
        }
    }

    static {
        DEFAULTS.put(PlayerAnimation.ARM_SWING, 0);
        DEFAULTS.put(PlayerAnimation.LEAVE_BED, 2);
        DEFAULTS.put(PlayerAnimation.ARM_SWING_OFFHAND, 3);
        DEFAULTS.put(PlayerAnimation.CRIT, 4);
        DEFAULTS.put(PlayerAnimation.MAGIC_CRIT, 5);
    }
}

