/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_20_R4.network.EmptyConnection;
import net.citizensnpcs.nms.v1_20_R4.network.EmptyPacketListener;
import net.citizensnpcs.nms.v1_20_R4.util.EmptyAdvancementDataPlayer;
import net.citizensnpcs.nms.v1_20_R4.util.EmptyServerStatsCounter;
import net.citizensnpcs.nms.v1_20_R4.util.MobAI;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.SkinProperty;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder,
SkinnableEntity,
MobAI.ForwardingMobAI {
    private AdvancementDataPlayer advancements;
    private MobAI ai;
    private int jumpTicks = 0;
    private final CitizensNPC npc;
    private boolean setBukkitEntity;
    private final SkinPacketTracker skinTracker;
    private EmptyServerStatsCounter statsCache;
    private static final float EPSILON = 0.003f;
    private static final MethodHandle GAMEMODE_SETTING = NMS.getFirstMethodHandle(PlayerInteractManager.class, (boolean)true, (Class[])new Class[]{EnumGamemode.class, EnumGamemode.class});

    public EntityHumanNPC(MinecraftServer minecraftServer, WorldServer world, GameProfile gameProfile, ClientInformation ci, NPC npc) {
        super(minecraftServer, world, gameProfile, ci);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.ai = new MobAI.BasicMobAI((EntityLiving)this);
            this.skinTracker = new SkinPacketTracker((SkinnableEntity)this);
            try {
                GAMEMODE_SETTING.invoke(this.e, EnumGamemode.a, null);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.initialise(minecraftServer, ci);
        } else {
            this.skinTracker = null;
        }
    }

    public void applyTexture(SkinProperty property) {
        this.gameProfile().getProperties().clear();
        this.gameProfile().getProperties().putAll((Object)property.name, (Iterable)ImmutableList.of((Object)new Property(property.name, property.value, property.signature)));
    }

    public boolean a(EntityPlayer player) {
        return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
    }

    public boolean a(float f, float f1, DamageSource damagesource) {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.a(f, f1, damagesource);
        }
        return false;
    }

    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(d0, flag, iblockdata, blockposition);
        }
    }

    public void a(DamageSource damagesource) {
        if (this.be) {
            return;
        }
        super.a(damagesource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), () -> {
            ((WorldServer)this.dP()).a((EntityPlayer)this, Entity.RemovalReason.a);
            ((WorldServer)this.dP()).l().a((net.minecraft.world.entity.Entity)this);
        }, 15L);
    }

    public void m() {
        boolean navigating;
        if (this.npc == null) {
            super.m();
            return;
        }
        NMSImpl.callNPCMoveEvent(this);
        super.au();
        boolean bl = navigating = this.npc.getNavigator().isNavigating() || this.ai.getMoveControl().b();
        if (!(navigating || this.getBukkitEntity() == null || this.npc.hasTrait(Gravity.class) && !((Gravity)this.npc.getOrAddTrait(Gravity.class)).hasGravity() || !Util.isLoaded((Location)this.getBukkitEntity().getLocation()) || this.npc.isProtected() && !SpigotUtil.checkYSafe((double)this.dw(), (World)this.getBukkitEntity().getWorld()))) {
            this.moveWithFallDamage(Vec3D.b);
        }
        Vec3D mot = this.ds();
        if (Math.abs(mot.c) < (double)0.003f && Math.abs(mot.d) < (double)0.003f && Math.abs(mot.e) < (double)0.003f) {
            this.h(Vec3D.b);
        }
        if (navigating) {
            if (!this.ai.getNavigation().l()) {
                this.ai.getNavigation().c();
            }
            this.moveOnCurrentHeading();
        }
        this.tickAI();
        this.aF();
        this.ag = this.N_();
        if (this.N_()) {
            this.aI = false;
        }
        this.q();
        if (this.npc.useMinecraftAI()) {
            this.cc.a((EntityHuman)this);
        }
        if (((Boolean)this.npc.data().get(NPC.Metadata.PICKUP_ITEMS, (Object)false)).booleanValue()) {
            if (this.cg > 0) {
                --this.cg;
            }
            AxisAlignedBB axisalignedbb = this.bR() && !this.dc().dK() ? this.cK().b(this.dc().cK()).c(1.0, 0.0, 1.0) : this.cK().c(1.0, 0.5, 1.0);
            for (net.minecraft.world.entity.Entity entity : this.dP().a_((net.minecraft.world.entity.Entity)this, axisalignedbb)) {
                entity.b_((EntityHuman)this);
            }
        }
        ++this.aT;
        this.gx().a();
        if (!this.npc.hasTrait(EntityPoseTrait.class) || ((EntityPoseTrait)this.npc.getTraitNullable(EntityPoseTrait.class)).getPose() == null) {
            this.fV();
        }
    }

    public GameProfile gameProfile() {
        return this.gb();
    }

    public AdvancementDataPlayer Q() {
        if (this.advancements == null) {
            this.advancements = new EmptyAdvancementDataPlayer(this.cO().aD(), this.cO().ah(), this);
        }
        return this.advancements;
    }

    @Override
    public MobAI getAI() {
        return this.ai;
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && !this.setBukkitEntity) {
            NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new PlayerNPC(this));
            this.setBukkitEntity = true;
        }
        return super.getBukkitEntity();
    }

    protected SoundEffect o_() {
        return NMSImpl.getSoundEffect((NPC)this.npc, super.o_(), NPC.Metadata.DEATH_SOUND);
    }

    protected SoundEffect d(DamageSource damagesource) {
        return NMSImpl.getSoundEffect((NPC)this.npc, super.d(damagesource), NPC.Metadata.HURT_SOUND);
    }

    public float fh() {
        return NMS.getJumpPower((NPC)this.npc, (float)super.fh());
    }

    public int cx() {
        return NMS.getFallDistance((NPC)this.npc, (int)super.cx());
    }

    public NPC getNPC() {
        return this.npc;
    }

    public EnumPistonReaction k_() {
        return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.k_();
    }

    public SkinPacketTracker getSkinTracker() {
        return this.skinTracker;
    }

    public ServerStatisticManager H() {
        return this.statsCache == null ? (this.statsCache = new EmptyServerStatsCounter()) : this.statsCache;
    }

    public IChatBaseComponent N() {
        if (this.npc != null && this.npc.shouldRemoveFromTabList()) {
            return IChatMutableComponent.a((ComponentContents)new LiteralContents.a(""));
        }
        return this.npc != null ? (IChatBaseComponent)Messaging.minecraftComponentFromRawMessage((String)this.npc.getRawName()) : super.N();
    }

    public boolean a(DamageSource damagesource, float f) {
        boolean damaged = super.a(damagesource, f);
        if (damaged && this.U) {
            this.U = false;
            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), () -> {
                this.U = true;
            });
        }
        return damaged;
    }

    private void initialise(MinecraftServer minecraftServer, ClientInformation clientInfo) {
        try {
            EmptyConnection conn = new EmptyConnection(EnumProtocolDirection.b);
            this.c = new EmptyPacketListener(minecraftServer, conn, this, new CommonListenerCookie(this.gameProfile(), 0, clientInfo, false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setSkinFlags((byte)-1);
    }

    public boolean bE() {
        if (this.npc == null || this.ag || this.fL()) {
            return super.bE();
        }
        return Util.inBlock((Entity)this.getBukkitEntity());
    }

    public boolean bA() {
        return this.npc == null ? super.bA() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
    }

    public void q(double strength, double dx, double dz) {
        NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.q((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
    }

    private void moveOnCurrentHeading() {
        if (this.bn) {
            if (this.aI && this.jumpTicks == 0) {
                this.fj();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.bo *= 0.98f;
        this.bq *= 0.98f;
        this.moveWithFallDamage(new Vec3D((double)this.bo, (double)this.bp, (double)this.bq));
        NMS.setHeadAndBodyYaw((Entity)this.getBukkitEntity(), (float)this.dF());
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    private void moveWithFallDamage(Vec3D vec) {
        double x = this.du();
        double y = this.dw();
        double z = this.dA();
        this.a(vec);
        if (!this.npc.isProtected()) {
            this.a(this.du() - x, this.dw() - y, this.dA() - z, this.aI);
        }
    }

    public boolean q_() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.q_();
        }
        return false;
    }

    public void h(net.minecraft.world.entity.Entity entity) {
        super.h(entity);
        if (this.npc != null) {
            Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
        }
    }

    public void a(Entity.RemovalReason reason) {
        super.a(reason);
        this.Q().b();
    }

    public void setSkinFlags(byte flags) {
        this.ap().a(EntityHuman.bV, (Object)flags);
    }

    public void l() {
        super.l();
        if (this.npc == null) {
            return;
        }
        if (NMSImpl.PAPER_LIVING_ENTITY_DETECT_EQUIPMENT_UPDATES != null) {
            try {
                NMSImpl.PAPER_LIVING_ENTITY_DETECT_EQUIPMENT_UPDATES.invoke(this);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            this.detectEquipmentUpdatesPublic();
        }
        float scale = this.ee();
        if (scale != this.bE) {
            this.bE = scale;
            this.j_();
        }
        Bukkit.getServer().getPluginManager().unsubscribeFromPermission("bukkit.broadcast.user", (Permissible)this.getBukkitEntity());
        this.updatePackets(this.npc.getNavigator().isNavigating());
        this.npc.update();
        if (NMSImpl.PAPER_PLAYER_MOB_COUNTS != null && this.npc.shouldRemoveFromPlayerList()) {
            try {
                int[] counts = NMSImpl.PAPER_PLAYER_MOB_COUNTS.invoke(this);
                for (int i = 0; i < counts.length; ++i) {
                    counts[i] = 0;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (this.fv()) {
            if (ItemStack.b((ItemStack)this.b(this.fw()), (ItemStack)this.bz)) {
                this.bz = this.b(this.fw());
                this.a(this.bz);
            } else {
                this.fB();
            }
        }
    }

    @Override
    public void tickAI() {
        this.ai.getMoveControl().a();
        this.ai.getJumpControl().b();
    }

    public void a(Vec3D vec3d) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(vec3d);
        } else {
            NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
        }
    }

    public boolean a(TagKey<FluidType> tagkey, double d0) {
        Vec3D old = this.ds().b(0.0, 0.0, 0.0);
        boolean res = super.a(tagkey, d0);
        if (!this.npc.isPushableByFluids()) {
            this.h(old);
        }
        return res;
    }

    private void updatePackets(boolean navigating) {
        if (!this.npc.isUpdating(NPC.NPCUpdate.PACKET)) {
            return;
        }
        this.bZ = true;
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder,
    SkinnableEntity.ForwardingSkinnableEntity {
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPlayer)entity);
            this.npc = entity.npc;
            this.npc.getOrAddTrait(Inventory.class);
        }

        public boolean canSee(Entity entity) {
            if (entity != null && entity.getType().name().contains("ITEM_FRAME")) {
                return false;
            }
            return super.canSee(entity);
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        public NPC getNPC() {
            return this.npc;
        }

        public SkinnableEntity getUnderlying() {
            return (SkinnableEntity)this.entity;
        }

        public boolean hasMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }
    }
}

