/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R4.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.nms.v1_21_R4.util.NMSImpl;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class PlayerAnimationImpl {
    private static Map<PlayerAnimation, Integer> DEFAULTS = Maps.newEnumMap(PlayerAnimation.class);

    public static void play(PlayerAnimation animation, Player bplayer, Iterable<Player> to) {
        asc player = (asc)NMSImpl.getHandle((Entity)bplayer);
        if (DEFAULTS.containsKey(animation)) {
            PlayerAnimationImpl.playDefaultAnimation(player, to, DEFAULTS.get(animation));
            return;
        }
        switch (animation) {
            case HURT: {
                PlayerAnimationImpl.sendPacketNearby(new ado((byf)player), to);
                break;
            }
            case SNEAK: {
                player.b(byr.f);
                PlayerAnimationImpl.sendEntityData(to, player);
                break;
            }
            case START_ELYTRA: {
                player.gr();
                break;
            }
            case STOP_ELYTRA: {
                player.fm();
                break;
            }
            case START_USE_MAINHAND_ITEM: {
                player.c(bvb.a);
                PlayerAnimationImpl.sendEntityData(to, player);
                player.getBukkitEntity().setMetadata("citizens-using-item-remaining-ticks", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)player.fC()));
                break;
            }
            case START_USE_OFFHAND_ITEM: {
                player.c(bvb.b);
                PlayerAnimationImpl.sendEntityData(to, player);
                player.getBukkitEntity().setMetadata("citizens-using-item-remaining-ticks", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)player.fC()));
                break;
            }
            case STOP_SNEAKING: {
                player.b(byr.a);
                PlayerAnimationImpl.sendEntityData(to, player);
                break;
            }
            case STOP_USE_ITEM: {
                player.fF();
                PlayerAnimationImpl.sendEntityData(to, player);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static void playDefaultAnimation(asc player, Iterable<Player> to, int code) {
        ach packet = new ach((bxe)player, code);
        PlayerAnimationImpl.sendPacketNearby(packet, to);
    }

    private static void sendEntityData(Iterable<Player> to, asc player) {
        if (!player.ar().a()) {
            return;
        }
        PlayerAnimationImpl.sendPacketNearby(new afo(player.ao(), player.ar().b()), to);
    }

    protected static void sendPacketNearby(zo<?> packet, Iterable<Player> to) {
        for (Player player : to) {
            NMSImpl.sendPacket(player, packet);
        }
    }

    static {
        DEFAULTS.put(PlayerAnimation.ARM_SWING, 0);
        DEFAULTS.put(PlayerAnimation.LEAVE_BED, 2);
        DEFAULTS.put(PlayerAnimation.ARM_SWING_OFFHAND, 3);
        DEFAULTS.put(PlayerAnimation.CRIT, 4);
        DEFAULTS.put(PlayerAnimation.MAGIC_CRIT, 5);
    }
}

