/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R6.entity.nonliving;

import java.util.function.Supplier;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R6.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R6.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R6.util.NMSImpl;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.Raft;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class RaftController
extends AbstractEntityController {
    protected Entity createEntity(Location at, NPC npc) {
        EntityRaftNPC handle = new EntityRaftNPC((EntityTypes<? extends Raft>)EntityTypes.l, (World)((CraftWorld)at.getWorld()).getHandle(), () -> Items.pJ, npc);
        return handle.getBukkitEntity();
    }

    public static class EntityRaftNPC
    extends Raft
    implements NPCHolder {
        private float invFriction;
        private float landFriction;
        private AbstractBoat.EnumStatus lastStatus;
        private final CitizensNPC npc;
        private AbstractBoat.EnumStatus status;
        private double waterLevel;

        public EntityRaftNPC(EntityTypes<? extends Raft> types, World level, Supplier<Item> supplier) {
            this(types, level, supplier, null);
        }

        public EntityRaftNPC(EntityTypes<? extends Raft> types, World level, Supplier<Item> supplier, NPC npc) {
            super(types, level, supplier);
            this.npc = (CitizensNPC)npc;
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        private boolean checkInWater() {
            AxisAlignedBB axisalignedbb = this.de();
            int i = MathHelper.a((double)axisalignedbb.a);
            int j = MathHelper.c((double)axisalignedbb.d);
            int k = MathHelper.a((double)axisalignedbb.b);
            int l = MathHelper.c((double)(axisalignedbb.b + 0.001));
            int i1 = MathHelper.a((double)axisalignedbb.c);
            int j1 = MathHelper.c((double)axisalignedbb.f);
            boolean flag = false;
            this.waterLevel = -1.7976931348623157E308;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockposition_mutableblockposition.d(k1, l1, i2);
                        Fluid fluid = this.an().b_((BlockPosition)blockposition_mutableblockposition);
                        if (!fluid.a(TagsFluid.a)) continue;
                        float f = (float)l1 + fluid.a((IBlockAccess)this.an(), (BlockPosition)blockposition_mutableblockposition);
                        this.waterLevel = Math.max((double)f, this.waterLevel);
                        flag |= axisalignedbb.b < (double)f;
                    }
                }
            }
            return flag;
        }

        private void floatRaft() {
            double d0 = -this.bp();
            double d1 = 0.0;
            this.invFriction = 0.05f;
            if (this.lastStatus == AbstractBoat.EnumStatus.e && this.status != AbstractBoat.EnumStatus.e && this.status != AbstractBoat.EnumStatus.d) {
                this.waterLevel = this.f(1.0);
                double d2 = (double)(this.i() - this.dB()) + 0.101;
                if (this.an().a((net.minecraft.world.entity.Entity)this, this.de().d(0.0, d2 - this.dM(), 0.0))) {
                    this.a(EnumMoveType.a, new Vec3D(0.0, d2 - this.dM(), 0.0));
                    this.k(this.dI().d(1.0, 0.0, 1.0));
                }
                this.status = AbstractBoat.EnumStatus.a;
            } else {
                if (this.status == AbstractBoat.EnumStatus.a) {
                    d1 = (this.waterLevel - this.dM()) / (double)this.dB();
                    this.invFriction = 0.9f;
                } else if (this.status == AbstractBoat.EnumStatus.c) {
                    d0 = -7.0E-4;
                    this.invFriction = 0.9f;
                } else if (this.status == AbstractBoat.EnumStatus.b) {
                    d1 = 0.01f;
                    this.invFriction = 0.45f;
                } else if (this.status == AbstractBoat.EnumStatus.e) {
                    this.invFriction = 0.9f;
                } else if (this.status == AbstractBoat.EnumStatus.d) {
                    this.invFriction = this.landFriction;
                    if (this.dg() instanceof Player) {
                        this.landFriction /= 2.0f;
                    }
                }
                Vec3D vec3d = this.dI();
                this.m(vec3d.g * (double)this.invFriction, vec3d.h + d0, vec3d.i * (double)this.invFriction);
                if (d1 > 0.0) {
                    Vec3D vec3d1 = this.dI();
                    this.m(vec3d1.g, (vec3d1.h + d1 * (this.bo() / 0.65)) * 0.75, vec3d1.i);
                }
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new RaftNPC(this));
            }
            return super.getBukkitEntity();
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction p_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.p_();
        }

        private AbstractBoat.EnumStatus getStatus() {
            AbstractBoat.EnumStatus entityRaft_Status = this.isUnderwater();
            if (entityRaft_Status != null) {
                this.waterLevel = this.de().e;
                return entityRaft_Status;
            }
            if (this.checkInWater()) {
                return AbstractBoat.EnumStatus.a;
            }
            float f = this.k();
            if (f > 0.0f) {
                this.landFriction = f;
                return AbstractBoat.EnumStatus.d;
            }
            return AbstractBoat.EnumStatus.e;
        }

        public boolean bU() {
            return this.npc == null ? super.bU() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        private AbstractBoat.EnumStatus isUnderwater() {
            AxisAlignedBB axisalignedbb = this.de();
            double d0 = axisalignedbb.e + 0.001;
            int i = MathHelper.a((double)axisalignedbb.a);
            int j = MathHelper.c((double)axisalignedbb.d);
            int k = MathHelper.a((double)axisalignedbb.e);
            int l = MathHelper.c((double)d0);
            int i1 = MathHelper.a((double)axisalignedbb.c);
            int j1 = MathHelper.c((double)axisalignedbb.f);
            boolean flag = false;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockposition_mutableblockposition.d(k1, l1, i2);
                        Fluid fluid = this.an().b_((BlockPosition)blockposition_mutableblockposition);
                        if (!fluid.a(TagsFluid.a) || !(d0 < (double)((float)blockposition_mutableblockposition.v() + fluid.a((IBlockAccess)this.an(), (BlockPosition)blockposition_mutableblockposition)))) continue;
                        if (!fluid.b()) {
                            return AbstractBoat.EnumStatus.c;
                        }
                        flag = true;
                    }
                }
            }
            return flag ? AbstractBoat.EnumStatus.b : null;
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.c(vec3));
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void l_() {
            if (this.npc == null) {
                super.l_();
            } else {
                NMSImpl.setSize((net.minecraft.world.entity.Entity)this, this.ay);
            }
        }

        public boolean c(ValueOutput save) {
            return this.npc == null ? super.c(save) : false;
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null || transition.b().al().equals(this.an().al())) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void g() {
            if (this.npc != null) {
                this.aH();
                if (this.dg() instanceof NPCHolder && ((NPCHolder)this.dg()).getNPC().getNavigator().isNavigating()) {
                    this.k(this.dg().dI().d(20.0, 0.0, 20.0));
                }
                this.npc.update();
                if (this.H() > 0) {
                    this.d(this.H() - 1);
                }
                if (this.G() > 0.0f) {
                    this.a(this.G() - 1.0f);
                }
                this.lastStatus = this.status;
                this.status = this.getStatus();
                this.floatRaft();
                this.a(EnumMoveType.a, this.dI());
                this.aT();
            } else {
                super.g();
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dI().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.k(old);
            }
            return res;
        }
    }

    public static class RaftNPC
    extends CraftBoat
    implements ForwardingNPCHolder {
        public RaftNPC(EntityRaftNPC entity) {
            super((CraftServer)Bukkit.getServer(), (AbstractBoat)entity);
        }
    }
}

