/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R7.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R7.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R7.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R7.util.MobAI;
import net.citizensnpcs.nms.v1_21_R7.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R7.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.SkinProperty;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.ClientAsset;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.Mannequin;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartAbstract;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftMannequin;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class MannequinController
extends MobEntityController {
    public MannequinController() {
        super(EntityMannequinNPC.class, EntityTypes.aH);
    }

    public org.bukkit.entity.Mannequin getBukkitEntity() {
        return (org.bukkit.entity.Mannequin)super.getBukkitEntity();
    }

    public static class EntityMannequinNPC
    extends Mannequin
    implements NPCHolder,
    SkinnableEntity,
    MobAI.ForwardingMobAI {
        private final MobAI ai;
        private final CitizensNPC npc;
        private final SkinPacketTracker skinTracker;

        public EntityMannequinNPC(EntityTypes<? extends Mannequin> types, World level) {
            this(types, level, null);
        }

        public EntityMannequinNPC(EntityTypes<? extends Mannequin> types, World level, NPC npc) {
            super(level);
            this.npc = (CitizensNPC)npc;
            if (npc != null && !npc.useMinecraftAI()) {
                this.b(true);
                this.skinTracker = new SkinPacketTracker((SkinnableEntity)this);
                this.ai = new MobAI.BasicMobAI((EntityLiving)this);
            } else {
                this.ai = null;
                this.skinTracker = null;
            }
        }

        public void applyTexture(SkinProperty property) {
            this.a(ResolvableProfile.a((GameProfile)property.applyProperties((Object)this.k().b())));
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        protected boolean p(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof AbstractBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.p(entity);
        }

        public boolean a(double f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public void dW() {
            if (this.npc == null) {
                super.dW();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public GameProfile gameProfile() {
            return this.k().b();
        }

        @Override
        public MobAI getAI() {
            return this.ai;
        }

        public CraftLivingEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new MannequinNPC(this));
            }
            return (CraftLivingEntity)super.getBukkitEntity();
        }

        protected SoundEffect fd() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.fd(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect h(DamageSource damagesource) {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.h(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fF() {
            return NMS.getJumpPower((NPC)this.npc, (float)super.fF());
        }

        public int cW() {
            return NMS.getFallDistance((NPC)this.npc, (int)super.cW());
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction n_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.n_();
        }

        public SkinPacketTracker getSkinTracker() {
            return this.skinTracker;
        }

        public boolean bY() {
            return this.npc == null ? super.bY() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        public void o(double strength, double dx, double dz) {
            NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.o((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.c(vec3));
        }

        public boolean fl() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.fl();
            }
            return false;
        }

        public void a(DataWatcherObject<?> datawatcherobject) {
            if (this.npc == null) {
                super.a(datawatcherobject);
                return;
            }
            NMSImpl.checkAndUpdateHeight((EntityLiving)this, datawatcherobject, x$0 -> super.a(x$0));
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean c(ValueOutput save) {
            return this.npc == null ? super.c(save) : false;
        }

        public void setSkinFlags(byte flags) {
            this.aD().a(Avatar.t, (Object)flags);
        }

        public void setSkinPatch(SkinnableEntity.PlayerSkinModelType type, NamespacedKey body, NamespacedKey cape, NamespacedKey elytra) {
            this.a((ResolvableProfile)new ResolvableProfile.Static(Either.left((Object)this.k().b()), new PlayerSkin.Patch(body == null ? Optional.empty() : Optional.of(new ClientAsset.b(MinecraftKey.a((String)body.getNamespace(), (String)body.getKey()))), cape == null ? Optional.empty() : Optional.of(new ClientAsset.b(MinecraftKey.a((String)cape.getNamespace(), (String)cape.getKey()))), elytra == null ? Optional.empty() : Optional.of(new ClientAsset.b(MinecraftKey.a((String)elytra.getNamespace(), (String)elytra.getKey()))), Optional.of(type == SkinnableEntity.PlayerSkinModelType.SLIM ? PlayerModelType.a : PlayerModelType.b))));
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null || transition.b().aq().equals(this.ao().aq())) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void g() {
            super.g();
            if (this.npc == null) {
                return;
            }
            this.npc.update();
            this.tickAI();
        }

        public void m(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.m(vec3d);
            } else {
                NMSImpl.moveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dN().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.k(old);
            }
            return res;
        }
    }

    public static class MannequinNPC
    extends CraftMannequin
    implements ForwardingNPCHolder,
    SkinnableEntity.ForwardingSkinnableEntity {
        public MannequinNPC(EntityMannequinNPC entity) {
            super((CraftServer)Bukkit.getServer(), (Mannequin)entity);
        }

        public LivingEntity getBukkitEntity() {
            return (LivingEntity)this.entity;
        }

        public SkinnableEntity getUnderlying() {
            return (SkinnableEntity)this.entity;
        }
    }
}

