/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R7.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R7.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R7.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R7.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R7.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftCreaking;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CreakingController
extends MobEntityController {
    public CreakingController() {
        super(EntityCreakingNPC.class, EntityTypes.H);
    }

    public org.bukkit.entity.Creaking getBukkitEntity() {
        return (org.bukkit.entity.Creaking)super.getBukkitEntity();
    }

    public static class EntityCreakingNPC
    extends Creaking
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityCreakingNPC(EntityTypes<? extends Creaking> types, World level) {
            this(types, level, null);
        }

        public EntityCreakingNPC(EntityTypes<? extends Creaking> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.x(true);
            }
        }

        public void q(net.minecraft.world.entity.Entity passenger) {
            if (this.npc == null || this.npc.useMinecraftAI()) {
                super.q(passenger);
                return;
            }
            if (passenger.dz() != this) {
                throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
            }
            if (this.aS.isEmpty()) {
                this.aS = ImmutableList.of((Object)passenger);
            } else {
                ArrayList list = Lists.newArrayList((Iterable)this.aS);
                if (!this.ao().B_() && passenger instanceof Player && !(this.do() instanceof Player)) {
                    list.add(0, passenger);
                } else {
                    list.add(passenger);
                }
                this.aS = ImmutableList.copyOf((Collection)list);
            }
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        public boolean gP() {
            return this.npc == null || this.npc.useMinecraftAI() ? super.gP() : true;
        }

        protected boolean p(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof AbstractBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.p(entity);
        }

        public boolean a(double f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public boolean gZ() {
            return this.npc == null || this.npc.useMinecraftAI() ? super.gZ() : true;
        }

        public void dW() {
            if (this.npc == null) {
                super.dW();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public void a(WorldServer level) {
            super.a(level);
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState((NPC)this.npc, (EntityInsentient)this);
                this.npc.update();
            }
        }

        protected SoundEffect W() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.W(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new CreakingNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect fd() {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.fd(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect h(DamageSource damagesource) {
            return NMSImpl.getSoundEffect((NPC)this.npc, super.h(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fF() {
            return NMS.getJumpPower((NPC)this.npc, (float)super.fF());
        }

        public int cW() {
            return NMS.getFallDistance((NPC)this.npc, (int)super.cW());
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction n_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.n_();
        }

        public boolean hb() {
            return this.npc == null || this.npc.useMinecraftAI() ? super.hb() : true;
        }

        public boolean k() {
            if (this.npc == null || this.npc.useMinecraftAI()) {
                return super.k();
            }
            return this.npc.isProtected() ? false : super.k();
        }

        public boolean S_() {
            return NMSImpl.isLeashed((NPC)this.npc, () -> super.S_(), (EntityInsentient)this);
        }

        public boolean bY() {
            return this.npc == null ? super.bY() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        public void o(double strength, double dx, double dz) {
            NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.o((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.c(vec3));
        }

        public boolean fl() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.fl();
            }
            return false;
        }

        public void a(DataWatcherObject<?> datawatcherobject) {
            if (this.npc == null) {
                super.a(datawatcherobject);
                return;
            }
            NMSImpl.checkAndUpdateHeight((EntityLiving)this, datawatcherobject, x$0 -> super.a(x$0));
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean c(ValueOutput save) {
            return this.npc == null ? super.c(save) : false;
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null || transition.b().aq().equals(this.ao().aq())) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public void m(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.m(vec3d);
            } else {
                NMSImpl.moveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dN().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.k(old);
            }
            return res;
        }
    }

    public static class CreakingNPC
    extends CraftCreaking
    implements ForwardingNPCHolder {
        public CreakingNPC(EntityCreakingNPC entity) {
            super((CraftServer)Bukkit.getServer(), (Creaking)entity);
        }
    }
}

