/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.scripting;

import com.google.common.base.Throwables;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import net.citizensnpcs.api.scripting.ContextProvider;
import net.citizensnpcs.api.scripting.Script;

public class SimpleScript
implements Script {
    private final Bindings bindings;
    private final ScriptEngine engine;
    private final Invocable invocable;
    private final Object root;

    public SimpleScript(CompiledScript src, ContextProvider[] providers) throws ScriptException {
        this.engine = src.getEngine();
        this.invocable = (Invocable)((Object)this.engine);
        this.bindings = this.engine.createBindings();
        for (ContextProvider provider : providers) {
            provider.provide(this);
        }
        this.root = src.eval(this.bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T convertToInterface(Object obj, Class<T> expected) {
        if (obj == null || expected == null) {
            throw new IllegalArgumentException("arguments should not be null");
        }
        if (expected.isAssignableFrom(obj.getClass())) {
            return expected.cast(obj);
        }
        ScriptEngine scriptEngine = this.engine;
        synchronized (scriptEngine) {
            Bindings old = this.engine.getBindings(100);
            this.engine.setBindings(this.bindings, 100);
            T t = this.invocable.getInterface(expected);
            this.engine.setBindings(old, 100);
            return t;
        }
    }

    @Override
    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name should not be null");
        }
        return this.bindings.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object instance, String name, Object ... args) {
        if (instance == null || name == null) {
            throw new IllegalArgumentException("instance and method name should not be null");
        }
        try {
            ScriptEngine scriptEngine = this.engine;
            synchronized (scriptEngine) {
                Bindings old = this.engine.getBindings(100);
                this.engine.setBindings(this.bindings, 100);
                Object ret = this.invocable.invokeMethod(instance, name, args);
                this.engine.setBindings(old, 100);
                return ret;
            }
        }
        catch (ScriptException e) {
            Throwables.getRootCause((Throwable)e).printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(String name, Object ... args) {
        if (name == null) {
            throw new IllegalArgumentException("name should not be null");
        }
        try {
            ScriptEngine scriptEngine = this.engine;
            synchronized (scriptEngine) {
                Bindings old = this.engine.getBindings(100);
                this.engine.setBindings(this.bindings, 100);
                Object ret = this.invocable.invokeFunction(name, args);
                this.engine.setBindings(old, 100);
                return ret;
            }
        }
        catch (ScriptException e) {
            Throwables.getRootCause((Throwable)e).printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("arguments should not be null");
        }
        this.bindings.put(name, value);
    }
}

