/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import lib.trove.map.hash.TIntObjectHashMap;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCCreateEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_7_R4.Entity;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;

public class CitizensNPCRegistry
implements NPCRegistry {
    private final NPCCollection npcs = TROVE_EXISTS ? new TroveNPCCollection() : new MapNPCCollection();
    private final NPCDataStore saves;
    private static final Comparator<NPC> NPC_COMPARATOR = new Comparator<NPC>(){

        @Override
        public int compare(NPC o1, NPC o2) {
            return o1.getId() - o2.getId();
        }
    };
    private static boolean TROVE_EXISTS = false;

    public CitizensNPCRegistry(NPCDataStore store) {
        this.saves = store;
    }

    @Override
    public NPC createNPC(EntityType type, String name) {
        return this.createNPC(type, UUID.randomUUID(), this.generateUniqueId(), name);
    }

    @Override
    public NPC createNPC(EntityType type, UUID uuid, int id, String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        Preconditions.checkNotNull((Object)type, (Object)"type cannot be null");
        CitizensNPC npc = this.getByType(type, uuid, id, name);
        if (npc == null) {
            throw new IllegalStateException("Could not create NPC.");
        }
        this.npcs.put(npc.getId(), npc);
        Bukkit.getPluginManager().callEvent((Event)new NPCCreateEvent(npc));
        return npc;
    }

    @Override
    public void deregister(NPC npc) {
        this.npcs.remove(npc);
        if (this.saves != null) {
            this.saves.clearData(npc);
        }
        npc.despawn(DespawnReason.REMOVAL);
    }

    @Override
    public void deregisterAll() {
        Iterator<NPC> itr = this.iterator();
        while (itr.hasNext()) {
            NPC npc = itr.next();
            itr.remove();
            npc.despawn(DespawnReason.REMOVAL);
            for (Trait t : npc.getTraits()) {
                t.onRemove();
            }
            if (this.saves == null) continue;
            this.saves.clearData(npc);
        }
    }

    private int generateUniqueId() {
        return this.saves.createUniqueNPCId(this);
    }

    @Override
    public NPC getById(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("invalid id");
        }
        return this.npcs.get(id);
    }

    private CitizensNPC getByType(EntityType type, UUID uuid, int id, String name) {
        return new CitizensNPC(uuid, id, name, EntityControllers.createForType(type), this);
    }

    @Override
    public NPC getByUniqueId(UUID uuid) {
        return this.npcs.get(uuid);
    }

    @Override
    public NPC getByUniqueIdGlobal(UUID uuid) {
        NPC npc = this.getByUniqueId(uuid);
        if (npc != null) {
            return npc;
        }
        for (NPCRegistry registry : CitizensAPI.getNPCRegistries()) {
            NPC other;
            if (registry == this || (other = registry.getByUniqueId(uuid)) == null) continue;
            return other;
        }
        return null;
    }

    @Override
    public NPC getNPC(org.bukkit.entity.Entity entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof NPCHolder) {
            return ((NPCHolder)entity).getNPC();
        }
        Entity handle = NMS.getHandle(entity);
        return handle instanceof NPCHolder ? ((NPCHolder)handle).getNPC() : null;
    }

    @Override
    public boolean isNPC(org.bukkit.entity.Entity entity) {
        return this.getNPC(entity) != null;
    }

    @Override
    public Iterator<NPC> iterator() {
        return this.npcs.iterator();
    }

    @Override
    public Iterable<NPC> sorted() {
        return this.npcs.sorted();
    }

    static {
        try {
            Class.forName("lib.trove.map.hash.TIntObjectHashMap").newInstance();
            TROVE_EXISTS = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class TroveNPCCollection
    implements NPCCollection {
        private final TIntObjectHashMap<NPC> npcs = new TIntObjectHashMap();
        private final Map<UUID, NPC> uniqueNPCs = Maps.newHashMap();

        @Override
        public NPC get(int id) {
            return this.npcs.get(id);
        }

        @Override
        public NPC get(UUID uuid) {
            return this.uniqueNPCs.get(uuid);
        }

        @Override
        public Iterator<NPC> iterator() {
            return this.npcs.valueCollection().iterator();
        }

        @Override
        public void put(int id, NPC npc) {
            this.npcs.put(id, npc);
            this.uniqueNPCs.put(npc.getUniqueId(), npc);
        }

        @Override
        public void remove(NPC npc) {
            this.npcs.remove(npc.getId());
            this.uniqueNPCs.remove(npc.getUniqueId());
        }

        @Override
        public Iterable<NPC> sorted() {
            ArrayList<NPC> vals = new ArrayList<NPC>(this.npcs.valueCollection());
            Collections.sort(vals, NPC_COMPARATOR);
            return vals;
        }
    }

    public static interface NPCCollection
    extends Iterable<NPC> {
        public NPC get(int var1);

        public NPC get(UUID var1);

        public void put(int var1, NPC var2);

        public void remove(NPC var1);

        public Iterable<NPC> sorted();
    }

    public static class MapNPCCollection
    implements NPCCollection {
        private final Map<Integer, NPC> npcs = Maps.newHashMap();
        private final Map<UUID, NPC> uniqueNPCs = Maps.newHashMap();

        @Override
        public NPC get(int id) {
            return this.npcs.get(id);
        }

        @Override
        public NPC get(UUID uuid) {
            return this.uniqueNPCs.get(uuid);
        }

        @Override
        public Iterator<NPC> iterator() {
            return this.npcs.values().iterator();
        }

        @Override
        public void put(int id, NPC npc) {
            this.npcs.put(id, npc);
            this.uniqueNPCs.put(npc.getUniqueId(), npc);
        }

        @Override
        public void remove(NPC npc) {
            this.npcs.remove(npc.getId());
            this.uniqueNPCs.remove(npc.getUniqueId());
        }

        @Override
        public Iterable<NPC> sorted() {
            ArrayList<NPC> vals = new ArrayList<NPC>(this.npcs.values());
            Collections.sort(vals, NPC_COMPARATOR);
            return vals;
        }
    }
}

