/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_7_R4.Block;
import net.minecraft.server.v1_7_R4.Blocks;
import net.minecraft.server.v1_7_R4.Enchantment;
import net.minecraft.server.v1_7_R4.EnchantmentManager;
import net.minecraft.server.v1_7_R4.EntityLiving;
import net.minecraft.server.v1_7_R4.EntityPlayer;
import net.minecraft.server.v1_7_R4.Material;
import net.minecraft.server.v1_7_R4.MobEffectList;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BlockBreaker
extends BehaviorGoalAdapter {
    private final Configuration configuration;
    private int currentDamage;
    private int currentTick;
    private final EntityLiving entity;
    private boolean isDigging = true;
    private final Location location;
    private int startDigTick;
    private final int x;
    private final int y;
    private final int z;
    private static final Configuration EMPTY = new Configuration();

    private BlockBreaker(LivingEntity entity, org.bukkit.block.Block target, Configuration config) {
        this.entity = ((CraftLivingEntity)entity).getHandle();
        this.x = target.getX();
        this.y = target.getY();
        this.z = target.getZ();
        this.location = target.getLocation();
        this.startDigTick = (int)(System.currentTimeMillis() / 50L);
        this.configuration = config;
    }

    private double distanceSquared() {
        return Math.pow(this.entity.locX - (double)this.x, 2.0) + Math.pow(this.entity.locY - (double)this.y, 2.0) + Math.pow(this.entity.locZ - (double)this.z, 2.0);
    }

    private net.minecraft.server.v1_7_R4.ItemStack getCurrentItem() {
        return this.configuration.item() != null ? CraftItemStack.asNMSCopy((ItemStack)this.configuration.item()) : this.entity.getEquipment(0);
    }

    private float getStrength(Block block) {
        float base = block.f(null, 0, 0, 0);
        return base < 0.0f ? 0.0f : (!this.isDestroyable(block) ? 1.0f / base / 100.0f : this.strengthMod(block) / base / 30.0f);
    }

    private boolean isDestroyable(Block block) {
        if (block.getMaterial().isAlwaysDestroyable()) {
            return true;
        }
        net.minecraft.server.v1_7_R4.ItemStack current = this.getCurrentItem();
        return current != null ? current.b(block) : false;
    }

    public boolean isFinished() {
        return !this.isDigging;
    }

    @Override
    public void reset() {
        if (this.configuration.callback() != null) {
            this.configuration.callback().run();
        }
        this.isDigging = false;
        this.currentDamage = -1;
        this.setBlockDamage(-1);
    }

    @Override
    public BehaviorStatus run() {
        Block block;
        if (this.entity.dead) {
            return BehaviorStatus.FAILURE;
        }
        if (!this.isDigging) {
            return BehaviorStatus.SUCCESS;
        }
        this.currentTick = (int)(System.currentTimeMillis() / 50L);
        if (this.configuration.radiusSquared() > 0.0 && this.distanceSquared() >= this.configuration.radiusSquared()) {
            NPC npc;
            this.startDigTick = this.currentTick;
            if (this.entity instanceof NPCHolder && (npc = ((NPCHolder)this.entity).getNPC()) != null && !npc.getNavigator().isNavigating()) {
                npc.getNavigator().setTarget(this.entity.world.getWorld().getBlockAt(this.x, this.y, this.z).getLocation().add(0.0, 1.0, 0.0));
            }
            return BehaviorStatus.RUNNING;
        }
        Util.faceLocation((Entity)this.entity.getBukkitEntity(), this.location);
        if (this.entity instanceof EntityPlayer) {
            PlayerAnimation.ARM_SWING.play((Player)this.entity.getBukkitEntity());
        }
        if ((block = this.entity.world.getType(this.x, this.y, this.z)) == null || block == Blocks.AIR) {
            return BehaviorStatus.SUCCESS;
        }
        int tickDifference = this.currentTick - this.startDigTick;
        float damage = this.getStrength(block) * (float)(tickDifference + 1) * this.configuration.blockStrengthModifier();
        if (damage >= 1.0f) {
            this.entity.world.getWorld().getBlockAt(this.x, this.y, this.z).breakNaturally((ItemStack)CraftItemStack.asCraftMirror((net.minecraft.server.v1_7_R4.ItemStack)this.getCurrentItem()));
            return BehaviorStatus.SUCCESS;
        }
        int modifiedDamage = (int)(damage * 10.0f);
        if (modifiedDamage != this.currentDamage) {
            this.setBlockDamage(modifiedDamage);
            this.currentDamage = modifiedDamage;
        }
        return BehaviorStatus.RUNNING;
    }

    private void setBlockDamage(int modifiedDamage) {
        this.entity.world.d(this.entity.getId(), this.x, this.y, this.z, modifiedDamage);
    }

    @Override
    public boolean shouldExecute() {
        return this.entity.world.getType(this.x, this.y, this.z) != Blocks.AIR;
    }

    private float strengthMod(Block block) {
        net.minecraft.server.v1_7_R4.ItemStack itemstack = this.getCurrentItem();
        float strength = itemstack != null ? itemstack.a(block) : 1.0f;
        int ench = EnchantmentManager.getEnchantmentLevel((int)Enchantment.DURABILITY.id, (net.minecraft.server.v1_7_R4.ItemStack)this.getCurrentItem());
        if (ench > 0 && itemstack != null) {
            float levelSquared = ench * ench + 1;
            strength = !itemstack.b(block) && strength <= 1.0f ? (strength += levelSquared * 0.08f) : (strength += levelSquared);
        }
        if (this.entity.hasEffect(MobEffectList.FASTER_DIG)) {
            strength *= 1.0f + (float)(this.entity.getEffect(MobEffectList.FASTER_DIG).getAmplifier() + 1) * 0.2f;
        }
        if (this.entity.hasEffect(MobEffectList.SLOWER_DIG)) {
            strength *= 1.0f - (float)(this.entity.getEffect(MobEffectList.SLOWER_DIG).getAmplifier() + 1) * 0.2f;
        }
        if (this.entity.a(Material.WATER) && !EnchantmentManager.hasWaterWorkerEnchantment((EntityLiving)this.entity)) {
            strength /= 5.0f;
        }
        if (!this.entity.onGround) {
            strength /= 5.0f;
        }
        return strength;
    }

    public static BlockBreaker create(LivingEntity entity, org.bukkit.block.Block target) {
        return BlockBreaker.createWithConfiguration(entity, target, EMPTY);
    }

    public static BlockBreaker createWithConfiguration(LivingEntity entity, org.bukkit.block.Block target, Configuration config) {
        return new BlockBreaker(entity, target, config);
    }

    public static class Configuration {
        private Runnable callback;
        private ItemStack itemStack;
        private float modifier = 1.0f;
        private double radius = 0.0;

        public float blockStrengthModifier() {
            return this.modifier;
        }

        public Configuration blockStrengthModifier(float modifier) {
            this.modifier = modifier;
            return this;
        }

        private Runnable callback() {
            return this.callback;
        }

        public Configuration callback(Runnable callback) {
            this.callback = callback;
            return this;
        }

        private ItemStack item() {
            return this.itemStack;
        }

        public Configuration item(ItemStack stack) {
            this.itemStack = stack;
            return this;
        }

        public Configuration radius(double radius) {
            this.radius = radius;
            return this;
        }

        private double radiusSquared() {
            return Math.pow(this.radius, 2.0);
        }
    }
}

