/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import java.util.Iterator;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.ai.EntityTarget;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.ai.event.NavigationReplaceEvent;
import net.citizensnpcs.api.ai.event.NavigationStuckEvent;
import net.citizensnpcs.api.ai.event.NavigatorCallback;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.npc.ai.AStarNavigationStrategy;
import net.citizensnpcs.npc.ai.AbstractPathStrategy;
import net.citizensnpcs.npc.ai.FlyingAStarNavigationStrategy;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.ai.PathStrategy;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class CitizensNavigator
implements Navigator,
Runnable {
    private final NavigatorParameters defaultParams;
    private PathStrategy executing;
    private int lastX;
    private int lastY;
    private int lastZ;
    private NavigatorParameters localParams;
    private final NPC npc;
    private boolean paused;
    private int stationaryTicks;
    private static final Location STATIONARY_LOCATION = new Location(null, 0.0, 0.0, 0.0);
    private static int UNINITIALISED_SPEED = Integer.MIN_VALUE;

    public CitizensNavigator(NPC npc) {
        this.localParams = this.defaultParams = new NavigatorParameters().baseSpeed(UNINITIALISED_SPEED).range(Settings.Setting.DEFAULT_PATHFINDING_RANGE.asFloat()).defaultAttackStrategy(MCTargetStrategy.DEFAULT_ATTACK_STRATEGY).attackRange(Settings.Setting.NPC_ATTACK_DISTANCE.asDouble()).stationaryTicks(Settings.Setting.DEFAULT_STATIONARY_TICKS.asInt()).stuckAction(TeleportStuckAction.INSTANCE).examiner(new MinecraftBlockExaminer()).useNewPathfinder(Settings.Setting.USE_NEW_PATHFINDER.asBoolean());
        this.npc = npc;
        if (Settings.Setting.NEW_PATHFINDER_OPENS_DOORS.asBoolean()) {
            this.defaultParams.examiner(new DoorExaminer());
        }
    }

    @Override
    public void cancelNavigation() {
        this.stopNavigating(CancelReason.PLUGIN);
    }

    @Override
    public NavigatorParameters getDefaultParameters() {
        return this.defaultParams;
    }

    @Override
    public EntityTarget getEntityTarget() {
        return this.executing instanceof EntityTarget ? (EntityTarget)((Object)this.executing) : null;
    }

    @Override
    public NavigatorParameters getLocalParameters() {
        if (!this.isNavigating()) {
            return this.defaultParams;
        }
        return this.localParams;
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    @Override
    public Location getTargetAsLocation() {
        return this.isNavigating() ? this.executing.getTargetAsLocation() : null;
    }

    @Override
    public TargetType getTargetType() {
        return this.isNavigating() ? this.executing.getTargetType() : null;
    }

    @Override
    public boolean isNavigating() {
        return this.executing != null;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    public void load(DataKey root) {
        this.defaultParams.range((float)root.getDouble("pathfindingrange", Settings.Setting.DEFAULT_PATHFINDING_RANGE.asFloat()));
        this.defaultParams.stationaryTicks(root.getInt("stationaryticks", Settings.Setting.DEFAULT_STATIONARY_TICKS.asInt()));
        this.defaultParams.speedModifier((float)root.getDouble("speedmodifier", 1.0));
        if (root.keyExists("avoidwater")) {
            this.defaultParams.avoidWater(root.getBoolean("avoidwater"));
        }
        if (!root.getBoolean("usedefaultstuckaction") && this.defaultParams.stuckAction() == TeleportStuckAction.INSTANCE) {
            this.defaultParams.stuckAction(null);
        }
    }

    public void onDespawn() {
        this.stopNavigating(CancelReason.NPC_DESPAWNED);
    }

    public void onSpawn() {
        if (this.defaultParams.baseSpeed() == (float)UNINITIALISED_SPEED) {
            this.defaultParams.baseSpeed(NMS.getSpeedFor(this.npc));
        }
        this.updatePathfindingRange();
    }

    @Override
    public void run() {
        if (!this.isNavigating() || !this.npc.isSpawned() || this.paused) {
            return;
        }
        if (this.updateStationaryStatus()) {
            return;
        }
        this.updatePathfindingRange();
        boolean finished = this.executing.update();
        if (!finished) {
            return;
        }
        if (this.executing.getCancelReason() != null) {
            this.stopNavigating(this.executing.getCancelReason());
        } else {
            NavigationCompleteEvent event = new NavigationCompleteEvent(this);
            PathStrategy old = this.executing;
            Bukkit.getPluginManager().callEvent((Event)event);
            if (old == this.executing) {
                this.stopNavigating(null);
            }
        }
    }

    public void save(DataKey root) {
        root.setDouble("pathfindingrange", this.defaultParams.range());
        root.setInt("stationaryticks", this.defaultParams.stationaryTicks());
        root.setDouble("speedmodifier", this.defaultParams.speedModifier());
        root.setBoolean("avoidwater", this.defaultParams.avoidWater());
        root.setBoolean("usedefaultstuckaction", this.defaultParams.stuckAction() == TeleportStuckAction.INSTANCE);
    }

    @Override
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Override
    public void setTarget(Entity target, boolean aggressive) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (target == null) {
            this.cancelNavigation();
            return;
        }
        this.switchParams();
        this.updatePathfindingRange();
        MCTargetStrategy newStrategy = new MCTargetStrategy(this.npc, target, aggressive, this.localParams);
        this.switchStrategyTo(newStrategy);
    }

    @Override
    public void setTarget(LivingEntity target, boolean aggressive) {
        this.setTarget((Entity)target, aggressive);
    }

    @Override
    public void setTarget(Location target) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (target == null) {
            this.cancelNavigation();
            return;
        }
        this.switchParams();
        this.updatePathfindingRange();
        AbstractPathStrategy newStrategy = this.npc.isFlyable() ? new FlyingAStarNavigationStrategy(this.npc, target, this.localParams) : (this.localParams.useNewPathfinder() || !(this.npc.getEntity() instanceof LivingEntity) ? new AStarNavigationStrategy(this.npc, target, this.localParams) : new MCNavigationStrategy(this.npc, target, this.localParams));
        this.switchStrategyTo(newStrategy);
    }

    private void stopNavigating() {
        if (this.executing != null) {
            this.executing.stop();
        }
        this.executing = null;
        this.localParams = this.defaultParams;
        this.stationaryTicks = 0;
        if (this.npc.isSpawned()) {
            Vector velocity = this.npc.getEntity().getVelocity();
            velocity.setX(0).setY(0).setZ(0);
            this.npc.getEntity().setVelocity(velocity);
        }
    }

    private void stopNavigating(CancelReason reason) {
        if (!this.isNavigating()) {
            return;
        }
        Iterator<NavigatorCallback> itr = this.localParams.callbacks().iterator();
        while (itr.hasNext()) {
            itr.next().onCompletion(reason);
            itr.remove();
        }
        if (reason == null) {
            this.stopNavigating();
            return;
        }
        if (reason == CancelReason.STUCK) {
            boolean shouldContinue;
            StuckAction action = this.localParams.stuckAction();
            NavigationStuckEvent event = new NavigationStuckEvent(this, action);
            Bukkit.getPluginManager().callEvent((Event)event);
            action = event.getAction();
            boolean bl = shouldContinue = action != null ? action.run(this.npc, this) : false;
            if (shouldContinue) {
                this.stationaryTicks = 0;
                this.executing.clearCancelReason();
                return;
            }
        }
        NavigationCancelEvent event = new NavigationCancelEvent(this, reason);
        PathStrategy old = this.executing;
        Bukkit.getPluginManager().callEvent((Event)event);
        if (old == this.executing) {
            this.stopNavigating();
        }
    }

    private void switchParams() {
        this.localParams = this.defaultParams.clone();
    }

    private void switchStrategyTo(PathStrategy newStrategy) {
        if (this.executing != null) {
            Bukkit.getPluginManager().callEvent((Event)new NavigationReplaceEvent(this));
        }
        this.executing = newStrategy;
        this.stationaryTicks = 0;
        if (this.npc.isSpawned()) {
            NMS.updateNavigationWorld(this.npc.getEntity(), this.npc.getEntity().getWorld());
        }
        Bukkit.getPluginManager().callEvent((Event)new NavigationBeginEvent(this));
    }

    private void updatePathfindingRange() {
        NMS.updatePathfindingRange(this.npc, this.localParams.range());
    }

    private boolean updateStationaryStatus() {
        if (this.localParams.stationaryTicks() < 0) {
            return false;
        }
        Location current = this.npc.getEntity().getLocation(STATIONARY_LOCATION);
        if (current.getY() < -5.0) {
            this.stopNavigating(CancelReason.STUCK);
            return true;
        }
        if (this.lastX == current.getBlockX() && this.lastY == current.getBlockY() && this.lastZ == current.getBlockZ()) {
            if (++this.stationaryTicks >= this.localParams.stationaryTicks()) {
                this.stopNavigating(CancelReason.STUCK);
                return true;
            }
        } else {
            this.stationaryTicks = 0;
        }
        this.lastX = current.getBlockX();
        this.lastY = current.getBlockY();
        this.lastZ = current.getBlockZ();
        return false;
    }

    private static class DoorOpener
    implements PathPoint.PathCallback {
        private DoorOpener() {
        }

        @Override
        public void run(NPC npc, Block point, double radius) {
            if (radius < 2.0) {
                boolean bottom = (point.getData() & 8) == 0;
                Block set = bottom ? point : point.getRelative(BlockFace.DOWN);
                set.setData((byte)(set.getData() & 7 | 4));
            }
        }
    }

    public static class DoorExaminer
    implements BlockExaminer {
        @Override
        public float getCost(BlockSource source, PathPoint point) {
            return 0.0f;
        }

        @Override
        public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
            Material in = source.getMaterialAt(point.getVector());
            if (MinecraftBlockExaminer.isDoor(in)) {
                point.addCallback(new DoorOpener());
                return BlockExaminer.PassableState.PASSABLE;
            }
            return BlockExaminer.PassableState.IGNORE;
        }
    }
}

